/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.rpc.service.ContractInvokeMainDataRpcService;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.esignv3.dto.AuthRp;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.OrgAdminRp;
import com.els.modules.electronsign.esignv3.dto.OrgGetAuthRp;
import com.els.modules.electronsign.esignv3.dto.OrgQueryRp;
import com.els.modules.electronsign.esignv3.dto.OrgQueryRq;
import com.els.modules.electronsign.esignv3.dto.OrgRq;
import com.els.modules.electronsign.esignv3.dto.PersonalRq;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3OrgPsn;
import com.els.modules.electronsign.esignv3.entity.PurchaseEsignV3Personal;
import com.els.modules.electronsign.esignv3.enums.AuthCallBackEnum;
import com.els.modules.electronsign.esignv3.enums.RealNameStatusEnum;
import com.els.modules.electronsign.esignv3.enums.RoleEnum;
import com.els.modules.electronsign.esignv3.mapper.PurchaseEsignV3OrgMapper;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgPsnService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.PurchaseEsignV3PersonalService;
import com.els.modules.electronsign.util.IpassUtil;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEsignV3OrgServiceImpl
extends BaseServiceImpl<PurchaseEsignV3OrgMapper, PurchaseEsignV3Org>
implements PurchaseEsignV3OrgService {
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private ContractInvokeMainDataRpcService contractInvokeMainDataRpcService;
    @Autowired
    private PurchaseEsignV3OrgPsnService esignV3OrgPsnService;
    @Autowired
    private PurchaseEsignV3PersonalService personalService;
    @Autowired
    private EsignV3Properties esignV3Properties;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(PurchaseEsignV3Org purchaseEsignV3Org) {
        this.handleDbBefore(purchaseEsignV3Org);
        ((PurchaseEsignV3OrgMapper)this.baseMapper).insert((Object)purchaseEsignV3Org);
        this.processNewCompany(purchaseEsignV3Org);
    }

    public void processNewCompany(PurchaseEsignV3Org purchaseEsignV3Org) {
        block9: {
            OrgQueryRq rq = new OrgQueryRq();
            rq.setOrgName(purchaseEsignV3Org.getOrgName());
            IpassUtil.setNullValue(rq);
            boolean throwE = false;
            try {
                TenantContext.setTenant((String)purchaseEsignV3Org.getElsAccount());
                OrgQueryRp orgQueryRp = this.ipassUtil.sendBaseRequest(rq, "e3-query-auth-org", OrgQueryRp.class);
                if (!RealNameStatusEnum.REAL_NAME.getValue().equals(orgQueryRp.getRealnameStatus())) break block9;
                BeanUtil.copyProperties((Object)orgQueryRp.getOrgInfo(), (Object)((Object)purchaseEsignV3Org), (String[])new String[0]);
                purchaseEsignV3Org.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
                purchaseEsignV3Org.setOrgId(orgQueryRp.getOrgId());
                purchaseEsignV3Org.setOrgName(orgQueryRp.getOrgName());
                purchaseEsignV3Org.setAuthorizeUserInfo(orgQueryRp.getAuthorizeUserInfo() != false ? "1" : "0");
                this.updateById((Object)purchaseEsignV3Org);
                if (!orgQueryRp.getAuthorizeUserInfo().booleanValue()) break block9;
                OrgQueryRq orgQueryRq = new OrgQueryRq();
                orgQueryRq.setOrgId(purchaseEsignV3Org.getOrgId());
                OrgGetAuthRp orgGetAuthRp = this.ipassUtil.sendBaseRequest(orgQueryRq, "e3-get-auth-info", OrgGetAuthRp.class);
                if (CollUtil.isNotEmpty(orgGetAuthRp.getAuthorizedInfo())) {
                    purchaseEsignV3Org.setAuthorizedScopes(orgGetAuthRp.getAuthorizedInfo().stream().map(x -> x.getAuthorizedScope()).distinct().collect(Collectors.joining(",")));
                    this.updateById((Object)purchaseEsignV3Org);
                    if (purchaseEsignV3Org.getAuthorizedScopes().contains("manage_org_resource")) {
                        OrgAdminRp rp = this.ipassUtil.sendBaseRequest(orgQueryRq, "e3-query-org-admin", OrgAdminRp.class);
                        if (ObjectUtil.isNotEmpty((Object)rp)) {
                            boolean doAdmin = false;
                            List<OrgAdminRp.Administrator> administrators = rp.getAdministrators();
                            for (OrgAdminRp.Administrator administrator : administrators) {
                                if (!StrUtil.equals((CharSequence)purchaseEsignV3Org.getPsnId(), (CharSequence)administrator.getPsnId()) && (!ObjectUtil.isNotEmpty((Object)administrator.getPsnAccount()) || (!StrUtil.isNotBlank((CharSequence)administrator.getPsnAccount().getAccountMobile()) || !purchaseEsignV3Org.getPsnAccount().equals(administrator.getPsnAccount().getAccountMobile())) && (!StrUtil.isNotBlank((CharSequence)administrator.getPsnAccount().getAccountEmail()) || !administrator.getPsnAccount().getAccountEmail().equals(purchaseEsignV3Org.getPsnAccount())))) continue;
                                this.handleOrgAndPsn(purchaseEsignV3Org, administrator.getPsnId());
                                purchaseEsignV3Org.setPsnId(administrator.getPsnId());
                                if (!StrUtil.equals((CharSequence)administrator.getPsnName(), (CharSequence)purchaseEsignV3Org.getPsnName())) {
                                    purchaseEsignV3Org.setPsnName(administrator.getPsnName());
                                    purchaseEsignV3Org.setPsnAccount(Optional.ofNullable(administrator.getPsnAccount().getAccountMobile()).orElse(administrator.getPsnAccount().getAccountEmail()));
                                }
                                this.updateById((Object)purchaseEsignV3Org);
                                doAdmin = true;
                                break;
                            }
                            if (!doAdmin) {
                                OrgAdminRp.Administrator administrator = administrators.get(0);
                                purchaseEsignV3Org.setPsnName(administrator.getPsnName());
                                purchaseEsignV3Org.setPsnAccount(Optional.ofNullable(administrator.getPsnAccount().getAccountMobile()).orElse(administrator.getPsnAccount().getAccountEmail()));
                                this.handleOrgAndPsn(purchaseEsignV3Org, administrator.getPsnId());
                                purchaseEsignV3Org.setPsnId(administrator.getPsnId());
                                this.updateById((Object)purchaseEsignV3Org);
                            }
                        }
                        break block9;
                    }
                    throwE = true;
                    throw new ELSBootException("\u6b64\u4f01\u4e1a\u5df2\u8ba4\u8bc1\uff0c\u672a\u6388\u6743\u8d44\u6e90\u7ba1\u7406\u6743\u9650\uff0c\u65e0\u6cd5\u81ea\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458\uff0c\u8bf7\u6388\u6743\u540e\u624b\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458");
                }
                throwE = true;
                throw new ELSBootException("\u6b64\u4f01\u4e1a\u5df2\u8ba4\u8bc1\uff0c\u672a\u6388\u6743\u5e94\u7528\uff0c\u65e0\u6cd5\u81ea\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458\uff0c\u8bf7\u6388\u6743\u540e\u624b\u52a8\u6dfb\u52a0\u7ba1\u7406\u5458");
            }
            catch (Exception e) {
                if (throwE) {
                    throw e;
                }
                this.log.error("processNewCompany error", (Throwable)e);
            }
        }
    }

    private void handleDbBefore(PurchaseEsignV3Org purchaseEsignV3Org) {
        if ("1".equals(purchaseEsignV3Org.getLoadingOrg())) {
            PurchaseOrganizationInfoDTO organizationInfo = this.contractInvokeMainDataRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", purchaseEsignV3Org.getOrgCode());
            Assert.notNull((Object)organizationInfo, (String)I18nUtil.translate((String)"i18n_field_tRcodeIH_b9e65e2d", (String)"\u673a\u6784code\u5f02\u5e38"));
            purchaseEsignV3Org.setOrgName(organizationInfo.getOrgName());
        }
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseEsignV3Org::getOrgName, (Object)purchaseEsignV3Org.getOrgName())).ne(BaseEntity::getId, (Object)purchaseEsignV3Org.getId())) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_rAEIMK_369fd5a4", (String)"\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728"));
        Assert.isTrue((Validator.isEmail((CharSequence)purchaseEsignV3Org.getPsnAccount()) || Validator.isMobile((CharSequence)purchaseEsignV3Org.getPsnAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_EPsmLjDeyBKlTKltSNjImK_6b3061f", (String)"E\u7b7e\u5b9d\u4e2a\u4eba\u7528\u6237\u8d26\u53f7\u6807\u8bc6\u5fc5\u987b\u662f\u624b\u673a\u6216\u8005\u90ae\u4ef6\u683c\u5f0f"));
    }

    @Override
    public void edit(PurchaseEsignV3Org purchaseEsignV3Org) {
        this.handleDbBefore(purchaseEsignV3Org);
        int count = ((PurchaseEsignV3OrgMapper)this.baseMapper).updateById((Object)purchaseEsignV3Org);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseEsignV3OrgMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseEsignV3OrgMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public PurchaseEsignV3Org submitCertification(PurchaseEsignV3Org org, String needSave) {
        if ("1".equals(needSave)) {
            if (StrUtil.isBlank((CharSequence)org.getId())) {
                this.add(org);
            } else {
                this.edit(org);
            }
        } else {
            org = (PurchaseEsignV3Org)((Object)this.getById((Serializable)((Object)org.getId())));
        }
        OrgRq.OrgAuthConfig orgAuthConfig = new OrgRq.OrgAuthConfig();
        BeanUtil.copyProperties((Object)((Object)org), (Object)orgAuthConfig, (String[])new String[0]);
        IpassUtil.setNullValue(orgAuthConfig);
        OrgRq.OrgInfo orgInfo = new OrgRq.OrgInfo();
        orgInfo.setOrgIDCardNum(org.getOrgIdCardNum());
        orgInfo.setOrgIDCardType(org.getOrgIdCardType());
        orgInfo.setLegalRepName(org.getLegalRepName());
        orgInfo.setLegalRepIDCardNum(org.getLegalRepIdCardNum());
        orgInfo.setLegalRepIDCardType(org.getLegalRepIdCardType());
        IpassUtil.setNullValue(orgInfo);
        orgAuthConfig.setOrgInfo(orgInfo);
        PersonalRq.PsnAuthConfig transactorInfo = new PersonalRq.PsnAuthConfig();
        if (StrUtil.isNotBlank((CharSequence)org.getPsnId())) {
            transactorInfo.setPsnId(org.getPsnId());
        } else {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)org.getPsnAccount()), (String)I18nUtil.translate((String)"i18n_field_OrLeyBKltySjdLV_bc320b6b", (String)"\u7ecf\u529e\u4eba\u8d26\u53f7\u6807\u8bc6\uff08\u624b\u673a\u53f7\u6216\u90ae\u7bb1\uff09\u4e3a\u7a7a"));
            transactorInfo.setPsnAccount(org.getPsnAccount());
            PersonalRq.PsnInfo psnInfo = new PersonalRq.PsnInfo();
            BeanUtil.copyProperties((Object)((Object)org), (Object)psnInfo, (String[])new String[0]);
            IpassUtil.setNullValue(psnInfo);
            transactorInfo.setPsnInfo(psnInfo);
            PersonalRq.PsnAuthPageConfig psnAuthPageConfig = new PersonalRq.PsnAuthPageConfig();
            psnAuthPageConfig.setPsnDefaultAuthMode(org.getPsnDefaultAuthmode());
            if (StrUtil.isNotBlank((CharSequence)org.getPsnAvailableAuthmodes())) {
                psnAuthPageConfig.setPsnAvailableAuthModes(Arrays.asList(org.getPsnAvailableAuthmodes().split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)org.getPsnEditableFields())) {
                psnAuthPageConfig.setPsnEditableFields(Arrays.asList(org.getPsnEditableFields().split(",")));
            }
            orgAuthConfig.setTransactorAuthPageConfig(psnAuthPageConfig);
        }
        orgAuthConfig.setTransactorInfo(transactorInfo);
        OrgRq.OrgAuthPageConfig orgAuthPageConfig = new OrgRq.OrgAuthPageConfig();
        BeanUtil.copyProperties((Object)((Object)org), (Object)orgAuthPageConfig, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)org.getOrgAvailableAuthModes())) {
            orgAuthPageConfig.setOrgAvailableAuthModes(Arrays.asList(org.getOrgAvailableAuthModes().split(",")));
        }
        if (StrUtil.isNotBlank((CharSequence)org.getOrgEditableFields())) {
            orgAuthPageConfig.setOrgEditableFields(Arrays.asList(org.getOrgEditableFields().split(",")));
        }
        IpassUtil.setNullValue(orgAuthPageConfig);
        orgAuthConfig.setOrgAuthPageConfig(orgAuthPageConfig);
        String notifyUrl = this.esignV3Properties.getCallBackUrl() + "/esignv3/purchaseEsignV3Org/noToken/callback";
        OrgRq orgRq = OrgRq.builder().orgAuthConfig(orgAuthConfig).notifyUrl(notifyUrl).build();
        if (StrUtil.isNotBlank((CharSequence)org.getAuthorizedScopes())) {
            OrgRq.AuthorizeConfig authorizeConfig = new OrgRq.AuthorizeConfig();
            authorizeConfig.setAuthorizedScopes(Arrays.asList(org.getAuthorizedScopes().split(",")));
            orgRq.setAuthorizeConfig(authorizeConfig);
        }
        IpassUtil.setNullValue(orgRq);
        AuthRp rp = this.ipassUtil.sendRequest(orgRq, "e3-get-auth-org", AuthRp.class);
        org.setAuthFlowId(rp.getAuthFlowId());
        org.setAuthUrl(rp.getAuthUrl());
        org.setAuthShortYrl(rp.getAuthShortUrl());
        this.updateById((Object)org);
        return org;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void handleCallBack(CallBackDto.OrgAuth params) {
        PurchaseEsignV3Org org;
        if (AuthCallBackEnum.AUTH_PASS.getCode().equals(params.getAction()) && ObjectUtil.isNotEmpty((Object)((Object)(org = ((PurchaseEsignV3OrgMapper)this.baseMapper).selectByRequestId(params.getAuthFlowId()))))) {
            org.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
            CallBackDto.Organization organization = params.getOrganization();
            org.setOrgId(organization.getOrgId());
            org.setOrgName(Optional.ofNullable(organization.getOrgName()).orElse(org.getOrgName()));
            CallBackDto.PsnInfo psnInfo = organization.getTransactor();
            String psnId = Optional.ofNullable(psnInfo.getPsnId()).orElse(org.getPsnId());
            if (ObjectUtil.isNotEmpty((Object)organization.getTransactor())) {
                org.setPsnId(psnId);
            }
            this.updateById((Object)org);
            this.handleOrgAndPsn(org, psnId);
        }
        if (AuthCallBackEnum.AUTHORIZE_FINISH.getCode().equals(params.getAction()) && ObjectUtil.isNotEmpty((Object)((Object)(org = ((PurchaseEsignV3OrgMapper)this.baseMapper).selectByRequestId(params.getAuthFlowId()))))) {
            this.processNewCompany(org);
        }
    }

    private void handleOrgAndPsn(PurchaseEsignV3Org org, String psnId) {
        TenantContext.setTenant((String)org.getElsAccount());
        PurchaseEsignV3Personal psn = this.personalService.getByPsnId(psnId);
        if (ObjectUtil.isEmpty((Object)((Object)psn))) {
            psn = this.personalService.getByPsnAccount(org.getPsnAccount());
        }
        if (ObjectUtil.isEmpty((Object)((Object)psn))) {
            psn = new PurchaseEsignV3Personal();
            psn.setSubAccount(org.getSubAccount());
            psn.setPsnName(org.getPsnName());
            psn.setPsnAccount(org.getPsnAccount());
            psn.setPsnMobile(org.getPsnMobile());
            psn.setPsnIdCardNum(org.getPsnIdCardNum());
            psn.setPsnIdCardType(org.getPsnIdCardType());
            psn.setBankCardNum(org.getBankCardNum());
            psn.setPsnDefaultAuthMode(org.getPsnDefaultAuthmode());
            psn.setPsnAvailableAuthModes(org.getPsnAvailableAuthmodes());
            psn.setPsnEditableFields(org.getPsnEditableFields());
        }
        psn.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
        psn.setPsnId(psnId);
        this.personalService.saveOrUpdate((Object)psn);
        this.saveOrgAndPsn(org, psn);
        TenantContext.clear();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void refreshRealNameStatus(String id) {
        PurchaseEsignV3Org org = (PurchaseEsignV3Org)((Object)this.getById((Serializable)((Object)id)));
        OrgQueryRq rq = new OrgQueryRq();
        rq.setOrgName(org.getOrgName());
        IpassUtil.setNullValue(rq);
        OrgQueryRp orgQueryRp = this.ipassUtil.sendBaseRequest(rq, "e3-query-auth-org", OrgQueryRp.class);
        if (RealNameStatusEnum.REAL_NAME.getValue().equals(orgQueryRp.getRealnameStatus())) {
            BeanUtil.copyProperties((Object)orgQueryRp.getOrgInfo(), (Object)((Object)org), (String[])new String[0]);
            org.setRealnameStatus(RealNameStatusEnum.REAL_NAME.getCode());
            org.setOrgId(orgQueryRp.getOrgId());
            org.setOrgName(orgQueryRp.getOrgName());
            org.setAuthorizeUserInfo(orgQueryRp.getAuthorizeUserInfo() != false ? "1" : "0");
            this.updateById((Object)org);
            if (StrUtil.isBlank((CharSequence)org.getPsnId())) {
                PersonalRq.QueryAuth queryAuth = new PersonalRq.QueryAuth();
                queryAuth.setPsnAccount(org.getPsnAccount());
                IpassUtil.setNullValue(queryAuth);
                AuthRp.QueryRp queryRp = this.ipassUtil.sendBaseRequest(queryAuth, "e3-query-auth-personal", AuthRp.QueryRp.class);
                if (RealNameStatusEnum.REAL_NAME.getCode().equals(queryRp.getRealnameStatus())) {
                    org.setPsnId(queryRp.getPsnId());
                } else {
                    throw new ELSBootException("\u8bf7\u68c0\u67e5\u7ecf\u529e\u4eba\u662f\u5426\u548c\u8ba4\u8bc1\u65f6\u7684\u7ecf\u529e\u4eba\u4e00\u81f4");
                }
            }
            this.handleOrgAndPsn(org, org.getPsnId());
        }
    }

    @Override
    public PurchaseEsignV3Org getByOrgId(String orgId) {
        return (PurchaseEsignV3Org)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3Org::getOrgId, (Object)orgId), false));
    }

    @Override
    public String getAuth(PurchaseEsignV3Org org) {
        PurchaseEsignV3Org db = (PurchaseEsignV3Org)((Object)this.getById((Serializable)((Object)org.getId())));
        if (StrUtil.isNotBlank((CharSequence)db.getAuthorizedScopes())) {
            List<String> old = Arrays.asList(db.getAuthorizedScopes().split(","));
            List<String> n = Arrays.asList(org.getAuthorizedScopes().split(","));
            ArrayList end = Lists.newArrayList();
            end.addAll(old);
            end.addAll(n);
            db.setAuthorizedScopes(end.stream().distinct().collect(Collectors.joining(",")));
        } else {
            db.setAuthorizedScopes(org.getAuthorizedScopes());
        }
        db = this.submitCertification(db, "1");
        return db.getAuthUrl();
    }

    public void saveOrgAndPsn(PurchaseEsignV3Org org, PurchaseEsignV3Personal psn) {
        PurchaseEsignV3OrgPsn elsEsignV3OrgPsn = new PurchaseEsignV3OrgPsn();
        elsEsignV3OrgPsn.setOrgId(org.getId());
        elsEsignV3OrgPsn.setOrgCode(org.getOrgId());
        elsEsignV3OrgPsn.setPsnId(psn.getId());
        elsEsignV3OrgPsn.setPsnCode(psn.getPsnId());
        elsEsignV3OrgPsn.setRole(RoleEnum.ADMIN.getCode());
        PurchaseEsignV3OrgPsn db = (PurchaseEsignV3OrgPsn)((Object)this.esignV3OrgPsnService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseEsignV3OrgPsn::getOrgId, (Object)org.getOrgId())).eq(PurchaseEsignV3OrgPsn::getPsnId, (Object)org.getPsnId())).eq(BaseEntity::getDeleted, (Object)"0")));
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            this.esignV3OrgPsnService.save((Object)elsEsignV3OrgPsn);
        }
    }
}

