/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.contract.entity.SaleContractAcceptance;
import com.els.modules.contract.service.SaleContractAcceptanceService;
import com.els.modules.contract.vo.SaleContractAcceptanceVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9500\u552e\u5408\u540c\u9a8c\u6536")
@RestController
@RequestMapping(value={"/contract/saleContractAcceptance"})
public class SaleContractAcceptanceController
extends BaseController<SaleContractAcceptance, SaleContractAcceptanceService> {
    @Autowired
    private SaleContractAcceptanceService saleContractAcceptanceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:list"})
    public Result<?> queryPageList(SaleContractAcceptance saleContractAcceptance, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleContractAcceptance), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleContractAcceptanceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:list"})
    public Result<?> counts(SaleContractAcceptance saleContractAcceptance, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"document_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"document_status");
        List list = ((SaleContractAcceptanceService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleContractAcceptance::getDocumentStatus, SaleContractAcceptance::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "documentStatus", null, (long)all.intValue()));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("contractAcceptanceStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "documentStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleContractAcceptanceVO saleContractAcceptanceVO = this.saleContractAcceptanceService.getDataById(id);
        return Result.ok((Object)((Object)saleContractAcceptanceVO));
    }

    @AutoLog(busModule="\u9500\u552e\u5408\u540c\u9a8c\u6536", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:add"})
    public Result<?> add(@RequestBody SaleContractAcceptanceVO saleContractAcceptancePage) {
        SaleContractAcceptance saleContractAcceptance = new SaleContractAcceptance();
        BeanUtils.copyProperties((Object)((Object)saleContractAcceptancePage), (Object)((Object)saleContractAcceptance));
        this.saleContractAcceptanceService.saveMain(saleContractAcceptance, saleContractAcceptancePage.getSaleAttachmentList());
        this.handleNameValue(saleContractAcceptance);
        return Result.ok((Object)((Object)saleContractAcceptance));
    }

    @AutoLog(busModule="\u9500\u552e\u5408\u540c\u9a8c\u6536", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:edit"})
    public Result<?> edit(@RequestBody SaleContractAcceptanceVO saleContractAcceptancePage) {
        SaleContractAcceptance saleContractAcceptance = new SaleContractAcceptance();
        BeanUtils.copyProperties((Object)((Object)saleContractAcceptancePage), (Object)((Object)saleContractAcceptance));
        this.saleContractAcceptanceService.updateMain(saleContractAcceptance, saleContractAcceptancePage.getSaleAttachmentList());
        this.handleNameValue(saleContractAcceptance);
        String id = saleContractAcceptance.getId();
        return this.queryById(id);
    }

    private void handleNameValue(SaleContractAcceptance saleContractAcceptance) {
        Result<?> result = this.queryById(saleContractAcceptance.getId());
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson(result.getResult(), new DictTranslateAspectParam());
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || String.valueOf(next.getValue()).split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        saleContractAcceptance.setPurchaseGroupName(jsonObject.getString("purchaseGroup_dictText"));
        saleContractAcceptance.setPurchaseOrgName(jsonObject.getString("purchaseOrg_dictText"));
        saleContractAcceptance.setAcceptanceProjectName(jsonObject.getString("acceptanceProject_dictText"));
        saleContractAcceptance.setAcceptanceDepartmentName(jsonObject.getString("acceptanceDepartment_dictText"));
        this.saleContractAcceptanceService.updateById((Object)saleContractAcceptance);
    }

    @AutoLog(busModule="\u9500\u552e\u5408\u540c\u9a8c\u6536", value="\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:publish"})
    public Result<?> publish(@RequestBody SaleContractAcceptanceVO saleContractAcceptancePage) {
        SaleContractAcceptance saleContractAcceptance = new SaleContractAcceptance();
        BeanUtils.copyProperties((Object)((Object)saleContractAcceptancePage), (Object)((Object)saleContractAcceptance));
        SaleContractAcceptance acceptance = (SaleContractAcceptance)((Object)this.saleContractAcceptanceService.getById((Serializable)((Object)saleContractAcceptancePage.getId())));
        if (acceptance != null) {
            saleContractAcceptance.setDataVersion(acceptance.getDataVersion());
        }
        this.saleContractAcceptanceService.updateById((Object)saleContractAcceptance);
        this.handleNameValue(saleContractAcceptance);
        this.saleContractAcceptanceService.publish(saleContractAcceptance, saleContractAcceptancePage.getSaleAttachmentList());
        return Result.ok((Object)((Object)saleContractAcceptance));
    }

    @AutoLog(busModule="\u9500\u552e\u5408\u540c\u9a8c\u6536", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleContractAcceptanceService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u5408\u540c\u9a8c\u6536", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.saleContractAcceptanceService.delBatchMain(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u5408\u540c\u9a8c\u6536", value="\u901a\u8fc7id\u4f5c\u5e9f")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u4f5c\u5e9f")
    @PostMapping(value={"/invalid"})
    @RequiresPermissions(value={"contractAcceptance#saleContractAcceptance:cancellation"})
    public Result<?> invalid(@RequestBody SaleContractAcceptance saleContractAcceptance) {
        this.saleContractAcceptanceService.invalidById(saleContractAcceptance.getId());
        return this.commonSuccessResult(7);
    }
}

