/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.service.ContractBoardService;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractBoardServiceImpl
implements ContractBoardService {
    @Autowired
    private PurchaseContractHeadService contractHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public JSONObject compareCountTrend() {
        List contractHeadList = this.contractHeadService.list();
        Map<String, BigDecimal> supplierMap = contractHeadList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSupplierName())).collect(Collectors.groupingBy(PurchaseContractHead::getSupplierName, Collectors.reducing(BigDecimal.ZERO, PurchaseContractHead::getTotalTaxAmount, BigDecimal::add)));
        JSONArray jsonArr = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("data", supplierMap.values());
        jsonObj.put("type", (Object)"bar");
        jsonArr.add((Object)jsonObj);
        JSONObject resultObj = new JSONObject();
        resultObj.put("seriesData", (Object)jsonArr);
        resultObj.put("xAxisData", supplierMap.keySet());
        return resultObj;
    }

    @Override
    public JSONObject countStatusPie() {
        List contractHeadList = this.contractHeadService.list();
        JSONArray jsonArr = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        Map<String, Long> statusMap = contractHeadList.stream().collect(Collectors.groupingBy(PurchaseContractHead::getContractStatus, Collectors.counting()));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmContractStatus", TenantContext.getTenant());
        Map<String, String> dictMap = srmContractStatus.stream().collect(Collectors.toMap(DictDTO::getValue, DictDTO::getText, (v1, v2) -> v1));
        ArrayList resultArr = new ArrayList();
        statusMap.forEach((k, v) -> {
            JSONObject itemObj = new JSONObject();
            itemObj.put("name", dictMap.get(k));
            itemObj.put("value", v);
            resultArr.add(itemObj);
        });
        jsonObj.put("data", resultArr);
        jsonArr.add((Object)jsonObj);
        JSONObject resultObj = new JSONObject();
        resultObj.put("type", (Object)"pie");
        resultObj.put("seriesData", (Object)jsonArr);
        return resultObj;
    }
}

