/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.electronsign.contractlock.enumerate.ClSignerStatusEmun;
import com.els.modules.electronsign.enums.SrmSignatoryType;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignStatusEmun;
import com.els.modules.electronsign.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.electronsign.esign.service.EsignOperationService;
import com.els.modules.electronsign.esign.util.FileHelper;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.FileDownloadRp;
import com.els.modules.electronsign.esignv3.dto.FileQueryRp;
import com.els.modules.electronsign.esignv3.dto.FileQueryRq;
import com.els.modules.electronsign.esignv3.dto.FileRp;
import com.els.modules.electronsign.esignv3.dto.FileRq;
import com.els.modules.electronsign.esignv3.dto.KeyWordRp;
import com.els.modules.electronsign.esignv3.dto.KeyWordRq;
import com.els.modules.electronsign.esignv3.dto.LaunchRp;
import com.els.modules.electronsign.esignv3.dto.LaunchRq;
import com.els.modules.electronsign.esignv3.dto.PersonalRq;
import com.els.modules.electronsign.esignv3.entity.ElsEsignV3Action;
import com.els.modules.electronsign.esignv3.entity.ElsEsignV3Attachment;
import com.els.modules.electronsign.esignv3.entity.ElsEsignV3Flow;
import com.els.modules.electronsign.esignv3.entity.ElsEsignV3Signers;
import com.els.modules.electronsign.esignv3.enums.EsignV3SignerTypeEnum;
import com.els.modules.electronsign.esignv3.enums.FileUploadStatusEnum;
import com.els.modules.electronsign.esignv3.enums.SendStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.ElsEsignV3FlowMapper;
import com.els.modules.electronsign.esignv3.service.ElsEsignV3ActionService;
import com.els.modules.electronsign.esignv3.service.ElsEsignV3AttachmentService;
import com.els.modules.electronsign.esignv3.service.ElsEsignV3FlowService;
import com.els.modules.electronsign.esignv3.service.ElsEsignV3SignersService;
import com.els.modules.electronsign.esignv3.vo.ElsEsignV3SignersVO;
import com.els.modules.electronsign.esignv3.vo.ElsEsignV3VO;
import com.els.modules.electronsign.esignv3.vo.KeyWordVo;
import com.els.modules.electronsign.util.ESignUtil;
import com.els.modules.electronsign.util.IpassUtil;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ElsEsignV3FlowServiceImpl
extends BaseServiceImpl<ElsEsignV3FlowMapper, ElsEsignV3Flow>
implements ElsEsignV3FlowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElsEsignV3FlowServiceImpl.class);
    @Autowired
    private ESignUtil eSignUtil;
    @Autowired
    private EsignOperationService operationService;
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private ElsEsignV3SignersService signersService;
    @Autowired
    private ElsEsignV3ActionService actionService;
    @Autowired
    private EsignV3Properties esignV3Properties;
    @Autowired
    private ElsEsignV3AttachmentService esignV3AttachmentService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private EsignInvokeOrderRpcService orderRpcService;
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    @Value(value="${els.storage.type}")
    private String storeType;

    @Override
    public void add(ElsEsignV3Flow elsEsignV3Flow) {
        ((ElsEsignV3FlowMapper)this.baseMapper).insert((Object)elsEsignV3Flow);
    }

    @Override
    public void edit(ElsEsignV3Flow elsEsignV3Flow) {
        int count = ((ElsEsignV3FlowMapper)this.baseMapper).updateById((Object)elsEsignV3Flow);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsEsignV3FlowMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsEsignV3FlowMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(ElsEsignV3VO flow, String cookie) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        flow.setCreateTime(new Date());
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        flow.setCreateBy(currentUser);
        flow.setElsAccount(TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)flow.getPurchaseName()) && (enterpriseInfo = this.invokeAccountRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            flow.setPurchaseName(enterpriseInfo.getName());
        }
        if (StrUtil.isBlank((CharSequence)flow.getSupplierName()) && (enterpriseInfo = this.invokeAccountRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            flow.setSupplierName(enterpriseInfo.getName());
        }
        flow.setEsignStatus("0");
        flow.setPurchaseEsignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        flow.setSaleEsignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        flow.setBusAccount(sysUser.getElsAccount());
        flow.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        flow.setOnlineSealed(this.eSignUtil.getOnlineSealed(flow.getBusType(), flow.getToElsAccount()));
        flow.setFirstSeal("1".equals(flow.getOnlineSealed()) ? EsignRoleTypeEnum.SALE.getCode() : EsignRoleTypeEnum.PURCHASE.getCode());
        if (StrUtil.isBlank((CharSequence)flow.getNoticeType())) {
            flow.setNoticeType("1");
        }
        if (StrUtil.isBlank((CharSequence)flow.getAutoArchiving())) {
            flow.setAutoArchiving("1");
        }
        if (StrUtil.isBlank((CharSequence)flow.getAutoInitiate())) {
            flow.setAutoInitiate("1");
        }
        this.eSignUtil.handleBusType(flow.getBusType(), flow.getRelationId(), flow.getEsignStatus(), CLBusTypeEnum.ADD, "esignV3");
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)flow), ElsEsignV3Flow.class, (String[])new String[0]));
        db.setId(IdWorker.getIdStr());
        flow.setId(db.getId());
        if (CollUtil.isNotEmpty(flow.getPurchaseSignersList())) {
            this.handleEditSigner(flow.getPurchaseSignersList(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
            db.setPurchaseEsignStatus("0");
        }
        if (CollUtil.isNotEmpty(flow.getSaleSignersList())) {
            this.handleEditSigner(flow.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
            db.setSaleEsignStatus("0");
        }
        if (CollUtil.isNotEmpty(flow.getPurchaseAttachments())) {
            this.handleEditAttachment(flow.getPurchaseAttachments(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
        } else {
            this.esignV3AttachmentService.remove((Wrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Attachment::getHeadId, (Object)db.getId()));
        }
        ((ElsEsignV3FlowMapper)this.baseMapper).insert((Object)db);
        this.handleBusAttachment(flow.getBusType(), flow, cookie);
    }

    public void handleBusAttachment(String busType, ElsEsignV3VO flow, String cookie) {
        switch (busType) {
            case "contract": {
                this.handleContractAttachment(flow, cookie);
                break;
            }
            case "order": {
                this.handleOrderAttachment(flow, cookie);
                break;
            }
        }
    }

    public InputStream fileToInputStream(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int bytesRead = ((InputStream)inputStream).read(buffer);
            if (bytesRead > 0) {
                System.out.println("First 10 bytes: " + new String(buffer, 0, bytesRead));
            }
            return inputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendBaseUploadFile(File file, ElsEsignV3VO flow) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDateTime time = LocalDateTime.now();
        String nowDay = dtf.format(time);
        String BIZ_PATH = "files";
        Object documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowDay + File.separator + file.getName();
        if (((String)documentLocation).contains("\\")) {
            documentLocation = ((String)documentLocation).replace("\\", "/");
        }
        if (((String)documentLocation).startsWith("\\")) {
            ((String)documentLocation).replace("\\", "");
        }
        String pathType = this.invokeBaseRpcService.uploadFiles(FileUtil.readBytes((File)file), (String)documentLocation, file.getName(), this.storeType);
        try {
            file.delete();
        }
        catch (Exception e) {
            log.error("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
        PurchaseAttachmentDTO attachment = new PurchaseAttachmentDTO();
        attachment.setId(IdWorker.getIdStr());
        attachment.setBusinessType("esignV3");
        attachment.setHeadId(flow.getId());
        attachment.setFileType("5");
        attachment.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        attachment.setUploadElsAccount(TenantContext.getTenant());
        attachment.setFileName(file.getName());
        attachment.setFileSize(String.valueOf(file.length()));
        attachment.setFilePath(pathType);
        attachment.setSaveType(this.storeType);
        attachment.setSendStatus("0");
        attachment.setReceiveStatus("0");
        attachment.setUploadTime(new Date());
        attachment.setSourceType("1");
        attachment.setActionRoutePath("");
        this.invokeBaseRpcService.insertPurchaseAttachment(attachment);
        ElsEsignV3Attachment elsEsignV3Attachment = new ElsEsignV3Attachment();
        elsEsignV3Attachment.setBusinessType("esignV3");
        elsEsignV3Attachment.setAbsoluteFilePath(file.getAbsolutePath());
        elsEsignV3Attachment.setFileName(file.getName());
        elsEsignV3Attachment.setFilePath(file.getPath());
        elsEsignV3Attachment.setRelationId(attachment.getId());
        elsEsignV3Attachment.setHeadId(flow.getId());
        elsEsignV3Attachment.setFileName(file.getName());
        elsEsignV3Attachment.setFileType("5");
        elsEsignV3Attachment.setSignType("1");
        elsEsignV3Attachment.setAccountType("0");
        elsEsignV3Attachment.setUploadTime(new Date());
        elsEsignV3Attachment.setUploadElsAccount(flow.getElsAccount());
        elsEsignV3Attachment.setAbsoluteFilePath(this.invokeBaseRpcService.getRealPath(attachment.getFilePath(), attachment.getSaveType(), false));
        elsEsignV3Attachment.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        elsEsignV3Attachment.setFileSize(String.valueOf(file.length()));
        elsEsignV3Attachment.setCreateBy(flow.getCreateBy());
        elsEsignV3Attachment.setCreateById(flow.getCreateById());
        this.esignV3AttachmentService.save((Object)elsEsignV3Attachment);
    }

    public void handleSignAttachment(ElsEsignV3VO flow, String cookie, List<PurchaseAttachmentDTO> purchaseAttachmentDTOS) {
        File file = this.operationService.getFileById(flow.getRelationId(), flow.getBusType(), flow.getBusNumber(), Optional.ofNullable(flow.getBusVersion()).orElse("1"), flow.getReportUrl(), flow.getToken(), cookie, flow.getPrintTemplateId());
        this.sendBaseUploadFile(file, flow);
        if (CollUtil.isNotEmpty(purchaseAttachmentDTOS)) {
            ArrayList elsEsignV3Attachments = Lists.newArrayList();
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentDTOS) {
                ElsEsignV3Attachment busAttachment = new ElsEsignV3Attachment();
                BeanUtil.copyProperties((Object)purchaseAttachmentDTO, (Object)((Object)busAttachment), (String[])new String[0]);
                busAttachment.setRelationId(purchaseAttachmentDTO.getId());
                busAttachment.setHeadId(flow.getId());
                busAttachment.setId(IdWorker.getIdStr());
                busAttachment.setBusinessType("esignV3");
                busAttachment.setAccountType("0");
                busAttachment.setAbsoluteFilePath(this.invokeBaseRpcService.getRealPath(purchaseAttachmentDTO.getFilePath(), purchaseAttachmentDTO.getSaveType(), false));
                elsEsignV3Attachments.add(busAttachment);
            }
            this.esignV3AttachmentService.saveBatch(elsEsignV3Attachments);
            flow.setPurchaseAttachments(elsEsignV3Attachments);
        }
    }

    public void handleOrderAttachment(ElsEsignV3VO flow, String cookie) {
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.orderRpcService.getPurchaseOrderById(flow.getRelationId());
        Assert.notNull((Object)purchaseOrderHeadDTO, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseOrderHeadDTO.getId());
        this.handleSignAttachment(flow, cookie, purchaseAttachmentDTOS);
    }

    public void handleContractAttachment(ElsEsignV3VO flow, String cookie) {
        PurchaseContractHead contractHead = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)flow.getRelationId())));
        Assert.notNull((Object)((Object)contractHead), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(contractHead.getId());
        this.handleSignAttachment(flow, cookie, purchaseAttachmentDTOS);
    }

    private List<Pair<ElsEsignV3Attachment, File>> getFile(ElsEsignV3VO esign, String cookie) {
        if (CollUtil.isNotEmpty(esign.getSaleAttachments())) {
            Assert.isTrue((esign.getSaleAttachments().stream().filter(x -> "1".equals(x.getSignType())).count() > 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_lTjIzQIjPWAcLdD_764ae989", (String)"\u5fc5\u987b\u6709\u4e00\u4efd\u6587\u4ef6\u7684\u7b7e\u7f72\u7c7b\u578b\u4e3a\u4e3b\u4f53"));
            ArrayList list = Lists.newArrayList();
            for (ElsEsignV3Attachment row : esign.getSaleAttachments()) {
                File file = IpassUtil.getFileFromUrl(row.getAbsoluteFilePath(), row.getId());
                list.add(new Pair((Object)row, (Object)file));
            }
            return list;
        }
        if (CollUtil.isNotEmpty(esign.getPurchaseAttachments())) {
            Assert.isTrue((esign.getPurchaseAttachments().stream().filter(x -> "1".equals(x.getSignType())).count() > 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_lTjIzQIjPWAcLdD_764ae989", (String)"\u5fc5\u987b\u6709\u4e00\u4efd\u6587\u4ef6\u7684\u7b7e\u7f72\u7c7b\u578b\u4e3a\u4e3b\u4f53"));
            ArrayList list = Lists.newArrayList();
            for (ElsEsignV3Attachment row : esign.getPurchaseAttachments()) {
                File file = IpassUtil.getFileFromUrl(row.getAbsoluteFilePath(), row.getId());
                list.add(new Pair((Object)row, (Object)file));
            }
            return list;
        }
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void uploadFile(ElsEsignV3VO esign, HttpServletRequest request, HttpServletResponse response) {
        this.editMain(esign);
        String cookie = request.getHeader("cookie");
        List<Pair<ElsEsignV3Attachment, File>> files = this.getFile(esign, cookie);
        for (Pair<ElsEsignV3Attachment, File> pair : files) {
            File file = (File)pair.getValue();
            FileRq fileRq = new FileRq();
            String fileName = ((ElsEsignV3Attachment)((Object)pair.getKey())).getFileName();
            fileRq.setFileName(fileName);
            fileRq.setFileSize(file.length());
            fileRq.setContentType("application/pdf");
            int dotIndex = fileName.lastIndexOf(46);
            String extension = "pdf";
            if (dotIndex > 0 && dotIndex < fileName.length() - 1) {
                extension = fileName.substring(dotIndex + 1);
            }
            if ("1".equals(((ElsEsignV3Attachment)((Object)pair.getKey())).getSignType()) && !extension.equals("pdf") && !extension.equals("PDF")) {
                fileRq.setConvertToPDF(true);
            }
            String contentMD5 = IpassUtil.getFileContentMD5(IpassUtil.getFileMD5Bytes128(file));
            fileRq.setContentMd5(contentMD5);
            FileRp fileRp = this.ipassUtil.sendRequestAndChangeElsAccountRequest(fileRq, "e3-flow-get-file-url", esign.getElsAccount(), FileRp.class);
            esign.setFilesId(fileRp.getFileId());
            try {
                FileInputStream input = new FileInputStream(file);
                byte[] push = IoUtil.readBytes((InputStream)input);
                FileHelper.streamUploadBytes(push, fileRp.getFileUploadUrl(), contentMD5, "application/pdf");
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
            }
            FileQueryRq fileQuery = new FileQueryRq();
            fileQuery.setFileId(fileRp.getFileId());
            FileQueryRp fileQueryRp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(fileQuery, "e3-flow-query-file-status", esign.getElsAccount(), FileQueryRp.class);
            if (FileUploadStatusEnum.COMPLETED.getCode().equals(fileQueryRp.getFileStatus()) || FileUploadStatusEnum.UPLOAD_TRANSFORMATION.getCode().equals(fileQueryRp.getFileStatus())) {
                esign.setUploaded("1");
            }
            esign.setFilesName(fileQueryRp.getFileName());
            this.updateById((Object)((ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esign), ElsEsignV3Flow.class, (String[])new String[0]))));
            ElsEsignV3Attachment attachment = (ElsEsignV3Attachment)((Object)pair.getKey());
            ElsEsignV3Attachment update = new ElsEsignV3Attachment();
            update.setId(attachment.getId());
            update.setUploaded("1");
            update.setFileId(fileRp.getFileId());
            this.esignV3AttachmentService.updateById((Object)update);
        }
    }

    @Override
    public void editMain(ElsEsignV3VO esignVO) {
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esignVO), ElsEsignV3Flow.class, (String[])new String[0]));
        if (StrUtil.isNotBlank((CharSequence)esignVO.getId())) {
            if (!EsignStatusEmun.FINISHED.getValue().equals(db.getEsignStatus())) {
                this.signersService.remove((Wrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Signers::getHeadId, (Object)db.getId()));
                if (CollUtil.isNotEmpty(esignVO.getPurchaseSignersList())) {
                    this.handleEditSigner(esignVO.getPurchaseSignersList(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
                    if (SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue().equals(db.getSignerVindicateStatus())) {
                        db.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
                    }
                    db.setPurchaseEsignStatus("0");
                }
                if (CollUtil.isNotEmpty(esignVO.getSaleSignersList())) {
                    this.handleEditSigner(esignVO.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
                    db.setSaleEsignStatus("0");
                }
            }
            if (!"1".equals(esignVO.getUploaded())) {
                if (CollUtil.isNotEmpty(esignVO.getPurchaseAttachments())) {
                    this.handleEditAttachment(esignVO.getPurchaseAttachments(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
                } else {
                    this.esignV3AttachmentService.remove((Wrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Attachment::getHeadId, (Object)db.getId()));
                }
            }
            if (CollUtil.isNotEmpty(esignVO.getSaleAttachments())) {
                this.handleEditAttachment(esignVO.getSaleAttachments(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
                db.setSignFileUploaded("1");
                if ("0".equals(db.getOnlineSealed())) {
                    db.setSaleEsignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                    if (CollUtil.isNotEmpty(esignVO.getPurchaseSignersList())) {
                        db.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
                    } else {
                        db.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
                    }
                }
            }
            this.updateById((Object)db);
        } else {
            this.saveMain(esignVO, null);
        }
    }

    @Override
    public ElsEsignV3VO getMainById(String id) {
        List<ElsEsignV3Attachment> attachments;
        ElsEsignV3VO vo = new ElsEsignV3VO();
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        BeanUtil.copyProperties((Object)((Object)db), (Object)((Object)vo), (String[])new String[0]);
        List<ElsEsignV3Signers> signers = this.signersService.getByHeadId(id);
        if (CollUtil.isNotEmpty(signers)) {
            List<ElsEsignV3Action> actions = this.actionService.getByFlowId(id);
            Map<String, List<ElsEsignV3Action>> actionMap = actions.stream().collect(Collectors.groupingBy(x -> x.getHeadId()));
            List<ElsEsignV3Signers> purchaseSigners = signers.stream().filter(x -> EsignRoleTypeEnum.PURCHASE.getValue().equals(x.getRoleType())).collect(Collectors.toList());
            ArrayList purchaseSignersVOS = Lists.newArrayList();
            purchaseSigners.forEach(x -> {
                ElsEsignV3SignersVO elsEsignV3SignersVo = new ElsEsignV3SignersVO();
                BeanUtil.copyProperties((Object)x, (Object)((Object)elsEsignV3SignersVo), (String[])new String[0]);
                List elsEsignV3Actions = (List)actionMap.get(x.getId());
                elsEsignV3SignersVo.setSignersActions(CollUtil.isEmpty((Collection)elsEsignV3Actions) ? Lists.newArrayList() : (List)actionMap.get(x.getId()));
                purchaseSignersVOS.add(elsEsignV3SignersVo);
            });
            vo.setPurchaseSignersList(purchaseSignersVOS);
            ArrayList saleSignersVOS = Lists.newArrayList();
            List<ElsEsignV3Signers> saleSigners = signers.stream().filter(x -> EsignRoleTypeEnum.SALE.getValue().equals(x.getRoleType())).collect(Collectors.toList());
            saleSigners.forEach(x -> {
                ElsEsignV3SignersVO elsEsignV3SignersVo = new ElsEsignV3SignersVO();
                BeanUtil.copyProperties((Object)x, (Object)((Object)elsEsignV3SignersVo), (String[])new String[0]);
                List elsEsignV3Actions = (List)actionMap.get(x.getId());
                elsEsignV3SignersVo.setSignersActions(CollUtil.isEmpty((Collection)elsEsignV3Actions) ? Lists.newArrayList() : (List)actionMap.get(x.getId()));
                saleSignersVOS.add(elsEsignV3SignersVo);
            });
            vo.setSaleSignersList(saleSignersVOS);
        }
        if (CollUtil.isNotEmpty(attachments = this.esignV3AttachmentService.getByHeadId(id))) {
            vo.setPurchaseAttachments(attachments.stream().filter(x -> EsignRoleTypeEnum.PURCHASE.getValue().equals(x.getAccountType())).collect(Collectors.toList()));
            vo.setSaleAttachments(attachments.stream().filter(x -> EsignRoleTypeEnum.SALE.getValue().equals(x.getAccountType())).collect(Collectors.toList()));
            if (StrUtil.equals((CharSequence)vo.getSaleSendStatus(), (CharSequence)SendStatusEnum.SENT.getCode()) && CollUtil.isEmpty(vo.getPurchaseAttachments())) {
                vo.setPurchaseAttachments(vo.getSaleAttachments());
            }
            vo.setSaleAttachments(attachments.stream().filter(x -> EsignRoleTypeEnum.SALE.getValue().equals(x.getAccountType())).collect(Collectors.toList()));
            vo.setReturnAttachments(attachments.stream().filter(x -> "2".equals(x.getSignType())).collect(Collectors.toList()));
        }
        return vo;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void createFlowOneStep(ElsEsignV3VO flowVo) {
        if (flowVo.getBusType().equals("multipleSign")) {
            this.editMain(flowVo);
        } else {
            flowVo = this.getMainById(flowVo.getId());
        }
        LaunchRq launchRq = this.buildLaunchRq(flowVo);
        LaunchRp res = this.ipassUtil.sendRequest(launchRq, "e3-flow-create", LaunchRp.class);
        flowVo.setFlowId(res.getSignFlowId());
        flowVo.setLaunch("1");
        if ("1".equals(flowVo.getAutoInitiate())) {
            flowVo.setInitiate("1");
        } else {
            flowVo.setInitiate("0");
        }
        flowVo.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        this.updateById((Object)flowVo);
    }

    @Override
    public void send(ElsEsignV3VO esignVO) {
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esignVO), ElsEsignV3Flow.class, (String[])new String[0]));
        db.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
        this.updateById((Object)db);
        if (EsignStatusEmun.FINISHED.getValue().equals(db.getEsignStatus())) {
            return;
        }
        if (CollUtil.isNotEmpty(esignVO.getPurchaseSignersList())) {
            this.handleEditSigner(esignVO.getPurchaseSignersList(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
            db.setPurchaseEsignStatus("0");
        }
        if (CollUtil.isNotEmpty(esignVO.getSaleSignersList())) {
            this.handleEditSigner(esignVO.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
        }
    }

    @Override
    public void saleSend(ElsEsignV3VO esignVO) {
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esignVO), ElsEsignV3Flow.class, (String[])new String[0]));
        Assert.isTrue((boolean)CollUtil.isNotEmpty(esignVO.getSaleSignersList()), (String)I18nUtil.translate((String)"i18n_field_RCLLDPWLVH_725bf198", (String)"\u4f9b\u65b9\u672a\u7ef4\u62a4\u7b7e\u7f72\u4eba\u4fe1\u606f"));
        this.handleEditSigner(esignVO.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
        if (CollUtil.isEmpty(esignVO.getPurchaseSignersList())) {
            db.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            db.setSaleEsignStatus("0");
        } else {
            db.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            db.setPurchaseEsignStatus("0");
            db.setSaleEsignStatus("0");
        }
        this.updateById((Object)db);
    }

    @Override
    public void sendBack(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)flow), (String)I18nUtil.translate((String)"i18n_field_neLV_27784384", (String)"\u5408\u540c\u4e3a\u7a7a"));
        if (!EsignStatusEmun.UNDONE.getValue().equals(flow.getEsignStatus())) {
            Assert.isTrue((!"1".equals(flow.getLaunch()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PWQLIhAWShYM_a3d2ed05", (String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u9000\u56de"));
        }
        this.eSignUtil.handleBusType(flow.getBusType(), flow.getRelationId(), null, CLBusTypeEnum.RETURN, "esignV3");
        flow.setSendBack("1");
        this.updateById((Object)flow);
    }

    @Override
    public List<KeyWordVo> keyWordToAera(String filesId, String signWord, String elsAccount) {
        KeyWordRq keyWordRq = new KeyWordRq(filesId, signWord);
        KeyWordRp keyWordRp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(keyWordRq, "e3-search-keyword-position", elsAccount, KeyWordRp.class);
        ArrayList keyWordVos = Lists.newArrayList();
        if (CollUtil.isNotEmpty(keyWordRp.getKeywordPositions())) {
            keyWordRp.getKeywordPositions().forEach(row -> {
                if (row.isSearchResult()) {
                    row.getPositions().forEach(v -> v.getCoordinates().forEach(b -> {
                        KeyWordVo keyWordVo = new KeyWordVo();
                        keyWordVo.setPage(v.getPageNum());
                        keyWordVo.setPositionX(b.getPositionX());
                        keyWordVo.setPositionY(b.getPositionY());
                        keyWordVos.add(keyWordVo);
                    }));
                }
            });
        }
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)keyWordVos), (String)I18nUtil.translate((String)"i18n_field_LYumRIJVH_dc2f9482", (String)"\u672a\u627e\u5230\u6b64\u5173\u952e\u5b57\u4fe1\u606f"));
        return keyWordVos;
    }

    @Override
    public FileQueryRp viewEsignFile(String id) {
        ElsEsignV3Flow esign = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)esign)), (String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
        FileQueryRq fileQuery = new FileQueryRq();
        fileQuery.setFileId(esign.getFilesId());
        FileQueryRp fileQueryRp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(fileQuery, "e3-flow-query-file-status", esign.getElsAccount(), FileQueryRp.class);
        if (FileUploadStatusEnum.COMPLETED.getCode().equals(fileQueryRp.getFileStatus())) {
            return fileQueryRp;
        }
        return null;
    }

    @Override
    public void callback(JSONObject jsonObject) {
        String action;
        switch (action = jsonObject.getString("action")) {
            case "SIGN_MISSON_COMPLETE": {
                String[] customBizNums;
                CallBackDto.SignComplete signComplete = (CallBackDto.SignComplete)jsonObject.toJavaObject(CallBackDto.SignComplete.class);
                if (!StrUtil.isNotBlank((CharSequence)signComplete.getCustomBizNum())) break;
                for (String customBizNum : customBizNums = signComplete.getCustomBizNum().split(",")) {
                    ElsEsignV3Signers signers = (ElsEsignV3Signers)((Object)this.signersService.getById((Serializable)((Object)customBizNum)));
                    if (!ObjectUtil.isNotEmpty((Object)((Object)signers))) continue;
                    signers.setEsignStatus("" + (signComplete.getSignResult() - 1));
                    this.signersService.updateById((Object)signers);
                    ElsEsignV3Flow elsEsignV3Flow = this.delayGet(signComplete.getSignFlowId());
                    if (EsignStatusEmun.FINISHED.getValue().equals(elsEsignV3Flow.getEsignStatus())) continue;
                    if (signers.getRoleType().equals(EsignRoleTypeEnum.PURCHASE.getValue())) {
                        elsEsignV3Flow.setPurchaseEsignStatus("" + (signComplete.getSignResult() - 1));
                        this.updateById((Object)elsEsignV3Flow);
                    }
                    if (!signers.getRoleType().equals(EsignRoleTypeEnum.SALE.getValue())) continue;
                    elsEsignV3Flow.setSaleEsignStatus("" + (signComplete.getSignResult() - 1));
                    this.updateById((Object)elsEsignV3Flow);
                }
                break;
            }
            case "SIGN_FLOW_COMPLETE": {
                CallBackDto.SignEndComplete signEndComplete = (CallBackDto.SignEndComplete)jsonObject.toJavaObject(CallBackDto.SignEndComplete.class);
                ElsEsignV3Flow elsEsignV3Flow2 = this.delayGet(signEndComplete.getSignFlowId());
                ElsEsignV3VO dbData = this.getMainById(elsEsignV3Flow2.getId());
                elsEsignV3Flow2.setPurchaseEsignStatus("1");
                elsEsignV3Flow2.setEsignStatus(signEndComplete.getSignFlowStatus());
                this.updateById((Object)elsEsignV3Flow2);
                if (!EsignStatusEmun.FINISHED.getValue().equals(signEndComplete.getSignFlowStatus())) break;
                if ("1".equals(dbData.getOnlineSealed()) && CollUtil.isNotEmpty(dbData.getSaleSignersList())) {
                    elsEsignV3Flow2.setSaleEsignStatus("1");
                }
                if (!"1".equals(elsEsignV3Flow2.getAutoArchiving())) break;
                this.handleArchiving(elsEsignV3Flow2);
            }
        }
    }

    private ElsEsignV3Flow delayGet(String flowId) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Flow::getFlowId, (Object)flowId), false));
        if (ObjectUtil.isNotEmpty((Object)((Object)flow))) {
            return flow;
        }
        try {
            for (int i = 0; i <= 4; ++i) {
                log.info("\u7b49\u5f85\u6570\u636e\u6267\u884c,{}\u6b21", (Object)i);
                Thread.sleep(5000L);
                flow = (ElsEsignV3Flow)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Flow::getFlowId, (Object)flowId), false));
                if (!ObjectUtil.isNotEmpty((Object)((Object)flow))) continue;
                return flow;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void handleArchiving(ElsEsignV3Flow flow) {
        flow.setArchiving("1");
        this.updateById((Object)flow);
        this.eSignUtil.handleBusType(flow.getBusType(), flow.getRelationId(), EsignStatusEmun.FINISHED.getValue(), CLBusTypeEnum.FINISH, "esignV3");
    }

    @Override
    public FileDownloadRp getFile(String flowId) {
        LaunchRp launchRp = new LaunchRp();
        launchRp.setSignFlowId(flowId);
        FileDownloadRp fileDownloadRp = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-file-get", FileDownloadRp.class);
        return fileDownloadRp;
    }

    public FileDownloadRp getFile(ElsEsignV3Flow flow) {
        LaunchRp launchRp = new LaunchRp();
        launchRp.setSignFlowId(flow.getFlowId());
        FileDownloadRp fileDownloadRp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(launchRp, "e3-flow-file-get", flow.getElsAccount(), FileDownloadRp.class);
        return fileDownloadRp;
    }

    @Override
    public String flowQuery(String id) {
        LaunchRp launchRp = new LaunchRp();
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        launchRp.setSignFlowId(flow.getFlowId());
        JSONObject jsonObject = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-query-detail", JSONObject.class);
        if (ObjectUtil.isNotEmpty((Object)jsonObject)) {
            return jsonObject.getString("signFlowDescription");
        }
        return null;
    }

    @Override
    public void revoke(String id, String reason) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        LaunchRp launchRp = new LaunchRp();
        launchRp.setSignFlowId(flow.getFlowId());
        JSONObject jsonObject = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-revoke", JSONObject.class);
        flow.setEsignStatus(EsignStatusEmun.UNDONE.getValue());
        flow.setLaunch("0");
        flow.setReason(reason);
        this.updateById((Object)flow);
    }

    @Override
    public void startFlow(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        LaunchRp launchRp = new LaunchRp();
        launchRp.setSignFlowId(flow.getFlowId());
        JSONObject jsonObject = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-start", JSONObject.class);
        flow.setInitiate("1");
        this.updateById((Object)flow);
    }

    @Override
    public void archiveFlow(String id) {
        this.handleArchiving((ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id))));
    }

    @Override
    public FileDownloadRp signFileDownload(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        return this.getFile(flow);
    }

    @Override
    public FileDownloadRp signFileDownloadByRelationId(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Flow::getRelationId, (Object)id)).eq(ElsEsignV3Flow::getArchiving, (Object)"1"), false));
        Assert.notNull((Object)((Object)flow), (String)I18nUtil.translate((String)"i18n_field_LSMuIdjPWQI_d1dc8b25", (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7b7e\u7f72\u6587\u4ef6"));
        return this.getFile(flow.getFlowId());
    }

    @Override
    public void multipleSend(ElsEsignV3VO esignVO) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)esignVO.getId()), (String)I18nUtil.translate((String)"i18n_field_VWsM_40db030c", (String)"\u8bf7\u5148\u4fdd\u5b58"));
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(ElsEsignV3Flow::getSendStatus, (Object)"1")).eq(ParentEntity::getId, (Object)esignVO.getId()));
    }

    @Override
    public void saleSignEditAndSend(ElsEsignV3VO esignVO) {
        esignVO.setSaleSendStatus(SendStatusEnum.SENT.getCode());
        this.editMain(esignVO);
    }

    @Override
    public void reject(ElsEsignV3VO esignVO) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(ElsEsignV3Flow::getReason, esignVO.getReason())).set(ElsEsignV3Flow::getSaleSendStatus, (Object)SendStatusEnum.REJECT.getCode())).eq(ParentEntity::getId, (Object)esignVO.getId()));
    }

    @Override
    public void returnSaleSend(ElsEsignV3VO esignVO) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(ElsEsignV3Flow::getReturnSignedFile, (Object)"1")).set(ElsEsignV3Flow::getSaleSendStatus, (Object)SendStatusEnum.RETURNED.getCode())).eq(ParentEntity::getId, (Object)esignVO.getId()));
        this.esignV3AttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Attachment::getHeadId, (Object)esignVO.getId())).eq(ElsEsignV3Attachment::getSignType, (Object)"2"));
        if (CollUtil.isNotEmpty(esignVO.getReturnAttachments())) {
            esignVO.getReturnAttachments().forEach(p -> {
                p.setSignType("2");
                p.setId(null);
                p.setHeadId(esignVO.getId());
            });
            this.esignV3AttachmentService.saveBatch(esignVO.getReturnAttachments());
        }
    }

    @Override
    public void confirm(ElsEsignV3VO esignVO) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(ElsEsignV3Flow::getReturnFileConfirmStatus, (Object)esignVO.getReturnFileConfirmStatus())).set(ElsEsignV3Flow::getReason, esignVO.getReason())).eq(ParentEntity::getId, (Object)esignVO.getId()));
    }

    @Override
    public void sendBackToSale(String id, String rejectReason) {
        ElsEsignV3Flow contract = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)contract), (String)I18nUtil.translate((String)"i18n_field_neLV_27784384", (String)"\u5408\u540c\u4e3a\u7a7a"));
        contract.setReason(rejectReason);
        contract.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
        this.updateById((Object)contract);
    }

    @Override
    public void offLineEditMain(ElsEsignV3VO esignVO) {
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esignVO), ElsEsignV3Flow.class, (String[])new String[0]));
        if (CollUtil.isNotEmpty(esignVO.getSaleAttachments())) {
            this.handleEditAttachment(esignVO.getSaleAttachments(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
            db.setSignFileUploaded("1");
            if ("0".equals(db.getOnlineSealed())) {
                db.setSaleEsignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                if (CollUtil.isNotEmpty(esignVO.getPurchaseSignersList())) {
                    db.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
                } else {
                    db.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
                }
            }
        }
        this.updateById((Object)db);
    }

    @Override
    public ElsEsignV3VO multipleSave(ElsEsignV3VO flow) {
        if (StrUtil.isBlank((CharSequence)flow.getId())) {
            flow.setBusNumber(this.invokeBaseRpcService.getNextCode("srmEsignV3Number", (Object)flow));
            flow.setBusType("multipleSign");
            this.saveMain(flow, null);
        } else {
            this.editMain(flow);
        }
        return flow;
    }

    private LaunchRq buildLaunchRq(ElsEsignV3VO flowVo) {
        ArrayList docs = Lists.newArrayList();
        ArrayList attachments = Lists.newArrayList();
        List<ElsEsignV3Attachment> srmAttachments = flowVo.getPurchaseAttachments();
        if ("0".equals(flowVo.getOnlineSealed()) && EsignRoleTypeEnum.SALE.getCode().equals(flowVo.getFirstSeal())) {
            srmAttachments = flowVo.getSaleAttachments();
        }
        srmAttachments.forEach(x -> {
            LaunchRq.Doc doc = new LaunchRq.Doc();
            doc.setFileId(x.getFileId());
            if ("1".equals(x.getSignType())) {
                docs.add(doc);
            } else {
                attachments.add(doc);
            }
        });
        LaunchRq launchRq = LaunchRq.builder().docs(docs).attachments(attachments).signFlowConfig(this.buildSignFlowConfig(flowVo)).signers(this.buildSigners(flowVo, docs)).signFlowInitiator(this.buildFlowInitiator(flowVo)).build();
        return launchRq;
    }

    private LaunchRq.SignFlowInitiator buildFlowInitiator(ElsEsignV3VO flowVo) {
        LaunchRq.SignFlowInitiator signFlowInitiator = new LaunchRq.SignFlowInitiator();
        LaunchRq.SignFlowInitiator.OrgInitiator orgInitiator = new LaunchRq.SignFlowInitiator.OrgInitiator();
        orgInitiator.setOrgId(flowVo.getPurchaseSignersList().get(0).getOrgId());
        LaunchRq.SignFlowInitiator.Transactor transactor = new LaunchRq.SignFlowInitiator.Transactor();
        transactor.setPsnId(flowVo.getPurchaseSignersList().get(0).getPsnId());
        orgInitiator.setTransactor(transactor);
        signFlowInitiator.setOrgInitiator(orgInitiator);
        return signFlowInitiator;
    }

    public static void main(String[] args) {
        String s = "2_147_361.211";
        String[] a = s.split("_");
        System.out.println(a[0]);
        System.out.println(a[1]);
        System.out.println(a[2]);
    }

    private List<LaunchRq.Signers> buildSigners(ElsEsignV3VO flowVo, List<LaunchRq.Doc> docs) {
        ArrayList dbs = Lists.newArrayList();
        if (SrmSignatoryType.PURCHASE.getCode().equals(flowVo.getFirstSeal())) {
            dbs.addAll(flowVo.getPurchaseSignersList());
            dbs.addAll(flowVo.getSaleSignersList());
        } else {
            dbs.addAll(flowVo.getSaleSignersList());
            dbs.addAll(flowVo.getPurchaseSignersList());
        }
        ArrayList list = Lists.newArrayList();
        int signOrder = 1;
        for (ElsEsignV3SignersVO signer : dbs) {
            LaunchRq.Signers toSigners = new LaunchRq.Signers();
            LaunchRq.Signers.SignConfig signConfig = new LaunchRq.Signers.SignConfig();
            signConfig.setSignOrder(signOrder++);
            toSigners.setSignConfig(signConfig);
            toSigners.setSignerType(Integer.valueOf(signer.getSignerType()));
            toSigners.setNoticeConfig(new LaunchRq.Signers.NoticeConfig());
            ArrayList signFields = Lists.newArrayList();
            switch (EsignV3SignerTypeEnum.getByValue(signer.getSignerType())) {
                case PSN: {
                    PersonalRq.PsnAuthConfig psnAuthConfig = new PersonalRq.PsnAuthConfig();
                    psnAuthConfig.setPsnId(signer.getPsnId());
                    toSigners.setPsnSignerInfo(psnAuthConfig);
                    break;
                }
                case ORG: {
                    LaunchRq.Signers.OrgSignerInfo orgSignerInfo = new LaunchRq.Signers.OrgSignerInfo();
                    PersonalRq.PsnAuthConfig tr = new PersonalRq.PsnAuthConfig();
                    tr.setPsnId(signer.getPsnId());
                    if (!StrUtil.equals((CharSequence)"1", (CharSequence)signer.getAutoArchive())) {
                        orgSignerInfo.setTransactorInfo(tr);
                        orgSignerInfo.setOrgId(signer.getOrgId());
                    }
                    toSigners.setOrgSignerInfo(orgSignerInfo);
                    break;
                }
            }
            if (CollUtil.isNotEmpty(signer.getSignersActions())) {
                for (ElsEsignV3Action signersAction : signer.getSignersActions()) {
                    fileId = signersAction.getFilesId();
                    sf = new LaunchRq.Signers.SignFields();
                    sf.setFileId(fileId);
                    sf.setCustomBizNum(signer.getId());
                    normalSignFieldConfig = new LaunchRq.Signers.SignFields.NormalSignFieldConfig();
                    if (StrUtil.equals((CharSequence)"1", (CharSequence)signersAction.getAutoArchive())) {
                        normalSignFieldConfig.setFreeMode(Boolean.FALSE);
                    } else if (StrUtil.isNotBlank((CharSequence)signersAction.getSignArea())) {
                        normalSignFieldConfig.setFreeMode(Boolean.FALSE);
                        LaunchRq.Signers.SignFields.NormalSignFieldConfig.SignFieldPosition signFieldPosition = new LaunchRq.Signers.SignFields.NormalSignFieldConfig.SignFieldPosition();
                        String[] area = signersAction.getSignArea().split("_");
                        signFieldPosition.setPositionPage(area[0]);
                        signFieldPosition.setPositionX(Float.valueOf(area[1]));
                        signFieldPosition.setPositionY(Float.valueOf(area[2]));
                        normalSignFieldConfig.setSignFieldPosition(signFieldPosition);
                    } else {
                        normalSignFieldConfig.setFreeMode(Boolean.TRUE);
                    }
                    normalSignFieldConfig.setAutoSign(StrUtil.equals((CharSequence)"1", (CharSequence)signer.getAutoArchive()));
                    normalSignFieldConfig.setAssignedSealId(signersAction.getSealIds());
                    if (StrUtil.isNotBlank((CharSequence)signersAction.getSignFieldStyle())) {
                        normalSignFieldConfig.setSignFieldStyle(Integer.valueOf(signersAction.getSignFieldStyle()));
                    }
                    sf.setNormalSignFieldConfig(normalSignFieldConfig);
                    signFields.add(sf);
                }
            } else {
                for (LaunchRq.Doc doc : docs) {
                    fileId = doc.getFileId();
                    sf = new LaunchRq.Signers.SignFields();
                    sf.setFileId(fileId);
                    sf.setCustomBizNum(signer.getId());
                    normalSignFieldConfig = new LaunchRq.Signers.SignFields.NormalSignFieldConfig();
                    normalSignFieldConfig.setFreeMode(Boolean.TRUE);
                    sf.setNormalSignFieldConfig(normalSignFieldConfig);
                    signFields.add(sf);
                }
            }
            toSigners.setSignFields(signFields);
            list.add(toSigners);
        }
        return list;
    }

    private LaunchRq.SignFlowConfig buildSignFlowConfig(ElsEsignV3VO flowVo) {
        LaunchRq.SignFlowConfig signFlowConfig = new LaunchRq.SignFlowConfig();
        signFlowConfig.setSignFlowTitle(flowVo.getBusinessScene());
        if (ObjectUtil.isNotEmpty((Object)flowVo.getCutOffTime())) {
            signFlowConfig.setSignFlowExpireTime(flowVo.getCutOffTime().getTime());
        }
        if (StrUtil.isNotBlank((CharSequence)flowVo.getAutoInitiate())) {
            signFlowConfig.setAutoStart("1".equals(flowVo.getAutoInitiate()));
        }
        if (StrUtil.isNotBlank((CharSequence)flowVo.getNoticeType())) {
            signFlowConfig.setNoticeConfig(LaunchRq.SignFlowConfig.NoticeConfig.builder().noticeTypes(flowVo.getNoticeType()).build());
        }
        signFlowConfig.setNotifyUrl(this.esignV3Properties.getCallBackUrl() + "/esignv3/elsEsignV3Flow/noToken/callback");
        return signFlowConfig;
    }

    private void handleEditSigner(List<ElsEsignV3SignersVO> signers, String roleType, String headId) {
        this.signersService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Signers::getHeadId, (Object)headId)).eq(ElsEsignV3Signers::getRoleType, (Object)roleType));
        this.actionService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Action::getFlowId, (Object)headId)).eq(ElsEsignV3Action::getRoleType, (Object)roleType));
        ArrayList dbSigners = Lists.newArrayList();
        signers.forEach(p -> {
            p.setRoleType(roleType);
            p.setId(IdWorker.getIdStr());
            p.setHeadId(headId);
            dbSigners.add(p);
            if (CollUtil.isNotEmpty(p.getSignersActions())) {
                p.getSignersActions().forEach(a -> {
                    a.setId(IdWorker.getIdStr());
                    a.setFlowId(headId);
                    a.setRoleType(roleType);
                    a.setHeadId(p.getId());
                });
                this.actionService.saveBatch(p.getSignersActions());
            }
        });
        this.signersService.saveBatch(dbSigners);
    }

    private void handleEditAttachment(List<ElsEsignV3Attachment> attachments, String roleType, String headId) {
        this.esignV3AttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Attachment::getAccountType, (Object)roleType)).eq(ElsEsignV3Attachment::getHeadId, (Object)headId));
        attachments.forEach(p -> {
            p.setAccountType(roleType);
            p.setId(null);
            p.setHeadId(headId);
        });
        this.esignV3AttachmentService.saveBatch(attachments);
    }
}

