/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.dto.PushBodyDTO;
import com.els.modules.extend.api.vo.ThirdVO;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ErpTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(ErpTokenUtil.class);
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Value(value="${SYS.ERP.auth.client_id}")
    private String clientId;
    @Value(value="${SYS.ERP.auth.client_secret}")
    private String clientSecret;
    @Value(value="${SYS.ERP.auth.username}")
    private String userName;
    @Value(value="${SYS.ERP.auth.accountId}")
    private String accountId;
    @Value(value="${SYS.ERP.auth.language}")
    private String language;
    private String srmInterfaceCode = "getK3AccessToken";
    public static final String ACCESS_TOKEN = "SRM_SUPPLIER_MASTER_ERP_ACCESSTOKEN_";
    private static final Integer ERP_SUCCESS_CODE = 200;
    private static final String ERP_SUCCESS_CODE_STR = "200";

    public String getErpToken(String elsAccount) {
        return this.accessToken(elsAccount);
    }

    private String accessToken(String elsAccount) {
        String tenantId = StrUtil.isNotEmpty((CharSequence)elsAccount) ? elsAccount : TenantContext.getTenant();
        JSONObject param0 = new JSONObject();
        param0.put("bus_account", (Object)tenantId);
        param0.put("srm_interface_code", (Object)this.srmInterfaceCode);
        JSONObject urlParam = new JSONObject();
        urlParam.put("client_id", (Object)this.clientId);
        urlParam.put("client_secret", (Object)this.clientSecret);
        urlParam.put("username", (Object)this.userName);
        urlParam.put("accountId", (Object)this.accountId);
        urlParam.put("nonce", (Object)UUID.randomUUID((boolean)true).toString().replaceAll("-", ""));
        urlParam.put("timestamp", (Object)DateUtil.now());
        urlParam.put("language", (Object)this.language);
        param0.put("body", (Object)urlParam);
        JSONObject object0 = this.interfaceUtil.callInterface(tenantId, null, param0, null);
        if (object0.getBoolean("success").booleanValue()) {
            JSONObject data = object0.getJSONObject("result");
            String accessToken = data.getJSONObject("data").getString("access_token");
            long expiresIn = data.getJSONObject("data").getLong("expires_in");
            long seconds = TimeUnit.MILLISECONDS.toSeconds(expiresIn);
            this.redisUtil.set(ACCESS_TOKEN + elsAccount, (Object)accessToken, seconds - 10L);
            return accessToken;
        }
        return null;
    }

    public ThirdVO pushDataToK3(PushBodyDTO erpBodyDTO) {
        String erpToken = this.getErpToken(erpBodyDTO.getElsAccount());
        log.info("callK3PushInterface erp token:{}", (Object)erpToken);
        if (StringUtils.isBlank((CharSequence)erpToken)) {
            throw new ELSBootException("erp \u8ba4\u8bc1\u5931\u8d25");
        }
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)erpBodyDTO.getElsAccount());
        param.put("srm_interface_code", (Object)erpBodyDTO.getSrmInterfaceCode());
        param.put("body", erpBodyDTO.getData());
        JSONObject headParam = new JSONObject();
        headParam.put("accesstoken", (Object)erpToken);
        param.put("header_param", (Object)headParam);
        log.info("callK3PushInterface req: {}", (Object)JSONObject.toJSONString((Object)param));
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        JSONObject resultObj = interfaceUtil.callInterface(erpBodyDTO.getElsAccount(), null, param, null);
        log.info("callK3PushInterface resp: {}", (Object)resultObj.toString());
        if (resultObj.getBoolean("success").booleanValue()) {
            JSONObject data = resultObj.getJSONObject("result");
            if (data == null) {
                throw new ELSBootException("\u63a8\u9001\u5931\u8d25: data\u6570\u636e\u4e3a\u7a7a");
            }
            if (ERP_SUCCESS_CODE_STR.equals(data.get((Object)"errorCode"))) {
                return ThirdVO.success("\u4f9b\u5e94\u5546\u786e\u8ba4, \u63a8\u9001\u6210\u529f");
            }
            String msg = resultObj.getJSONObject("result") == null ? "\u7a7a\u503c" : resultObj.getJSONObject("result").getString("message");
            return ThirdVO.error(msg);
        }
        throw new ELSBootException(String.format("\u63a8\u9001\u5931\u8d25all:%s", resultObj.getString("message")));
    }

    public ThirdVO pushDataToErp(PushBodyDTO erpBodyDTO) {
        String erpToken = this.getErpToken(erpBodyDTO.getElsAccount());
        log.info("callK3PushInterface erp token:{}", (Object)erpToken);
        if (StringUtils.isBlank((CharSequence)erpToken)) {
            throw new ELSBootException("erp \u8ba4\u8bc1\u5931\u8d25");
        }
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)erpBodyDTO.getElsAccount());
        param.put("srm_interface_code", (Object)erpBodyDTO.getSrmInterfaceCode());
        JSONObject body = new JSONObject();
        param.put("body", erpBodyDTO.getData());
        JSONObject headParam = new JSONObject();
        headParam.put("accesstoken", (Object)erpToken);
        param.put("header_param", (Object)headParam);
        log.info("callK3PushInterface req: {}", (Object)JSONObject.toJSONString((Object)param));
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        JSONObject resultObj = interfaceUtil.callInterface(erpBodyDTO.getElsAccount(), null, param, null);
        log.info("callK3PushInterface resp: {}", (Object)resultObj.toString());
        if (resultObj.getBoolean("success").booleanValue()) {
            JSONObject data = resultObj.getJSONObject("result");
            if (data == null) {
                throw new ELSBootException("\u63a8\u9001\u5931\u8d25: data\u6570\u636e\u4e3a\u7a7a");
            }
            if (ERP_SUCCESS_CODE_STR.equals(data.getString("errorCode"))) {
                return ThirdVO.success("\u4f9b\u5e94\u5546\u786e\u8ba4, \u63a8\u9001\u6210\u529f");
            }
            String msg = resultObj.getJSONObject("result") == null ? "\u7a7a\u503c" : resultObj.getJSONObject("result").getString("message");
            return ThirdVO.error(msg);
        }
        throw new ELSBootException(String.format("\u63a8\u9001\u5931\u8d25all:%s", resultObj.getString("message")));
    }
}

