/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.service;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import com.els.modules.base.api.service.SaleAttachmentRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FileUtils {
    @Autowired
    @Lazy
    private PurchaseAttachmentRpcService purchaseAttachmentRpcService;
    @Autowired
    @Lazy
    private SaleAttachmentRpcService saleAttachmentRpcService;
    private static final String SERVICE_ADDRESS = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.service.address");

    public String getFileFullUrl(String id) {
        String signature = null;
        PurchaseAttachmentDTO dbPurchaseAttachment = this.purchaseAttachmentRpcService.selectById(id);
        String key = IdWorker.getIdStr();
        if (dbPurchaseAttachment == null) {
            SaleAttachmentDTO dbSaleAttachment = this.saleAttachmentRpcService.selectById(id);
            if (dbSaleAttachment == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
            }
            signature = SERVICE_ADDRESS + "/els/external/purchase/sale/download?id=" + dbSaleAttachment.getId() + "&key=" + key + "&fullfilename=" + dbSaleAttachment.getFileName().replace("&", "@");
        } else {
            signature = SERVICE_ADDRESS + "/els/external/purchase/download/attachment?id=" + dbPurchaseAttachment.getId() + "&key=" + key + "&fullfilename=" + dbPurchaseAttachment.getFileName().replace("&", "@");
        }
        return signature.replace("\\", "/");
    }
}

