/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.u8.api.extend;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GetPaymentApplyFromLuoShiU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentApplyFromLuoShiU8ServiceImpl.class);
    @Resource
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Resource
    private AccountRpcService accountRpcService;

    public JSONObject before(JSONObject jsonObject, Object o) {
        JSONObject body = new JSONObject();
        body.put("dwbm", (Object)"02");
        body.put("djzt", (Object)"3");
        body.put("page_now", (Object)"1");
        body.put("page_size", (Object)"2");
        jsonObject.put("body", (Object)body);
        log.info("SRM\u83b7\u53d6\u4ed8\u6b3e\u7533\u8bf7\u5355\u63a5\u53e3\uff0c\u5165\u53c2\u4e3a\uff1a" + jsonObject);
        return jsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject after(JSONObject jsonObject, JSONObject jsonObject1, Object o) {
        log.info("SRM\u83b7\u53d6\u4ed8\u6b3e\u7533\u8bf7\u5355\u63a5\u53e3\uff0c\u51fa\u53c2\u4e3a\uff1a" + jsonObject);
        if (!CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) throw new ELSBootException("SRM\u83b7\u53d6ERP\u4ed8\u6b3e\u7533\u8bf7\u63a5\u5931\u8d25: " + jsonObject.getString("message"));
        JSONObject result = jsonObject.getJSONObject("result");
        String returnStatus = result.getString("status");
        if ("success".equals(returnStatus)) {
            JSONObject data = JSONObject.parseObject((String)result.getString("data"));
            Assert.isTrue((!data.getInteger("retcount").equals(BigDecimal.ZERO) ? 1 : 0) != 0, (String)"\u6682\u65e0\u7269\u6599\u6570\u636e\u9700\u8981\u540c\u6b65");
            JSONArray array = data.getJSONArray("datas");
            if (data.getInteger("retcount") == 0) {
                return null;
            }
            List templateList = this.templateRpcService.getDefaultTemplateByType("paymentApply");
            Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u4ed8\u6b3e\u7533\u8bf7\u9ed8\u8ba4\u6a21\u677f");
            TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
            Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
            ArrayList saveHeadList = new ArrayList();
            ArrayList saveItemList = new ArrayList();
            Map<String, SupplierMasterDataDTO> masterDataMap = this.getSupplierMap(array);
            for (Object object : array) {
                JSONObject item = (JSONObject)object;
                String parentvo = item.getString("parentvo");
                JSONObject parentJson = JSONObject.parseObject((String)parentvo);
                String children = item.getString("childrenvo");
                JSONArray childrenArray = JSONObject.parseArray((String)children);
                this.checkRequired(parentJson);
                PurchasePaymentApplyHead applyHead = new PurchasePaymentApplyHead();
                applyHead.setTemplateName(template.getTemplateName());
                applyHead.setTemplateNumber(template.getTemplateNumber());
                applyHead.setTemplateAccount(template.getElsAccount());
                applyHead.setTemplateVersion(template.getTemplateVersion().toString());
                applyHead.setElsAccount(TenantContext.getTenant());
                applyHead.setSupplierName(parentJson.getString("hbbm_name"));
                SupplierMasterDataDTO supplierMasterDataDTO = masterDataMap.get(parentJson.getString("hbbm_code"));
                if (null != supplierMasterDataDTO) {
                    applyHead.setToElsAccount(supplierMasterDataDTO.getToElsAccount());
                }
                applyHead.setPaymentApplyNumber(parentJson.getString("djbh"));
                applyHead.setPeerSystemNumber(parentJson.getString("djbh"));
                applyHead.setPaymentApplyStatus(parentJson.getString("djzt"));
                applyHead.setPaymentApplyDate(parentJson.getDate("djrq"));
                applyHead.setCompany(parentJson.getString("dwbm_code"));
                applyHead.setFbk1(parentJson.getString("deptid_code"));
                applyHead.setPurchasePrincipal(parentJson.getString("ywybm_code"));
                applyHead.setCurrency(parentJson.getString("bzbm_code"));
                applyHead.setFbk19(parentJson.getString("vouchid"));
                applyHead.setTaxTotalAmount(parentJson.getBigDecimal("bbje"));
                applyHead.setDeleted(CommonConstant.NO_0);
                ArrayList<PurchasePaymentApplyItem> applyItems = new ArrayList<PurchasePaymentApplyItem>();
                for (Object i : childrenArray) {
                    JSONObject applyItemJSON = (JSONObject)i;
                    PurchasePaymentApplyItem applyItem = new PurchasePaymentApplyItem();
                    applyItem.setPaymentApplyNumber(applyHead.getPaymentApplyNumber());
                    applyItem.setCurrency(applyItemJSON.getString("bzbm_code"));
                    applyItem.setClosingAmount(applyItemJSON.getBigDecimal("jfbbje"));
                    applyItem.setPayAmount(applyItemJSON.getBigDecimal("jfbbje"));
                    applyItem.setPeerSystemNumber(applyHead.getPeerSystemNumber());
                    applyItem.setDeleted(CommonConstant.NO_0);
                    applyItems.add(applyItem);
                }
                PurchasePaymentApplyHeadVO applyHeadVO = new PurchasePaymentApplyHeadVO();
                BeanUtils.copyProperties((Object)applyHead, (Object)applyHeadVO);
                applyHeadVO.setPaymentApplyItemList(applyItems);
                this.purchasePaymentApplyHeadService.saveMain(applyHead, applyHeadVO);
            }
            return null;
        } else {
            String errorMsg = result.getString("errormsg");
            throw new ELSBootException("SRM\u83b7\u53d6ERP\u4ed8\u6b3e\u7533\u8bf7\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
        }
    }

    private Map<String, SupplierMasterDataDTO> getSupplierMap(JSONArray array) {
        List supplierCodeList = array.stream().map(object -> {
            JSONObject json = (JSONObject)object;
            return json.getString("hbbm_code");
        }).distinct().collect(Collectors.toList());
        List supplierList = this.supplierMasterDataRpcService.getSupplierMasterDataBySupplierCode(supplierCodeList);
        return supplierList.stream().filter(master -> StringUtils.isNotBlank((CharSequence)master.getSupplierCode())).collect(Collectors.toMap(master -> master.getSupplierCode().toUpperCase(), Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private void checkRequired(JSONObject item) {
    }
}

