/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.cbs.api;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.third.cbs.common.CBSBusinessManager;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPaymentApplyFromShiWeiCBSImpl
extends CBSBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentApplyFromShiWeiCBSImpl.class);
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        block9: {
            JSONObject customObj = (JSONObject)custom;
            List dbList = (List)customObj.get((Object)"dbList");
            try {
                String requestParam = this.getRequestParam(customObj);
                log.error("\u540c\u6b65CBS\u4ed8\u6b3e\u7533\u8bf7\u652f\u4ed8\u7ed3\u679c GetPaymentApplyFromShiWeiCBSImpl info[" + requestParam + "]");
                String resultString = this.sendHttp(requestParam, obj, custom);
                JSONObject result = JSONObject.parseObject((String)resultString);
                if ("0".equals(result.getString("code"))) {
                    JSONObject data = result.getJSONObject("data");
                    JSONArray list = data.getJSONArray("list").stream().filter(o -> ((JSONObject)o).getString("payStatus").equals("g") || ((JSONObject)o).getString("payStatus").equals("h")).collect(Collectors.toCollection(JSONArray::new));
                    if (CollUtil.isEmpty((Collection)list)) {
                        log.error("GetPaymentApplyFromShiWeiCBSImpl \u672a\u83b7\u53d6\u5230\u4ed8\u6b3e\u5355\u636e");
                        return false;
                    }
                    for (PurchasePaymentApplyHead applyHead : dbList) {
                        for (Object o2 : list) {
                            String msg;
                            JSONObject object = (JSONObject)o2;
                            if (!object.getString("busNum").equals(applyHead.getFbk21())) continue;
                            log.error("GetPaymentApplyFromShiWeiCBSImpl" + applyHead.getPaymentApplyNumber() + "\u8fd4\u56de\u7ed3\u679c " + object.toJSONString());
                            if ("g".equals(object.getString("payStatus"))) {
                                try {
                                    this.purchasePaymentApplyHeadService.paymentConfirmation(applyHead.getId());
                                }
                                catch (Exception e) {
                                    log.error("GetPaymentApplyFromShiWeiCBSImpl \u786e\u8ba4\u652f\u4ed8\u540c\u6b65U8\u5931\u8d25" + e.getMessage());
                                    PurchasePaymentApplyHead head = new PurchasePaymentApplyHead();
                                    head.setId(applyHead.getId());
                                    msg = e.getMessage().length() > 90 ? e.getMessage().substring(0, 90) : e.getMessage();
                                    head.setFbk23("U8 -> " + msg);
                                    this.purchasePaymentApplyHeadService.updateById((Object)head);
                                }
                                continue;
                            }
                            PurchasePaymentApplyHead head = new PurchasePaymentApplyHead();
                            head.setId(applyHead.getId());
                            String errorMsg = object.getString("errorMsg");
                            msg = errorMsg.length() > 90 ? errorMsg.substring(0, 90) : errorMsg;
                            head.setFbk23("CBS -> " + object.getString("errorMsg"));
                            this.purchasePaymentApplyHeadService.updateById((Object)head);
                        }
                    }
                    break block9;
                }
                throw new ELSBootException(result.getString("msg"));
            }
            catch (Exception e) {
                throw new ELSBootException(e.getMessage());
            }
        }
        return false;
    }

    private String getRequestParam(JSONObject customObj) {
        JSONObject object = new JSONObject();
        JSONArray busTypeList = new JSONArray();
        busTypeList.add((Object)"202");
        object.put("busTypeList", (Object)busTypeList);
        JSONArray statusList = new JSONArray();
        statusList.add((Object)"4");
        object.put("statusList", (Object)statusList);
        object.put("queryDateStart", (Object)customObj.getString("beginDate"));
        object.put("queryDateEnd", (Object)customObj.getString("endDate"));
        return JSONObject.toJSONString((Object)object);
    }

    public JSONObject before(JSONObject obj, Object custom) {
        return null;
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        return null;
    }
}

