/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.cbs.api;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.DictRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.third.cbs.common.CBSBusinessManager;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushPaymentApplyToShiWeiCBSImpl
extends CBSBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushPaymentApplyToShiWeiCBSImpl.class);
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private DictRpcService dictRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        PurchasePaymentApplyHead head = (PurchasePaymentApplyHead)customObj.get((Object)"purchasePaymentApplyHead");
        log.info("PushPaymentApplyToShiWeiCBSImpl before ");
        try {
            String requestData = this.getData(head);
            log.error("\u4ed8\u6b3e\u7533\u8bf7" + head.getPaymentApplyNumber() + "\u540c\u6b65CBS PushPaymentApplyToShiWeiCBSImpl info[" + requestData + "]");
            String resultString = this.sendHttp(requestData, obj, custom);
            JSONObject result = JSONObject.parseObject((String)resultString);
            log.error("\u4ed8\u6b3e\u7533\u8bf7" + head.getPaymentApplyNumber() + "\u540c\u6b65CBS PushPaymentApplyToShiWeiCBSImpl result[" + resultString + "]");
            if (!"0".equals(result.getString("code"))) {
                throw new ELSBootException(result.getString("msg"));
            }
            JSONArray data = result.getJSONArray("data");
            if (data != null && data.size() > 0) {
                JSONObject o = (JSONObject)data.get(0);
                if (!o.getBooleanValue("successed")) {
                    throw new ELSBootException(o.getString("errorMsg"));
                }
                PurchasePaymentApplyHead applyHead = new PurchasePaymentApplyHead();
                applyHead.setId(head.getId());
                applyHead.setFbk21(o.getString("busNum"));
                applyHead.setFbk22(DateUtil.formatDate((Date)new Date()));
                ((PurchasePaymentApplyHeadService)SpringContextUtils.getBean(PurchasePaymentApplyHeadService.class)).updateById((Object)applyHead);
            }
        }
        catch (Exception e) {
            throw new ELSBootException("\u540c\u6b65CBS\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return false;
    }

    private String getData(PurchasePaymentApplyHead head) {
        String cbsCurrency = this.invokeBaseRpcService.queryDictTextByKey("cbsCurrency", head.getCurrency(), head.getElsAccount());
        JSONArray array = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("referenceNum", (Object)head.getPaymentApplyNumber());
        object.put("amount", (Object)head.getPaymentAmount().stripTrailingZeros().toPlainString());
        object.put("busType", (Object)"202");
        object.put("currency", (Object)cbsCurrency);
        object.put("payAccount", (Object)head.getFbk4());
        object.put("revAccount", (Object)head.getReceiverBankBccountName());
        object.put("revAccountName", (Object)head.getSupplierName());
        object.put("revBankType", (Object)head.getFbk7());
        object.put("revBankName", (Object)head.getReceiverBank());
        object.put("purpose", (Object)head.getFbk8());
        object.put("summary", (Object)head.getPurchaseRemark());
        object.put("urgentTag", (Object)"0");
        object.put("personalFlag", (Object)"0");
        array.add((Object)object);
        log.error("\u4ed8\u6b3e\u7533\u8bf7" + head.getPaymentApplyNumber() + "\u540c\u6b65CBS PushPaymentApplyToShiWeiCBSImpl info[" + JSONArray.toJSONString((Object)array) + "]");
        return JSONArray.toJSONString((Object)array);
    }

    public JSONObject before(JSONObject obj, Object custom) {
        return obj;
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        return null;
    }
}

