/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.cbs.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.CompanyInterfaceConfigItemDTO;
import com.els.modules.finance.third.cbs.utils.CBSSM2Util;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CBSBusinessManager {
    private static final Logger log = LoggerFactory.getLogger(CBSBusinessManager.class);
    private static final String CBS_TOKEN = "sys:cbs:third:token:";
    private static RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);

    protected String sendHttp(String data, JSONObject obj, Object custom) throws Exception {
        String elsAccount = obj.getString("bus_account");
        JSONObject customObj = (JSONObject)custom;
        if (StringUtils.isBlank((CharSequence)customObj.getString(""))) {
            List configItemList = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).getConfig(elsAccount, "getCBSToken");
            if (CollUtil.isEmpty((Collection)configItemList)) {
                throw new ELSBootException("\u627e\u4e0d\u5230\u83b7\u53d6CBS token\u63a5\u53e3\u914d\u7f6e\u4fe1\u606f");
            }
            String customParam = ((CompanyInterfaceConfigItemDTO)configItemList.get(0)).getCustomParam();
            JSONObject customParamObj = JSONObject.parseObject((String)customParam);
            Assert.hasText((String)customParamObj.getString("platformPublicKey"), (String)"\u8bf7\u5148\u914d\u7f6e\u5e73\u53f0\u516c\u94a5");
            Assert.hasText((String)customParamObj.getString("enterprisePrivateKey"), (String)"\u8bf7\u5148\u914d\u7f6e\u4f01\u4e1a\u79c1\u94a5");
            customObj.put("platformPublicKey", (Object)customParamObj.getString("platformPublicKey"));
            customObj.put("enterprisePrivateKey", (Object)customParamObj.getString("enterprisePrivateKey"));
        }
        long timestamp = System.currentTimeMillis();
        byte[] requestDataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] timestampBytes = ("&timestamp=" + timestamp).getBytes(StandardCharsets.UTF_8);
        byte[] newBytes = new byte[requestDataBytes.length + timestampBytes.length];
        System.arraycopy(requestDataBytes, 0, newBytes, 0, requestDataBytes.length);
        System.arraycopy(timestampBytes, 0, newBytes, requestDataBytes.length, timestampBytes.length);
        byte[] encryptedData = CBSSM2Util.encrypt(customObj.getString("platformPublicKey"), requestDataBytes);
        byte[] signature = CBSSM2Util.sign(customObj.getString("enterprisePrivateKey"), newBytes);
        String sign = Base64.encodeBase64String((byte[])CBSSM2Util.encodeDERSignature(signature));
        JSONObject customParam = customObj.getJSONObject("custom_param");
        log.error("CBS\u63a5\u53e3\u8c03\u7528\u8bb0\u5f55 before url:[" + customParam.getString("url") + "] \n data:[" + data + "]");
        HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)customParam.getString("url")).header("X-MBCLOUD-API-SIGN", sign)).header("X-MBCLOUD-TIMESTAMP", Long.toString(timestamp))).header("Content-Type", "application/json")).header("Authorization", "Bearer " + this.getToken(obj, custom))).body(encryptedData).execute();
        return this.handlerResult(response, obj, custom);
    }

    private String getToken(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = "";
        elsAccount = customObj.containsKey((Object)"bus_account") && StringUtils.isNotBlank((CharSequence)customObj.getString("bus_account")) ? customObj.getString("bus_account") : obj.getString("bus_account");
        String tokenKey = CBS_TOKEN + elsAccount;
        String token = (String)redisUtil.get(tokenKey);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        List configItemList = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).getConfig(elsAccount, "getCBSToken");
        String customParam = ((CompanyInterfaceConfigItemDTO)configItemList.get(0)).getCustomParam();
        JSONObject customParamObj = JSONObject.parseObject((String)customParam);
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"getCBSToken");
        JSONObject body = new JSONObject();
        body.put("app_id", (Object)customParamObj.getString("app_id"));
        body.put("app_secret", (Object)customParamObj.getString("app_secret"));
        body.put("grant_type", (Object)"client_credentials");
        param.put("body", (Object)body);
        JSONObject result = ((InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class)).callInterface(elsAccount, null, param, null);
        if (result.getIntValue("code") != 200) {
            throw new ELSBootException(result.getString("message"));
        }
        JSONObject result2 = result.getJSONObject("result");
        JSONObject data = result2.getJSONObject("data");
        if (data == null || !StringUtils.isNotBlank((CharSequence)data.getString("token"))) {
            throw new ELSBootException("\u83b7\u53d6CBS token\u5931\u8d25\uff1a" + result2.getString("msg"));
        }
        token = data.getString("token");
        redisUtil.set(tokenKey, (Object)token, (long)data.getInteger("expires").intValue());
        return token;
    }

    protected String handlerResult(HttpResponse response, JSONObject obj, Object custom) throws Exception {
        String header2;
        JSONObject customObj = (JSONObject)custom;
        byte[] responseData = response.bodyBytes();
        String header1 = response.header("X-MBCLOUD-ENCRYPTION-ENABLED");
        if (StringUtils.isNotBlank((CharSequence)header1)) {
            responseData = CBSSM2Util.decrypt(customObj.getString("enterprisePrivateKey"), responseData);
        }
        if (StringUtils.isNotBlank((CharSequence)(header2 = response.header("X-Mbcloud-Compress")))) {
            ByteArrayInputStream input = new ByteArrayInputStream(responseData);
            GZIPInputStream gzipInput = new GZIPInputStream(input);
            responseData = IOUtils.toByteArray((InputStream)gzipInput);
        }
        String responseString = new String(responseData);
        return new String(responseData);
    }
}

