/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.cbs.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.finance.api.enumerate.PaymentApplyStatusEnum;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPaymentApplyFromShiWeiCBSJobRpcServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentApplyFromShiWeiCBSJobRpcServiceImpl.class);
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;

    public void execute(String parameter) {
        String requestId = "PaymentApplyFromShiWeiCBSJob";
        String LOCK_PREFIX = "PaymentApplyFromShiWeiCBSJob_schedule";
        long EXPIRE_TIME = 50000L;
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        if (!this.redisUtil.tryGetDistributedLock(LOCK_PREFIX, requestId, EXPIRE_TIME)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LSiKRcWVxPVBRc_38df5694", (String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        TenantContext.setTenant((String)paramObj.getString("tenant"));
        log.error("\u83b7\u53d6CBS\u4ed8\u6b3e\u7533\u8bf7\u5217\u8868\u5b9a\u65f6\u4efb\u52a1 GetPaymentApplyFromShiWeiCBSJobRpcServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp());
        long startTime = System.currentTimeMillis();
        try {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchasePaymentApplyHead::getPaymentApplyStatus, (Object)PaymentApplyStatusEnum.OUTSTANDING.getValue())).isNotNull(PurchasePaymentApplyHead::getFbk21)).ne(PurchasePaymentApplyHead::getFbk21, (Object)"")).eq(PurchasePaymentApplyHead::getAuditStatus, (Object)AuditStatusEnum.AUDIT_FINISH.getValue());
            List list = this.purchasePaymentApplyHeadService.list((Wrapper)wrapper);
            if (CollUtil.isNotEmpty((Collection)list)) {
                PurchasePaymentApplyHead firstHead = list.stream().filter(head -> StringUtils.isNotBlank((CharSequence)head.getFbk22())).min(Comparator.comparing(PurchasePaymentApplyHead::getFbk22)).orElse(null);
                PurchasePaymentApplyHead lastHead = list.stream().filter(head -> StringUtils.isNotBlank((CharSequence)head.getFbk22())).max(Comparator.comparing(PurchasePaymentApplyHead::getFbk22)).orElse(null);
                if (firstHead != null && lastHead != null) {
                    JSONObject custom = new JSONObject();
                    custom.put("beginDate", (Object)firstHead.getFbk22());
                    custom.put("endDate", (Object)lastHead.getFbk22());
                    custom.put("dbList", (Object)list);
                    this.interfaceUtil.callInterface(TenantContext.getTenant(), "getPaymentApplyResult", (Object)custom);
                } else {
                    log.error("GetPaymentApplyFromShiWeiCBSJobRpcServiceImpl \u6570\u636e\u5f02\u5e38\uff0c\u540c\u6b65CBS\u65e5\u671f\u6570\u636e\u4e3a\u7a7a");
                }
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_PREFIX, requestId);
        }
        log.error("\u83b7\u53d6CBS\u4ed8\u6b3e\u7533\u8bf7\u5217\u8868\u5b9a\u65f6\u4efb\u52a1 GetPaymentApplyFromShiWeiCBSJobRpcServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + "\u603b\u8017\u65f6" + (System.currentTimeMillis() - startTime) + "ms");
    }
}

