/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.cbs.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBSSM2Util {
    private static final Logger log = LoggerFactory.getLogger(CBSSM2Util.class);
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String TARGET_CONTENT_TYPE = "application/json";
    public static final String SIGN_HEADER_NAME = "X-MBCLOUD-API-SIGN";
    public static final String TIMESTAMP_HEADER = "X-MBCLOUD-TIMESTAMP";
    public static final String ENCRYPTION_ENABLED_HEADER_NAME = "X-MBCLOUD-ENCRYPTION-ENABLED";
    public static final String X_MBCLOUD_COMPRESS = "X-Mbcloud-Compress";
    public static final String AUTHORIZATION = "Authorization";
    public static final String BEARER = "Bearer ";
    private static final String STD_NAME = "sm2p256v1";

    private CBSSM2Util() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] encrypt(String publicKey, byte[] data) {
        ECPublicKeyParameters ecPublicKeyParameters = CBSSM2Util.encodePublicKey(Hex.decode((String)publicKey));
        SM2Engine engine = new SM2Engine();
        engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
        byte[] bytes = null;
        try {
            byte[] cipherText = engine.processBlock(data, 0, data.length);
            bytes = CBSSM2Util.C1C2C3ToC1C3C2(cipherText);
        }
        catch (Exception e) {
            log.warn("SM2\u52a0\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return bytes;
    }

    public static byte[] decrypt(String privateKey, byte[] cipherData) {
        ECPrivateKeyParameters ecPrivateKeyParameters = CBSSM2Util.encodePrivateKey(Hex.decode((String)privateKey));
        SM2Engine engine = new SM2Engine();
        engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        byte[] bytes = null;
        try {
            cipherData = CBSSM2Util.C1C3C2ToC1C2C3(cipherData);
            bytes = engine.processBlock(cipherData, 0, cipherData.length);
        }
        catch (Exception e) {
            log.warn("SM2\u89e3\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return bytes;
    }

    public static byte[] sign(String privateKey, byte[] data) {
        ECPrivateKeyParameters ecPrivateKeyParameters = CBSSM2Util.encodePrivateKey(CBSSM2Util.hexToByte(privateKey));
        SM2Signer signer = new SM2Signer();
        ParametersWithID parameters = new ParametersWithID((CipherParameters)ecPrivateKeyParameters, "1234567812345678".getBytes());
        signer.init(true, (CipherParameters)parameters);
        signer.update(data, 0, data.length);
        byte[] signature = null;
        try {
            signature = CBSSM2Util.decodeDERSignature(signer.generateSignature());
        }
        catch (Exception e) {
            log.warn("SM2\u7b7e\u540d\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return signature;
    }

    private static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteInt = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = BigInteger.valueOf(byteInt).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    private static byte[] C1C2C3ToC1C3C2(byte[] cipherText) throws Exception {
        if (cipherText != null && cipherText.length >= 97) {
            byte[] bytes = new byte[cipherText.length];
            System.arraycopy(cipherText, 0, bytes, 0, 65);
            System.arraycopy(cipherText, cipherText.length - 32, bytes, 65, 32);
            System.arraycopy(cipherText, 65, bytes, 97, cipherText.length - 97);
            return bytes;
        }
        throw new Exception("SM2 cipher text error, must be more than 96 bytes and in the format C1||C3||C2.");
    }

    private static byte[] C1C3C2ToC1C2C3(byte[] cipherText) throws Exception {
        if (cipherText != null && cipherText.length >= 97) {
            byte[] bytes = new byte[cipherText.length];
            System.arraycopy(cipherText, 0, bytes, 0, 65);
            System.arraycopy(cipherText, 97, bytes, 65, cipherText.length - 97);
            System.arraycopy(cipherText, 65, bytes, cipherText.length - 32, 32);
            return bytes;
        }
        throw new Exception("SM2 cipher text error, must be more than 96 bytes and in the format C1||C3||C2.");
    }

    private static ECPublicKeyParameters encodePublicKey(byte[] value) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(value, 1, x, 0, 32);
        System.arraycopy(value, 33, y, 0, 32);
        BigInteger X = new BigInteger(1, x);
        BigInteger Y = new BigInteger(1, y);
        ECPoint Q = CBSSM2Util.getSM2Curve().createPoint(X, Y);
        return new ECPublicKeyParameters(Q, CBSSM2Util.getECDomainParameters());
    }

    private static ECCurve getSM2Curve() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)STD_NAME);
        return spec.getCurve();
    }

    private static ECPrivateKeyParameters encodePrivateKey(byte[] value) {
        BigInteger d = new BigInteger(1, value);
        return new ECPrivateKeyParameters(d, CBSSM2Util.getECDomainParameters());
    }

    private static ECDomainParameters getECDomainParameters() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)STD_NAME);
        return new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
    }

    private static byte[] decodeDERSignature(byte[] signature) {
        ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(signature));
        byte[] bytes = new byte[64];
        try {
            ASN1Sequence primitive = (ASN1Sequence)stream.readObject();
            Enumeration enumeration = primitive.getObjects();
            BigInteger R = ((ASN1Integer)enumeration.nextElement()).getValue();
            BigInteger S = ((ASN1Integer)enumeration.nextElement()).getValue();
            byte[] r = CBSSM2Util.format(R.toByteArray());
            byte[] s = CBSSM2Util.format(S.toByteArray());
            System.arraycopy(r, 0, bytes, 0, 32);
            System.arraycopy(s, 0, bytes, 32, 32);
        }
        catch (Exception e) {
            log.warn("decodeDERSignature\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return bytes;
    }

    public static byte[] encodeDERSignature(byte[] signature) {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, r)));
        vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, s)));
        byte[] encoded = null;
        try {
            encoded = new DERSequence(vector).getEncoded();
        }
        catch (Exception e) {
            log.warn("encodeDERSignature\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return encoded;
    }

    private static byte[] format(byte[] value) {
        if (value.length == 32) {
            return value;
        }
        byte[] bytes = new byte[32];
        if (value.length > 32) {
            System.arraycopy(value, value.length - 32, bytes, 0, 32);
        } else {
            System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
        }
        return bytes;
    }
}

