/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.u8.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.finance.api.enumerate.PaymentApplyStatusEnum;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.mapper.PurchasePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyItemMapper;
import com.els.modules.finance.mapper.SalePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GetPaymentApplyFromManXiaoBaoU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentApplyFromManXiaoBaoU8ServiceImpl.class);
    @Resource
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Resource
    private PurchasePaymentApplyHeadMapper purchasePaymentApplyHeadMapper;
    @Resource
    private PurchasePaymentApplyItemMapper purchasePaymentApplyItemMapper;
    @Resource
    private SalePaymentApplyHeadMapper salePaymentApplyHeadMapper;
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;

    public JSONObject before(JSONObject jsonObject, Object custom) {
        JSONObject body = new JSONObject();
        JSONObject c = (JSONObject)custom;
        String company = StrUtil.nullToDefault((CharSequence)c.getString("company"), (String)"0103");
        body.put("dwbm", (Object)company);
        body.put("djzt", (Object)"3");
        body.put("page_now", (Object)"1");
        body.put("page_size", (Object)"500");
        int amount = -3;
        if (c.getInteger("pullDays") != null) {
            amount = c.getInteger("pullDays");
        }
        String nowDate = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        body.put("startTs", (Object)(DateUtils.formatAddDate((String)nowDate, (String)"yyyy-MM-dd", (int)amount) + " 00:00:00"));
        body.put("endTs", (Object)(nowDate + " 23:59:59"));
        jsonObject.put("body", (Object)body);
        log.info("SRM\u83b7\u53d6\u4ed8\u6b3e\u7ed3\u679c\u63a5\u53e3\uff0c\u5165\u53c2\u4e3a\uff1a" + jsonObject);
        return jsonObject;
    }

    public JSONObject after(JSONObject jsonObject, JSONObject jsonObject1, Object o) {
        if (!CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) {
            throw new ELSBootException("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5931\u8d25: " + jsonObject.getString("message"));
        }
        JSONObject result = jsonObject.getJSONObject("result");
        String returnStatus = result.getString("status");
        if (!"success".equals(returnStatus)) {
            String errorMsg = result.getString("errormsg");
            throw new ELSBootException("SRM\u83b7\u53d6\u4ed8\u6b3e\u5355\u67e5\u8be2\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
        }
        JSONArray datas = result.getJSONObject("data").getJSONArray("datas");
        if (CollectionUtil.isEmpty((Collection)datas)) {
            return jsonObject;
        }
        ArrayList<String> paymentApplyNumbers = new ArrayList<String>();
        ArrayList<String> supplierCodes = new ArrayList<String>();
        for (Object object : datas) {
            JSONObject data = (JSONObject)object;
            JSONObject parentVO = data.getJSONObject("parentvo");
            JSONArray childrenVO = data.getJSONArray("childrenvo");
            paymentApplyNumbers.add(parentVO.getString("djbh"));
            for (Object c : childrenVO) {
                JSONObject child = (JSONObject)c;
                String supplierCode = child.getString("hbbm");
                if (supplierCodes.contains(supplierCode)) continue;
                supplierCodes.add(supplierCode);
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(PurchasePaymentApplyHead::getPaymentApplyNumber, paymentApplyNumbers);
        List dbPurchaseOrderHeads = this.purchasePaymentApplyHeadService.list((Wrapper)queryWrapper);
        Map<String, PurchasePaymentApplyHead> dbPurchasePaymentApplyHeadMap = dbPurchaseOrderHeads.stream().collect(Collectors.toMap(PurchasePaymentApplyHead::getPaymentApplyNumber, dbPurchasePaymentApplyHead -> dbPurchasePaymentApplyHead, (o1, o2) -> o1));
        Map<String, SupplierMasterDataDTO> dbSupplierMasterDataMap = this.getSupplierMasterData(supplierCodes);
        List templateList = this.templateRpcService.getDefaultTemplateByType("paymentApply");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u4ed8\u6b3e\u7533\u8bf7\u9ed8\u8ba4\u6a21\u677f");
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        ArrayList<PurchasePaymentApplyHead> addPurchasePaymentApplyHeadList = new ArrayList<PurchasePaymentApplyHead>();
        ArrayList<PurchasePaymentApplyItem> addPurchasePaymentApplyItemList = new ArrayList<PurchasePaymentApplyItem>();
        ArrayList<SalePaymentApplyHead> addSalePaymentApplyHeadList = new ArrayList<SalePaymentApplyHead>();
        ArrayList<SalePaymentApplyItem> addSalePaymentApplyItemList = new ArrayList<SalePaymentApplyItem>();
        HashMap<String, JSONObject> bankAccountMap = new HashMap<String, JSONObject>();
        for (Object object : datas) {
            PurchasePaymentApplyHead purchasePaymentApplyHead;
            PurchasePaymentApplyHead dbHead;
            JSONObject data = (JSONObject)object;
            JSONObject parentVO = data.getJSONObject("parentvo");
            JSONArray childrenVO = data.getJSONArray("childrenvo");
            if (parentVO.getBoolean("breturn") != null && parentVO.getBoolean("breturn").booleanValue() || (dbHead = dbPurchasePaymentApplyHeadMap.get((purchasePaymentApplyHead = this.buildPurPaymentApplyHead(template, parentVO)).getPaymentApplyNumber())) != null) continue;
            List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.buildPurPaymentApplyItem(purchasePaymentApplyHead, childrenVO, bankAccountMap, dbSupplierMasterDataMap);
            if (purchasePaymentApplyHead.getToElsAccount() == null) continue;
            addPurchasePaymentApplyHeadList.add(purchasePaymentApplyHead);
            addPurchasePaymentApplyItemList.addAll(purchasePaymentApplyItems);
            SalePaymentApplyHead salePaymentApplyHead = this.buildSalePaymentApplyHead(purchasePaymentApplyHead);
            List<SalePaymentApplyItem> salePaymentApplyItems = this.buildSalePaymentApplyItem(salePaymentApplyHead, purchasePaymentApplyItems);
            addSalePaymentApplyHeadList.add(salePaymentApplyHead);
            addSalePaymentApplyItemList.addAll(salePaymentApplyItems);
        }
        if (addPurchasePaymentApplyHeadList.size() > 0) {
            this.purchasePaymentApplyHeadMapper.insertBatchSomeColumn(addPurchasePaymentApplyHeadList);
            this.salePaymentApplyHeadMapper.insertBatchSomeColumn(addSalePaymentApplyHeadList);
        }
        if (addPurchasePaymentApplyItemList.size() > 0) {
            this.purchasePaymentApplyItemMapper.insertBatchSomeColumn(addPurchasePaymentApplyItemList);
            this.salePaymentApplyItemMapper.insertBatchSomeColumn(addSalePaymentApplyItemList);
        }
        for (PurchasePaymentApplyHead purchasePaymentApplyHead : addPurchasePaymentApplyHeadList) {
            this.purchasePaymentApplyHeadService.sendMessage(purchasePaymentApplyHead.getElsAccount(), "paymentApply", "auditPass", purchasePaymentApplyHead.getId(), "paymentApplyHeadBusDataServiceImpl", Arrays.asList(purchasePaymentApplyHead.getToElsAccount()));
        }
        return jsonObject;
    }

    private PurchasePaymentApplyHead buildPurPaymentApplyHead(TemplateHeadDTO template, JSONObject parentVO) {
        PurchasePaymentApplyHead head = new PurchasePaymentApplyHead();
        head.setElsAccount(TenantContext.getTenant());
        head.setId(IdWorker.getIdStr());
        head.setRelationId(IdWorker.getIdStr());
        head.setTemplateName(template.getTemplateName());
        head.setTemplateNumber(template.getTemplateNumber());
        head.setTemplateAccount(template.getElsAccount());
        head.setTemplateVersion(String.valueOf(template.getTemplateVersion()));
        head.setPaymentApplyNumber(parentVO.getString("djbh"));
        head.setCompany(parentVO.getString("dwbm_code"));
        head.setPaymentApplyDate(parentVO.getDate("djrq"));
        head.setPaymentApplyStatus(PaymentApplyStatusEnum.HAS_BEEN_PAID.getValue());
        head.setSourceId(parentVO.getString("vouchid"));
        head.setCurrency(parentVO.getString("xxx"));
        head.setDeleted(CommonConstant.DEL_FLAG_0);
        return head;
    }

    private List<PurchasePaymentApplyItem> buildPurPaymentApplyItem(PurchasePaymentApplyHead head, JSONArray childrenVO, Map<String, JSONObject> bankAccountMap, Map<String, SupplierMasterDataDTO> dbSupplierMasterDataMap) {
        ArrayList<PurchasePaymentApplyItem> purchasePaymentApplyItems = new ArrayList<PurchasePaymentApplyItem>();
        if (CollectionUtil.isEmpty((Collection)childrenVO)) {
            return purchasePaymentApplyItems;
        }
        for (Object o : childrenVO) {
            JSONObject children = (JSONObject)o;
            PurchasePaymentApplyItem item = new PurchasePaymentApplyItem();
            item.setId(IdWorker.getIdStr());
            item.setRelationId(IdWorker.getIdStr());
            item.setHeadId(head.getId());
            item.setElsAccount(head.getElsAccount());
            item.setSourceSystem("U8C");
            item.setSourceId(children.getString("fb_oid"));
            item.setPaymentApplyNumber(head.getPaymentApplyNumber());
            item.setShouldTaxAmount(children.getBigDecimal("jfybje"));
            item.setInvoiceNumber(children.getString("fph"));
            item.setTaxRate(children.getBigDecimal("bbhl"));
            item.setApplyAmount(children.getBigDecimal("jfybje"));
            item.setPayAmount(children.getBigDecimal("jfybje"));
            item.setPaymentBankAccountName(children.getString("skyhmc"));
            item.setDeleted(CommonConstant.DEL_FLAG_0);
            SupplierMasterDataDTO supplierMasterDataDTO = dbSupplierMasterDataMap.get(children.getString("hbbm"));
            if (supplierMasterDataDTO != null) {
                head.setToElsAccount(supplierMasterDataDTO.getToElsAccount());
                head.setSupplierName(children.getString("hbbm_name"));
            }
            head.setCurrency(children.getString("bzbm_code"));
            this.handlePaymentBankAccount(item, children.getString("bfyhzh"), bankAccountMap);
            purchasePaymentApplyItems.add(item);
        }
        return purchasePaymentApplyItems;
    }

    private SalePaymentApplyHead buildSalePaymentApplyHead(PurchasePaymentApplyHead purchasePaymentApplyHead) {
        SalePaymentApplyHead salePaymentApplyHead = (SalePaymentApplyHead)SysUtil.copyProperties((Object)purchasePaymentApplyHead, SalePaymentApplyHead.class);
        salePaymentApplyHead.setId(purchasePaymentApplyHead.getRelationId());
        salePaymentApplyHead.setRelationId(purchasePaymentApplyHead.getId());
        salePaymentApplyHead.setBusAccount(purchasePaymentApplyHead.getElsAccount());
        salePaymentApplyHead.setElsAccount(purchasePaymentApplyHead.getToElsAccount());
        salePaymentApplyHead.setToElsAccount(purchasePaymentApplyHead.getElsAccount());
        return salePaymentApplyHead;
    }

    private List<SalePaymentApplyItem> buildSalePaymentApplyItem(SalePaymentApplyHead salePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItems) {
        ArrayList<SalePaymentApplyItem> salePaymentApplyItems = new ArrayList<SalePaymentApplyItem>();
        if (CollectionUtil.isEmpty(purchasePaymentApplyItems)) {
            return salePaymentApplyItems;
        }
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            SalePaymentApplyItem salePaymentApplyItem = (SalePaymentApplyItem)SysUtil.copyProperties((Object)purchasePaymentApplyItem, SalePaymentApplyItem.class);
            salePaymentApplyItem.setId(purchasePaymentApplyItem.getRelationId());
            salePaymentApplyItem.setRelationId(purchasePaymentApplyItem.getId());
            salePaymentApplyItem.setHeadId(salePaymentApplyHead.getId());
            salePaymentApplyItem.setBusAccount(salePaymentApplyHead.getBusAccount());
            salePaymentApplyItem.setElsAccount(salePaymentApplyHead.getElsAccount());
            salePaymentApplyItem.setToElsAccount(salePaymentApplyHead.getToElsAccount());
            salePaymentApplyItems.add(salePaymentApplyItem);
        }
        return salePaymentApplyItems;
    }

    private void handlePaymentBankAccount(PurchasePaymentApplyItem purchasePaymentApplyItem, String bankId, Map<String, JSONObject> bankAccountMap) {
        if (StrUtil.isEmpty((CharSequence)bankId)) {
            return;
        }
        JSONObject data = bankAccountMap.get(bankId);
        if (data == null) {
            data = this.getPaymentBankAccount(bankId);
            bankAccountMap.put(bankId, data);
        }
        if (data == null) {
            return;
        }
        purchasePaymentApplyItem.setPaymentBankAccount(data.getString("accountcode"));
        purchasePaymentApplyItem.setPaymentBankAccountName(data.getString("accountname"));
        purchasePaymentApplyItem.setPaymentBank(data.getString("bankdocname"));
    }

    private JSONObject getPaymentBankAccount(String bankId) {
        JSONObject param = new JSONObject();
        JSONObject body = new JSONObject();
        String sql = "select accountcode,accountname,bankdoccode, bankdocname from bd_bankaccbas left join bd_bankdoc on bd_bankdoc.pk_bankdoc = bd_bankaccbas.pk_bankdoc where pk_bankaccbas = '" + bankId + "'";
        body.put("page_now", (Object)"1");
        body.put("page_size", (Object)"1");
        body.put("sql", (Object)sql);
        param.put("bus_account", (Object)TenantContext.getTenant());
        param.put("srm_interface_code", (Object)"getDataBySql");
        param.put("body", (Object)body);
        JSONObject result = this.interfaceUtil.callInterface(TenantContext.getTenant(), null, param, null);
        if (!CommonConstant.SC_OK_200.equals(result.getIntValue("code"))) {
            log.error("\u67e5\u8be2\u94f6\u884c\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        if (!"success".equals((result = result.getJSONObject("result")).getString("status"))) {
            String errorMsg = result.getString("errormsg");
            log.error("SRM\u67e5\u8be2\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
            return null;
        }
        JSONArray datas = result.getJSONObject("data").getJSONArray("datas");
        if (CollectionUtil.isEmpty((Collection)datas)) {
            return null;
        }
        return (JSONObject)datas.get(0);
    }

    private Map<String, SupplierMasterDataDTO> getSupplierMasterData(List<String> supplierCodes) {
        if (supplierCodes.size() == 0) {
            return new HashMap<String, SupplierMasterDataDTO>();
        }
        List supplierMasterDataList = this.supplierMasterDataRpcService.getSupplierMasterDataBySupplierCode(supplierCodes);
        if (CollectionUtil.isEmpty((Collection)supplierMasterDataList)) {
            return new HashMap<String, SupplierMasterDataDTO>();
        }
        return supplierMasterDataList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getSupplierCode, masterData -> masterData, (o1, o2) -> o1));
    }
}

