/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.u8.api.extend;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseInvoiceHookInformation;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceHookInformationMapper;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushPurchaseInvoiceToLuoShiU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushPurchaseInvoiceToLuoShiU8ServiceImpl.class);
    @Resource
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    @Resource
    private PurchaseInvoiceHookInformationMapper purchaseInvoiceHookInformationMapper;

    public JSONObject before(JSONObject obj, Object custom) {
        PurchaseInvoice head = (PurchaseInvoice)custom;
        if (!"2".equals(head.getStatus())) {
            throw new ELSBootException("\u53d1\u7968\u72b6\u6001\u672a\u786e\u8ba4\u4e0d\u80fd\u64cd\u4f5c");
        }
        List formations = this.purchaseInvoiceHookInformationMapper.selectByMainId(head.getHeadId());
        JSONObject parentvo = this.paramParentvo(head);
        JSONArray childrenvo = this.paramChildrenvo(head, formations);
        JSONObject invoicevo = new JSONObject();
        invoicevo.put("parentvo", (Object)parentvo);
        invoicevo.put("childrenvo", (Object)childrenvo);
        JSONObject parms = new JSONObject();
        parms.put("invoicevo", (Object)invoicevo);
        obj.put("body", (Object)parms);
        log.info("\u53d1\u7968\u63a8\u9001U8C\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)obj.toJSONString());
        return obj;
    }

    private JSONArray paramChildrenvo(PurchaseInvoice head, List<PurchaseInvoiceHookInformation> formations) {
        JSONArray childrenvoArray = new JSONArray();
        for (PurchaseInvoiceHookInformation formation : formations) {
            JSONObject childrenvos = new JSONObject();
            childrenvos.put("ninvoicenum", (Object)"1");
            childrenvos.put("noriginalcurmny", (Object)formation.getNotIncludeTaxAmount());
            childrenvos.put("noriginalsummny", (Object)formation.getIncludeTaxAmount());
            childrenvoArray.add((Object)childrenvos);
        }
        return childrenvoArray;
    }

    private JSONObject paramParentvo(PurchaseInvoice head) {
        JSONObject parentvo = new JSONObject();
        parentvo.put("coperator", (Object)head.getCreateBy());
        parentvo.put("pk_corp", (Object)"02");
        parentvo.put("dinvoicedate", (Object)DateUtils.formatDate((Date)head.getInvoiceTime(), (String)"yyyy-MM-dd"));
        parentvo.put("vinvoicecode", (Object)head.getInvoiceNo());
        return parentvo;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("\u53d1\u7968\u63a8\u9001U8C\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)interfaceResult.toJSONString());
        if (interfaceResult.getIntValue("code") != 200) {
            throw new ELSBootException("U8C\u8fd4\u56de\u9519\u8bef\u6d88\u606f:" + interfaceResult.getString("message"));
        }
        JSONObject result = interfaceResult.getJSONObject("result");
        if (!result.getString("status").equals("success")) {
            throw new ELSBootException("U8C\u8fd4\u56de\u9519\u8bef\u6d88\u606f:" + result.getString("errormsg"));
        }
        return interfaceResult;
    }
}

