/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.third.u8.api.extend;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.DictRpcService;
import com.els.common.exception.ELSBootException;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.finance.api.enumerate.PaymentApplyStatusEnum;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushPaymentApplyToShiWeiU8Impl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushPaymentApplyToShiWeiU8Impl.class);
    private SupplierMasterDataDTO supplier;
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired
    private DictRpcService dictRpcService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        PurchasePaymentApplyHead head = (PurchasePaymentApplyHead)custom;
        this.supplier = this.supplierMasterDataRpcService.getByAccount(head.getElsAccount(), head.getToElsAccount());
        return !"\u5df2\u63a8\u9001".equals(head.getFbk20()) && PaymentApplyStatusEnum.HAS_BEEN_PAID.getValue().equals(head.getPaymentApplyStatus()) && StringUtils.isNotBlank((CharSequence)this.supplier.getSourceId());
    }

    public JSONObject before(JSONObject obj, Object custom) {
        PurchasePaymentApplyHead head = (PurchasePaymentApplyHead)custom;
        obj.put("body", (Object)this.getBody(head));
        log.info("PushPaymentApplyToShiWeiU8Impl.before -> obj \u3010{}\u3011 custom \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj), custom);
        return obj;
    }

    public JSONObject after(JSONObject result, JSONObject obj, Object custom) {
        log.info("PushPaymentApplyToShiWeiU8Impl.after -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)result));
        String elsAccount = obj.getString("bus_account");
        PurchasePaymentApplyHead applyHead = (PurchasePaymentApplyHead)custom;
        if (result.getIntValue("code") != 200) {
            throw new ELSBootException(result.getString("message"));
        }
        JSONObject result2 = result.getJSONObject("result");
        PurchasePaymentApplyHead head = new PurchasePaymentApplyHead();
        head.setId(applyHead.getId());
        if (!result2.getBooleanValue("IsSucceed")) {
            log.error("PushPaymentApplyToShiWeiU8Impl \u63a8\u9001\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25\uff1a" + result2.getString("Dsc"));
            throw new ELSBootException(result2.getString("Dsc"));
        }
        head.setFbk20("\u5df2\u63a8\u9001");
        this.purchasePaymentApplyHeadService.updateById((Object)head);
        return result;
    }

    private JSONArray getBody(PurchasePaymentApplyHead head) {
        String currencyText = this.dictRpcService.queryDictTextByKey("srmCurrency", head.getCurrency(), head.getElsAccount());
        List itemList = this.purchasePaymentApplyItemService.selectByMainId(head.getId());
        JSONArray array = new JSONArray();
        JSONObject body = new JSONObject();
        body.put("cVenCode", (Object)this.supplier.getSupplierCode());
        body.put("cVenName", (Object)head.getSupplierName());
        body.put("dDate", (Object)DateUtil.formatDate((Date)head.getPaymentApplyDate()));
        body.put("cexch_name", (Object)currencyText);
        body.put("nflat", (Object)(head.getExchangeRate() != null && head.getExchangeRate().compareTo(BigDecimal.ZERO) > 0 ? head.getExchangeRate() : BigDecimal.ONE));
        body.put("payWay", (Object)head.getPayWay());
        body.put("paymentClause", (Object)head.getPaymentClause());
        body.put("fbk2", (Object)head.getFbk2());
        body.put("fbk3", (Object)head.getFbk3());
        JSONArray detlist = new JSONArray();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : itemList) {
            JSONObject itemObj = new JSONObject();
            itemObj.put("cCode", (Object)head.getPaymentApplyNumber());
            itemObj.put("irowno", (Object)purchasePaymentApplyItem.getItemNumber());
            itemObj.put("iAmount", (Object)purchasePaymentApplyItem.getPayAmount());
            detlist.add((Object)itemObj);
        }
        body.put("detlist", (Object)detlist);
        array.add((Object)body);
        return array;
    }
}

