/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.third.u8.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.DateUtils;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GetInvoiceInfoFromManXiaoBaoU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetInvoiceInfoFromManXiaoBaoU8ServiceImpl.class);
    @Resource
    private PurchaseReconciliationService purchaseReconciliationService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Value(value="${els.config.service.address}")
    private String address;
    @Resource
    private PurchaseAttachmentRpcService purchaseAttachmentRpcService;

    public JSONObject before(JSONObject jsonObject, Object o) {
        JSONObject body = new JSONObject();
        body.put("ibillstatus", (Object)"3");
        String nowDate = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        body.put("startTs", (Object)(DateUtils.formatAddDate((String)nowDate, (String)"yyyy-MM-dd", (int)-3) + " 00:00:00"));
        body.put("endTs", (Object)(nowDate + " 23:59:59"));
        jsonObject.put("body", (Object)body);
        return jsonObject;
    }

    public JSONObject after(JSONObject jsonObject, JSONObject jsonObject1, Object o) {
        if (!CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) {
            throw new ELSBootException("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5931\u8d25: " + jsonObject.getString("message"));
        }
        JSONObject result = jsonObject.getJSONObject("result");
        String returnStatus = result.getString("status");
        if (!"success".equals(returnStatus)) {
            String errorMsg = result.getString("errormsg");
            throw new ELSBootException("SRM\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
        }
        if ((result = result.getJSONObject("data")) == null) {
            return jsonObject;
        }
        JSONArray datas = result.getJSONArray("datas");
        if (CollectionUtil.isEmpty((Collection)datas)) {
            return jsonObject;
        }
        for (Object d : datas) {
            JSONObject data = (JSONObject)d;
            JSONObject parent = data.getJSONObject("parentvo");
            JSONArray childrens = data.getJSONArray("childrenvo");
            if (CollectionUtil.isEmpty((Collection)childrens)) continue;
            JSONObject children = (JSONObject)childrens.get(0);
            String reconciliationNumber = children.getString("vdef1");
            String id = children.getString("cinvoiceid");
            if (!StrUtil.isNotEmpty((CharSequence)reconciliationNumber)) continue;
            this.pushInvoice(reconciliationNumber, id);
        }
        return jsonObject;
    }

    private void pushInvoice(String reconciliationNumber, String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseReconciliationService.lambdaQuery().eq(PurchaseReconciliation::getReconciliationNumber, (Object)reconciliationNumber)).last("limit 1")).one();
        if (purchaseReconciliation == null) {
            return;
        }
        if ("1".equals(purchaseReconciliation.getFbk1())) {
            return;
        }
        List purchaseAttachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseReconciliation.getId());
        if (CollectionUtil.isEmpty((Collection)purchaseAttachments)) {
            return;
        }
        JSONObject param = new JSONObject();
        JSONObject body = new JSONObject();
        JSONArray files = new JSONArray();
        for (PurchaseAttachmentDTO purchaseAttachment : purchaseAttachments) {
            String fileUrl = this.purchaseAttachmentRpcService.getSignature("local", purchaseAttachment.getFilePath(), this.address + "/opt/upFiles");
            String fileBase64 = this.file2Base64(fileUrl);
            if (fileBase64 == null) {
                log.info("\u83b7\u53d6fileBase64\u4e3a\u7a7a, signature={}", (Object)fileUrl);
                continue;
            }
            JSONObject file = new JSONObject();
            file.put("content", (Object)fileBase64);
            file.put("creator", (Object)"srm");
            file.put("file_name", (Object)purchaseAttachment.getFileName());
            file.put("upload_path", (Object)(id + "/pu/pi"));
            files.add((Object)file);
        }
        body.put("file", (Object)files);
        param.put("bus_account", (Object)TenantContext.getTenant());
        param.put("srm_interface_code", (Object)"pushInvoiceData");
        param.put("body", (Object)body);
        JSONObject jsonObject = this.interfaceUtil.callInterface(TenantContext.getTenant(), null, param, null);
        if (CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code")) && "success".equals(jsonObject.getJSONObject("result").getString("status"))) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseReconciliationService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseReconciliation.getId())).set(PurchaseReconciliation::getFbk1, (Object)"1")).update();
        }
    }

    public String getFileBase64(String fileUrl) {
        try {
            String line;
            URL url = new URL(fileUrl);
            URLConnection connection = url.openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            reader.close();
            return Base64.getEncoder().encodeToString(content.toString().getBytes());
        }
        catch (Exception ex) {
            log.error("getFileBase64 error=", (Throwable)ex);
            return null;
        }
    }

    public static String encode(byte[] image) {
        String encodeStr = Base64.getEncoder().encodeToString(image);
        return GetInvoiceInfoFromManXiaoBaoU8ServiceImpl.replaceEnter(encodeStr);
    }

    public static String replaceEnter(String str) {
        String reg = "[\n-\r]";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String file2Base64(String fileUrl) {
        URL url = null;
        InputStream is = null;
        ByteArrayOutputStream outStream = null;
        HttpURLConnection httpUrl = null;
        try {
            url = new URL(fileUrl);
            httpUrl = (HttpURLConnection)url.openConnection();
            httpUrl.connect();
            httpUrl.getInputStream();
            is = httpUrl.getInputStream();
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            String string = GetInvoiceInfoFromManXiaoBaoU8ServiceImpl.encode(outStream.toByteArray());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpUrl != null) {
                httpUrl.disconnect();
            }
        }
        return null;
    }
}

