/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SaleRecAcceptReturnMapper;
import com.els.modules.reconciliation.mapper.SaleRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.SaleRecChargeMapper;
import com.els.modules.reconciliation.mapper.SaleReconciliationMapper;
import com.els.modules.reconciliation.rpc.ElsTaxLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.service.PurchaseRecAcceptReturnService;
import com.els.modules.reconciliation.service.PurchaseRecAdditionalChargesService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseReconciliationServiceImpl
extends BaseServiceImpl<PurchaseReconciliationMapper, PurchaseReconciliation>
implements PurchaseReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseReconciliationServiceImpl.class);
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Resource
    private PurchaseRecAcceptReturnService purchaseRecAcceptReturnService;
    @Resource
    private PurchaseRecAdditionalChargesService purchaseRecAdditionalChargesService;
    @Resource
    private PurchaseRecChargeService purchaseRecChargeService;
    @Resource
    private PurchaseVoucherItemLocalRpcService purchaseVoucherItemRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Resource
    private ElsTaxLocalRpcService elsTaxService;
    @Resource
    private SaleReconciliationMapper saleReconciliationMapper;
    @Resource
    private SaleRecChargeMapper saleRecChargeMapper;
    @Resource
    private SaleRecAdditionalChargesMapper saleRecAdditionalChargesMapper;
    @Resource
    private SaleRecAcceptReturnMapper saleRecAcceptReturnMapper;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private SaleAddCostService saleAddCostService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList, List<PurchaseRecCharge> purchaseRecChargeList) {
        purchaseReconciliation.setReconciliationNumber(this.invokeBaseRpcService.getNextCode("reconciliation", (Object)purchaseReconciliation));
        purchaseReconciliation.setCreateAccount(TenantContext.getTenant());
        purchaseReconciliation.setSendStatus("0");
        purchaseReconciliation.setReconciliationStatus(ReconciliationStatusEmun.NEW.getValue());
        purchaseReconciliation.setInvoiced("0");
        purchaseReconciliation.setCancellation("0");
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchaseReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        this.purchaseReconciliationMapper.insert((Object)purchaseReconciliation);
        this.invokeBaseRpcService.addStatusLog(purchaseReconciliation.getId(), ReconciliationStatusEmun.NEW.getValue(), "reconciliation", "inster");
        if (purchaseRecAcceptReturnList != null && purchaseRecAcceptReturnList.size() > 0) {
            this.updateMain(purchaseReconciliation, purchaseRecAcceptReturnList, purchaseRecAdditionalChargesList, purchaseRecChargeList);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList, List<PurchaseRecCharge> purchaseRecChargeList) {
        void var7_10;
        log.error("Finance-->\u5f00\u59cb\u4fee\u6539");
        boolean isCreated = true;
        List<PurchaseRecAcceptReturn> acceptReturns = this.purchaseRecAcceptReturnService.selectByMainId(purchaseReconciliation.getId());
        if (acceptReturns != null && acceptReturns.size() > 0) {
            isCreated = false;
        }
        ArrayList arrayList = new ArrayList();
        if (!isCreated && !StringUtils.isEmpty((CharSequence)purchaseReconciliation.getId())) {
            List list = purchaseRecAcceptReturnList.stream().filter(reconciliation -> !purchaseReconciliation.getId().equals(reconciliation.getHeadId())).map(PurchaseRecAcceptReturn::getBusinessId).collect(Collectors.toList());
        } else {
            List list = purchaseRecAcceptReturnList.stream().map(PurchaseRecAcceptReturn::getBusinessId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)var7_10)) {
            List<Object> voucherItemDTOList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds((List<String>)var7_10);
            if (!CollectionUtils.isEmpty(voucherItemDTOList = voucherItemDTOList.stream().filter(item -> "1".equals(item.getReconciliation())).collect(Collectors.toList()))) {
                log.error("PurchaseReconciliationController edit \u51ed\u8bc1\u5df2\u5bf9\u8d26");
                throw new ELSBootException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u6216\u51ed\u8bc1" + ((PurchaseVoucherItemDTO)voucherItemDTOList.get(0)).getVoucherNumber() + " \u5df2\u5bf9\u8d26");
            }
        }
        if (isCreated) {
            ArrayList<String> taxCodeList = new ArrayList<String>();
            ArrayList<String> currenyList = new ArrayList<String>();
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
                if (!taxCodeList.contains(purchaseRecAcceptReturn.getTaxCode()) && StringUtils.isNotBlank((CharSequence)purchaseRecAcceptReturn.getTaxCode())) {
                    taxCodeList.add(purchaseRecAcceptReturn.getTaxCode());
                } else if (StringUtils.isBlank((CharSequence)purchaseRecAcceptReturn.getTaxCode())) {
                    log.error("PurchaseReconciliationController edit booleanStringMap\u9519\u8bef1");
                    throw new ELSBootException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u6216\u51ed\u8bc1" + purchaseRecAcceptReturn.getVoucherNumber() + " \u7a0e\u7801\u4e3a\u7a7a");
                }
                if (!currenyList.contains(purchaseRecAcceptReturn.getCurrency()) && StringUtils.isNotBlank((CharSequence)purchaseRecAcceptReturn.getCurrency())) {
                    currenyList.add(purchaseRecAcceptReturn.getCurrency());
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)purchaseRecAcceptReturn.getCurrency())) continue;
                log.error("PurchaseReconciliationController edit booleanStringMap\u9519\u8bef2");
                throw new ELSBootException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u6216\u51ed\u8bc1" + purchaseRecAcceptReturn.getVoucherNumber() + " \u5e01\u522b\u4e3a\u7a7a");
            }
            Map<Boolean, String> map = this.generateReconciliation(purchaseReconciliation, purchaseRecAcceptReturnList, purchaseRecAdditionalChargesList, purchaseRecChargeList, taxCodeList, currenyList);
            if (map == null || !StringUtils.isNotBlank((CharSequence)map.get(true))) throw new ELSBootException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25\uff1a" + map.get(false));
            log.error("\u6dfb\u52a0\u7ed3\u675f" + map);
            return;
        } else {
            ArrayList<String> acceptReturnIds = new ArrayList<String>();
            BigDecimal amount = new BigDecimal(0);
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
                acceptReturnIds.add(purchaseRecAcceptReturn.getBusinessId());
                if (purchaseRecAcceptReturn.getDirectionBorrowing().equals("+")) {
                    amount = amount.add(purchaseRecAcceptReturn.getTotalAmount());
                }
                if (!purchaseRecAcceptReturn.getDirectionBorrowing().equals("-")) continue;
                amount = amount.subtract(purchaseRecAcceptReturn.getTotalAmount());
            }
            if (amount.compareTo(new BigDecimal(0)) < 0) {
                throw new ELSBootException("\u5bf9\u8d26\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u6536\u9000\u8d27\u660e\u7ec6\u603b\u91d1\u989d\u5c0f\u4e8e0");
            }
            ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : acceptReturns) {
                if (acceptReturnIds.contains(purchaseRecAcceptReturn.getBusinessId())) continue;
                PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(purchaseRecAcceptReturn.getBusinessId());
                voucherItem.setReconciliation("0");
                voucherItem.setReconciliationNumber(null);
                voucherItems.add(voucherItem);
            }
            if (!voucherItems.isEmpty()) {
                this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (PurchaseRecAdditionalCharges additionalCharges : purchaseRecAdditionalChargesList) {
                arrayList2.add(additionalCharges.getBusinessId());
            }
            List<PurchaseRecAdditionalCharges> list = this.purchaseRecAdditionalChargesService.selectByMainId(purchaseReconciliation.getId());
            ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
            ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
            for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : list) {
                if (arrayList2.contains(purchaseRecAdditionalCharges.getBusinessId())) continue;
                PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)purchaseRecAdditionalCharges.getBusinessId())));
                addCost.setCostStatus("0");
                addCost.setReconciliationNumber(null);
                addCosts.add(addCost);
                SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)addCost.getRelationId())));
                saleAddCost.setReconciliationNumber(null);
                saleAddCost.setCostStatus("0");
                saleAddCosts.add(saleAddCost);
            }
            if (!addCosts.isEmpty()) {
                this.purchaseAddCostService.updateBatchById(addCosts);
            }
            if (!saleAddCosts.isEmpty()) {
                this.saleAddCostService.updateBatchById(saleAddCosts);
            }
            ArrayList<String> deductCostIds = new ArrayList<String>();
            for (PurchaseRecCharge charge : purchaseRecChargeList) {
                deductCostIds.add(charge.getBusinessId());
            }
            List<PurchaseRecCharge> list2 = this.purchaseRecChargeService.selectByMainId(purchaseReconciliation.getId());
            ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
            ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
            for (PurchaseRecCharge charge : list2) {
                if (deductCostIds.contains(charge.getBusinessId())) continue;
                PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
                deductCost.setDeductStatus("0");
                deductCost.setReconciliationNumber(null);
                deductCosts.add(deductCost);
                SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
                saleDeductCost.setDeductStatus("0");
                saleDeductCost.setReconciliationNumber(null);
                saleDeductCosts.add(saleDeductCost);
            }
            if (!deductCosts.isEmpty()) {
                this.purchaseDeductCostService.updateBatchById(deductCosts);
            }
            if (!saleDeductCosts.isEmpty()) {
                this.saleDeductCostService.updateBatchById(saleDeductCosts);
            }
            this.calculateMoney(purchaseReconciliation, purchaseRecAcceptReturnList, purchaseRecAdditionalChargesList, purchaseRecChargeList);
            if ("1".equals(purchaseReconciliation.getSaveForZero())) {
                if (purchaseReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                    log.error("PurchaseReconciliationController edit booleanStringMap\u9519\u8bef3");
                    throw new ELSBootException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + purchaseReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
                }
            } else if (purchaseReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
                log.error("PurchaseReconciliationController edit booleanStringMap\u9519\u8bef4");
                throw new ELSBootException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + purchaseReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e\u7b49\u4e8e0\u90fd\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
            }
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.insertData(purchaseReconciliation, purchaseRecAcceptReturnList, purchaseRecAdditionalChargesList, purchaseRecChargeList);
        }
    }

    public Map<Boolean, String> generateReconciliation(PurchaseReconciliation reconciliation, List<PurchaseRecAcceptReturn> acceptReturns, List<PurchaseRecAdditionalCharges> additionalCharges, List<PurchaseRecCharge> charges, List<String> taxCodeList, List<String> currenyList) {
        HashMap<Boolean, String> result = new HashMap<Boolean, String>();
        result.put(false, "");
        result.put(true, "");
        boolean flag = false;
        for (String taxCode : taxCodeList) {
            for (String currency : currenyList) {
                List<ElsTaxDTO> taxs;
                Object acceptReturn2;
                ArrayList<PurchaseRecAcceptReturn> recAcceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
                BigDecimal amount = new BigDecimal(0);
                for (Object acceptReturn2 : acceptReturns) {
                    if (!taxCode.equals(acceptReturn2.getTaxCode()) || !currency.equals(acceptReturn2.getCurrency())) continue;
                    recAcceptReturns.add((PurchaseRecAcceptReturn)((Object)acceptReturn2));
                    if (acceptReturn2.getDirectionBorrowing().equals("+")) {
                        amount = amount.add(acceptReturn2.getTotalAmount());
                    }
                    if (!acceptReturn2.getDirectionBorrowing().equals("-")) continue;
                    amount = amount.subtract(acceptReturn2.getTotalAmount());
                }
                if (recAcceptReturns.isEmpty()) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u6536\u9000\u8d27\u660e\u7ec6\u4e3a\u7a7a\uff1b ");
                    continue;
                }
                if (amount.compareTo(new BigDecimal(0)) < 0) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u6536\u9000\u8d27\u660e\u7ec6\u603b\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                    continue;
                }
                ArrayList<PurchaseRecAdditionalCharges> recAdditionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
                acceptReturn2 = additionalCharges.iterator();
                while (acceptReturn2.hasNext()) {
                    Object purchaseRecAdditionalCharges = (PurchaseRecAdditionalCharges)((Object)acceptReturn2.next());
                    if (!taxCode.equals(purchaseRecAdditionalCharges.getTaxCode()) || !currency.equals(purchaseRecAdditionalCharges.getCurrency())) continue;
                    recAdditionalCharges.add((PurchaseRecAdditionalCharges)((Object)purchaseRecAdditionalCharges));
                }
                ArrayList<PurchaseRecCharge> recCharges = new ArrayList<PurchaseRecCharge>();
                for (PurchaseRecCharge charge : charges) {
                    if (!taxCode.equals(charge.getTaxCode()) || !currency.equals(charge.getCurrency())) continue;
                    recCharges.add(charge);
                }
                reconciliation.setTaxCode(taxCode);
                if (reconciliation.getTaxRate() == null && (taxs = this.elsTaxService.findList(reconciliation.getElsAccount(), taxCode)) != null && taxs.size() > 0) {
                    reconciliation.setTaxRate(taxs.get(0).getTaxRate());
                }
                reconciliation.setCurrency(currency);
                if (flag) {
                    PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
                    BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)purchaseReconciliation));
                    purchaseReconciliation.setId(null);
                    purchaseReconciliation.setReconciliationNumber(this.invokeBaseRpcService.getNextCode("reconciliation", (Object)purchaseReconciliation));
                    this.calculateMoney(purchaseReconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                    if ("1".equals(purchaseReconciliation.getSaveForZero())) {
                        if (purchaseReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                            result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                            continue;
                        }
                    } else if (purchaseReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
                        result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff1b ");
                        continue;
                    }
                    this.purchaseReconciliationMapper.insert((Object)purchaseReconciliation);
                    this.insertData(purchaseReconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                    result.put(true, (String)result.get(true) + taxCode + "/" + currency + ": " + purchaseReconciliation.getReconciliationNumber());
                    continue;
                }
                this.calculateMoney(reconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                if ("1".equals(reconciliation.getSaveForZero())) {
                    if (reconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                        result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                        continue;
                    }
                } else if (reconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff1b ");
                    continue;
                }
                this.purchaseReconciliationMapper.updateById((Object)reconciliation);
                this.insertData(reconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                flag = true;
                result.put(true, (String)result.get(true) + taxCode + "/" + currency + ": " + reconciliation.getReconciliationNumber());
            }
        }
        return result;
    }

    public void calculateMoney(PurchaseReconciliation reconciliation, List<PurchaseRecAcceptReturn> acceptReturns, List<PurchaseRecAdditionalCharges> additionalCharges, List<PurchaseRecCharge> charges) {
        BigDecimal deliveryIncludeTaxAmount = new BigDecimal(0);
        for (Object purchaseRecAcceptReturn : acceptReturns) {
            if (purchaseRecAcceptReturn.getDirectionBorrowing().equals("+")) {
                deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.add(purchaseRecAcceptReturn.getTotalAmount());
            }
            if (!purchaseRecAcceptReturn.getDirectionBorrowing().equals("-")) continue;
            deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.subtract(purchaseRecAcceptReturn.getTotalAmount());
        }
        reconciliation.setDeliveryIncludeTaxAmount(deliveryIncludeTaxAmount);
        BigDecimal additionalChangesAmount = new BigDecimal(0);
        for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : additionalCharges) {
            additionalChangesAmount = additionalChangesAmount.add(purchaseRecAdditionalCharges.getTotalAmount());
        }
        reconciliation.setAdditionalChangesAmount(additionalChangesAmount);
        BigDecimal chargeTotalAmount = new BigDecimal(0);
        BigDecimal chargeAmount = new BigDecimal(0);
        BigDecimal buckleTicketsAmount = new BigDecimal(0);
        for (PurchaseRecCharge purchaseRecCharge : charges) {
            chargeTotalAmount = chargeTotalAmount.add(purchaseRecCharge.getTotalAmount());
            if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) {
                chargeAmount = chargeAmount.add(purchaseRecCharge.getTotalAmount());
            }
            if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) continue;
            buckleTicketsAmount = buckleTicketsAmount.add(purchaseRecCharge.getTotalAmount());
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = deliveryIncludeTaxAmount.add(additionalChangesAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
    }

    private void insertData(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList, List<PurchaseRecCharge> purchaseRecChargeList) {
        int itemNumber;
        this.purchaseRecAcceptReturnService.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecAdditionalChargesService.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecChargeService.deleteByMainId(purchaseReconciliation.getId());
        if (purchaseRecAcceptReturnList != null) {
            itemNumber = 1;
            ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
            Date date = new Date();
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
                purchaseRecAcceptReturn.setHeadId(purchaseReconciliation.getId());
                SysUtil.setSysParam((BaseEntity)purchaseRecAcceptReturn, (BaseEntity)purchaseReconciliation);
                purchaseRecAcceptReturn.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                purchaseRecAcceptReturn.setItemNumber(String.valueOf(itemNumber));
                PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(purchaseRecAcceptReturn.getBusinessId());
                voucherItem.setReconciliation("1");
                voucherItem.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                voucherItem.setPostDate(date);
                voucherItems.add(voucherItem);
                ++itemNumber;
            }
            if (!purchaseRecAcceptReturnList.isEmpty()) {
                this.purchaseRecAcceptReturnService.saveBatch(purchaseRecAcceptReturnList, 2000);
            }
            if (!voucherItems.isEmpty()) {
                this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
            }
        }
        if (purchaseRecAdditionalChargesList != null) {
            itemNumber = 1;
            ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
            ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
            for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : purchaseRecAdditionalChargesList) {
                purchaseRecAdditionalCharges.setHeadId(purchaseReconciliation.getId());
                SysUtil.setSysParam((BaseEntity)purchaseRecAdditionalCharges, (BaseEntity)purchaseReconciliation);
                purchaseRecAdditionalCharges.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                purchaseRecAdditionalCharges.setItemNumber(String.valueOf(itemNumber));
                PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)purchaseRecAdditionalCharges.getBusinessId())));
                addCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                addCost.setCostStatus("1");
                addCosts.add(addCost);
                SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)addCost.getRelationId())));
                saleAddCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                saleAddCost.setCostStatus("1");
                saleAddCosts.add(saleAddCost);
                ++itemNumber;
            }
            if (!purchaseRecAdditionalChargesList.isEmpty()) {
                this.purchaseRecAdditionalChargesService.saveBatch(purchaseRecAdditionalChargesList, 2000);
            }
            if (!addCosts.isEmpty()) {
                this.purchaseAddCostService.updateBatchById(addCosts);
            }
            if (!saleAddCosts.isEmpty()) {
                this.saleAddCostService.updateBatchById(saleAddCosts);
            }
        }
        if (purchaseRecChargeList != null) {
            itemNumber = 1;
            ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
            ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
            for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
                purchaseRecCharge.setHeadId(purchaseReconciliation.getId());
                SysUtil.setSysParam((BaseEntity)purchaseRecCharge, (BaseEntity)purchaseReconciliation);
                purchaseRecCharge.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                purchaseRecCharge.setItemNumber(String.valueOf(itemNumber));
                PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)purchaseRecCharge.getBusinessId())));
                deductCost.setDeductStatus("1");
                deductCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                deductCosts.add(deductCost);
                SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
                saleDeductCost.setDeductStatus("1");
                saleDeductCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
                saleDeductCosts.add(saleDeductCost);
                ++itemNumber;
            }
            if (!purchaseRecChargeList.isEmpty()) {
                this.purchaseRecChargeService.saveBatch(purchaseRecChargeList, 200);
            }
            if (!deductCosts.isEmpty()) {
                this.purchaseDeductCostService.updateBatchById(deductCosts);
            }
            if (!saleDeductCosts.isEmpty()) {
                this.saleDeductCostService.updateBatchById(saleDeductCosts);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        List<PurchaseRecAcceptReturn> acceptReturns = this.purchaseRecAcceptReturnService.selectByMainId(id);
        List<PurchaseRecAdditionalCharges> additionalCharges = this.purchaseRecAdditionalChargesService.selectByMainId(id);
        List<PurchaseRecCharge> charges = this.purchaseRecChargeService.selectByMainId(id);
        this.purchaseRecAcceptReturnService.deleteByMainId(id);
        this.purchaseRecAdditionalChargesService.deleteByMainId(id);
        this.purchaseRecChargeService.deleteByMainId(id);
        this.purchaseReconciliationMapper.deleteById((Serializable)((Object)id));
        if (acceptReturns != null && acceptReturns.size() > 0) {
            ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
            for (PurchaseRecAcceptReturn acceptReturn : acceptReturns) {
                PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(acceptReturn.getBusinessId());
                voucherItem.setReconciliation("0");
                voucherItem.setReconciliationNumber(null);
                voucherItems.add(voucherItem);
            }
            if (!voucherItems.isEmpty()) {
                this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
            }
        }
        if (additionalCharges != null && additionalCharges.size() > 0) {
            ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
            ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
            for (PurchaseRecAdditionalCharges recAdditionalCharges : additionalCharges) {
                PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())));
                addCost.setCostStatus("0");
                addCost.setReconciliationNumber(null);
                addCosts.add(addCost);
                SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)addCost.getRelationId())));
                saleAddCost.setReconciliationNumber(null);
                saleAddCost.setCostStatus("0");
                saleAddCosts.add(saleAddCost);
            }
            if (!addCosts.isEmpty()) {
                this.purchaseAddCostService.updateBatchById(addCosts);
            }
            if (!saleAddCosts.isEmpty()) {
                this.saleAddCostService.updateBatchById(saleAddCosts);
            }
        }
        if (charges != null && charges.size() > 0) {
            ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
            ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
            for (PurchaseRecCharge charge : charges) {
                PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
                deductCost.setDeductStatus("0");
                deductCost.setReconciliationNumber(null);
                deductCosts.add(deductCost);
                SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
                saleDeductCost.setDeductStatus("0");
                saleDeductCost.setReconciliationNumber(null);
                saleDeductCosts.add(saleDeductCost);
            }
            if (!deductCosts.isEmpty()) {
                this.purchaseDeductCostService.updateBatchById(deductCosts);
            }
            if (!saleDeductCosts.isEmpty()) {
                this.saleDeductCostService.updateBatchById(saleDeductCosts);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseRecAcceptReturnService.deleteByMainId(serializable.toString());
            this.purchaseRecAdditionalChargesService.deleteByMainId(serializable.toString());
            this.purchaseRecChargeService.deleteByMainId(serializable.toString());
            this.purchaseReconciliationMapper.deleteById(serializable);
        }
    }

    @Override
    public PurchaseReconciliationVO extractReconciliation(PurchaseReconciliationVO reconciliationVO) {
        List<PurchaseVoucherItemDTO> voucherItems;
        String elsAccount = StringUtils.isBlank((CharSequence)reconciliationVO.getElsAccount()) ? reconciliationVO.getElsAccount() : TenantContext.getTenant();
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = new PurchaseVoucherItemDTO();
        purchaseVoucherItemDTO.setElsAccount(elsAccount);
        purchaseVoucherItemDTO.setToElsAccount(reconciliationVO.getToElsAccount());
        purchaseVoucherItemDTO.setCompany(reconciliationVO.getCompany());
        purchaseVoucherItemDTO.setBeginDate(reconciliationVO.getBeginDate());
        purchaseVoucherItemDTO.setEndDate(reconciliationVO.getEndDate());
        purchaseVoucherItemDTO.setVoucherStatus("0");
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            purchaseVoucherItemDTO.setTaxCode(reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            purchaseVoucherItemDTO.setCurrency(reconciliationVO.getCurrency());
        }
        if ((voucherItems = this.purchaseVoucherItemRpcService.selectReconciliationVoucher(purchaseVoucherItemDTO)) != null && voucherItems.size() > 0) {
            List deductCosts;
            List<PurchaseRecAcceptReturn> acceptReturns = this.getByPurchaseVoucherItemDTO(voucherItems);
            reconciliationVO.setPurchaseRecAcceptReturnList(acceptReturns);
            QueryWrapper deDuctWapper = new QueryWrapper();
            deDuctWapper.eq((Object)"els_account", (Object)elsAccount);
            deDuctWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
            deDuctWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
            deDuctWapper.ge((Object)"deduct_time", (Object)reconciliationVO.getBeginDate());
            deDuctWapper.le((Object)"deduct_time", (Object)reconciliationVO.getEndDate());
            deDuctWapper.eq((Object)"confirm_status", (Object)DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
            deDuctWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"deduct_status")).or()).eq((Object)"deduct_status", (Object)"0"));
            if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
                deDuctWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
            }
            if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
                deDuctWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
            }
            if ((deductCosts = this.purchaseDeductCostService.list((Wrapper)deDuctWapper)) != null && deductCosts.size() > 0) {
                List<PurchaseRecCharge> charges = this.getByPurchaseDeductCost(deductCosts);
                reconciliationVO.setPurchaseRecChargeList(charges);
            } else {
                reconciliationVO.setPurchaseRecChargeList(null);
            }
            QueryWrapper addCostWapper = new QueryWrapper();
            addCostWapper.eq((Object)"els_account", (Object)elsAccount);
            addCostWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
            addCostWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
            addCostWapper.ge((Object)"cost_time", (Object)reconciliationVO.getBeginDate());
            addCostWapper.le((Object)"cost_time", (Object)reconciliationVO.getEndDate());
            if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
                addCostWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
            }
            if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
                addCostWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
            }
            addCostWapper.eq((Object)"confirm_status", (Object)AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
            addCostWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"cost_status")).or()).eq((Object)"cost_status", (Object)"0"));
            List addCosts = this.purchaseAddCostService.list((Wrapper)addCostWapper);
            if (addCosts != null && addCosts.size() > 0) {
                List<PurchaseRecAdditionalCharges> additionalCharges = this.getByPurchaseAddCost(addCosts);
                reconciliationVO.setPurchaseRecAdditionalChargesList(additionalCharges);
            } else {
                reconciliationVO.setPurchaseRecAdditionalChargesList(null);
            }
        } else {
            reconciliationVO.setPurchaseRecAcceptReturnList(null);
        }
        return reconciliationVO;
    }

    public List<PurchaseRecAcceptReturn> getByPurchaseVoucherItemDTO(List<PurchaseVoucherItemDTO> voucherItems) {
        ArrayList<PurchaseRecAcceptReturn> acceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
        for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItems) {
            PurchaseRecAcceptReturn acceptReturn = new PurchaseRecAcceptReturn();
            acceptReturn.setItemType(ReconcilationItemTypeEmun.RECEIVING_REFUND.getValue());
            acceptReturn.setVoucherNumber(purchaseVoucherItem.getVoucherNumber());
            acceptReturn.setVoucherItemNumber(purchaseVoucherItem.getItemNumber());
            acceptReturn.setVoucherTime(purchaseVoucherItem.getVoucherDate());
            acceptReturn.setDeliveryNumber(purchaseVoucherItem.getDeliveryNumber());
            acceptReturn.setDeliveryItemNumber(purchaseVoucherItem.getDeliveryItemNumber());
            acceptReturn.setMobileType(purchaseVoucherItem.getMoveType());
            acceptReturn.setDirectionBorrowing(purchaseVoucherItem.getLoanDirection());
            acceptReturn.setOrderNumber(purchaseVoucherItem.getOrderNumber());
            acceptReturn.setOrderItemNumber(purchaseVoucherItem.getOrderItemNumber());
            acceptReturn.setPurchaseFactory(purchaseVoucherItem.getFactory());
            acceptReturn.setPurchaseOrg(purchaseVoucherItem.getPurchaseOrg());
            acceptReturn.setCompany(purchaseVoucherItem.getCompany());
            acceptReturn.setInventoryAddress(purchaseVoucherItem.getStorageLocation());
            acceptReturn.setInventoryAddressDesc(purchaseVoucherItem.getStorageLocationName());
            acceptReturn.setMaterialNumber(purchaseVoucherItem.getMaterialNumber());
            acceptReturn.setMaterialDesc(purchaseVoucherItem.getMaterialDesc());
            acceptReturn.setMaterialSpec(purchaseVoucherItem.getMaterialSpec());
            acceptReturn.setQuantity(purchaseVoucherItem.getQuantity());
            acceptReturn.setUnitQuantity(purchaseVoucherItem.getQuantityUnit());
            acceptReturn.setPrice(purchaseVoucherItem.getPrice());
            acceptReturn.setNoTaxUnitPrice(purchaseVoucherItem.getNetPrice());
            acceptReturn.setTaxCode(purchaseVoucherItem.getTaxCode());
            acceptReturn.setTaxRate(StringUtils.isNotBlank((CharSequence)purchaseVoucherItem.getTaxRate()) ? Integer.valueOf(Integer.parseInt(purchaseVoucherItem.getTaxRate())) : null);
            acceptReturn.setCurrency(purchaseVoucherItem.getCurrency());
            acceptReturn.setVoucherQuantity(purchaseVoucherItem.getVoucherQuantity());
            if (purchaseVoucherItem.getPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalAmount(purchaseVoucherItem.getPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            if (purchaseVoucherItem.getNetPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalNonTaxAmount(purchaseVoucherItem.getNetPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            acceptReturn.setRefVoucherNumber(purchaseVoucherItem.getRefVoucherNumber());
            acceptReturn.setRefVoucherItemNumber(purchaseVoucherItem.getRefVoucherItemNumber());
            acceptReturn.setRefVoucherYear(purchaseVoucherItem.getRefVoucherYear());
            acceptReturn.setBusinessId(purchaseVoucherItem.getId());
            acceptReturns.add(acceptReturn);
        }
        return acceptReturns;
    }

    public List<PurchaseRecCharge> getByPurchaseDeductCost(List<PurchaseDeductCost> deductCosts) {
        ArrayList<PurchaseRecCharge> charges = new ArrayList<PurchaseRecCharge>();
        for (PurchaseDeductCost purchaseDeductCost : deductCosts) {
            PurchaseRecCharge charge = new PurchaseRecCharge();
            charge.setItemType(ReconcilationItemTypeEmun.CHARGE.getValue());
            charge.setVoucherNumber(purchaseDeductCost.getDeductNumber());
            charge.setPurchaseOrg(purchaseDeductCost.getPurchaseOrg());
            charge.setCompany(purchaseDeductCost.getCompany());
            charge.setVoucherTime(purchaseDeductCost.getDeductTime());
            charge.setDeductionType(purchaseDeductCost.getDeductType());
            charge.setTotalAmount(purchaseDeductCost.getTaxAmount());
            charge.setTotalNonTaxAmount(purchaseDeductCost.getNetAmount());
            charge.setCurrency(purchaseDeductCost.getCurrency());
            charge.setDeductionsReason(purchaseDeductCost.getDeductReason());
            charge.setDeductionsInstructions(purchaseDeductCost.getDeductInstruction());
            charge.setSource(purchaseDeductCost.getSourceType());
            charge.setBusinessType(purchaseDeductCost.getRelationType());
            charge.setBusinessId(purchaseDeductCost.getId());
            charge.setTaxCode(purchaseDeductCost.getTaxCode());
            charge.setTaxRate(purchaseDeductCost.getTaxRate());
            charges.add(charge);
        }
        return charges;
    }

    public List<PurchaseRecAdditionalCharges> getByPurchaseAddCost(List<PurchaseAddCost> addCosts) {
        ArrayList<PurchaseRecAdditionalCharges> additionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
        for (PurchaseAddCost purchaseAddCost : addCosts) {
            PurchaseRecAdditionalCharges charges = new PurchaseRecAdditionalCharges();
            charges.setVoucherNumber(purchaseAddCost.getCostNumber());
            charges.setPurchaseOrg(purchaseAddCost.getPurchaseOrg());
            charges.setCompany(purchaseAddCost.getCompany());
            charges.setBusinessType(purchaseAddCost.getCostType());
            charges.setTaxCode(purchaseAddCost.getTaxCode());
            charges.setTaxRate(purchaseAddCost.getTaxRate());
            charges.setTotalAmount(purchaseAddCost.getTaxAmount());
            charges.setTotalNonTaxAmount(purchaseAddCost.getNetAmount());
            charges.setCurrency(purchaseAddCost.getCurrency());
            charges.setCostReason(purchaseAddCost.getCostReason());
            charges.setCostInstruction(purchaseAddCost.getCostInstruction());
            charges.setSource(purchaseAddCost.getSourceType());
            charges.setBusinessId(purchaseAddCost.getId());
            charges.setItemType(ReconcilationItemTypeEmun.ADDITIONAL_CHARGES.getValue());
            charges.setCostTime(purchaseAddCost.getCostTime());
            additionalCharges.add(charges);
        }
        return additionalCharges;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList, List<PurchaseRecCharge> purchaseRecChargeList, List<PurchaseAttachmentDTO> attachments) {
        boolean flag = false;
        if (ReconciliationStatusEmun.REFUSED.getValue().equals(purchaseReconciliation.getReconciliationStatus()) && StringUtils.isNotBlank((CharSequence)purchaseReconciliation.getRelationId())) {
            flag = true;
        }
        if (!"1".equals(purchaseReconciliation.getNeedCoordination())) {
            purchaseReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
        } else {
            purchaseReconciliation.setReconciliationStatus(ReconciliationStatusEmun.UNCONFIRMED.getValue());
        }
        purchaseReconciliation.setSendStatus("1");
        this.updateMain(purchaseReconciliation, purchaseRecAcceptReturnList, purchaseRecAdditionalChargesList, purchaseRecChargeList);
        this.invokeBaseRpcService.addStatusLog(purchaseReconciliation.getId(), purchaseReconciliation.getReconciliationStatus(), "reconciliation", "publish");
        String id = purchaseReconciliation.getRelationId();
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)((Object)saleReconciliation));
        saleReconciliation.setElsAccount(purchaseReconciliation.getToElsAccount());
        saleReconciliation.setToElsAccount(purchaseReconciliation.getElsAccount());
        saleReconciliation.setBusAccount(purchaseReconciliation.getElsAccount());
        saleReconciliation.setRelationId(purchaseReconciliation.getId());
        if (flag) {
            saleReconciliation.setId(id);
            saleReconciliation.setReconciliationStatus(purchaseReconciliation.getReconciliationStatus());
            this.saleReconciliationMapper.updateById((Object)saleReconciliation);
            this.handleDetail(saleReconciliation, purchaseRecAcceptReturnList, purchaseRecAdditionalChargesList, purchaseRecChargeList, attachments);
        } else {
            saleReconciliation.setId(null);
            this.saleReconciliationMapper.insert((Object)saleReconciliation);
            this.handleDetail(saleReconciliation, purchaseRecAcceptReturnList, purchaseRecAdditionalChargesList, purchaseRecChargeList, attachments);
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        String url = "id=" + saleReconciliation.getId() + "&createAccount=" + saleReconciliation.getCreateAccount();
        if (StringUtils.isNotBlank((CharSequence)purchaseReconciliation.getSalePrincipal())) {
            super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), purchaseReconciliation.getSalePrincipal(), (Object)saleReconciliation, url, "reconciliation", "publish");
        } else {
            super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "reconciliation", "publish");
        }
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    private MsgParamsVO parameterAssemble(PurchaseReconciliation reconciliation) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(reconciliation.getToElsAccount(), reconciliation.getSalePrincipal().split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(reconciliation.getToElsAccount(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        Map paramMap = (Map)JSON.parse((String)JSONObject.toJSON((Object)((Object)reconciliation)).toString());
        paramMap.put("userName", subAccount.getRealname());
        msgParamsVO.setParams((Object)paramMap);
        return msgParamsVO;
    }

    public void handleDetail(SaleReconciliation saleReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList, List<PurchaseRecCharge> purchaseRecChargeList, List<PurchaseAttachmentDTO> attachments) {
        this.saleRecAcceptReturnMapper.deleteByMainId(saleReconciliation.getId());
        this.saleRecChargeMapper.deleteByMainId(saleReconciliation.getId());
        this.saleRecAdditionalChargesMapper.deleteByMainId(saleReconciliation.getId());
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleReconciliation.getId());
        if (purchaseRecAcceptReturnList != null && purchaseRecAcceptReturnList.size() > 0) {
            ArrayList<SaleRecAcceptReturn> saleRecAcceptReturns = new ArrayList<SaleRecAcceptReturn>();
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
                SaleRecAcceptReturn saleRecAcceptReturn = new SaleRecAcceptReturn();
                BeanUtils.copyProperties((Object)((Object)purchaseRecAcceptReturn), (Object)((Object)saleRecAcceptReturn));
                saleRecAcceptReturn.setId(null);
                saleRecAcceptReturn.setElsAccount(saleReconciliation.getElsAccount());
                saleRecAcceptReturn.setToElsAccount(saleReconciliation.getToElsAccount());
                saleRecAcceptReturn.setBusAccount(saleReconciliation.getBusAccount());
                saleRecAcceptReturn.setHeadId(saleReconciliation.getId());
                saleRecAcceptReturn.setRelationId(purchaseRecAcceptReturn.getId());
                saleRecAcceptReturns.add(saleRecAcceptReturn);
            }
            this.saleRecAcceptReturnMapper.insertBatchSomeColumn(saleRecAcceptReturns);
        }
        if (purchaseRecChargeList != null && purchaseRecChargeList.size() > 0) {
            ArrayList<SaleRecCharge> saleRecCharges = new ArrayList<SaleRecCharge>();
            for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
                SaleRecCharge saleRecCharge = new SaleRecCharge();
                BeanUtils.copyProperties((Object)((Object)purchaseRecCharge), (Object)((Object)saleRecCharge));
                saleRecCharge.setId(null);
                saleRecCharge.setElsAccount(saleReconciliation.getElsAccount());
                saleRecCharge.setToElsAccount(saleReconciliation.getToElsAccount());
                saleRecCharge.setBusAccount(saleReconciliation.getBusAccount());
                saleRecCharge.setHeadId(saleReconciliation.getId());
                saleRecCharge.setRelationId(purchaseRecCharge.getId());
                saleRecCharges.add(saleRecCharge);
            }
            this.saleRecChargeMapper.insertBatchSomeColumn(saleRecCharges);
        }
        if (purchaseRecAdditionalChargesList != null && purchaseRecAdditionalChargesList.size() > 0) {
            ArrayList<SaleRecAdditionalCharges> saleRecAdditionalCharges = new ArrayList<SaleRecAdditionalCharges>();
            for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : purchaseRecAdditionalChargesList) {
                SaleRecAdditionalCharges saleRecAdditionalCharge = new SaleRecAdditionalCharges();
                BeanUtils.copyProperties((Object)((Object)purchaseRecAdditionalCharges), (Object)((Object)saleRecAdditionalCharge));
                saleRecAdditionalCharge.setId(null);
                saleRecAdditionalCharge.setElsAccount(saleReconciliation.getElsAccount());
                saleRecAdditionalCharge.setToElsAccount(saleReconciliation.getToElsAccount());
                saleRecAdditionalCharge.setBusAccount(saleReconciliation.getBusAccount());
                saleRecAdditionalCharge.setHeadId(saleReconciliation.getId());
                saleRecAdditionalCharge.setRelationId(purchaseRecAdditionalCharges.getId());
                saleRecAdditionalCharges.add(saleRecAdditionalCharge);
            }
            this.saleRecAdditionalChargesMapper.insertBatchSomeColumn(saleRecAdditionalCharges);
        }
        if (attachments != null && attachments.size() > 0) {
            ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
            for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                purchaseAttachment.setSendStatus("1");
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(null);
                saleAttachment.setElsAccount(saleReconciliation.getElsAccount());
                saleAttachment.setHeadId(saleReconciliation.getId());
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
                saleAttachments.add(saleAttachment);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> invoiceRefusedOrConfirm(PurchaseReconciliation purchaseReconciliation, List<PurchaseInvoice> invoices, String operation) {
        String opt = "confirm";
        if ("refused".equals(operation)) {
            opt = "refund";
            purchaseReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.RENTURNED.getValue());
        } else if ("confirm".equals(operation)) {
            purchaseReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.CONFIRMED.getValue());
        }
        this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.saleReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getRelationId())));
        if (saleReconciliation != null) {
            BigDecimal invoiceTotalAmount = new BigDecimal(0);
            saleReconciliation.setPurchaseInvoiceAffirmStatus(purchaseReconciliation.getPurchaseInvoiceAffirmStatus());
            saleReconciliation.setPurchaseRemark(purchaseReconciliation.getPurchaseRemark());
            for (PurchaseInvoice purchaseInvoice : invoices) {
                if (OperationEnum.REFUSED.getValue().equals(operation)) {
                    purchaseInvoice.setStatus(InvoiceStatusEnum.RENTURNED.getValue());
                } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                    purchaseInvoice.setStatus(InvoiceStatusEnum.CONFIRMED.getValue());
                }
                this.purchaseInvoiceMapper.updateById((Object)purchaseInvoice);
                SaleInvoice saleInvoice = (SaleInvoice)((Object)this.saleInvoiceMapper.selectById((Serializable)((Object)purchaseInvoice.getRelationId())));
                if (saleInvoice == null) continue;
                if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                    SaleInvoice invoice = new SaleInvoice();
                    BeanUtils.copyProperties((Object)((Object)purchaseInvoice), (Object)((Object)invoice));
                    invoice.setId(saleInvoice.getId());
                    invoice.setElsAccount(saleInvoice.getElsAccount());
                    invoice.setToElsAccount(saleInvoice.getToElsAccount());
                    invoice.setBusAccount(saleInvoice.getBusAccount());
                    invoice.setHeadId(saleInvoice.getHeadId());
                    invoice.setNotIncludeTaxAmount(invoice.getIncludeTaxAmount().subtract(invoice.getTaxAmount()));
                    this.saleInvoiceMapper.updateById((Object)invoice);
                    invoiceTotalAmount = invoiceTotalAmount.add(invoice.getIncludeTaxAmount());
                    String url = "id=" + saleReconciliation.getId() + "&createAccount=" + saleReconciliation.getCreateAccount();
                    super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), (Object)purchaseReconciliation, url, "invoice", opt);
                    continue;
                }
                saleInvoice.setPurchaseRemark(purchaseInvoice.getPurchaseRemark());
                saleInvoice.setStatus(purchaseInvoice.getStatus());
                this.saleInvoiceMapper.updateById((Object)saleInvoice);
            }
            if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                saleReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
            }
            this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> refusedOrConfirm(PurchaseReconciliation purchaseReconciliation, String operation) {
        String opt = "confirm";
        if (OperationEnum.REFUSED.getValue().equals(operation)) {
            purchaseReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.REFUSED.getValue());
            opt = "refund";
        } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            purchaseReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.COMFIRMED.getValue());
        }
        SaleReconciliation reconciliation = (SaleReconciliation)((Object)this.saleReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getRelationId())));
        if (reconciliation != null) {
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            SaleReconciliation saleReconciliation = new SaleReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)((Object)saleReconciliation));
            saleReconciliation.setId(reconciliation.getId());
            saleReconciliation.setElsAccount(reconciliation.getElsAccount());
            saleReconciliation.setToElsAccount(reconciliation.getToElsAccount());
            saleReconciliation.setBusAccount(reconciliation.getBusAccount());
            saleReconciliation.setRelationId(purchaseReconciliation.getId());
            this.saleReconciliationMapper.updateById((Object)saleReconciliation);
            String url = "id=" + saleReconciliation.getId() + "&createAccount=" + saleReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)purchaseReconciliation.getSalePrincipal())) {
                super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), purchaseReconciliation.getSalePrincipal(), (Object)purchaseReconciliation, url, "saleReconciliation", opt);
            } else {
                super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), (Object)purchaseReconciliation, url, "saleReconciliation", opt);
            }
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        throw new RuntimeException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)id)));
        purchaseReconciliation.setCancellation("1");
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseReconciliation.setCancellationName(loginUser.getRealname());
        purchaseReconciliation.setCancellationSubAccount(loginUser.getSubAccount());
        purchaseReconciliation.setCancellationTime(new Date());
        this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.saleReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getRelationId())));
        saleReconciliation.setCancellation("1");
        saleReconciliation.setCancellationName(purchaseReconciliation.getCancellationName());
        saleReconciliation.setCancellationSubAccount(purchaseReconciliation.getCancellationSubAccount());
        saleReconciliation.setCancellationTime(purchaseReconciliation.getCancellationTime());
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        List<PurchaseRecAcceptReturn> acceptReturns = this.purchaseRecAcceptReturnService.selectByMainId(id);
        List<PurchaseRecAdditionalCharges> additionalCharges = this.purchaseRecAdditionalChargesService.selectByMainId(id);
        List<PurchaseRecCharge> charges = this.purchaseRecChargeService.selectByMainId(id);
        if (acceptReturns != null && acceptReturns.size() > 0) {
            ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
            for (PurchaseRecAcceptReturn acceptReturn : acceptReturns) {
                PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(acceptReturn.getBusinessId());
                if (voucherItem == null) continue;
                voucherItem.setReconciliation("0");
                voucherItem.setReconciliationNumber(null);
                voucherItems.add(voucherItem);
            }
            if (!voucherItems.isEmpty()) {
                this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
            }
        }
        if (additionalCharges != null && additionalCharges.size() > 0) {
            ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
            ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
            for (PurchaseRecAdditionalCharges recAdditionalCharges : additionalCharges) {
                PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())));
                if (addCost == null) continue;
                addCost.setCostStatus("0");
                addCost.setReconciliationNumber(null);
                addCosts.add(addCost);
                SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)addCost.getRelationId())));
                saleAddCost.setReconciliationNumber(null);
                saleAddCost.setCostStatus("0");
                saleAddCosts.add(saleAddCost);
            }
            if (!addCosts.isEmpty()) {
                this.purchaseAddCostService.updateBatchById(addCosts);
            }
            if (!saleAddCosts.isEmpty()) {
                this.saleAddCostService.updateBatchById(saleAddCosts);
            }
        }
        if (charges != null && charges.size() > 0) {
            ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
            ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
            for (PurchaseRecCharge charge : charges) {
                PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
                if (deductCost == null) continue;
                deductCost.setDeductStatus("0");
                deductCost.setReconciliationNumber(null);
                deductCosts.add(deductCost);
                SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
                saleDeductCost.setDeductStatus("0");
                saleDeductCost.setReconciliationNumber(null);
                saleDeductCosts.add(saleDeductCost);
            }
            if (!deductCosts.isEmpty()) {
                this.purchaseDeductCostService.updateBatchById(deductCosts);
            }
            if (!saleDeductCosts.isEmpty()) {
                this.saleDeductCostService.updateBatchById(saleDeductCosts);
            }
        }
    }
}

