/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ElsTaxRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.api.service.PurchaseVoucherItemRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecAcceptReturnMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecChargeMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SaleReconciliationMapper;
import com.els.modules.reconciliation.service.SaleRecAcceptReturnService;
import com.els.modules.reconciliation.service.SaleRecAdditionalChargesService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleReconciliationService;
import com.els.modules.reconciliation.vo.SaleReconciliationVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleReconciliationServiceImpl
extends BaseServiceImpl<SaleReconciliationMapper, SaleReconciliation>
implements SaleReconciliationService {
    @Resource
    private SaleReconciliationMapper saleReconciliationMapper;
    @Resource
    private SaleRecAcceptReturnService saleRecAcceptReturnService;
    @Resource
    private SaleRecAdditionalChargesService saleRecAdditionalChargesService;
    @Resource
    private SaleRecChargeService saleRecChargeService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private TemplateRpcService templateHeadService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private PurchaseVoucherItemRpcService purchaseVoucherItemRpcService;
    @Autowired
    private SaleAddCostService saleAddCostService;
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Resource
    private PurchaseRecAcceptReturnMapper purchaseRecAcceptReturnMapper;
    @Resource
    private PurchaseRecAdditionalChargesMapper purchaseRecAdditionalChargesMapper;
    @Resource
    private PurchaseRecChargeMapper purchaseRecChargeMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsTaxRpcService elsTaxRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleReconciliation saleReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList, List<SaleRecCharge> saleRecChargeList, List<SaleInvoice> saleInvoiceList) {
        saleReconciliation.setReconciliationNumber(this.invokeBaseRpcService.getNextCode("saleReconciliation", (Object)saleReconciliation, saleReconciliation.getBusAccount()));
        saleReconciliation.setBusAccount(saleReconciliation.getToElsAccount());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(saleReconciliation.getTemplateNumber());
        if (templateHead != null) {
            saleReconciliation.setTemplateName(templateHead.getTemplateName());
            saleReconciliation.setTemplateNumber(templateHead.getTemplateNumber());
            saleReconciliation.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            saleReconciliation.setTemplateAccount(templateHead.getElsAccount());
        }
        saleReconciliation.setCreateAccount(TenantContext.getTenant());
        saleReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.NEW.getValue());
        saleReconciliation.setSaleRecSendStatus("0");
        saleReconciliation.setInvoiced("0");
        saleReconciliation.setCancellation("0");
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            saleReconciliation.setSupplierName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(saleReconciliation.getToElsAccount())) != null) {
            saleReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        saleReconciliation.setRelationId(IdWorker.getIdStr());
        this.saleReconciliationMapper.insert((Object)saleReconciliation);
        this.insertData(saleReconciliation, saleRecAcceptReturnList, saleRecAdditionalChargesList, saleRecChargeList);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), ReconciliationStatusEmun.NEW.getValue(), "saleReconciliation", "inster");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> updateMain(SaleReconciliation saleReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList, List<SaleRecCharge> saleRecChargeList) {
        boolean isCreated = true;
        List<SaleRecAcceptReturn> acceptReturns = this.saleRecAcceptReturnService.selectByMainId(saleReconciliation.getId());
        if (acceptReturns != null && acceptReturns.size() > 0) {
            isCreated = false;
        }
        if (isCreated) {
            ArrayList<String> taxCodeList = new ArrayList<String>();
            ArrayList<String> currenyList = new ArrayList<String>();
            if (saleRecAcceptReturnList == null || saleRecAcceptReturnList != null && saleRecAcceptReturnList.size() < 1) {
                throw new RuntimeException("\u6536\u9000\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
                if (!taxCodeList.contains(saleRecAcceptReturn.getTaxCode())) {
                    taxCodeList.add(saleRecAcceptReturn.getTaxCode());
                } else if (StringUtils.isBlank((CharSequence)saleRecAcceptReturn.getTaxCode())) {
                    throw new RuntimeException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u6216\u51ed\u8bc1" + saleRecAcceptReturn.getVoucherNumber() + " \u7a0e\u7801\u4e3a\u7a7a");
                }
                if (!currenyList.contains(saleRecAcceptReturn.getCurrency())) {
                    currenyList.add(saleRecAcceptReturn.getCurrency());
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)saleRecAcceptReturn.getCurrency())) continue;
                throw new RuntimeException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u6216\u51ed\u8bc1" + saleRecAcceptReturn.getVoucherNumber() + " \u5e01\u522b\u4e3a\u7a7a");
            }
            Map<Boolean, String> map = this.generateReconciliation(saleReconciliation, saleRecAcceptReturnList, saleRecAdditionalChargesList, saleRecChargeList, taxCodeList, currenyList);
            if (StringUtils.isNotBlank((CharSequence)map.get(true))) {
                return Result.ok((String)("\u5bf9\u8d26\u5355\u751f\u6210\u6210\u529f\uff0c\u5355\u636e\u7f16\u53f7\u5206\u522b\u4e3a\uff1a" + map.get(true)));
            }
            throw new RuntimeException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25\uff1a" + map.get(false));
        }
        ArrayList<String> acceptReturnIds = new ArrayList<String>();
        BigDecimal amount = new BigDecimal(0);
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            acceptReturnIds.add(saleRecAcceptReturn.getBusinessId());
            if (saleRecAcceptReturn.getDirectionBorrowing().equals("+")) {
                amount = amount.add(saleRecAcceptReturn.getTotalAmount());
            }
            if (!saleRecAcceptReturn.getDirectionBorrowing().equals("-")) continue;
            amount = amount.subtract(saleRecAcceptReturn.getTotalAmount());
        }
        if (amount.compareTo(new BigDecimal(0)) < 0) {
            throw new ELSBootException("\u5bf9\u8d26\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u6536\u9000\u8d27\u660e\u7ec6\u603b\u91d1\u989d\u5c0f\u4e8e0");
        }
        ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
        for (Object acceptReturn : acceptReturns) {
            if (acceptReturnIds.contains(acceptReturn.getBusinessId())) continue;
            PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(acceptReturn.getBusinessId());
            voucherItem.setReconciliation("0");
            voucherItem.setReconciliationNumber(null);
            voucherItems.add(voucherItem);
        }
        if (!voucherItems.isEmpty()) {
            this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SaleRecAdditionalCharges additionalCharges : saleRecAdditionalChargesList) {
            arrayList.add(additionalCharges.getBusinessId());
        }
        List<SaleRecAdditionalCharges> additionalCharges = this.saleRecAdditionalChargesService.selectByMainId(saleReconciliation.getId());
        ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
        ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
        for (Object recAdditionalCharges : additionalCharges) {
            if (arrayList.contains(recAdditionalCharges.getBusinessId())) continue;
            SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())));
            saleAddCost.setReconciliationNumber(null);
            saleAddCost.setCostStatus("0");
            saleAddCosts.add(saleAddCost);
            PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
            addCost.setCostStatus("0");
            addCost.setReconciliationNumber(null);
            addCosts.add(addCost);
        }
        if (!addCosts.isEmpty()) {
            this.purchaseAddCostService.updateBatchById(addCosts);
        }
        if (!saleAddCosts.isEmpty()) {
            this.saleAddCostService.updateBatchById(saleAddCosts);
        }
        ArrayList<String> deductCostIds = new ArrayList<String>();
        for (SaleRecCharge charge : saleRecChargeList) {
            deductCostIds.add(charge.getBusinessId());
        }
        List<SaleRecCharge> charges = this.saleRecChargeService.selectByMainId(saleReconciliation.getId());
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge charge : charges) {
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            if (deductCostIds.contains(charge.getBusinessId())) continue;
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("0");
            deductCost.setReconciliationNumber(null);
            deductCosts.add(deductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
        this.calculateMoney(saleReconciliation, saleRecAcceptReturnList, saleRecAdditionalChargesList, saleRecChargeList);
        if ("1".equals(saleReconciliation.getSaveForZero())) {
            if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                throw new RuntimeException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + saleReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
            }
        } else if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
            throw new RuntimeException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + saleReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e\u7b49\u4e8e0\u90fd\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
        }
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        this.insertData(saleReconciliation, saleRecAcceptReturnList, saleRecAdditionalChargesList, saleRecChargeList);
        return Result.ok((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public Map<Boolean, String> generateReconciliation(SaleReconciliation reconciliation, List<SaleRecAcceptReturn> acceptReturns, List<SaleRecAdditionalCharges> additionalCharges, List<SaleRecCharge> charges, List<String> taxCodeList, List<String> currenyList) {
        HashMap<Boolean, String> result = new HashMap<Boolean, String>();
        result.put(false, "");
        result.put(true, "");
        boolean flag = false;
        for (String taxCode : taxCodeList) {
            for (String currency : currenyList) {
                List taxs;
                Object acceptReturn2;
                ArrayList<SaleRecAcceptReturn> recAcceptReturns = new ArrayList<SaleRecAcceptReturn>();
                BigDecimal amount = new BigDecimal(0);
                for (Object acceptReturn2 : acceptReturns) {
                    if (!taxCode.equals(acceptReturn2.getTaxCode()) || !currency.equals(acceptReturn2.getCurrency())) continue;
                    recAcceptReturns.add((SaleRecAcceptReturn)((Object)acceptReturn2));
                    if (acceptReturn2.getDirectionBorrowing().equals("+")) {
                        amount = amount.add(acceptReturn2.getTotalAmount());
                    }
                    if (!acceptReturn2.getDirectionBorrowing().equals("-")) continue;
                    amount = amount.subtract(acceptReturn2.getTotalAmount());
                }
                if (recAcceptReturns.isEmpty()) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u6536\u9000\u8d27\u660e\u7ec6\u4e3a\u7a7a\uff1b ");
                    continue;
                }
                if (amount.compareTo(new BigDecimal(0)) < 0) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u6536\u9000\u8d27\u660e\u7ec6\u603b\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                    continue;
                }
                ArrayList<SaleRecAdditionalCharges> recAdditionalCharges = new ArrayList<SaleRecAdditionalCharges>();
                acceptReturn2 = additionalCharges.iterator();
                while (acceptReturn2.hasNext()) {
                    Object purchaseRecAdditionalCharges = (SaleRecAdditionalCharges)((Object)acceptReturn2.next());
                    if (!taxCode.equals(purchaseRecAdditionalCharges.getTaxCode()) || !currency.equals(purchaseRecAdditionalCharges.getCurrency())) continue;
                    recAdditionalCharges.add((SaleRecAdditionalCharges)((Object)purchaseRecAdditionalCharges));
                }
                ArrayList<SaleRecCharge> recCharges = new ArrayList<SaleRecCharge>();
                for (SaleRecCharge charge : charges) {
                    if (!taxCode.equals(charge.getTaxCode()) || !currency.equals(charge.getCurrency())) continue;
                    recCharges.add(charge);
                }
                reconciliation.setTaxCode(taxCode);
                if (reconciliation.getTaxRate() == null && (taxs = this.elsTaxRpcService.findList(reconciliation.getToElsAccount(), taxCode)) != null && taxs.size() > 0) {
                    reconciliation.setTaxRate(((ElsTaxDTO)taxs.get(0)).getTaxRate());
                }
                reconciliation.setCurrency(currency);
                if (flag) {
                    SaleReconciliation saleReconciliation = new SaleReconciliation();
                    BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)saleReconciliation));
                    saleReconciliation.setId(null);
                    saleReconciliation.setReconciliationNumber(this.invokeBaseRpcService.getNextCode("saleReconciliation", (Object)saleReconciliation));
                    this.calculateMoney(saleReconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                    if ("1".equals(saleReconciliation.getSaveForZero())) {
                        if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                            result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                            continue;
                        }
                    } else if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
                        result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff1b ");
                        continue;
                    }
                    this.saleReconciliationMapper.insert((Object)saleReconciliation);
                    this.insertData(saleReconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                    result.put(true, (String)result.get(true) + taxCode + "/" + currency + ": " + saleReconciliation.getReconciliationNumber());
                    continue;
                }
                this.calculateMoney(reconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                if ("1".equals(reconciliation.getSaveForZero())) {
                    if (reconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                        result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                        continue;
                    }
                } else if (reconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff1b ");
                    continue;
                }
                this.saleReconciliationMapper.updateById((Object)reconciliation);
                this.insertData(reconciliation, recAcceptReturns, recAdditionalCharges, recCharges);
                flag = true;
                result.put(true, (String)result.get(true) + taxCode + "/" + currency + ": " + reconciliation.getReconciliationNumber());
            }
        }
        return result;
    }

    public void calculateMoney(SaleReconciliation reconciliation, List<SaleRecAcceptReturn> acceptReturns, List<SaleRecAdditionalCharges> additionalCharges, List<SaleRecCharge> charges) {
        BigDecimal deliveryIncludeTaxAmount = new BigDecimal(0);
        for (Object recAcceptReturn : acceptReturns) {
            if (recAcceptReturn.getDirectionBorrowing().equals("+")) {
                deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.add(recAcceptReturn.getTotalAmount());
            }
            if (!recAcceptReturn.getDirectionBorrowing().equals("-")) continue;
            deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.subtract(recAcceptReturn.getTotalAmount());
        }
        reconciliation.setDeliveryIncludeTaxAmount(deliveryIncludeTaxAmount);
        BigDecimal additionalChangesAmount = new BigDecimal(0);
        for (SaleRecAdditionalCharges recAdditionalCharges : additionalCharges) {
            additionalChangesAmount = additionalChangesAmount.add(recAdditionalCharges.getTotalAmount());
        }
        reconciliation.setAdditionalChangesAmount(additionalChangesAmount);
        BigDecimal chargeTotalAmount = new BigDecimal(0);
        BigDecimal chargeAmount = new BigDecimal(0);
        BigDecimal buckleTicketsAmount = new BigDecimal(0);
        for (SaleRecCharge recCharge : charges) {
            chargeTotalAmount = chargeTotalAmount.add(recCharge.getTotalAmount());
            if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(recCharge.getDeductionType())) {
                chargeAmount = chargeAmount.add(recCharge.getTotalAmount());
            }
            if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(recCharge.getDeductionType())) continue;
            buckleTicketsAmount = buckleTicketsAmount.add(recCharge.getTotalAmount());
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = deliveryIncludeTaxAmount.add(additionalChangesAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.add(additionalChangesAmount).subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
    }

    private void insertData(SaleReconciliation saleReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList, List<SaleRecCharge> saleRecChargeList) {
        int itemNumber;
        this.saleRecAcceptReturnService.deleteByMainId(saleReconciliation.getId());
        this.saleRecAdditionalChargesService.deleteByMainId(saleReconciliation.getId());
        this.saleRecChargeService.deleteByMainId(saleReconciliation.getId());
        System.out.println("123");
        if (saleRecAcceptReturnList != null) {
            itemNumber = 1;
            ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
            Date date = new Date();
            for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
                saleRecAcceptReturn.setHeadId(saleReconciliation.getId());
                SysUtil.setSysParam((BaseEntity)saleRecAcceptReturn, (BaseEntity)saleReconciliation);
                saleRecAcceptReturn.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                saleRecAcceptReturn.setItemNumber(String.valueOf(itemNumber));
                saleRecAcceptReturn.setBusAccount(saleReconciliation.getBusAccount());
                PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(saleRecAcceptReturn.getBusinessId());
                voucherItem.setReconciliation("1");
                voucherItem.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                voucherItem.setPostDate(date);
                voucherItems.add(voucherItem);
                ++itemNumber;
            }
            if (!saleRecAcceptReturnList.isEmpty()) {
                this.saleRecAcceptReturnService.saveBatch(saleRecAcceptReturnList, 2000);
            }
            if (!voucherItems.isEmpty()) {
                this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
            }
        }
        if (saleRecAdditionalChargesList != null) {
            itemNumber = 1;
            ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
            ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
            for (SaleRecAdditionalCharges saleRecAdditionalCharges : saleRecAdditionalChargesList) {
                saleRecAdditionalCharges.setHeadId(saleReconciliation.getId());
                SysUtil.setSysParam((BaseEntity)saleRecAdditionalCharges, (BaseEntity)saleReconciliation);
                saleRecAdditionalCharges.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                saleRecAdditionalCharges.setItemNumber(String.valueOf(itemNumber));
                saleRecAdditionalCharges.setBusAccount(saleReconciliation.getBusAccount());
                SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)saleRecAdditionalCharges.getBusinessId())));
                saleAddCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                saleAddCost.setCostStatus("1");
                saleAddCosts.add(saleAddCost);
                PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
                addCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                addCost.setCostStatus("1");
                addCosts.add(addCost);
                ++itemNumber;
            }
            if (!saleRecAdditionalChargesList.isEmpty()) {
                this.saleRecAdditionalChargesService.saveBatch(saleRecAdditionalChargesList, 200);
            }
            if (!addCosts.isEmpty()) {
                this.purchaseAddCostService.updateBatchById(addCosts);
            }
            if (!saleAddCosts.isEmpty()) {
                this.saleAddCostService.updateBatchById(saleAddCosts);
            }
        }
        if (saleRecChargeList != null) {
            itemNumber = 1;
            ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
            ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
            for (SaleRecCharge saleRecCharge : saleRecChargeList) {
                saleRecCharge.setHeadId(saleReconciliation.getId());
                SysUtil.setSysParam((BaseEntity)saleRecCharge, (BaseEntity)saleReconciliation);
                saleRecCharge.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                saleRecCharge.setItemNumber(String.valueOf(itemNumber));
                saleRecCharge.setBusAccount(saleReconciliation.getBusAccount());
                SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)saleRecCharge.getBusinessId())));
                saleDeductCost.setDeductStatus("1");
                saleDeductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                saleDeductCosts.add(saleDeductCost);
                PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
                deductCost.setDeductStatus("1");
                deductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
                deductCosts.add(deductCost);
                ++itemNumber;
            }
            if (!saleRecChargeList.isEmpty()) {
                this.saleRecChargeService.saveBatch(saleRecChargeList, 2000);
            }
            if (!deductCosts.isEmpty()) {
                this.purchaseDeductCostService.updateBatchById(deductCosts);
            }
            if (!saleDeductCosts.isEmpty()) {
                this.saleDeductCostService.updateBatchById(saleDeductCosts);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        List<SaleRecAcceptReturn> acceptReturns = this.saleRecAcceptReturnService.selectByMainId(id);
        List<SaleRecAdditionalCharges> additionalCharges = this.saleRecAdditionalChargesService.selectByMainId(id);
        List<SaleRecCharge> charges = this.saleRecChargeService.selectByMainId(id);
        this.saleRecAcceptReturnService.deleteByMainId(id);
        this.saleRecAdditionalChargesService.deleteByMainId(id);
        this.saleRecChargeService.deleteByMainId(id);
        this.saleInvoiceMapper.deleteByMainId(id);
        this.saleReconciliationMapper.deleteById((Serializable)((Object)id));
        if (acceptReturns != null && acceptReturns.size() > 0) {
            ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
            for (SaleRecAcceptReturn acceptReturn : acceptReturns) {
                PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(acceptReturn.getBusinessId());
                voucherItem.setReconciliation("0");
                voucherItem.setReconciliationNumber(null);
                voucherItems.add(voucherItem);
            }
            if (!voucherItems.isEmpty()) {
                this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
            }
        }
        if (additionalCharges != null && additionalCharges.size() > 0) {
            ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
            ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
            for (SaleRecAdditionalCharges recAdditionalCharges : additionalCharges) {
                SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())));
                saleAddCost.setReconciliationNumber(null);
                saleAddCost.setCostStatus("0");
                saleAddCosts.add(saleAddCost);
                PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
                addCost.setCostStatus("0");
                addCost.setReconciliationNumber(null);
                addCosts.add(addCost);
            }
            if (!addCosts.isEmpty()) {
                this.purchaseAddCostService.updateBatchById(addCosts);
            }
            if (!saleAddCosts.isEmpty()) {
                this.saleAddCostService.updateBatchById(saleAddCosts);
            }
        }
        if (charges != null && charges.size() > 0) {
            ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
            ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
            for (SaleRecCharge charge : charges) {
                SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
                saleDeductCost.setDeductStatus("0");
                saleDeductCost.setReconciliationNumber(null);
                saleDeductCosts.add(saleDeductCost);
                PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
                deductCost.setDeductStatus("0");
                deductCost.setReconciliationNumber(null);
                deductCosts.add(deductCost);
            }
            if (!deductCosts.isEmpty()) {
                this.purchaseDeductCostService.updateBatchById(deductCosts);
            }
            if (!saleDeductCosts.isEmpty()) {
                this.saleDeductCostService.updateBatchById(saleDeductCosts);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleRecAcceptReturnService.deleteByMainId(serializable.toString());
            this.saleRecAdditionalChargesService.deleteByMainId(serializable.toString());
            this.saleRecChargeService.deleteByMainId(serializable.toString());
            this.saleInvoiceMapper.deleteByMainId(serializable.toString());
            this.saleReconciliationMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SaleReconciliation saleReconciliation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.REFUSED.getValue());
            opt = "refund";
        }
        this.updateById((Object)saleReconciliation);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "reconciliation", opt);
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setReconciliationStatus(saleReconciliation.getReconciliationStatus());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        if (opt != null) {
            String url = "id=" + purchaseReconciliation.getId() + "&createAccount=" + purchaseReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)saleReconciliation.getPurchasePrincipal())) {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "reconciliation", "refund");
            } else {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "reconciliation", "refund");
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(SaleReconciliation saleReconciliation, List<SaleInvoice> saleInvoiceList, String operation) {
        this.saleInvoiceMapper.deleteByMainId(saleReconciliation.getId());
        BigDecimal invoiceTotalAmount = new BigDecimal(0);
        for (SaleInvoice saleInvoice : saleInvoiceList) {
            saleInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)saleInvoice.getInvoiceNumber())) {
                saleInvoice.setInvoiceNumber(this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)saleInvoice));
            }
            if ("save".equals(operation)) {
                if (!InvoiceStatusEnum.RENTURNED.getValue().equals(saleInvoice.getStatus())) {
                    saleInvoice.setStatus(InvoiceStatusEnum.NEW.getValue());
                }
            } else if ("send".equals(operation)) {
                saleInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            }
            if (saleInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = new BigDecimal(saleInvoice.getTaxRate()).divide(new BigDecimal(100)).add(BigDecimal.ONE);
                saleInvoice.setNotIncludeTaxAmount(saleInvoice.getIncludeTaxAmount().divide(tax, 5));
            }
            if (saleInvoice.getTaxAmount() == null) {
                saleInvoice.setTaxAmount(saleInvoice.getIncludeTaxAmount().subtract(saleInvoice.getNotIncludeTaxAmount()));
            }
            saleInvoice.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleInvoice.setBusAccount(saleReconciliation.getToElsAccount());
            saleInvoice.setToElsAccount(saleReconciliation.getToElsAccount());
            saleInvoice.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)saleInvoice, (BaseEntity)saleReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(saleInvoice.getIncludeTaxAmount());
        }
        saleReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        if (!saleInvoiceList.isEmpty()) {
            this.saleInvoiceMapper.insertBatchSomeColumn(saleInvoiceList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void sendInvoice(SaleReconciliation saleReconciliation, List<SaleInvoice> saleInvoiceList) {
        saleReconciliation.setInvoiced("1");
        saleReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
        this.saveInvoice(saleReconciliation, saleInvoiceList, "send");
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setInvoiced("1");
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            purchaseReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
            purchaseReconciliation.setTotalInvoiceAmount(saleReconciliation.getTotalInvoiceAmount());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.purchaseInvoiceMapper.deleteByMainId(purchaseReconciliation.getId());
            ArrayList<PurchaseInvoice> purchaseInvoices = new ArrayList<PurchaseInvoice>();
            for (SaleInvoice saleInvoice : saleInvoiceList) {
                PurchaseInvoice purchaseInvoice = new PurchaseInvoice();
                BeanUtils.copyProperties((Object)((Object)saleInvoice), (Object)((Object)purchaseInvoice));
                purchaseInvoice.setRelationId(saleInvoice.getId());
                purchaseInvoice.setElsAccount(purchaseReconciliation.getElsAccount());
                purchaseInvoice.setToElsAccount(purchaseReconciliation.getToElsAccount());
                purchaseInvoice.setHeadId(purchaseReconciliation.getId());
                purchaseInvoice.setId(null);
                purchaseInvoices.add(purchaseInvoice);
            }
            String url = "id=" + purchaseReconciliation.getId() + "&createAccount=" + purchaseReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)saleReconciliation.getPurchasePrincipal())) {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "invoice", "publish");
            } else {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "invoice", "publish");
            }
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoices);
        }
    }

    @Override
    public SaleReconciliationVO extractReconciliation(SaleReconciliationVO reconciliationVO) {
        List deductCosts;
        List voucherItems;
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = new PurchaseVoucherItemDTO();
        purchaseVoucherItemDTO.setElsAccount(reconciliationVO.getToElsAccount());
        purchaseVoucherItemDTO.setToElsAccount(reconciliationVO.getElsAccount());
        purchaseVoucherItemDTO.setCompany(reconciliationVO.getCompany());
        purchaseVoucherItemDTO.setBeginDate(reconciliationVO.getBeginDate());
        purchaseVoucherItemDTO.setEndDate(reconciliationVO.getEndDate());
        purchaseVoucherItemDTO.setVoucherStatus("0");
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            purchaseVoucherItemDTO.setTaxCode(reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            purchaseVoucherItemDTO.setCurrency(reconciliationVO.getCurrency());
        }
        if ((voucherItems = this.purchaseVoucherItemRpcService.selectReconciliationVoucher(purchaseVoucherItemDTO)) != null && voucherItems.size() > 0) {
            List<SaleRecAcceptReturn> acceptReturns = this.getBySaleVoucherItem(voucherItems);
            reconciliationVO.setSaleRecAcceptReturnList(acceptReturns);
        } else {
            reconciliationVO.setSaleRecAcceptReturnList(null);
        }
        QueryWrapper deDuctWapper = new QueryWrapper();
        deDuctWapper.eq((Object)"els_account", (Object)reconciliationVO.getElsAccount());
        deDuctWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        deDuctWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        deDuctWapper.ge((Object)"deduct_time", (Object)reconciliationVO.getBeginDate());
        deDuctWapper.le((Object)"deduct_time", (Object)reconciliationVO.getEndDate());
        deDuctWapper.eq((Object)"confirm_status", (Object)DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        deDuctWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"deduct_status")).or()).eq((Object)"deduct_status", (Object)"0"));
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            deDuctWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            deDuctWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        if ((deductCosts = this.saleDeductCostService.list((Wrapper)deDuctWapper)) != null && deductCosts.size() > 0) {
            List<SaleRecCharge> charges = this.getBySaleDeductCost(deductCosts);
            reconciliationVO.setSaleRecChargeList(charges);
        } else {
            reconciliationVO.setSaleRecChargeList(null);
        }
        QueryWrapper addCostWapper = new QueryWrapper();
        addCostWapper.eq((Object)"els_account", (Object)reconciliationVO.getElsAccount());
        addCostWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        addCostWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        addCostWapper.ge((Object)"cost_time", (Object)reconciliationVO.getBeginDate());
        addCostWapper.le((Object)"cost_time", (Object)reconciliationVO.getEndDate());
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            addCostWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            addCostWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        addCostWapper.eq((Object)"confirm_status", (Object)AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        addCostWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"cost_status")).or()).eq((Object)"cost_status", (Object)"0"));
        List addCosts = this.saleAddCostService.list((Wrapper)addCostWapper);
        if (addCosts != null && addCosts.size() > 0) {
            List<SaleRecAdditionalCharges> additionalCharges = this.getBySaleAddCost(addCosts);
            reconciliationVO.setSaleRecAdditionalChargesList(additionalCharges);
        } else {
            reconciliationVO.setSaleRecAdditionalChargesList(null);
        }
        return reconciliationVO;
    }

    public List<SaleRecAdditionalCharges> getBySaleAddCost(List<SaleAddCost> addCosts) {
        ArrayList<SaleRecAdditionalCharges> additionalCharges = new ArrayList<SaleRecAdditionalCharges>();
        for (SaleAddCost purchaseAddCost : addCosts) {
            SaleRecAdditionalCharges charges = new SaleRecAdditionalCharges();
            charges.setVoucherNumber(purchaseAddCost.getCostNumber());
            charges.setPurchaseOrg(purchaseAddCost.getPurchaseOrg());
            charges.setCompany(purchaseAddCost.getCompany());
            charges.setBusinessType(purchaseAddCost.getCostType());
            charges.setTaxCode(purchaseAddCost.getTaxCode());
            charges.setTaxRate(purchaseAddCost.getTaxRate());
            charges.setTotalAmount(purchaseAddCost.getTaxAmount());
            charges.setTotalNonTaxAmount(purchaseAddCost.getNetAmount());
            charges.setCurrency(purchaseAddCost.getCurrency());
            charges.setCostReason(purchaseAddCost.getCostReason());
            charges.setCostInstruction(purchaseAddCost.getCostInstruction());
            charges.setSource(purchaseAddCost.getSourceType());
            charges.setBusinessId(purchaseAddCost.getId());
            charges.setItemType(ReconcilationItemTypeEmun.ADDITIONAL_CHARGES.getValue());
            charges.setCostTime(purchaseAddCost.getCostTime());
            additionalCharges.add(charges);
        }
        return additionalCharges;
    }

    public List<SaleRecCharge> getBySaleDeductCost(List<SaleDeductCost> deductCosts) {
        ArrayList<SaleRecCharge> charges = new ArrayList<SaleRecCharge>();
        for (SaleDeductCost purchaseDeductCost : deductCosts) {
            SaleRecCharge charge = new SaleRecCharge();
            charge.setItemType(ReconcilationItemTypeEmun.CHARGE.getValue());
            charge.setVoucherNumber(purchaseDeductCost.getDeductNumber());
            charge.setPurchaseOrg(purchaseDeductCost.getPurchaseOrg());
            charge.setCompany(purchaseDeductCost.getCompany());
            charge.setVoucherTime(purchaseDeductCost.getDeductTime());
            charge.setDeductionType(purchaseDeductCost.getDeductType());
            charge.setTotalAmount(purchaseDeductCost.getTaxAmount());
            charge.setTotalNonTaxAmount(purchaseDeductCost.getNetAmount());
            charge.setCurrency(purchaseDeductCost.getCurrency());
            charge.setDeductionsReason(purchaseDeductCost.getDeductReason());
            charge.setDeductionsInstructions(purchaseDeductCost.getDeductInstruction());
            charge.setSource(purchaseDeductCost.getSourceType());
            charge.setBusinessType(purchaseDeductCost.getRelationType());
            charge.setBusinessId(purchaseDeductCost.getId());
            charge.setTaxCode(purchaseDeductCost.getTaxCode());
            charge.setTaxRate(purchaseDeductCost.getTaxRate());
            charges.add(charge);
        }
        return charges;
    }

    public List<SaleRecAcceptReturn> getBySaleVoucherItem(List<PurchaseVoucherItemDTO> voucherItems) {
        ArrayList<SaleRecAcceptReturn> acceptReturns = new ArrayList<SaleRecAcceptReturn>();
        for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItems) {
            SaleRecAcceptReturn acceptReturn = new SaleRecAcceptReturn();
            acceptReturn.setItemType(ReconcilationItemTypeEmun.RECEIVING_REFUND.getValue());
            acceptReturn.setVoucherNumber(purchaseVoucherItem.getVoucherNumber());
            acceptReturn.setVoucherItemNumber(purchaseVoucherItem.getItemNumber());
            acceptReturn.setVoucherTime(purchaseVoucherItem.getVoucherDate());
            acceptReturn.setDeliveryNumber(purchaseVoucherItem.getDeliveryNumber());
            acceptReturn.setDeliveryItemNumber(purchaseVoucherItem.getDeliveryItemNumber());
            acceptReturn.setMobileType(purchaseVoucherItem.getMoveType());
            acceptReturn.setDirectionBorrowing(purchaseVoucherItem.getLoanDirection());
            acceptReturn.setOrderNumber(purchaseVoucherItem.getOrderNumber());
            acceptReturn.setOrderItemNumber(purchaseVoucherItem.getOrderItemNumber());
            acceptReturn.setPurchaseFactory(purchaseVoucherItem.getFactory());
            acceptReturn.setPurchaseOrg(purchaseVoucherItem.getPurchaseOrg());
            acceptReturn.setCompany(purchaseVoucherItem.getCompany());
            acceptReturn.setInventoryAddress(purchaseVoucherItem.getStorageLocation());
            acceptReturn.setInventoryAddressDesc(purchaseVoucherItem.getStorageLocationName());
            acceptReturn.setMaterialNumber(purchaseVoucherItem.getMaterialNumber());
            acceptReturn.setMaterialDesc(purchaseVoucherItem.getMaterialDesc());
            acceptReturn.setMaterialSpec(purchaseVoucherItem.getMaterialSpec());
            acceptReturn.setQuantity(purchaseVoucherItem.getQuantity());
            acceptReturn.setUnitQuantity(purchaseVoucherItem.getQuantityUnit());
            acceptReturn.setPrice(purchaseVoucherItem.getPrice());
            acceptReturn.setNoTaxUnitPrice(purchaseVoucherItem.getNetPrice());
            acceptReturn.setTaxCode(purchaseVoucherItem.getTaxCode());
            acceptReturn.setTaxRate(StringUtils.isNotBlank((CharSequence)purchaseVoucherItem.getTaxRate()) ? Integer.valueOf(Integer.parseInt(purchaseVoucherItem.getTaxRate())) : null);
            acceptReturn.setCurrency(purchaseVoucherItem.getCurrency());
            acceptReturn.setVoucherQuantity(purchaseVoucherItem.getVoucherQuantity());
            if (purchaseVoucherItem.getPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalAmount(purchaseVoucherItem.getPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            if (purchaseVoucherItem.getNetPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalNonTaxAmount(purchaseVoucherItem.getNetPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            acceptReturn.setRefVoucherNumber(purchaseVoucherItem.getRefVoucherNumber());
            acceptReturn.setRefVoucherItemNumber(purchaseVoucherItem.getRefVoucherItemNumber());
            acceptReturn.setRefVoucherYear(purchaseVoucherItem.getRefVoucherYear());
            acceptReturn.setBusinessId(purchaseVoucherItem.getId());
            acceptReturns.add(acceptReturn);
        }
        return acceptReturns;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(SaleReconciliation saleReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList, List<SaleRecCharge> saleRecChargeList, List<SaleAttachmentDTO> attachments) {
        boolean flag = false;
        if (SaleStatusEmun.REFUSED.getValue().equals(saleReconciliation.getSaleRecAffirmStatus()) && StringUtils.isNotBlank((CharSequence)saleReconciliation.getRelationId())) {
            flag = true;
        }
        saleReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.UNCONFIRMED.getValue());
        saleReconciliation.setSaleRecSendStatus("1");
        this.updateMain(saleReconciliation, saleRecAcceptReturnList, saleRecAdditionalChargesList, saleRecChargeList);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "saleReconciliation", "publish");
        String id = saleReconciliation.getRelationId();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliation), (Object)((Object)purchaseReconciliation));
        purchaseReconciliation.setElsAccount(saleReconciliation.getToElsAccount());
        purchaseReconciliation.setToElsAccount(saleReconciliation.getElsAccount());
        purchaseReconciliation.setRelationId(saleReconciliation.getId());
        if (flag) {
            purchaseReconciliation.setId(id);
            purchaseReconciliation.setReconciliationStatus(purchaseReconciliation.getReconciliationStatus());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleRecAcceptReturnList, saleRecAdditionalChargesList, saleRecChargeList, attachments);
        } else {
            purchaseReconciliation.setId(id);
            this.purchaseReconciliationMapper.insert((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleRecAcceptReturnList, saleRecAdditionalChargesList, saleRecChargeList, attachments);
            saleReconciliation.setRelationId(purchaseReconciliation.getId());
        }
        String url = "id=" + purchaseReconciliation.getId() + "&createAccount=" + purchaseReconciliation.getCreateAccount();
        if (StringUtils.isNotBlank((CharSequence)saleReconciliation.getPurchasePrincipal())) {
            super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "saleReconciliation", "publish");
        } else {
            super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "saleReconciliation", "publish");
        }
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    private MsgParamsVO parameterAssemble(SaleReconciliation reconciliation) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(reconciliation.getToElsAccount(), reconciliation.getPurchasePrincipal().split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(reconciliation.getToElsAccount(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        Map paramMap = (Map)JSON.parse((String)JSONObject.toJSON((Object)((Object)reconciliation)).toString());
        paramMap.put("userName", subAccount.getRealname());
        msgParamsVO.setParams((Object)paramMap);
        return msgParamsVO;
    }

    public void handleDetail(PurchaseReconciliation purchaseReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList, List<SaleRecCharge> saleRecChargeList, List<SaleAttachmentDTO> attachments) {
        this.purchaseRecAcceptReturnMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecChargeMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecAdditionalChargesMapper.deleteByMainId(purchaseReconciliation.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseReconciliation.getId());
        if (saleRecAcceptReturnList != null && saleRecAcceptReturnList.size() > 0) {
            ArrayList<PurchaseRecAcceptReturn> purcahseRecAcceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
            for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
                PurchaseRecAcceptReturn purchaseRecAcceptReturn = new PurchaseRecAcceptReturn();
                BeanUtils.copyProperties((Object)((Object)saleRecAcceptReturn), (Object)((Object)purchaseRecAcceptReturn));
                purchaseRecAcceptReturn.setId(null);
                purchaseRecAcceptReturn.setElsAccount(purchaseReconciliation.getElsAccount());
                purchaseRecAcceptReturn.setToElsAccount(purchaseReconciliation.getToElsAccount());
                purchaseRecAcceptReturn.setHeadId(purchaseReconciliation.getId());
                purchaseRecAcceptReturn.setRelationId(saleRecAcceptReturn.getId());
                purcahseRecAcceptReturns.add(purchaseRecAcceptReturn);
            }
            this.purchaseRecAcceptReturnMapper.insertBatchSomeColumn(purcahseRecAcceptReturns);
        }
        if (saleRecChargeList != null && saleRecChargeList.size() > 0) {
            ArrayList<PurchaseRecCharge> purchaseRecCharges = new ArrayList<PurchaseRecCharge>();
            for (SaleRecCharge saleRecCharge : saleRecChargeList) {
                PurchaseRecCharge purchaseRecCharge = new PurchaseRecCharge();
                BeanUtils.copyProperties((Object)((Object)saleRecCharge), (Object)((Object)purchaseRecCharge));
                purchaseRecCharge.setId(null);
                purchaseRecCharge.setElsAccount(purchaseReconciliation.getElsAccount());
                purchaseRecCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
                purchaseRecCharge.setHeadId(purchaseReconciliation.getId());
                purchaseRecCharge.setRelationId(saleRecCharge.getId());
                purchaseRecCharges.add(purchaseRecCharge);
            }
            this.purchaseRecChargeMapper.insertBatchSomeColumn(purchaseRecCharges);
        }
        if (saleRecAdditionalChargesList != null && saleRecAdditionalChargesList.size() > 0) {
            ArrayList<PurchaseRecAdditionalCharges> purchaseRecAdditionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
            for (SaleRecAdditionalCharges saleRecAdditionalCharges : saleRecAdditionalChargesList) {
                PurchaseRecAdditionalCharges purchaseRecAdditionalCharge = new PurchaseRecAdditionalCharges();
                BeanUtils.copyProperties((Object)((Object)saleRecAdditionalCharges), (Object)((Object)purchaseRecAdditionalCharge));
                purchaseRecAdditionalCharge.setId(null);
                purchaseRecAdditionalCharge.setElsAccount(purchaseReconciliation.getElsAccount());
                purchaseRecAdditionalCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
                purchaseRecAdditionalCharge.setHeadId(purchaseReconciliation.getId());
                purchaseRecAdditionalCharge.setRelationId(saleRecAdditionalCharges.getId());
                purchaseRecAdditionalCharges.add(purchaseRecAdditionalCharge);
            }
            this.purchaseRecAdditionalChargesMapper.insertBatchSomeColumn(purchaseRecAdditionalCharges);
        }
        if (attachments != null && attachments.size() > 0) {
            ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
            for (SaleAttachmentDTO saleAttachment : attachments) {
                saleAttachment.setSendStatus("1");
                PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
                BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
                purchaseAttachment.setId(null);
                purchaseAttachment.setElsAccount(purchaseReconciliation.getElsAccount());
                purchaseAttachment.setHeadId(purchaseReconciliation.getId());
                purchaseAttachment.setRelationId(saleAttachment.getId());
                purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseAttachments.add(purchaseAttachment);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
        }
    }
}

