/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.mapper.SaleAddCostMapper;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleAddCostServiceImpl
extends BaseServiceImpl<SaleAddCostMapper, SaleAddCost>
implements SaleAddCostService {
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private CoreInvokeSupplierRpcService supplierContactsInfoService;

    @Override
    public void saveSaleAddCost(SaleAddCost saleAddCost) {
        if (StringUtils.isBlank((CharSequence)saleAddCost.getCostNumber())) {
            saleAddCost.setCostNumber(this.invokeBaseRpcService.getNextCode("srmAddCostNumber", (Object)saleAddCost, saleAddCost.getBusAccount()));
        }
        ((SaleAddCostMapper)this.baseMapper).insert((Object)saleAddCost);
    }

    @Override
    public void updateSaleAddCost(SaleAddCost saleAddCost) {
        this.calculateNetPrice(saleAddCost);
        ((SaleAddCostMapper)this.baseMapper).updateById((Object)saleAddCost);
    }

    private void calculateNetPrice(SaleAddCost addCost) {
        BigDecimal taxRate = addCost.getTaxRate() == null ? BigDecimal.ZERO : new BigDecimal(addCost.getTaxRate()).divide(BigDecimal.valueOf(100L));
        BigDecimal taxAmount = addCost.getTaxAmount() == null ? BigDecimal.ZERO : addCost.getTaxAmount();
        BigDecimal netAmount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        addCost.setNetAmount(netAmount);
    }

    @Override
    public void sendAddCost(SaleAddCost saleAddCost) {
        boolean firstSend = true;
        String id = saleAddCost.getId();
        String relationId = saleAddCost.getRelationId();
        String elsAccount = saleAddCost.getElsAccount();
        String toElsAccount = saleAddCost.getToElsAccount();
        if (StringUtils.isBlank((CharSequence)relationId)) {
            relationId = IdWorker.getIdStr();
            saleAddCost.setRelationId(relationId);
        } else {
            firstSend = false;
        }
        saleAddCost.setConfirmStatus(AddCostConfirmStatusEnum.WAIT_CONFIRM.getValue());
        this.updateSaleAddCost(saleAddCost);
        PurchaseAddCost purchaseAddCost = new PurchaseAddCost();
        BeanUtils.copyProperties((Object)((Object)saleAddCost), (Object)((Object)purchaseAddCost));
        purchaseAddCost.setId(relationId);
        purchaseAddCost.setRelationId(id);
        purchaseAddCost.setElsAccount(toElsAccount);
        purchaseAddCost.setToElsAccount(elsAccount);
        if (firstSend) {
            this.purchaseAddCostService.savePurchaseAddCost(purchaseAddCost);
        } else {
            this.purchaseAddCostService.updatePurchaseAddCost(purchaseAddCost);
        }
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        if (CollectionUtil.isNotEmpty((Collection)saleAttachmentList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(elsAccount);
            sendVO.setHeadId(id);
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(relationId, toElsAccount);
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendSaleFile(sendVO);
        }
        String urlParam = "id=" + purchaseAddCost.getRelationId();
        super.sendMsg(saleAddCost.getElsAccount(), saleAddCost.getToElsAccount(), (Object)saleAddCost, urlParam, "addCost", "publish");
    }

    @Override
    public void delSaleAddCost(String id) {
        ((SaleAddCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleAddCost(List<String> idList) {
        ((SaleAddCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void invalidSaleAddCost(SaleAddCost saleAddCost) {
        SaleAddCost addCost = (SaleAddCost)((Object)((SaleAddCostMapper)this.baseMapper).selectById((Serializable)((Object)saleAddCost.getId())));
        if ("1".equals(addCost.getCostStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tFIOIeWxiTku_286b37be", (String)"\u5355\u636e\u5df2\u7ecf\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f"));
        }
        addCost.setConfirmStatus(AddCostConfirmStatusEnum.INVALID.getValue());
        this.updateById((Object)addCost);
        if (StringUtils.isNotBlank((CharSequence)addCost.getRelationId())) {
            PurchaseAddCost purchaseAddCost = new PurchaseAddCost();
            purchaseAddCost.setId(addCost.getRelationId());
            purchaseAddCost.setConfirmStatus(AddCostConfirmStatusEnum.INVALID.getValue());
            this.purchaseAddCostService.updateById((Object)purchaseAddCost);
            String urlParam = "id=" + purchaseAddCost.getRelationId();
            super.sendMsg(saleAddCost.getElsAccount(), saleAddCost.getToElsAccount(), (Object)saleAddCost, urlParam, "addCost", "cancel");
        }
    }
}

