/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.confirm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsEsignDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmation;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.entity.SaleReconciliationConfirmation;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.rpc.ElsEsignRpcService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationService;
import com.els.modules.confirm.service.SaleReconciliationConfirmationBookBalanceService;
import com.els.modules.confirm.service.SaleReconciliationConfirmationUnpaidAccountService;
import com.els.modules.delivery.api.dto.PurchaseReconciliationConfirmationDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.finance.api.enumerate.ConfirmEsignStatusEnum;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.enumerate.ConfirmElectronicSignStatusEmun;
import com.els.modules.reconciliation.enumerate.ConfirmUnpaidAccountItemStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationConfirmStatusEnum;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationConfirmationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseReconciliationConfirmationServiceImpl
extends BaseServiceImpl<PurchaseReconciliationConfirmationMapper, PurchaseReconciliationConfirmation>
implements PurchaseReconciliationConfirmationService {
    @Resource
    private PurchaseReconciliationConfirmationMapper purchaseReconciliationConfirmationMapper;
    @Resource
    private PurchaseReconciliationConfirmationBookBalanceMapper purchaseReconciliationConfirmationBookBalanceMapper;
    @Resource
    private PurchaseReconciliationConfirmationDifferenceDescriptionMapper purchaseReconciliationConfirmationDifferenceDescriptionMapper;
    @Resource
    private PurchaseReconciliationConfirmationUnpaidAccountMapper purchaseReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleReconciliationConfirmationMapper saleReconciliationConfirmationMapper;
    @Resource
    private SaleReconciliationConfirmationBookBalanceMapper saleReconciliationConfirmationBookBalanceMapper;
    @Resource
    private SaleReconciliationConfirmationUnpaidAccountMapper saleReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private SaleReconciliationConfirmationDifferenceDescriptionMapper saleReconciliationConfirmationDifferenceDescriptionMapper;
    @Autowired
    private SaleReconciliationConfirmationBookBalanceService saleReconciliationConfirmationBookBalanceService;
    @Autowired
    private SaleReconciliationConfirmationUnpaidAccountService saleReconciliationConfirmationUnpaidAccountService;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private StaticConfig staticConfig;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseVoucherItemLocalRpcService purchaseVoucherItemRpcService;
    @Resource
    private ElsEsignRpcService elsEsignRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO) {
        List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList = purchaseReconciliationConfirmationVO.getBalance();
        String nextCode = this.invokeBaseRpcService.getNextCode("preparedByNumber", (Object)purchaseReconciliationConfirmation);
        purchaseReconciliationConfirmation.setCreateAccount(purchaseReconciliationConfirmation.getElsAccount());
        purchaseReconciliationConfirmation.setPreparedByNumber(nextCode);
        purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.NEW.getValue());
        if ("0".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
        this.purchaseReconciliationConfirmationMapper.insert((Object)purchaseReconciliationConfirmation);
        this.insertReconciliationConfirmationBookBalance(purchaseReconciliationConfirmation, purchaseReconciliationConfirmationBookBalanceList);
        this.insertReconciliationConfirmationDifferenceDescription(purchaseReconciliationConfirmation, purchaseReconciliationConfirmationVO.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(purchaseReconciliationConfirmation, purchaseReconciliationConfirmationVO.getUnpaidAccountItem());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO) {
        if ("0".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
        this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        List<PurchaseReconciliationConfirmationUnpaidAccount> unpaidAccountItem = purchaseReconciliationConfirmationVO.getUnpaidAccountItem();
        if (!CollectionUtils.isEmpty(unpaidAccountItem)) {
            for (PurchaseReconciliationConfirmationUnpaidAccount account : unpaidAccountItem) {
                String businessNumber = account.getBusinessNumbers();
                if (StringUtils.isEmpty((CharSequence)businessNumber)) continue;
                List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
                String preparedByNumber = purchaseReconciliationConfirmation.getPreparedByNumber();
                if (ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue().equals(account.getUnpaidAccountItem())) {
                    this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                    continue;
                }
                if (!ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue().equals(account.getUnpaidAccountItem())) continue;
                this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
            }
        }
        this.insertReconciliationConfirmationBookBalance(purchaseReconciliationConfirmation, purchaseReconciliationConfirmationVO.getBalance());
        this.insertReconciliationConfirmationDifferenceDescription(purchaseReconciliationConfirmation, purchaseReconciliationConfirmationVO.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(purchaseReconciliationConfirmation, unpaidAccountItem);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        List<PurchaseReconciliationConfirmationUnpaidAccount> accountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectByMainId(id);
        ((PurchaseReconciliationConfirmationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(id);
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount unpaidAccount : accountList) {
            String businessNumber = unpaidAccount.getBusinessNumbers();
            if (StringUtils.isEmpty((CharSequence)businessNumber) || !businessNumber.contains(",")) continue;
            List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
            this.releaseConfirmStatus(businessNumbers);
        }
    }

    private void releaseConfirmStatus(List<String> businessNumbers) {
        this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseReconciliationConfirmationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO) {
        Boolean flag = false;
        if (ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue().equals(purchaseReconciliationConfirmation.getPreparedByStatus()) && StringUtils.isNotBlank((CharSequence)purchaseReconciliationConfirmation.getRelationId())) {
            flag = true;
        }
        if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchaseReconciliationConfirmation.getTeamwork())) {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
        } else {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
        }
        this.updateMain(purchaseReconciliationConfirmation, purchaseReconciliationConfirmationVO);
        this.invokeBaseRpcService.addStatusLog(purchaseReconciliationConfirmation.getId(), purchaseReconciliationConfirmation.getPreparedByStatus(), "purchaseReconciliationConfirmation", "publish");
        String id = purchaseReconciliationConfirmation.getRelationId();
        SaleReconciliationConfirmation saleReconciliationConfirmation = new SaleReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmation), (Object)((Object)saleReconciliationConfirmation));
        saleReconciliationConfirmation.setToElsAccount(purchaseReconciliationConfirmation.getElsAccount());
        saleReconciliationConfirmation.setBusAccount(purchaseReconciliationConfirmation.getElsAccount());
        saleReconciliationConfirmation.setRelationId(purchaseReconciliationConfirmation.getId());
        saleReconciliationConfirmation.setElsAccount(purchaseReconciliationConfirmation.getToElsAccount());
        if (flag.booleanValue()) {
            saleReconciliationConfirmation.setId(id);
            saleReconciliationConfirmation.setPreparedByStatus(purchaseReconciliationConfirmation.getPreparedByStatus());
            this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
            this.handleDetail(saleReconciliationConfirmation, purchaseReconciliationConfirmationVO);
        } else {
            saleReconciliationConfirmation.setId(null);
            this.saleReconciliationConfirmationMapper.insert((Object)saleReconciliationConfirmation);
            this.handleDetail(saleReconciliationConfirmation, purchaseReconciliationConfirmationVO);
            purchaseReconciliationConfirmation.setRelationId(saleReconciliationConfirmation.getId());
            this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
        }
        this.sendMessage(purchaseReconciliationConfirmation, saleReconciliationConfirmation);
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    private void sendMessage(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, SaleReconciliationConfirmation saleReconciliationConfirmation) {
        String url = "id=" + saleReconciliationConfirmation.getId() + "&toElsAccount" + saleReconciliationConfirmation.getToElsAccount();
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(purchaseReconciliationConfirmation.getToElsAccount(), "1001");
        String token = JwtUtil.getOutToken((String)(elsSubAccount.getElsAccount() + "_" + elsSubAccount.getSubAccount()), (String)elsSubAccount.getPassword());
        saleReconciliationConfirmation.setFbk7(serviceAddress + "/els/reconciliation/saleReconciliationConfirmation/emailConfirmOrRefuesd?token=" + token + "&operation=confirm&id=" + saleReconciliationConfirmation.getId());
        saleReconciliationConfirmation.setFbk8(serviceAddress + "/els/reconciliation/saleReconciliationConfirmation/emailConfirmOrRefuesd?token=" + token + "&operation=refused&id=" + saleReconciliationConfirmation.getId());
        if (StringUtils.isNotBlank((CharSequence)purchaseReconciliationConfirmation.getSupplierName())) {
            super.sendMsg(purchaseReconciliationConfirmation.getElsAccount(), purchaseReconciliationConfirmation.getToElsAccount(), purchaseReconciliationConfirmation.getSupplierName(), (Object)saleReconciliationConfirmation, url, "purchaseReconciliationConfirmation", "publish");
        } else {
            super.sendMsg(purchaseReconciliationConfirmation.getElsAccount(), purchaseReconciliationConfirmation.getToElsAccount(), (Object)saleReconciliationConfirmation, url, "purchaseReconciliationConfirmation", "publish");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> confirmOrRefused(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
            opt = "refund";
        }
        this.updateById((Object)purchaseReconciliationConfirmation);
        this.invokeBaseRpcService.addStatusLog(purchaseReconciliationConfirmation.getRelationId(), purchaseReconciliationConfirmation.getPreparedByStatus(), "saleReconciliationConfirmation", opt);
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.saleReconciliationConfirmationMapper.selectById((Serializable)((Object)purchaseReconciliationConfirmation.getRelationId())));
        if (saleReconciliationConfirmation != null) {
            saleReconciliationConfirmation.setPreparedByStatus(purchaseReconciliationConfirmation.getPreparedByStatus());
            saleReconciliationConfirmation.setRemark(purchaseReconciliationConfirmation.getRemark());
            saleReconciliationConfirmation.setRelationId(purchaseReconciliationConfirmation.getId());
            this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
            String url = "id=" + saleReconciliationConfirmation.getId();
            if (StringUtils.isNotBlank((CharSequence)purchaseReconciliationConfirmation.getSupplierName())) {
                super.sendMsg(purchaseReconciliationConfirmation.getElsAccount(), purchaseReconciliationConfirmation.getToElsAccount(), purchaseReconciliationConfirmation.getSupplierName(), (Object)purchaseReconciliationConfirmation, url, "saleReconciliationConfirmation", opt);
            } else {
                super.sendMsg(purchaseReconciliationConfirmation.getElsAccount(), purchaseReconciliationConfirmation.getToElsAccount(), (Object)purchaseReconciliationConfirmation, url, "saleReconciliationConfirmation", opt);
            }
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
        }
        throw new RuntimeException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void opponentConfirm(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation) {
        String opt = "confirm";
        List<PurchaseReconciliationConfirmationDifferenceDescription> purchaseDescriptionList = this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.selectByMainId(purchaseReconciliationConfirmation.getId());
        List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList = this.purchaseReconciliationConfirmationBookBalanceMapper.selectByMainId(purchaseReconciliationConfirmation.getId());
        List<PurchaseReconciliationConfirmationUnpaidAccount> purchaseReconciliationConfirmationUnpaidAccountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectByMainId(purchaseReconciliationConfirmation.getId());
        if (CollectionUtils.isEmpty(purchaseDescriptionList)) {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
        } else {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue());
        }
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.saleReconciliationConfirmationMapper.selectById((Serializable)((Object)purchaseReconciliationConfirmation.getRelationId())));
        this.asyBalance(purchaseReconciliationConfirmationBookBalanceList);
        this.asyUnpaidAccount(purchaseReconciliationConfirmationUnpaidAccountList);
        this.handleSaleReconciliationConfirmationDifferenceDescription(saleReconciliationConfirmation, purchaseDescriptionList);
        this.updateById((Object)purchaseReconciliationConfirmation);
        if (saleReconciliationConfirmation != null) {
            saleReconciliationConfirmation.setPreparedByStatus(purchaseReconciliationConfirmation.getPreparedByStatus());
            saleReconciliationConfirmation.setRemark(purchaseReconciliationConfirmation.getRemark());
            saleReconciliationConfirmation.setRelationId(purchaseReconciliationConfirmation.getId());
            this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
        }
    }

    @Override
    public Result<?> batchSign(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        if (CollectionUtils.isEmpty(idList)) {
            throw new RuntimeException(I18nUtil.translate((String)"i18n_field_IdnRLxxMK_432d5df", (String)"\u5bf9\u5e94\u7684\u786e\u8ba4\u51fd\u4e0d\u5b58\u5728"));
        }
        List confirmationList = this.listByIds(idList);
        if (CollectionUtils.isEmpty((Collection)confirmationList)) {
            throw new RuntimeException(I18nUtil.translate((String)"i18n_field_IdnRLxxMK_432d5df", (String)"\u5bf9\u5e94\u7684\u786e\u8ba4\u51fd\u4e0d\u5b58\u5728"));
        }
        int succeed = 0;
        int fail = 0;
        ArrayList<ElsEsignDTO> elsEsignDTOList = new ArrayList<ElsEsignDTO>();
        for (PurchaseReconciliationConfirmation confirmation : confirmationList) {
            boolean signStatusFlag;
            boolean flag = ReconciliationConfirmStatusEnum.CONFIRMED.getValue().equals(confirmation.getPreparedByStatus()) && "1".equals(confirmation.getSign());
            boolean createAccountFlag = !StringUtils.isEmpty((CharSequence)confirmation.getElsAccount()) && confirmation.getElsAccount().equals(confirmation.getCreateAccount());
            boolean bl = signStatusFlag = StringUtils.isEmpty((CharSequence)confirmation.getSignStatus()) || ConfirmEsignStatusEnum.NO_START.getValue().equals(confirmation.getSignStatus()) || ConfirmEsignStatusEnum.BACK.getValue().equals(confirmation.getSignStatus());
            if (flag && createAccountFlag && signStatusFlag) {
                ElsEsignDTO dto = new ElsEsignDTO();
                dto.setBusNumber(confirmation.getPreparedByNumber());
                dto.setBusType("reconciliationConfirmation");
                dto.setRelationId(confirmation.getId());
                dto.setToElsAccount(confirmation.getToElsAccount());
                dto.setSupplierName(confirmation.getSupplierName());
                elsEsignDTOList.add(dto);
                ++succeed;
                continue;
            }
            ++fail;
        }
        this.elsEsignRpcService.saveMain(elsEsignDTOList);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLRWWWRirWWWWWWTWWWLRhAPWWWWWWWTWWKmWWWWWWT_fcb37836", (String)"\u64cd\u4f5c\u6210\u529f,  \u52fe\u9009\u4e86[${0}]\u6761,  \u6210\u529f\u53d1\u8d77\u7b7e\u7f72[${1}]\u6761, \u5931\u8d25[${2}]\u6761", (String[])new String[]{idList.size() + "", succeed + "", fail + ""}));
    }

    private void asyBalance(List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList) {
        HashMap<String, PurchaseReconciliationConfirmationBookBalance> balanceMap = new HashMap<String, PurchaseReconciliationConfirmationBookBalance>();
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationBookBalanceList)) {
            return;
        }
        Set balanceIds = purchaseReconciliationConfirmationBookBalanceList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(PurchaseReconciliationConfirmationBookBalance::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(balanceIds)) {
            return;
        }
        List saleReconciliationConfirmationBookBalanceList = this.saleReconciliationConfirmationBookBalanceMapper.selectBatchIds(balanceIds);
        if (CollectionUtils.isEmpty((Collection)saleReconciliationConfirmationBookBalanceList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationBookBalance purchaseReconciliationConfirmationBookBalance : purchaseReconciliationConfirmationBookBalanceList) {
            balanceMap.put(purchaseReconciliationConfirmationBookBalance.getRelationId(), purchaseReconciliationConfirmationBookBalance);
        }
        for (SaleReconciliationConfirmationBookBalance saleReconciliationConfirmationBookBalance : saleReconciliationConfirmationBookBalanceList) {
            PurchaseReconciliationConfirmationBookBalance purchaseBalance = (PurchaseReconciliationConfirmationBookBalance)((Object)balanceMap.get(saleReconciliationConfirmationBookBalance.getId()));
            if (purchaseBalance == null) continue;
            saleReconciliationConfirmationBookBalance.setDifferenceAmount(purchaseBalance.getDifferenceAmount());
            saleReconciliationConfirmationBookBalance.setOpponentConfirmAmount(purchaseBalance.getOpponentConfirmAmount());
        }
        this.saleReconciliationConfirmationBookBalanceService.updateBatchById(saleReconciliationConfirmationBookBalanceList);
    }

    private void asyUnpaidAccount(List<PurchaseReconciliationConfirmationUnpaidAccount> purchaseReconciliationConfirmationUnpaidAccountList) {
        HashMap<String, PurchaseReconciliationConfirmationUnpaidAccount> unpaidAccountMap = new HashMap<String, PurchaseReconciliationConfirmationUnpaidAccount>();
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        Set unpaidAccountIds = purchaseReconciliationConfirmationUnpaidAccountList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(PurchaseReconciliationConfirmationUnpaidAccount::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(unpaidAccountIds)) {
            return;
        }
        List saleReconciliationConfirmationUnpaidAccountList = this.saleReconciliationConfirmationUnpaidAccountMapper.selectBatchIds(unpaidAccountIds);
        if (CollectionUtils.isEmpty((Collection)saleReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount purchaseReconciliationConfirmationUnpaidAccount : purchaseReconciliationConfirmationUnpaidAccountList) {
            unpaidAccountMap.put(purchaseReconciliationConfirmationUnpaidAccount.getRelationId(), purchaseReconciliationConfirmationUnpaidAccount);
        }
        for (SaleReconciliationConfirmationUnpaidAccount saleReconciliationConfirmationUnpaidAccount : saleReconciliationConfirmationUnpaidAccountList) {
            PurchaseReconciliationConfirmationUnpaidAccount purchaseUnpaidAccount = (PurchaseReconciliationConfirmationUnpaidAccount)((Object)unpaidAccountMap.get(saleReconciliationConfirmationUnpaidAccount.getId()));
            if (purchaseUnpaidAccount == null) continue;
            saleReconciliationConfirmationUnpaidAccount.setDifferenceAmount(purchaseUnpaidAccount.getDifferenceAmount());
            saleReconciliationConfirmationUnpaidAccount.setOpponentConfirmAmount(purchaseUnpaidAccount.getOpponentConfirmAmount());
        }
        this.saleReconciliationConfirmationUnpaidAccountService.updateBatchById(saleReconciliationConfirmationUnpaidAccountList);
    }

    public void handleDetail(SaleReconciliationConfirmation saleReconciliationConfirmation, PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO) {
        List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList = purchaseReconciliationConfirmationVO.getBalance();
        List<PurchaseReconciliationConfirmationUnpaidAccount> purchaseReconciliationConfirmationUnpaidAccountList = purchaseReconciliationConfirmationVO.getUnpaidAccountItem();
        List<PurchaseReconciliationConfirmationDifferenceDescription> purchaseReconciliationConfirmationDifferenceDescriptionList = purchaseReconciliationConfirmationVO.getDifferenceDescription();
        List<PurchaseAttachmentDTO> attachments = purchaseReconciliationConfirmationVO.getAttachments();
        String id = saleReconciliationConfirmation.getId();
        this.saleReconciliationConfirmationBookBalanceMapper.deleteByMainId(id);
        this.saleReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(id);
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.handleSaleReconciliationConfirmationBookBalance(saleReconciliationConfirmation, purchaseReconciliationConfirmationBookBalanceList);
        this.handleSaleReconciliationConfirmationUnpaidAccount(saleReconciliationConfirmation, purchaseReconciliationConfirmationUnpaidAccountList);
        this.handleSaleReconciliationConfirmationDifferenceDescription(saleReconciliationConfirmation, purchaseReconciliationConfirmationDifferenceDescriptionList);
        this.handleSaleAttachmentDetail(saleReconciliationConfirmation, attachments);
    }

    private void handleSaleReconciliationConfirmationBookBalance(SaleReconciliationConfirmation saleReconciliationConfirmation, List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList) {
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationBookBalanceList)) {
            return;
        }
        ArrayList<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList = new ArrayList<SaleReconciliationConfirmationBookBalance>();
        for (PurchaseReconciliationConfirmationBookBalance purchaseReconciliationConfirmationBookBalance : purchaseReconciliationConfirmationBookBalanceList) {
            SaleReconciliationConfirmationBookBalance saleReconciliationConfirmationBookBalance = new SaleReconciliationConfirmationBookBalance();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmationBookBalance), (Object)((Object)saleReconciliationConfirmationBookBalance));
            saleReconciliationConfirmationBookBalance.setId(null);
            saleReconciliationConfirmationBookBalance.setElsAccount(saleReconciliationConfirmationBookBalance.getElsAccount());
            saleReconciliationConfirmationBookBalance.setToElsAccount(saleReconciliationConfirmation.getToElsAccount());
            saleReconciliationConfirmationBookBalance.setBusAccount(saleReconciliationConfirmation.getBusAccount());
            saleReconciliationConfirmationBookBalance.setHeadId(saleReconciliationConfirmation.getId());
            saleReconciliationConfirmationBookBalance.setRelationId(purchaseReconciliationConfirmationBookBalance.getId());
            saleReconciliationConfirmationBookBalanceList.add(saleReconciliationConfirmationBookBalance);
        }
        this.saleReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(saleReconciliationConfirmationBookBalanceList);
    }

    private void handleSaleReconciliationConfirmationUnpaidAccount(SaleReconciliationConfirmation saleReconciliationConfirmation, List<PurchaseReconciliationConfirmationUnpaidAccount> purchaseReconciliationConfirmationUnpaidAccountList) {
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        ArrayList<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList = new ArrayList<SaleReconciliationConfirmationUnpaidAccount>();
        for (PurchaseReconciliationConfirmationUnpaidAccount purchaseReconciliationConfirmationUnpaidAccount : purchaseReconciliationConfirmationUnpaidAccountList) {
            SaleReconciliationConfirmationUnpaidAccount saleReconciliationConfirmationUnpaidAccount = new SaleReconciliationConfirmationUnpaidAccount();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmationUnpaidAccount), (Object)((Object)saleReconciliationConfirmationUnpaidAccount));
            saleReconciliationConfirmationUnpaidAccount.setId(null);
            saleReconciliationConfirmationUnpaidAccount.setElsAccount(saleReconciliationConfirmation.getElsAccount());
            saleReconciliationConfirmationUnpaidAccount.setToElsAccount(saleReconciliationConfirmation.getToElsAccount());
            saleReconciliationConfirmationUnpaidAccount.setBusAccount(saleReconciliationConfirmation.getBusAccount());
            saleReconciliationConfirmationUnpaidAccount.setHeadId(saleReconciliationConfirmation.getId());
            saleReconciliationConfirmationUnpaidAccount.setRelationId(purchaseReconciliationConfirmationUnpaidAccount.getId());
            saleReconciliationConfirmationUnpaidAccountList.add(saleReconciliationConfirmationUnpaidAccount);
        }
        this.saleReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(saleReconciliationConfirmationUnpaidAccountList);
    }

    private void handleSaleReconciliationConfirmationDifferenceDescription(SaleReconciliationConfirmation saleReconciliationConfirmation, List<PurchaseReconciliationConfirmationDifferenceDescription> purchaseReconciliationConfirmationDifferenceDescriptionList) {
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationDifferenceDescriptionList)) {
            return;
        }
        ArrayList<SaleReconciliationConfirmationDifferenceDescription> saleReconciliationConfirmationDifferenceDescriptionList = new ArrayList<SaleReconciliationConfirmationDifferenceDescription>();
        for (PurchaseReconciliationConfirmationDifferenceDescription purchaseReconciliationConfirmationDifferenceDescription : purchaseReconciliationConfirmationDifferenceDescriptionList) {
            SaleReconciliationConfirmationDifferenceDescription saleReconciliationConfirmationDifferenceDescription = new SaleReconciliationConfirmationDifferenceDescription();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmationDifferenceDescription), (Object)((Object)saleReconciliationConfirmationDifferenceDescription));
            saleReconciliationConfirmationDifferenceDescription.setId(null);
            saleReconciliationConfirmationDifferenceDescription.setElsAccount(saleReconciliationConfirmation.getElsAccount());
            saleReconciliationConfirmationDifferenceDescription.setToElsAccount(saleReconciliationConfirmation.getToElsAccount());
            saleReconciliationConfirmationDifferenceDescription.setBusAccount(saleReconciliationConfirmation.getBusAccount());
            saleReconciliationConfirmationDifferenceDescription.setHeadId(saleReconciliationConfirmation.getId());
            saleReconciliationConfirmationDifferenceDescription.setRelationId(purchaseReconciliationConfirmationDifferenceDescription.getId());
            saleReconciliationConfirmationDifferenceDescriptionList.add(saleReconciliationConfirmationDifferenceDescription);
        }
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(saleReconciliationConfirmationDifferenceDescriptionList);
    }

    private void handleSaleAttachmentDetail(SaleReconciliationConfirmation saleReconciliation, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleReconciliation.getElsAccount());
            saleAttachment.setHeadId(saleReconciliation.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void insertReconciliationConfirmationBookBalance(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList) {
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationBookBalanceList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationBookBalance entity : purchaseReconciliationConfirmationBookBalanceList) {
            BigDecimal opponentConfirmAmount;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseReconciliationConfirmation);
            entity.setHeadId(purchaseReconciliationConfirmation.getId());
            BigDecimal bookBalance = entity.getBookBalance() == null ? BigDecimal.ZERO : entity.getBookBalance();
            BigDecimal bigDecimal = opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            if (StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmation.getElsAccount()) || purchaseReconciliationConfirmation.getElsAccount().equals(purchaseReconciliationConfirmation.getCreateAccount())) continue;
            BigDecimal result = bookBalance.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!purchaseReconciliationConfirmationBookBalanceList.isEmpty()) {
            this.purchaseReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(purchaseReconciliationConfirmationBookBalanceList);
        }
    }

    private void insertReconciliationConfirmationDifferenceDescription(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, List<PurchaseReconciliationConfirmationDifferenceDescription> purchaseReconciliationConfirmationDifferenceDescriptionList) {
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationDifferenceDescriptionList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationDifferenceDescription entity : purchaseReconciliationConfirmationDifferenceDescriptionList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseReconciliationConfirmation);
            entity.setHeadId(purchaseReconciliationConfirmation.getId());
        }
        if (!purchaseReconciliationConfirmationDifferenceDescriptionList.isEmpty()) {
            this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(purchaseReconciliationConfirmationDifferenceDescriptionList);
        }
    }

    private void insertReconciliationConfirmationUnpaidAccount(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, List<PurchaseReconciliationConfirmationUnpaidAccount> purchaseReconciliationConfirmationUnpaidAccountList) {
        if (CollectionUtils.isEmpty(purchaseReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount entity : purchaseReconciliationConfirmationUnpaidAccountList) {
            BigDecimal opponentConfirmAmount;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseReconciliationConfirmation);
            entity.setHeadId(purchaseReconciliationConfirmation.getId());
            BigDecimal preparationConfirmAmount = entity.getPreparationConfirmAmount() == null ? BigDecimal.ZERO : entity.getPreparationConfirmAmount();
            BigDecimal bigDecimal = opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            if (StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmation.getElsAccount()) || purchaseReconciliationConfirmation.getElsAccount().equals(purchaseReconciliationConfirmation.getCreateAccount())) continue;
            BigDecimal result = preparationConfirmAmount.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!purchaseReconciliationConfirmationUnpaidAccountList.isEmpty()) {
            this.purchaseReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(purchaseReconciliationConfirmationUnpaidAccountList);
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseReconciliationConfirmation", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseReconciliationConfirmationList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseReconciliationConfirmation purchaseReconciliationConfirmation : purchaseReconciliationConfirmationList) {
            this.pushDataToErp(purchaseReconciliationConfirmation);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        List<PurchaseReconciliationConfirmationUnpaidAccount> accountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectByMainId(id);
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = (PurchaseReconciliationConfirmation)((Object)this.purchaseReconciliationConfirmationMapper.selectById((Serializable)((Object)id)));
        purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.RENTURNED.getValue());
        this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.saleReconciliationConfirmationMapper.selectById((Serializable)((Object)purchaseReconciliationConfirmation.getRelationId())));
        saleReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.RENTURNED.getValue());
        this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount unpaidAccount : accountList) {
            String businessNumber = unpaidAccount.getBusinessNumbers();
            if (StringUtils.isEmpty((CharSequence)businessNumber) || !businessNumber.contains(",")) continue;
            List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
            this.releaseConfirmStatus(businessNumbers);
        }
    }

    private void pushDataToErp(PurchaseReconciliationConfirmation confirmation) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseReconciliationConfirmation", (Object)confirmation);
    }

    @Override
    public List<PurchaseReconciliationConfirmationUnpaidAccount> extractUnPaidAccountItem(PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO) {
        ArrayList<PurchaseReconciliationConfirmationUnpaidAccount> result = new ArrayList<PurchaseReconciliationConfirmationUnpaidAccount>();
        if (StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmationVO.getLocalCurrency())) {
            purchaseReconciliationConfirmationVO.setLocalCurrency("CNY");
        }
        if (StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmationVO.getToLocalCurrency())) {
            purchaseReconciliationConfirmationVO.setToLocalCurrency("CNY");
        }
        this.extractReconciliationPreparationConfirmAmount(purchaseReconciliationConfirmationVO, result);
        this.extractUnReconciliationConfirmationAmount(purchaseReconciliationConfirmationVO, result);
        return result;
    }

    private void extractUnReconciliationConfirmationAmount(PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        ArrayList<String> businessNumbers = new ArrayList<String>();
        PurchaseReconciliationConfirmationDTO dto = new PurchaseReconciliationConfirmationDTO();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmationVO), (Object)dto);
        List<PurchaseVoucherItemDTO> voucherItemList = this.purchaseVoucherItemRpcService.selectConfirmVoucher(dto);
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(voucherItemList)) {
            PurchaseReconciliationConfirmationUnpaidAccount unReconciliationConfirmationUnpaidAccounts = new PurchaseReconciliationConfirmationUnpaidAccount();
            unReconciliationConfirmationUnpaidAccounts.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue());
            unReconciliationConfirmationUnpaidAccounts.setPreparationConfirmAmount(BigDecimal.ZERO);
            result.add(unReconciliationConfirmationUnpaidAccounts);
            return;
        }
        for (PurchaseVoucherItemDTO purchaseVoucherItemDTO : voucherItemList) {
            boolean batchCreateFlag;
            boolean flag;
            BigDecimal dtoTaxAmount = purchaseVoucherItemDTO.getTaxAmount() == null ? BigDecimal.ZERO : purchaseVoucherItemDTO.getTaxAmount();
            if (BigDecimal.ZERO.compareTo(dtoTaxAmount) == 0 || (flag = "1".equals(purchaseVoucherItemDTO.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmationVO.getPreparedByNumber()) && !purchaseReconciliationConfirmationVO.getPreparedByNumber().equals(purchaseVoucherItemDTO.getConfirmNumber())) || (batchCreateFlag = StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmationVO.getPreparedByNumber()) && "1".equals(purchaseVoucherItemDTO.getConfirmStatus()))) continue;
            if ("-".equals(purchaseVoucherItemDTO.getLoanDirection())) {
                taxAmount = taxAmount.subtract(dtoTaxAmount);
            } else if ("+".equals(purchaseVoucherItemDTO.getLoanDirection())) {
                taxAmount = taxAmount.add(dtoTaxAmount);
            }
            businessNumbers.add(purchaseVoucherItemDTO.getVoucherNumber());
        }
        PurchaseReconciliationConfirmationUnpaidAccount unReconciliationConfirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        unReconciliationConfirmationUnpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue());
        unReconciliationConfirmationUnpaidAccount.setPreparationConfirmAmount(taxAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        unReconciliationConfirmationUnpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(unReconciliationConfirmationUnpaidAccount);
    }

    private void extractReconciliationPreparationConfirmAmount(PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        List<PurchasePerformanceReconciliation> purchasePerformanceReconciliationList;
        BigDecimal reconciliationPreparationConfirmAmount = BigDecimal.ZERO;
        ArrayList<String> businessNumbers = new ArrayList<String>();
        List<PurchaseReconciliation> purchaseReconciliationList = this.purchaseReconciliationMapper.listReconciliationByConfirm(purchaseReconciliationConfirmationVO);
        if (!CollectionUtils.isEmpty(purchaseReconciliationList)) {
            for (Object purchaseReconciliation : purchaseReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchaseReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchaseReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmationVO.getPreparedByNumber()) && !purchaseReconciliationConfirmationVO.getPreparedByNumber().equals(purchaseReconciliation.getConfirmNumber());
                if (flag) continue;
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
                businessNumbers.add(purchaseReconciliation.getReconciliationNumber());
            }
        }
        if (!CollectionUtils.isEmpty(purchasePerformanceReconciliationList = this.purchasePerformanceReconciliationMapper.listReconciliationByConfirm(purchaseReconciliationConfirmationVO))) {
            for (PurchasePerformanceReconciliation purchasePerformanceReconciliation : purchasePerformanceReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchasePerformanceReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchasePerformanceReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchasePerformanceReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)purchaseReconciliationConfirmationVO.getPreparedByNumber()) && !purchaseReconciliationConfirmationVO.getPreparedByNumber().equals(purchasePerformanceReconciliation.getConfirmNumber());
                if (flag) continue;
                businessNumbers.add(purchasePerformanceReconciliation.getReconciliationNumber());
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
            }
        }
        PurchaseReconciliationConfirmationUnpaidAccount reconciliationConfirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        reconciliationConfirmationUnpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue());
        reconciliationConfirmationUnpaidAccount.setPreparationConfirmAmount(reconciliationPreparationConfirmAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        reconciliationConfirmationUnpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(reconciliationConfirmationUnpaidAccount);
    }

    @Override
    public void createDifference(PurchaseReconciliationConfirmationVO purchaseReconciliationConfirmationVO) {
        List<PurchaseReconciliationConfirmationBookBalance> balanceList = purchaseReconciliationConfirmationVO.getBalance();
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(purchaseReconciliationConfirmationVO.getId());
        ArrayList<PurchaseReconciliationConfirmationDifferenceDescription> descriptionList = new ArrayList<PurchaseReconciliationConfirmationDifferenceDescription>();
        for (PurchaseReconciliationConfirmationBookBalance balance : balanceList) {
            PurchaseReconciliationConfirmationDifferenceDescription description = new PurchaseReconciliationConfirmationDifferenceDescription();
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) > 0) {
                description.setAccountAdjustmentDirection("0");
            } else if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) < 0) {
                description.setAccountAdjustmentDirection("1");
            }
            description.setDifferenceDate(new Date());
            description.setDifferencePayment(balance.getCurrentBalance());
            description.setDifferenceAmount(balance.getDifferenceAmount());
            descriptionList.add(description);
        }
        PurchaseReconciliationConfirmation confirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmationVO), (Object)((Object)confirmation));
        this.insertReconciliationConfirmationDifferenceDescription(confirmation, descriptionList);
    }
}

