/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.entity.SalePaymentApplyOther;
import com.els.modules.finance.entity.SalePaymentApplyWriteOff;
import com.els.modules.finance.service.SalePaymentApplyHeadService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.finance.service.SalePaymentApplyOtherService;
import com.els.modules.finance.service.SalePaymentApplyWriteOffService;
import com.els.modules.finance.vo.SalePaymentApplyHeadVO;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCase;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.SalePaymentCharge;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.SalePaymentChargeService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/finance/salePaymentApplyHead"})
@Api(tags={"\u9500\u552e\u7533\u8bf7\u4ed8\u6b3e\u5934"})
public class SalePaymentApplyHeadController
extends BaseController<SalePaymentApplyHead, SalePaymentApplyHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SalePaymentApplyHeadController.class);
    @Autowired
    private SalePaymentApplyHeadService salePaymentApplyHeadService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private SalePaymentApplyOtherService salePaymentApplyOtherService;
    @Autowired
    private SalePaymentChargeService salePaymentChargeService;
    @Autowired
    private SalePaymentApplyWriteOffService salePaymentApplyWriteOffService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"paymentApply#salePaymentApplyHead:list"})
    public Result<?> queryPageList(SalePaymentApplyHead salePaymentApplyHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)salePaymentApplyHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.salePaymentApplyHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u9500\u552e\u7533\u8bf7\u4ed8\u6b3e\u5934-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"paymentApply#salePaymentApplyHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SalePaymentApplyHead salePaymentApplyHead = (SalePaymentApplyHead)((Object)this.salePaymentApplyHeadService.getById((Serializable)((Object)id)));
        SalePaymentApplyHeadVO salePaymentApplyHeadVO = new SalePaymentApplyHeadVO();
        BeanUtils.copyProperties((Object)((Object)salePaymentApplyHead), (Object)((Object)salePaymentApplyHeadVO));
        List<SalePaymentApplyItem> salePaymentApplyItemList = this.salePaymentApplyItemService.selectByMainId(id);
        this.handlePaymentInfo(salePaymentApplyItemList);
        salePaymentApplyHeadVO.setSalePaymentApplyItemList(salePaymentApplyItemList);
        List<SalePaymentApplyOther> salePaymentApplyOthers = this.salePaymentApplyOtherService.selectByMainId(id);
        salePaymentApplyHeadVO.setSalePaymentApplyOtherList(salePaymentApplyOthers);
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        salePaymentApplyHeadVO.setSaleAttachmentList(saleAttachmentList);
        List<SalePaymentCharge> saleRecChargeList = this.salePaymentChargeService.selectByMainId(id);
        salePaymentApplyHeadVO.setSalePaymentChargeList(saleRecChargeList);
        List<SalePaymentApplyWriteOff> salePaymentApplyWriteOffList = this.salePaymentApplyWriteOffService.selectByMainId(id);
        this.handleWriteOffInfo(salePaymentApplyHeadVO, salePaymentApplyWriteOffList);
        return Result.ok((Object)((Object)salePaymentApplyHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u7533\u8bf7\u4ed8\u6b3e\u5934id\u67e5\u8be2\u9500\u552e\u7533\u8bf7\u4ed8\u6b3e\u884c", notes="\u901a\u8fc7\u9500\u552e\u7533\u8bf7\u4ed8\u6b3e\u5934id\u67e5\u8be2\u9500\u552e\u7533\u8bf7\u4ed8\u6b3e\u884c")
    @GetMapping(value={"/querySalePaymentApplyItemByMainId"})
    @RequiresPermissions(value={"paymentApply#salePaymentApplyHead:view"})
    public Result<?> querySalePaymentApplyItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SalePaymentApplyItem> salePaymentApplyItemList = this.salePaymentApplyItemService.selectByMainId(id);
        return Result.ok(salePaymentApplyItemList);
    }

    private void handlePaymentInfo(List<SalePaymentApplyItem> salePaymentApplyItemList) {
        if (!CollectionUtil.isEmpty(salePaymentApplyItemList)) {
            Map<String, ElsPurchaseStatisticsSourceCase> map = this.salePaymentApplyHeadService.getStatisticsSourceMap(salePaymentApplyItemList);
            for (SalePaymentApplyItem item : salePaymentApplyItemList) {
                ElsPurchaseStatisticsSourceCase sourceCase;
                if (StringUtils.isEmpty((CharSequence)item.getSourceId()) || (sourceCase = map.get(item.getSourceId())) == null) continue;
                if (sourceCase.getSourcePaymentAmount() != null) {
                    item.setItemPaymentAmount(sourceCase.getSourcePaymentAmount());
                }
                if (sourceCase.getSourcePaidAmount() == null) continue;
                item.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            }
        }
    }

    private void handleWriteOffInfo(SalePaymentApplyHeadVO salePaymentApplyHeadVO, List<SalePaymentApplyWriteOff> salePaymentApplyWriteOffList) {
        Set<String> businessIds = salePaymentApplyWriteOffList.stream().filter(writeOff -> !StringUtils.isEmpty((CharSequence)writeOff.getBusinessId())).map(SalePaymentApplyWriteOff::getBusinessId).collect(Collectors.toSet());
        Map<String, String> purchaseSaleIdsMap = this.salePaymentApplyItemService.exchangePurchaseSaleIdsFromSale(salePaymentApplyWriteOffList);
        HashSet<String> purchaseBussiness = new HashSet<String>(purchaseSaleIdsMap.values());
        businessIds.addAll(purchaseBussiness);
        Map<String, ElsPurchaseStatisticsWriteOff> writeOffMap = this.elsPurchaseStatisticsWriteOffService.getStatisticsSourceMap(businessIds);
        for (SalePaymentApplyWriteOff writeOff2 : salePaymentApplyWriteOffList) {
            ElsPurchaseStatisticsWriteOff statisticsWriteOff;
            String businessId = writeOff2.getBusinessId();
            if (StringUtils.isEmpty((CharSequence)businessId) || !StringUtils.isEmpty((CharSequence)writeOff2.getReconciliationNumber()) && (writeOff2.getReconciliationNumber().contains("SR") || writeOff2.getReconciliationNumber().contains("SPR")) && StringUtils.isEmpty((CharSequence)(businessId = purchaseSaleIdsMap.get(businessId))) || (statisticsWriteOff = writeOffMap.get(businessId)) == null) continue;
            writeOff2.setUnWrittenOffAmount(statisticsWriteOff.getSourceUnWrittenOffAmount());
            writeOff2.setWrittenOffAmount(statisticsWriteOff.getSourceWrittenOffAmount());
        }
        salePaymentApplyHeadVO.setSalePaymentApplyWriteOffList(salePaymentApplyWriteOffList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"paymentApply#salePaymentApplyHead:list"})
    public Result<?> queryTabsCount(SalePaymentApplyHead applyHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)applyHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"payment_apply_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"payment_apply_status");
        List list = ((SalePaymentApplyHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SalePaymentApplyHead::getPaymentApplyStatus, SalePaymentApplyHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "paymentApplyStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmPaymentApplyStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "paymentApplyStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

