/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractAcceptanceDTO;
import com.els.modules.contract.dto.PurchaseContractPromiseDTO;
import com.els.modules.contract.dto.SaleContractAcceptanceDTO;
import com.els.modules.contract.dto.SaleContractPromiseDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.api.enumerate.ReconciliationHookStatusEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchaseDeliveryWaterService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleRecContractAcceptance;
import com.els.modules.reconciliation.entity.SaleRecContractPromise;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationBillStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractAcceptanceMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractPromiseMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SalePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.SalePrePaymentWriteOffReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.SaleRecChargeMapper;
import com.els.modules.reconciliation.mapper.SaleRecContractAcceptanceMapper;
import com.els.modules.reconciliation.mapper.SaleRecContractPromiseMapper;
import com.els.modules.reconciliation.rpc.ElsTaxLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseContractPromiseLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractPromiseLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseRecContractAcceptanceService;
import com.els.modules.reconciliation.service.PurchaseRecContractPromiseService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceHookVO;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import com.els.modules.reconciliation.vo.ReconciliationRedisLockVO;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePerformanceReconciliationServiceImpl
extends BaseServiceImpl<PurchasePerformanceReconciliationMapper, PurchasePerformanceReconciliation>
implements PurchasePerformanceReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReconciliationServiceImpl.class);
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Resource
    private PurchaseContractPromiseLocalRpcService purchaseContractPromiseLocalRpcService;
    @Resource
    private SaleContractPromiseLocalRpcService saleContractPromiseLocalRpcService;
    @Resource
    private PurchaseContractAcceptanceLocalRpcService purchaseContractAcceptanceLocalRpcService;
    @Resource
    private SaleContractAcceptanceLocalRpcService saleContractAcceptanceLocalRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;
    @Autowired
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private PurchaseRecContractAcceptanceService purchaseRecContractAcceptanceService;
    @Autowired
    private PurchaseRecContractPromiseService purchaseRecContractPromiseService;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Resource
    private SalePerformanceReconciliationMapper salePerformanceReconciliationMapper;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private SaleRecChargeMapper saleRecChargeMapper;
    @Resource
    private SaleRecAdditionalChargesMapper saleRecAdditionalChargesMapper;
    @Resource
    private SalePrePaymentWriteOffReconciliationMapper salePrePaymentWriteOffReconciliationMapper;
    @Resource
    private SaleRecContractAcceptanceMapper saleRecContractAcceptanceMapper;
    @Resource
    private SaleRecContractPromiseMapper saleRecContractPromiseMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;
    @Resource
    private PurchaseRecContractPromiseMapper purchaseRecContractPromiseMapper;
    @Resource
    private PurchaseRecContractAcceptanceMapper purchaseRecContractAcceptanceMapper;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Resource
    private ElsTaxLocalRpcService elsTaxService;
    private static final String LOCK_KEY_PRIFFIX = "srm_performance_reconciliation_";
    private static final Long LOCK_EXPIRE_TIME = 120000L;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void delete(String id) {
        ((PurchasePerformanceReconciliationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchasePerformanceReconciliationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        ReconciliationRedisLockVO reconciliationRedisLockVO = this.redisLock(purchasePerformanceReconciliation.getToElsAccount());
        try {
            this.buildPurchasePerformanceReconciliation(purchasePerformanceReconciliation);
            this.purchasePerformanceReconciliationMapper.insert((Object)purchasePerformanceReconciliation);
            this.invokeBaseRpcService.addStatusLog(purchasePerformanceReconciliation.getId(), ReconciliationStatusEmun.NEW.getValue(), "reconciliation", "inster");
            this.generateReconciliation(purchasePerformanceReconciliation, reconciliationVO);
        }
        catch (ELSBootException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.redisUtil.releaseDistributedLock(reconciliationRedisLockVO.getLockKey(), reconciliationRedisLockVO.getRequestId());
        }
    }

    private void generateReconciliation(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO purchaseReconciliationVO) {
        boolean flag = false;
        List<PurchaseRecContractPromise> contractPromiseList = purchaseReconciliationVO.getPurchaseRecContractPromiseList();
        List<PurchaseRecContractAcceptance> contractAcceptanceList = purchaseReconciliationVO.getPurchaseRecContractAcceptanceList();
        List<PurchaseRecCharge> chargeList = purchaseReconciliationVO.getPurchaseRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> writeOffList = purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        HashSet currencySet = new HashSet();
        Set promiseCurrencySet = contractPromiseList.stream().filter(items -> !StringUtils.isEmpty((CharSequence)items.getCurrency())).map(PurchaseRecContractPromise::getCurrency).collect(Collectors.toSet());
        Set acceptanceCurrencySet = contractAcceptanceList.stream().map(PurchaseRecContractAcceptance::getCurrency).collect(Collectors.toSet());
        currencySet.addAll(promiseCurrencySet);
        currencySet.addAll(acceptanceCurrencySet);
        if (CollectionUtils.isEmpty(currencySet)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmneIZtSneOltlqLV_76c274e8", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u5408\u540c\u5c65\u7ea6\u5355\u6216\u5408\u540c\u9a8c\u6536\u5355 \u5e01\u522b\u4e3a\u7a7a"));
        }
        for (String currency : currencySet) {
            Set taxCodes;
            boolean taxCodeFlag = true;
            String taxCode = "";
            ArrayList<PurchaseRecContractPromise> promises = new ArrayList();
            if (!CollectionUtils.isEmpty(contractPromiseList)) {
                promises = contractPromiseList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
                Set taxCodes2 = contractPromiseList.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getTaxCode())).map(PurchaseRecContractPromise::getTaxCode).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(taxCodes2) && taxCodes2.size() == 1) {
                    Optional taxCodeOption = taxCodes2.stream().findFirst();
                    taxCode = (String)taxCodeOption.get();
                } else {
                    taxCodeFlag = false;
                }
            }
            ArrayList<PurchaseRecContractAcceptance> acceptances = new ArrayList();
            if (!CollectionUtils.isEmpty(contractAcceptanceList)) {
                acceptances = contractAcceptanceList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
                Set taxCodes3 = contractAcceptanceList.stream().map(PurchaseRecContractAcceptance::getTaxCode).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(taxCodes3) || taxCodes3.size() != 1 || !taxCodes3.contains(taxCode)) {
                    taxCodeFlag = false;
                }
            }
            if (CollectionUtils.isEmpty(promises) && CollectionUtils.isEmpty(acceptances)) continue;
            List<Object> charges = new ArrayList();
            if (!(CollectionUtils.isEmpty(chargeList) || !CollectionUtils.isEmpty(taxCodes = (charges = chargeList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList())).stream().map(PurchaseRecCharge::getTaxCode).collect(Collectors.toSet())) && taxCodes.size() == 1 && taxCodes.contains(taxCode))) {
                taxCodeFlag = false;
            }
            ArrayList<PurchasePrePaymentWriteOffReconciliation> writeOffs = new ArrayList();
            if (!CollectionUtils.isEmpty(writeOffList)) {
                writeOffs = writeOffList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
            }
            if (taxCodeFlag) {
                reconciliation.setTaxCode(taxCode);
                this.setTaxRate(reconciliation, taxCode);
            }
            reconciliation.setCurrency(currency);
            if (flag) {
                PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
                BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)purchaseReconciliation));
                purchaseReconciliation.setId(null);
                String reconciliationNumber = this.invokeBaseRpcService.getNextCode("performanceReconciliation", (Object)purchaseReconciliation);
                purchaseReconciliation.setReconciliationNumber(reconciliationNumber);
                PurchasePerformanceReconciliationVO reconciliationVO = new PurchasePerformanceReconciliationVO(promises, acceptances, charges, writeOffs);
                this.calculateMoney(purchaseReconciliation, reconciliationVO);
                this.checkSettlementAmount(purchaseReconciliation);
                this.purchasePerformanceReconciliationMapper.insert((Object)purchaseReconciliation);
                this.insertData(purchaseReconciliation, reconciliationVO);
                this.purchasePerformanceReconciliationMapper.updateById((Object)purchaseReconciliation);
                continue;
            }
            PurchasePerformanceReconciliationVO reconciliationVO = new PurchasePerformanceReconciliationVO(promises, acceptances, charges, writeOffs);
            this.calculateMoney(reconciliation, reconciliationVO);
            this.checkSettlementAmount(reconciliation);
            this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
            this.insertData(reconciliation, reconciliationVO);
            flag = true;
        }
    }

    private void setTaxRate(PurchasePerformanceReconciliation reconciliation, String taxCode) {
        if (reconciliation.getTaxRate() != null) {
            return;
        }
        List<ElsTaxDTO> taxs = this.elsTaxService.findList(reconciliation.getElsAccount(), taxCode);
        if (CollectionUtils.isEmpty(taxs)) {
            return;
        }
        Optional taxOptional = taxs.stream().findFirst();
        if (taxOptional.isPresent()) {
            ElsTaxDTO elsTaxDTO = (ElsTaxDTO)taxOptional.get();
            reconciliation.setTaxRate(elsTaxDTO.getTaxRate());
        }
    }

    private void checkSettlementAmount(PurchasePerformanceReconciliation purchasePerformanceReconciliation) {
        if ("1".equals(purchasePerformanceReconciliation.getSaveForZero())) {
            if (purchasePerformanceReconciliation.getSettlementAmount().compareTo(new BigDecimal(0)) < 0) {
                log.error("checkSettlementAmount, error  " + JSON.toJSONString((Object)((Object)purchasePerformanceReconciliation)));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeRHjydHfLWWWWWWWWXUWWShbLjXIet_a0732d09", (String)"\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a[${0}]\uff0c\u5c0f\u4e8e0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355", (String[])new String[]{purchasePerformanceReconciliation.getSettlementAmount().toString()}));
            }
        } else if (purchasePerformanceReconciliation.getSettlementAmount().compareTo(new BigDecimal(0)) < 1) {
            log.error("checkSettlementAmount, error  " + JSON.toJSONString((Object)((Object)purchasePerformanceReconciliation)));
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeRHjydHfLWWWWWWWWXUEUWOShbLjXIet_f75bb433", (String)"\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a[${0}]\uff0c\u5c0f\u4e8e\u7b49\u4e8e0\u90fd\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355", (String[])new String[]{purchasePerformanceReconciliation.getSettlementAmount().toString()}));
        }
    }

    private void buildPurchasePerformanceReconciliation(PurchasePerformanceReconciliation purchasePerformanceReconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("performanceReconciliation", (Object)purchasePerformanceReconciliation);
        purchasePerformanceReconciliation.setReconciliationNumber(reconciliationNumber);
        purchasePerformanceReconciliation.setInvoiced("0");
        purchasePerformanceReconciliation.setSendStatus("0");
        purchasePerformanceReconciliation.setReconciliationStatus(ReconciliationStatusEmun.NEW.getValue());
        purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.NEW.getValue());
        purchasePerformanceReconciliation.setCancellation("0");
        purchasePerformanceReconciliation.setCreateAccount(TenantContext.getTenant());
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchasePerformanceReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        this.handlePaymentExpireDate(purchasePerformanceReconciliation);
    }

    private void handlePaymentExpireDate(PurchasePerformanceReconciliation purchasePerformanceReconciliation) {
        if (StringUtils.isEmpty((CharSequence)purchasePerformanceReconciliation.getPayCycle()) || purchasePerformanceReconciliation.getPaymentBenchmarkDate() == null) {
            return;
        }
        Integer payCycle = Integer.valueOf(purchasePerformanceReconciliation.getPayCycle());
        if (payCycle > 0) {
            DateTime paymentExpireDate = DateUtil.offsetDay((Date)purchasePerformanceReconciliation.getPaymentBenchmarkDate(), (int)payCycle);
            purchasePerformanceReconciliation.setPaymentExpiredate((Date)paymentExpireDate);
        }
    }

    private void insertData(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        this.deleteDetail(purchasePerformanceReconciliation.getId());
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = reconciliationVO.getPurchaseRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = reconciliationVO.getPurchaseRecContractAcceptanceList();
        List<PurchaseRecCharge> purchaseRecChargeList = reconciliationVO.getPurchaseRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = reconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        this.insertContractPromise(purchasePerformanceReconciliation, purchaseRecContractPromiseList);
        this.insertContractAcceptance(purchasePerformanceReconciliation, purchaseRecContractAcceptanceList);
        this.insertDeductCost(purchasePerformanceReconciliation, purchaseRecChargeList);
        this.insertPrePaymentWriteOff(purchasePerformanceReconciliation, prePaymentWriteOffList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteDetail(String id) {
        this.purchaseRecContractPromiseService.deleteByMainId(id);
        this.purchaseRecContractAcceptanceService.deleteByMainId(id);
        this.purchaseRecChargeService.deleteByMainId(id);
        this.purchasePrePaymentWriteOffReconciliationService.deleteByMainId(id);
        this.purchaseInvoiceMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        ReconciliationRedisLockVO reconciliationRedisLockVO = this.redisLock(purchasePerformanceReconciliation.getToElsAccount());
        try {
            List<PurchaseRecContractPromise> purchaseRecContractPromiseList = reconciliationVO.getPurchaseRecContractPromiseList();
            List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = reconciliationVO.getPurchaseRecContractAcceptanceList();
            List<PurchaseRecCharge> purchaseRecChargeList = reconciliationVO.getPurchaseRecChargeList();
            List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = reconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
            if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
                this.cancelCharges(purchasePerformanceReconciliation.getId(), null);
                this.purchaseRecChargeService.deleteByMainId(purchasePerformanceReconciliation.getId());
            }
            if (CollectionUtils.isEmpty(purchasePrePaymentWriteOffList)) {
                this.purchasePrePaymentWriteOffReconciliationService.deleteByMainId(purchasePerformanceReconciliation.getId());
            }
            if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
                this.cancelContractPromise(purchasePerformanceReconciliation.getId(), null);
                this.purchaseRecContractPromiseService.deleteByMainId(purchasePerformanceReconciliation.getId());
            }
            if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
                this.cancelContractAcceptance(purchasePerformanceReconciliation.getId(), null);
                this.purchaseRecContractAcceptanceService.deleteByMainId(purchasePerformanceReconciliation.getId());
            }
            if (CollectionUtils.isEmpty(purchaseRecContractPromiseList) && CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
                this.calculateMoney(purchasePerformanceReconciliation, reconciliationVO);
                this.checkSettlementAmount(purchasePerformanceReconciliation);
                this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
                return;
            }
            this.handlePaymentExpireDate(purchasePerformanceReconciliation);
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
            this.cancelContractPromise(purchasePerformanceReconciliation.getId(), null);
            this.cancelContractAcceptance(purchasePerformanceReconciliation.getId(), null);
            this.cancelCharges(purchasePerformanceReconciliation.getId(), null);
            this.generateReconciliation(purchasePerformanceReconciliation, reconciliationVO);
        }
        catch (ELSBootException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.redisUtil.releaseDistributedLock(reconciliationRedisLockVO.getLockKey(), reconciliationRedisLockVO.getRequestId());
        }
    }

    private void calculateMoney(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO purchaseReconciliationVO) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = purchaseReconciliationVO.getPurchaseRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = purchaseReconciliationVO.getPurchaseRecContractAcceptanceList();
        List<PurchaseRecCharge> charges = purchaseReconciliationVO.getPurchaseRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        BigDecimal performanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            performanceIncludeTaxAmount = purchaseRecContractPromiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseRecContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setPerformanceIncludeTaxAmount(performanceIncludeTaxAmount);
        BigDecimal acceptanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            acceptanceIncludeTaxAmount = purchaseRecContractAcceptanceList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseRecContractAcceptance::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setAcceptanceIncludeTaxAmount(acceptanceIncludeTaxAmount);
        BigDecimal chargeTotalAmount = BigDecimal.ZERO;
        BigDecimal chargeAmount = BigDecimal.ZERO;
        BigDecimal buckleTicketsAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(charges)) {
            for (PurchaseRecCharge purchaseRecCharge : charges) {
                chargeTotalAmount = chargeTotalAmount.add(purchaseRecCharge.getTotalAmount());
                if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) {
                    chargeAmount = chargeAmount.add(purchaseRecCharge.getTotalAmount());
                }
                if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) continue;
                buckleTicketsAmount = buckleTicketsAmount.add(purchaseRecCharge.getTotalAmount());
            }
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = performanceIncludeTaxAmount.add(acceptanceIncludeTaxAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(PurchasePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setWrittenOffAmount(writtenOffAmount);
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
        this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
    }

    @Override
    public PurchasePerformanceReconciliationVO extractReconciliation(PurchasePerformanceReconciliationVO reconciliationVO) {
        String elsAccount = !StringUtils.isBlank((CharSequence)reconciliationVO.getElsAccount()) ? reconciliationVO.getElsAccount() : TenantContext.getTenant();
        ReconciliationVO targetReconciliationVO = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)targetReconciliationVO);
        PurchaseContractPromiseDTO purchaseContractPromiseDTO = new PurchaseContractPromiseDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)purchaseContractPromiseDTO);
        List<PurchaseContractPromiseDTO> purchaseContractPromiseList = this.purchaseContractPromiseLocalRpcService.listPurchaseContractPromiseDTO(purchaseContractPromiseDTO);
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.getPurchaseRecContractPromiseList(purchaseContractPromiseList);
        reconciliationVO.setPurchaseRecContractPromiseList(purchaseRecContractPromiseList);
        PurchaseContractAcceptanceDTO purchaseContractAcceptanceDTO = new PurchaseContractAcceptanceDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)purchaseContractAcceptanceDTO);
        List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = this.purchaseContractAcceptanceLocalRpcService.listPurchaseContractAcceptanceDTO(purchaseContractAcceptanceDTO);
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.getPurchaseRecContractAcceptanceList(purchaseContractAcceptanceList);
        reconciliationVO.setPurchaseRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        List<PurchaseRecCharge> charges = this.purchaseDeductCostService.getByPurchaseDeductCost(targetReconciliationVO, elsAccount);
        reconciliationVO.setPurchaseRecChargeList(charges);
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.purchasePaymentApplyItemService.getPurchasePrePaymentWriteOffReconciliations(targetReconciliationVO, elsAccount);
        reconciliationVO.setPurchasePrePaymentWriteOffReconciliationList(prePaymentWriteOff);
        return reconciliationVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        ReconciliationRedisLockVO reconciliationRedisLockVO = this.redisLock(purchasePerformanceReconciliation.getToElsAccount());
        try {
            this.purchaseRecContractPromiseService.checkPromise(reconciliationVO);
            this.purchaseRecContractAcceptanceService.checkAcceptance(reconciliationVO);
            this.purchaseRecChargeService.checkPerformanceReconcilationCharge(reconciliationVO);
            this.calculateMoney(purchasePerformanceReconciliation, reconciliationVO);
            this.checkSettlementAmount(purchasePerformanceReconciliation);
            ReconciliationVO vo = new ReconciliationVO();
            BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)vo);
            this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupy(vo, reconciliationVO.getPurchasePrePaymentWriteOffReconciliationList());
            boolean flag = false;
            if (ReconciliationStatusEmun.REFUSED.getValue().equals(purchasePerformanceReconciliation.getReconciliationStatus()) && StringUtils.isNotBlank((CharSequence)purchasePerformanceReconciliation.getRelationId())) {
                flag = true;
            }
            if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchasePerformanceReconciliation.getIsTeamwork())) {
                purchasePerformanceReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
                BigDecimal closingAmount = purchasePerformanceReconciliation.getClosingAmount();
                if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                    purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
                }
                if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
                }
            } else {
                purchasePerformanceReconciliation.setReconciliationStatus(ReconciliationStatusEmun.UNCONFIRMED.getValue());
                purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.SALE_UNCONFIRMED.getValue());
            }
            purchasePerformanceReconciliation.setSendStatus("1");
            this.updateMain(purchasePerformanceReconciliation, reconciliationVO);
            this.invokeBaseRpcService.addStatusLog(purchasePerformanceReconciliation.getId(), purchasePerformanceReconciliation.getReconciliationStatus(), "reconciliation", "publish");
            String id = purchasePerformanceReconciliation.getRelationId();
            SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)((Object)salePerformanceReconciliation));
            salePerformanceReconciliation.setToElsAccount(purchasePerformanceReconciliation.getElsAccount());
            salePerformanceReconciliation.setBusAccount(purchasePerformanceReconciliation.getElsAccount());
            salePerformanceReconciliation.setRelationId(purchasePerformanceReconciliation.getId());
            salePerformanceReconciliation.setElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            if (flag) {
                salePerformanceReconciliation.setDataVersion(null);
                salePerformanceReconciliation.setId(id);
                salePerformanceReconciliation.setReconciliationStatus(purchasePerformanceReconciliation.getReconciliationStatus());
                salePerformanceReconciliation.setStatus(purchasePerformanceReconciliation.getStatus());
                this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
                this.handleDetail(salePerformanceReconciliation, reconciliationVO);
            } else {
                salePerformanceReconciliation.setId(null);
                this.salePerformanceReconciliationMapper.insert((Object)salePerformanceReconciliation);
                this.handleDetail(salePerformanceReconciliation, reconciliationVO);
                purchasePerformanceReconciliation.setRelationId(salePerformanceReconciliation.getId());
                this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
            }
        }
        catch (ELSBootException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.redisUtil.releaseDistributedLock(reconciliationRedisLockVO.getLockKey(), reconciliationRedisLockVO.getRequestId());
        }
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    private void handleDetail(SalePerformanceReconciliation saleReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = reconciliationVO.getPurchaseRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = reconciliationVO.getPurchaseRecContractAcceptanceList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = reconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        List<PurchaseRecCharge> purchaseRecChargeList = reconciliationVO.getPurchaseRecChargeList();
        List<PurchaseAttachmentDTO> attachments = reconciliationVO.getAttachments();
        String id = saleReconciliation.getId();
        this.saleRecContractPromiseMapper.deleteByMainId(id);
        this.saleRecContractAcceptanceMapper.deleteByMainId(id);
        this.salePrePaymentWriteOffReconciliationMapper.deleteByMainId(id);
        this.saleRecChargeMapper.deleteByMainId(id);
        this.saleRecAdditionalChargesMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        this.handleSaleRecContractPromiseDetail(saleReconciliation, purchaseRecContractPromiseList);
        this.handleSaleRecContractAcceptanceDetail(saleReconciliation, purchaseRecContractAcceptanceList);
        this.handleSaleRecChargeDetail(saleReconciliation, purchaseRecChargeList);
        this.handleSaleRecPrePaymentWriteOffDetail(saleReconciliation, prePaymentWriteOffList);
        this.handleSaleAttachmentDetail(saleReconciliation, attachments);
    }

    private void handleSaleRecPrePaymentWriteOffDetail(SalePerformanceReconciliation saleReconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        ArrayList<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = new ArrayList<SalePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation purchasePrePaymentWriteOff : prePaymentWriteOffList) {
            SalePrePaymentWriteOffReconciliation salePrePaymentWriteOff = new SalePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchasePrePaymentWriteOff), (Object)((Object)salePrePaymentWriteOff));
            salePrePaymentWriteOff.setId(null);
            salePrePaymentWriteOff.setElsAccount(saleReconciliation.getElsAccount());
            salePrePaymentWriteOff.setToElsAccount(saleReconciliation.getToElsAccount());
            salePrePaymentWriteOff.setBusAccount(saleReconciliation.getBusAccount());
            salePrePaymentWriteOff.setHeadId(saleReconciliation.getId());
            salePrePaymentWriteOff.setRelationId(purchasePrePaymentWriteOff.getId());
            salePrePaymentWriteOffList.add(salePrePaymentWriteOff);
        }
        this.salePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(salePrePaymentWriteOffList);
    }

    private void handleSaleRecContractAcceptanceDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        ArrayList<SaleRecContractAcceptance> saleRecContractAcceptanceList = new ArrayList<SaleRecContractAcceptance>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            SaleRecContractAcceptance saleRecContractAcceptance = new SaleRecContractAcceptance();
            BeanUtils.copyProperties((Object)((Object)purchaseRecContractAcceptance), (Object)((Object)saleRecContractAcceptance));
            saleRecContractAcceptance.setId(null);
            saleRecContractAcceptance.setElsAccount(saleReconciliation.getElsAccount());
            saleRecContractAcceptance.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecContractAcceptance.setBusAccount(saleReconciliation.getBusAccount());
            saleRecContractAcceptance.setHeadId(saleReconciliation.getId());
            saleRecContractAcceptance.setRelationId(purchaseRecContractAcceptance.getId());
            saleRecContractAcceptanceList.add(saleRecContractAcceptance);
        }
        this.saleRecContractAcceptanceMapper.insertBatchSomeColumn(saleRecContractAcceptanceList);
    }

    private void handleSaleRecContractPromiseDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecContractPromise> purchaseRecContractPromiseList) {
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<SaleRecContractPromise> saleRecContractPromiseList = new ArrayList<SaleRecContractPromise>();
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            SaleRecContractPromise saleRecContractPromise = new SaleRecContractPromise();
            BeanUtils.copyProperties((Object)((Object)purchaseRecContractPromise), (Object)((Object)saleRecContractPromise));
            saleRecContractPromise.setId(null);
            saleRecContractPromise.setElsAccount(saleReconciliation.getElsAccount());
            saleRecContractPromise.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecContractPromise.setBusAccount(saleReconciliation.getBusAccount());
            saleRecContractPromise.setHeadId(saleReconciliation.getId());
            saleRecContractPromise.setRelationId(purchaseRecContractPromise.getId());
            saleRecContractPromiseList.add(saleRecContractPromise);
        }
        this.saleRecContractPromiseMapper.insertBatchSomeColumn(saleRecContractPromiseList);
    }

    private void handleSaleAttachmentDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleReconciliation.getElsAccount());
            saleAttachment.setHeadId(saleReconciliation.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void handleSaleRecChargeDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        ArrayList<SaleRecCharge> saleRecCharges = new ArrayList<SaleRecCharge>();
        for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
            SaleRecCharge saleRecCharge = new SaleRecCharge();
            BeanUtils.copyProperties((Object)((Object)purchaseRecCharge), (Object)((Object)saleRecCharge));
            saleRecCharge.setId(null);
            saleRecCharge.setElsAccount(saleReconciliation.getElsAccount());
            saleRecCharge.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecCharge.setBusAccount(saleReconciliation.getBusAccount());
            saleRecCharge.setHeadId(saleReconciliation.getId());
            saleRecCharge.setRelationId(purchaseRecCharge.getId());
            saleRecCharges.add(saleRecCharge);
        }
        this.saleRecChargeMapper.insertBatchSomeColumn(saleRecCharges);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> invoiceRefusedOrConfirm(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseInvoice> invoices, String operation) {
        String opt = "confirm";
        if ("refused".equals(operation)) {
            opt = "refund";
            purchasePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.RENTURNED.getValue());
            purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_RENTURNED.getValue());
        } else if ("confirm".equals(operation)) {
            purchasePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.CONFIRMED.getValue());
            purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_CONFIRMED.getValue());
            if (!CollectionUtils.isEmpty(invoices) && invoices.size() == 1) {
                PurchaseInvoiceHookVO hookVO = new PurchaseInvoiceHookVO();
                BeanUtils.copyProperties((Object)((Object)invoices.get(0)), (Object)((Object)hookVO));
                String id = purchasePerformanceReconciliation.getId();
                hookVO.setPurchaseRecContractPromiseList(this.purchaseRecContractPromiseService.selectByMainId(id));
                hookVO.setPurchaseRecContractAcceptanceList(this.purchaseRecContractAcceptanceService.selectByMainId(id));
                hookVO.setPurchaseRecChargeList(this.purchaseRecChargeService.selectByMainId(id));
                hookVO.setPurchasePrePaymentWriteOffReconciliationList(this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id));
                this.purchaseInvoiceHookInformationService.hook(hookVO);
            }
        }
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        if (salePerformanceReconciliation == null) {
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
        }
        salePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(purchasePerformanceReconciliation.getPurchaseInvoiceAffirmStatus());
        salePerformanceReconciliation.setPurchaseRemark(purchasePerformanceReconciliation.getPurchaseRemark());
        BigDecimal invoiceTotalAmount = this.saleInvoiceService.invoiceRefusedOrConfirm(invoices, operation);
        if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            salePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
            salePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_CONFIRMED.getValue());
            String url = "id=" + salePerformanceReconciliation.getId() + "&createAccount=" + salePerformanceReconciliation.getCreateAccount();
            super.sendMsg(purchasePerformanceReconciliation.getElsAccount(), purchasePerformanceReconciliation.getToElsAccount(), (Object)purchasePerformanceReconciliation, url, "invoice", opt);
        }
        salePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_RENTURNED.getValue());
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> refusedOrConfirm(PurchasePerformanceReconciliation purchasePerformanceReconciliation, String operation) {
        String opt = "confirm";
        if (OperationEnum.REFUSED.getValue().equals(operation)) {
            purchasePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.REFUSED.getValue());
            purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.PURCHASDE_REFUSED.getValue());
            opt = "refund";
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountFromSale(purchasePerformanceReconciliation.getRelationId());
        } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            purchasePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.COMFIRMED.getValue());
            BigDecimal closingAmount = purchasePerformanceReconciliation.getClosingAmount();
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
            }
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
            }
        }
        SalePerformanceReconciliation reconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        if (reconciliation == null) {
            throw new ELSBootException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
        }
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)((Object)salePerformanceReconciliation));
        salePerformanceReconciliation.setId(reconciliation.getId());
        salePerformanceReconciliation.setElsAccount(reconciliation.getElsAccount());
        salePerformanceReconciliation.setToElsAccount(reconciliation.getToElsAccount());
        salePerformanceReconciliation.setBusAccount(reconciliation.getBusAccount());
        salePerformanceReconciliation.setRelationId(purchasePerformanceReconciliation.getId());
        salePerformanceReconciliation.setDataVersion(reconciliation.getDataVersion());
        salePerformanceReconciliation.setStatus(purchasePerformanceReconciliation.getStatus());
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        String url = "id=" + salePerformanceReconciliation.getId() + "&createAccount=" + salePerformanceReconciliation.getCreateAccount();
        if (StringUtils.isNotBlank((CharSequence)purchasePerformanceReconciliation.getSalePrincipal())) {
            super.sendMsg(purchasePerformanceReconciliation.getElsAccount(), purchasePerformanceReconciliation.getToElsAccount(), purchasePerformanceReconciliation.getSalePrincipal(), (Object)purchasePerformanceReconciliation, url, "salePerformanceReconciliation", opt);
        } else {
            super.sendMsg(purchasePerformanceReconciliation.getElsAccount(), purchasePerformanceReconciliation.getToElsAccount(), (Object)purchasePerformanceReconciliation, url, "salePerformanceReconciliation", opt);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        if (purchaseReconciliation == null) {
            return;
        }
        String createAccount = purchaseReconciliation.getCreateAccount();
        String elsAccount = purchaseReconciliation.getElsAccount();
        if (!StringUtils.isEmpty((CharSequence)elsAccount) && elsAccount.equals(createAccount)) {
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountByPurchase(id);
        } else {
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountFromSale(purchaseReconciliation.getRelationId());
        }
        this.cancelReconciliation(id);
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseInvoice> purchaseInvoiceList, String operation) {
        this.purchaseInvoiceMapper.deleteByMainId(purchasePerformanceReconciliation.getId());
        this.saleInvoiceMapper.deleteByMainId(purchasePerformanceReconciliation.getRelationId());
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        this.purchaseInvoiceService.savePerformanceReconcilationInvoice(purchaseInvoiceList, purchasePerformanceReconciliation, salePerformanceReconciliation);
        purchasePerformanceReconciliation.setInvoiced("1");
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        salePerformanceReconciliation.setInvoiced("1");
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
    }

    @Override
    public void delMain(String id) {
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.purchasePerformanceReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public PurchasePerformanceReconciliationVO queryReconciliationItemList(PurchasePerformanceReconciliation purchaseReconciliation, String id) {
        PurchasePerformanceReconciliationVO purchaseReconciliationVO = new PurchasePerformanceReconciliationVO();
        PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)this.purchaseInvoiceService.getById((Serializable)((Object)id)));
        String reconciliationNumber = purchaseInvoice.getReconciliationNumber();
        LambdaQueryWrapper reconciliationLambdaQueryWrapper = new LambdaQueryWrapper();
        reconciliationLambdaQueryWrapper.eq(PurchasePerformanceReconciliation::getReconciliationNumber, (Object)reconciliationNumber);
        PurchasePerformanceReconciliation reconciliation = (PurchasePerformanceReconciliation)((Object)this.getOne((Wrapper)reconciliationLambdaQueryWrapper));
        if (reconciliation == null) {
            return purchaseReconciliationVO;
        }
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(reconciliation.getId());
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(reconciliation.getId());
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceService.selectByMainId(reconciliation.getId());
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseService.selectByMainId(reconciliation.getId());
        if (!StringUtils.isEmpty((CharSequence)reconciliation.getReconciliationNumber())) {
            PurchaseInvoiceHookVO vo = PurchaseInvoiceHookVO.builder().build();
            vo.setPurchaseRecContractPromiseList(purchaseRecContractPromiseList);
            vo.setPurchaseRecContractAcceptanceList(purchaseRecContractAcceptanceList);
            vo.setPurchaseRecChargeList(purchaseRecChargeList);
            vo.setPurchasePrePaymentWriteOffReconciliationList(purchasePrePaymentWriteOffList);
            this.purchaseInvoiceHookInformationService.handleBusinessList(vo, reconciliation.getReconciliationNumber());
        }
        purchaseReconciliationVO.setPurchaseRecContractPromiseList(purchaseRecContractPromiseList);
        purchaseReconciliationVO.setPurchaseRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        purchaseReconciliationVO.setPurchasePrePaymentWriteOffReconciliationList(purchasePrePaymentWriteOffList);
        purchaseReconciliationVO.setPurchaseRecChargeList(purchaseRecChargeList);
        purchaseReconciliationVO.setHookStatus(purchaseReconciliation.getHookStatus());
        return purchaseReconciliationVO;
    }

    private void cancelReconciliation(String id) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        purchasePerformanceReconciliation.setCancellation("1");
        LoginUser loginUser = SysUtil.getLoginUser();
        purchasePerformanceReconciliation.setCancellationSubAccount(loginUser.getSubAccount());
        purchasePerformanceReconciliation.setCancellationName(loginUser.getRealname());
        purchasePerformanceReconciliation.setCancellationTime(new Date());
        purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.RENTURNED.getValue());
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        salePerformanceReconciliation.setCancellationName(purchasePerformanceReconciliation.getCancellationName());
        salePerformanceReconciliation.setCancellationSubAccount(purchasePerformanceReconciliation.getCancellationSubAccount());
        salePerformanceReconciliation.setCancellationTime(purchasePerformanceReconciliation.getCancellationTime());
        salePerformanceReconciliation.setCancellation("1");
        salePerformanceReconciliation.setStatus(purchasePerformanceReconciliation.getStatus());
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
    }

    private void insertDeductCost(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge entity : purchaseRecChargeList) {
            entity.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePerformanceReconciliation);
            entity.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setId(null);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            ++itemNumber;
        }
        this.purchaseRecChargeService.saveBatch(purchaseRecChargeList, 2000);
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertPrePaymentWriteOff(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)purchasePerformanceReconciliation);
            prePaymentWriteOff.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            prePaymentWriteOff.setId(null);
            purchasePrePaymentWriteOffList.add(prePaymentWriteOff);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.purchasePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    private void insertContractAcceptance(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            purchaseRecContractAcceptance.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseRecContractAcceptance, (BaseEntity)purchasePerformanceReconciliation);
            purchaseRecContractAcceptance.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseRecContractAcceptance.setItemNumber(String.valueOf(itemNumber));
            PurchaseContractAcceptanceDTO contractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId());
            if (contractAcceptance != null) {
                contractAcceptance.setCostStatus("1");
                contractAcceptance.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
                purchaseRecContractAcceptance.setId(null);
                purchaseContractAcceptanceList.add(contractAcceptance);
                SaleContractAcceptanceDTO saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(contractAcceptance.getRelationId());
                saleContractAcceptance.setCostStatus("1");
                saleContractAcceptance.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
                saleContractAcceptanceList.add(saleContractAcceptance);
            }
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            this.purchaseRecContractAcceptanceService.saveBatch(purchaseRecContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
    }

    private void insertContractPromise(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseRecContractPromise> purchaseRecContractPromiseList) {
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseContractPromiseDTO> purchaseContractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        ArrayList<SaleContractPromiseDTO> saleContractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        int itemNumber = 1;
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            purchaseRecContractPromise.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseRecContractPromise, (BaseEntity)purchasePerformanceReconciliation);
            purchaseRecContractPromise.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseRecContractPromise.setItemNumber(String.valueOf(itemNumber));
            PurchaseContractPromiseDTO contractPromise = this.purchaseContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId());
            if (contractPromise != null) {
                contractPromise.setReconciliationStatus("1");
                contractPromise.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
                purchaseRecContractPromise.setId(null);
                purchaseContractPromiseList.add(contractPromise);
                SaleContractPromiseDTO saleContractPromise = this.saleContractPromiseLocalRpcService.getById(contractPromise.getRelationId());
                saleContractPromise.setReconciliationStatus("1");
                saleContractPromise.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
                saleContractPromiseList.add(saleContractPromise);
            }
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            this.purchaseRecContractPromiseService.saveBatch(purchaseRecContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(purchaseContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(saleContractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(saleContractPromiseList);
        }
    }

    private void cancelContractAcceptance(String id, List<String> existIds) {
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(purchaseRecContractAcceptance.getBusinessId())) continue;
            PurchaseContractAcceptanceDTO purchaseContractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId());
            if (purchaseContractAcceptance != null && !StringUtils.isEmpty((CharSequence)purchaseContractAcceptance.getId())) {
                this.handleContractAcceptanceFromPurchase(purchaseContractAcceptanceList, saleContractAcceptanceList, purchaseContractAcceptance);
                continue;
            }
            this.handleContractAcceptanceFromSale(purchaseContractAcceptanceList, saleContractAcceptanceList, purchaseRecContractAcceptance);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
    }

    private void handleContractAcceptanceFromSale(List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList, List<SaleContractAcceptanceDTO> saleContractAcceptanceList, PurchaseRecContractAcceptance purchaseRecContractAcceptance) {
        SaleContractAcceptanceDTO saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId());
        if (saleContractAcceptance == null) {
            return;
        }
        saleContractAcceptance.setCostStatus("0");
        saleContractAcceptance.setReconciliationNumber(null);
        saleContractAcceptanceList.add(saleContractAcceptance);
        String relationId = saleContractAcceptance.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        PurchaseContractAcceptanceDTO purchaseContractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(relationId);
        if (purchaseContractAcceptance == null) {
            return;
        }
        purchaseContractAcceptance.setCostStatus("0");
        purchaseContractAcceptance.setReconciliationNumber(null);
        purchaseContractAcceptanceList.add(purchaseContractAcceptance);
    }

    private void handleContractAcceptanceFromPurchase(List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList, List<SaleContractAcceptanceDTO> saleContractAcceptanceList, PurchaseContractAcceptanceDTO purchaseContractAcceptance) {
        purchaseContractAcceptance.setCostStatus("0");
        purchaseContractAcceptance.setReconciliationNumber(null);
        purchaseContractAcceptanceList.add(purchaseContractAcceptance);
        String relationId = purchaseContractAcceptance.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        SaleContractAcceptanceDTO saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(relationId);
        if (saleContractAcceptance == null) {
            return;
        }
        saleContractAcceptance.setCostStatus("0");
        saleContractAcceptance.setReconciliationNumber(null);
        saleContractAcceptanceList.add(saleContractAcceptance);
    }

    private void cancelContractPromise(String id, List<String> existIds) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseContractPromiseDTO> contractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        ArrayList<SaleContractPromiseDTO> saleContractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(purchaseRecContractPromise.getBusinessId())) continue;
            PurchaseContractPromiseDTO contractPromise = this.purchaseContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId());
            if (contractPromise != null && !StringUtils.isEmpty((CharSequence)contractPromise.getId())) {
                this.handleContractPromiseFromPurchase(contractPromiseList, saleContractPromiseList, contractPromise);
                continue;
            }
            this.handleContractPromiseFromSale(contractPromiseList, saleContractPromiseList, purchaseRecContractPromise);
        }
        if (!CollectionUtils.isEmpty(contractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(contractPromiseList);
        }
        if (!CollectionUtils.isEmpty(saleContractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(saleContractPromiseList);
        }
    }

    private void handleContractPromiseFromPurchase(List<PurchaseContractPromiseDTO> contractPromiseList, List<SaleContractPromiseDTO> saleContractPromiseList, PurchaseContractPromiseDTO contractPromise) {
        contractPromise.setReconciliationStatus("0");
        contractPromise.setReconciliationNumber(null);
        contractPromiseList.add(contractPromise);
        String relationId = contractPromise.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        SaleContractPromiseDTO saleContractPromise = this.saleContractPromiseLocalRpcService.getById(relationId);
        if (saleContractPromise == null) {
            return;
        }
        saleContractPromise.setReconciliationStatus("0");
        saleContractPromise.setReconciliationNumber(null);
        saleContractPromiseList.add(saleContractPromise);
    }

    private void handleContractPromiseFromSale(List<PurchaseContractPromiseDTO> contractPromiseList, List<SaleContractPromiseDTO> saleContractPromiseList, PurchaseRecContractPromise purchaseRecContractPromise) {
        SaleContractPromiseDTO saleContractPromise = this.saleContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId());
        if (saleContractPromise == null) {
            return;
        }
        saleContractPromise.setReconciliationStatus("0");
        saleContractPromise.setReconciliationNumber(null);
        saleContractPromiseList.add(saleContractPromise);
        String relationId = saleContractPromise.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        PurchaseContractPromiseDTO contractPromise = this.purchaseContractPromiseLocalRpcService.getById(relationId);
        if (contractPromise != null) {
            contractPromise.setReconciliationStatus("0");
            contractPromise.setReconciliationNumber(null);
            contractPromiseList.add(contractPromise);
        }
    }

    private void cancelCharges(String purchaseReconciliationId, List<String> existIds) {
        List<PurchaseRecCharge> charges = this.purchaseRecChargeService.selectByMainId(purchaseReconciliationId);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge charge : charges) {
            SaleDeductCost saleDeductCost;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId())) continue;
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            if (deductCost != null) {
                deductCost.setDeductStatus("0");
                deductCost.setReconciliationNumber(null);
                deductCosts.add(deductCost);
                saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
                saleDeductCost.setDeductStatus("0");
                saleDeductCost.setReconciliationNumber(null);
                saleDeductCosts.add(saleDeductCost);
            }
            if ((saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())))) == null) continue;
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            purchaseDeductCost.setDeductStatus("0");
            purchaseDeductCost.setReconciliationNumber(null);
            deductCosts.add(purchaseDeductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private List<PurchaseRecContractPromise> getPurchaseRecContractPromiseList(List<PurchaseContractPromiseDTO> purchaseContractPromiseList) {
        ArrayList<PurchaseRecContractPromise> list = new ArrayList<PurchaseRecContractPromise>();
        if (CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            return list;
        }
        for (PurchaseContractPromiseDTO purchaseContractPromiseDTO : purchaseContractPromiseList) {
            PurchaseRecContractPromise dto = new PurchaseRecContractPromise();
            BeanUtils.copyProperties((Object)purchaseContractPromiseDTO, (Object)((Object)dto));
            dto.setMasterContractNumber(purchaseContractPromiseDTO.getContractNumber());
            dto.setContractParties(purchaseContractPromiseDTO.getSupplierName());
            dto.setContractPromise(purchaseContractPromiseDTO.getPerformingPartyName());
            dto.setContractDrawer(purchaseContractPromiseDTO.getInvoicedName());
            dto.setContractReceiver(purchaseContractPromiseDTO.getPayeeName());
            dto.setId(null);
            dto.setAmount(purchaseContractPromiseDTO.getAmount());
            dto.setBusinessId(purchaseContractPromiseDTO.getId());
            dto.setCurrency(purchaseContractPromiseDTO.getCurreny());
            list.add(dto);
        }
        return list;
    }

    private List<PurchaseRecContractAcceptance> getPurchaseRecContractAcceptanceList(List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList) {
        ArrayList<PurchaseRecContractAcceptance> list = new ArrayList<PurchaseRecContractAcceptance>();
        for (PurchaseContractAcceptanceDTO purchaseContractAcceptanceDTO : purchaseContractAcceptanceList) {
            PurchaseRecContractAcceptance dto = new PurchaseRecContractAcceptance();
            BeanUtils.copyProperties((Object)purchaseContractAcceptanceDTO, (Object)((Object)dto));
            dto.setId(null);
            dto.setBusinessId(purchaseContractAcceptanceDTO.getId());
            list.add(dto);
        }
        return list;
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchasePerformanceReconciliation", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseReconciliationList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchasePerformanceReconciliation reconciliation : purchaseReconciliationList) {
            this.pushDataToErp(reconciliation);
        }
    }

    private void pushDataToErp(PurchasePerformanceReconciliation reconciliation) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchasePerformanceReconciliation", (Object)reconciliation);
    }

    @Override
    public void copyData(String id) {
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        if (purchaseReconciliation == null) {
            return;
        }
        PurchasePerformanceReconciliation newReconciliation = new PurchasePerformanceReconciliation();
        newReconciliation.setToElsAccount(purchaseReconciliation.getToElsAccount());
        newReconciliation.setCreateAccount(purchaseReconciliation.getCreateAccount());
        newReconciliation.setPurchaseName(purchaseReconciliation.getPurchaseName());
        newReconciliation.setSupplierName(purchaseReconciliation.getSupplierName());
        newReconciliation.setBeginDate(purchaseReconciliation.getBeginDate());
        newReconciliation.setEndDate(purchaseReconciliation.getEndDate());
        newReconciliation.setCompany(purchaseReconciliation.getCompany());
        newReconciliation.setPurchaseOrg(purchaseReconciliation.getPurchaseOrg());
        newReconciliation.setSupplierCode(purchaseReconciliation.getSupplierCode());
        newReconciliation.setSalePrincipalPhone(purchaseReconciliation.getSalePrincipalPhone());
        newReconciliation.setPaymentClause(purchaseReconciliation.getPaymentClause());
        newReconciliation.setPaymentClauseDesc(purchaseReconciliation.getPaymentClauseDesc());
        newReconciliation.setTaxCode(purchaseReconciliation.getTaxCode());
        newReconciliation.setTaxRate(purchaseReconciliation.getTaxRate());
        newReconciliation.setCurrency(purchaseReconciliation.getCurrency());
        newReconciliation.setExchangeRate(purchaseReconciliation.getExchangeRate());
        newReconciliation.setPayWay(purchaseReconciliation.getPayWay());
        newReconciliation.setPayCycle(purchaseReconciliation.getPayCycle());
        newReconciliation.setPurchasePrincipal(purchaseReconciliation.getPurchasePrincipal());
        newReconciliation.setSalePrincipal(purchaseReconciliation.getSalePrincipal());
        newReconciliation.setPaymentBenchmarkDate(purchaseReconciliation.getPaymentBenchmarkDate());
        newReconciliation.setPaymentExpiredate(purchaseReconciliation.getPaymentExpiredate());
        newReconciliation.setTemplateNumber(purchaseReconciliation.getTemplateNumber());
        newReconciliation.setTemplateVersion(purchaseReconciliation.getTemplateVersion());
        newReconciliation.setTemplateName(purchaseReconciliation.getTemplateName());
        newReconciliation.setTemplateAccount(purchaseReconciliation.getTemplateAccount());
        newReconciliation.setSaveForZero(purchaseReconciliation.getSaveForZero());
        newReconciliation.setChargeCurrency(purchaseReconciliation.getChargeCurrency());
        newReconciliation.setIsTeamwork(purchaseReconciliation.getIsTeamwork());
        this.saveMainByCopy(newReconciliation, new PurchasePerformanceReconciliationVO());
    }

    private void saveMainByCopy(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        this.buildPurchasePerformanceReconciliation(purchasePerformanceReconciliation);
        this.purchasePerformanceReconciliationMapper.insert((Object)purchasePerformanceReconciliation);
        this.invokeBaseRpcService.addStatusLog(purchasePerformanceReconciliation.getId(), ReconciliationStatusEmun.NEW.getValue(), "reconciliation", "inster");
    }

    @Override
    public Result<?> hookConfirm(PurchasePerformanceReconciliation purchaseReconciliation, List<PurchaseInvoice> purchaseInvoices) {
        PurchasePerformanceReconciliation reconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getId())));
        if (reconciliation == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_field_YxuIetVH_ba87ff35", (String)"\u627e\u4e0d\u5230\u5bf9\u8d26\u5355\u4fe1\u606f"));
        }
        if (ReconciliationHookStatusEnum.CONFIRM.getValue().equals(reconciliation.getHookStatus())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_tFIRLRt_45d3a84e", (String)"\u5355\u636e\u5df2\u786e\u8ba4\u52fe\u7a3d"));
        }
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)reconciliationVO);
        this.purchaseDeliveryWaterService.handleWaterData(purchaseInvoices, reconciliationVO);
        reconciliation.setHookStatus(ReconciliationHookStatusEnum.CONFIRM.getValue());
        this.updateById((Object)reconciliation);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    public JSONObject getRequestDataById(String id) {
        PurchasePerformanceReconciliationVO purchasePerformanceReconciliationVO = this.getMessageById(id);
        Result result = Result.ok((Object)((Object)purchasePerformanceReconciliationVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getRequestDataById(List<String> ids) {
        ArrayList headVOArrayList = new ArrayList();
        ids.forEach(id -> headVOArrayList.add(this.getMessageById((String)id)));
        Result result = Result.ok(headVOArrayList);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONArray)result.getResult();
    }

    private PurchasePerformanceReconciliationVO getMessageById(String id) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.getById((Serializable)((Object)id)));
        PurchasePerformanceReconciliationVO purchasePerformanceReconciliationVO = new PurchasePerformanceReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)((Object)purchasePerformanceReconciliationVO));
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseMapper.selectByMainId(id);
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceMapper.selectByMainId(id);
        purchasePerformanceReconciliationVO.setPurchaseRecContractPromiseList(purchaseRecContractPromiseList);
        purchasePerformanceReconciliationVO.setPurchaseRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        return purchasePerformanceReconciliationVO;
    }

    private ReconciliationRedisLockVO redisLock(String elsAccount) {
        String lockKey;
        String requestId = UUID.randomUUID().toString();
        if (StringUtils.isBlank((CharSequence)elsAccount)) {
            elsAccount = requestId;
        }
        if (!this.redisUtil.tryGetDistributedLock(lockKey = LOCK_KEY_PRIFFIX + elsAccount, requestId, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APRdXAvjDiKtkIeWVRSKKW_a59a17ea", (String)"\u5f53\u524d\u4f9b\u5e94\u5546\u5176\u4ed6\u7528\u6237\u6b63\u5728\u64cd\u4f5c\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01"));
        }
        return new ReconciliationRedisLockVO(lockKey, requestId);
    }
}

