/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.api.enumerate.ReconciliationHookStatusEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchaseDeliveryWaterService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.enumerate.ReconciliationBillStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecAcceptReturnMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SalePrePaymentWriteOffReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleRecAcceptReturnMapper;
import com.els.modules.reconciliation.mapper.SaleRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.SaleRecChargeMapper;
import com.els.modules.reconciliation.mapper.SaleReconciliationMapper;
import com.els.modules.reconciliation.rpc.ElsTaxLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseVoucherHeadLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.PurchaseRecAcceptReturnService;
import com.els.modules.reconciliation.service.PurchaseRecAdditionalChargesService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceHookVO;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.modules.reconciliation.vo.ReconciliationRedisLockVO;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseReconciliationServiceImpl
extends BaseServiceImpl<PurchaseReconciliationMapper, PurchaseReconciliation>
implements PurchaseReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseReconciliationServiceImpl.class);
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Resource
    private PurchaseRecAcceptReturnService purchaseRecAcceptReturnService;
    @Resource
    private PurchaseRecAcceptReturnMapper purchaseRecAcceptReturnMapper;
    @Resource
    private PurchaseRecAdditionalChargesService purchaseRecAdditionalChargesService;
    @Resource
    private PurchaseRecChargeService purchaseRecChargeService;
    @Resource
    private PurchaseVoucherItemLocalRpcService purchaseVoucherItemRpcService;
    @Resource
    private PurchaseVoucherHeadLocalRpcService purchaseVoucherHeadLocalRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Resource
    private ElsTaxLocalRpcService elsTaxService;
    @Resource
    private SaleReconciliationMapper saleReconciliationMapper;
    @Resource
    private SaleRecChargeMapper saleRecChargeMapper;
    @Resource
    private SaleRecAdditionalChargesMapper saleRecAdditionalChargesMapper;
    @Resource
    private SaleRecAcceptReturnMapper saleRecAcceptReturnMapper;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private SalePrePaymentWriteOffReconciliationMapper salePrePaymentWriteOffReconciliationMapper;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private SaleAddCostService saleAddCostService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private StaticConfig staticConfig;
    @Autowired
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY_PRIFFIX = "srm_reconciliation_";
    private static final Long LOCK_EXPIRE_TIME = 120000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseReconciliation purchaseReconciliation, PurchaseReconciliationVO purchaseReconciliationVO) {
        ReconciliationRedisLockVO reconciliationRedisLockVO = this.redisLock(purchaseReconciliation.getToElsAccount());
        try {
            List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = purchaseReconciliationVO.getPurchaseRecAcceptReturnList();
            this.buildReconciliation(purchaseReconciliation);
            this.purchaseReconciliationMapper.insert((Object)purchaseReconciliation);
            this.invokeBaseRpcService.addStatusLog(purchaseReconciliation.getId(), ReconciliationStatusEmun.NEW.getValue(), "reconciliation", "inster");
            if (CollectionUtils.isEmpty(purchaseRecAcceptReturnList)) {
                return;
            }
            this.generateReconciliation(purchaseReconciliation, purchaseReconciliationVO);
        }
        catch (ELSBootException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.redisUtil.releaseDistributedLock(reconciliationRedisLockVO.getLockKey(), reconciliationRedisLockVO.getRequestId());
        }
    }

    private void buildReconciliation(PurchaseReconciliation purchaseReconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("reconciliation", (Object)purchaseReconciliation);
        purchaseReconciliation.setReconciliationNumber(reconciliationNumber);
        purchaseReconciliation.setCreateAccount(TenantContext.getTenant());
        purchaseReconciliation.setSendStatus("0");
        purchaseReconciliation.setReconciliationStatus(ReconciliationStatusEmun.NEW.getValue());
        purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.NEW.getValue());
        purchaseReconciliation.setInvoiced("0");
        purchaseReconciliation.setCancellation("0");
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchaseReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        this.handlePaymentExpireDate(purchaseReconciliation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseReconciliation purchaseReconciliation, PurchaseReconciliationVO purchaseReconciliationVO) {
        ReconciliationRedisLockVO reconciliationRedisLockVO = this.redisLock(purchaseReconciliation.getToElsAccount());
        try {
            List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = purchaseReconciliationVO.getPurchaseRecAcceptReturnList();
            List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = purchaseReconciliationVO.getPurchaseRecAdditionalChargesList();
            List<PurchaseRecCharge> purchaseRecChargeList = purchaseReconciliationVO.getPurchaseRecChargeList();
            List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
            this.handlePaymentExpireDate(purchaseReconciliation);
            if (CollectionUtils.isEmpty(purchaseRecAdditionalChargesList)) {
                this.cancelAdditionalCharges(purchaseReconciliation.getId(), null);
                this.purchaseRecAdditionalChargesService.deleteByMainId(purchaseReconciliation.getId());
            }
            if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
                this.cancelCharges(purchaseReconciliation.getId(), null);
                this.purchaseRecChargeService.deleteByMainId(purchaseReconciliation.getId());
            }
            if (CollectionUtils.isEmpty(purchasePrePaymentWriteOffList)) {
                this.purchasePrePaymentWriteOffReconciliationService.deleteByMainId(purchaseReconciliation.getId());
            }
            if (CollectionUtils.isEmpty(purchaseRecAcceptReturnList)) {
                this.cancelAcceptReturns(purchaseReconciliation.getId(), null);
                this.purchaseRecAcceptReturnService.deleteByMainId(purchaseReconciliation.getId());
                this.calculateMoney(purchaseReconciliation, purchaseReconciliationVO);
                this.checkSettlementAmount(purchaseReconciliation);
                this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
                return;
            }
            boolean isCreated = true;
            List<PurchaseRecAcceptReturn> acceptReturns = this.purchaseRecAcceptReturnService.selectByMainId(purchaseReconciliation.getId());
            if (acceptReturns != null && acceptReturns.size() > 0) {
                isCreated = false;
            }
            this.checkHasExtract(purchaseReconciliation, purchaseRecAcceptReturnList, isCreated);
            ArrayList<String> acceptReturnIds = new ArrayList<String>();
            BigDecimal amount = new BigDecimal(0);
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
                acceptReturnIds.add(purchaseRecAcceptReturn.getBusinessId());
                if (purchaseRecAcceptReturn.getDirectionBorrowing().equals("+")) {
                    amount = amount.add(purchaseRecAcceptReturn.getTotalAmount());
                }
                if (!purchaseRecAcceptReturn.getDirectionBorrowing().equals("-")) continue;
                amount = amount.subtract(purchaseRecAcceptReturn.getTotalAmount());
            }
            if (amount.compareTo(new BigDecimal(0)) < 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetsMKmWlYSRHkHfXUW_47a1224a", (String)"\u5bf9\u8d26\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u6536\u9000\u8d27\u660e\u7ec6\u603b\u91d1\u989d\u5c0f\u4e8e0"));
            }
            this.cancelAcceptReturns(purchaseReconciliation.getId(), acceptReturnIds);
            List<String> addCostIds = purchaseRecAdditionalChargesList.stream().map(PurchaseRecAdditionalCharges::getBusinessId).collect(Collectors.toList());
            this.cancelAdditionalCharges(purchaseReconciliation.getId(), addCostIds);
            List<String> deductCostIds = purchaseRecChargeList.stream().map(PurchaseRecCharge::getBusinessId).collect(Collectors.toList());
            this.cancelCharges(purchaseReconciliation.getId(), deductCostIds);
            this.generateReconciliation(purchaseReconciliation, purchaseReconciliationVO);
        }
        catch (ELSBootException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.redisUtil.releaseDistributedLock(reconciliationRedisLockVO.getLockKey(), reconciliationRedisLockVO.getRequestId());
        }
    }

    private void handlePaymentExpireDate(PurchaseReconciliation purchaseReconciliation) {
        if (StringUtils.isEmpty((CharSequence)purchaseReconciliation.getPayCycle()) || purchaseReconciliation.getPaymentBenchmarkDate() == null) {
            return;
        }
        Integer payCycle = Integer.valueOf(purchaseReconciliation.getPayCycle());
        if (payCycle > 0) {
            DateTime paymentExpireDate = DateUtil.offsetDay((Date)purchaseReconciliation.getPaymentBenchmarkDate(), (int)payCycle);
            purchaseReconciliation.setPaymentExpiredate((Date)paymentExpireDate);
        }
    }

    private void insertPrePaymentWriteOff(PurchaseReconciliation purchaseReconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(purchaseReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)purchaseReconciliation);
            prePaymentWriteOff.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setToElsAccount(purchaseReconciliation.getToElsAccount());
            prePaymentWriteOff.setId(null);
            purchasePrePaymentWriteOffList.add(prePaymentWriteOff);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.purchasePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    private void checkSettlementAmount(PurchaseReconciliation purchaseReconciliation) {
        if ("1".equals(purchaseReconciliation.getSaveForZero())) {
            if (purchaseReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeRHjydHfLWWWWWWWWXUWWShbLjXIet_a0732d09", (String)"\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a[${0}]\uff0c\u5c0f\u4e8e0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355", (String[])new String[]{purchaseReconciliation.getClosingAmount().toString()}));
            }
        } else if (purchaseReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeRHjydHfLWWWWWWWWXUEUWOShbLjXIet_f75bb433", (String)"\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a[${0}]\uff0c\u5c0f\u4e8e\u7b49\u4e8e0\u90fd\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355", (String[])new String[]{purchaseReconciliation.getClosingAmount().toString()}));
        }
    }

    private void checkData(List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList) {
        for (PurchaseRecAcceptReturn item : purchaseRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)item.getTaxCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmWlWYWSUiWWWWWWfoLV_4ecddce1", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u8d27\u51ed\u8bc1[${0}]\u7a0e\u7801\u4e3a\u7a7a", (String[])new String[]{item.getVoucherNumber()}));
            }
            if (!StringUtils.isEmpty((CharSequence)item.getCurrency())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmWlWYWSUiWWWWWWlqLV_417f87b8", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u8d27\u51ed\u8bc1[${0}]\u5e01\u522b\u4e3a\u7a7a", (String[])new String[]{item.getVoucherNumber()}));
        }
    }

    private void checkHasExtract(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, boolean isCreated) {
        List<Object> voucherItemIds = new ArrayList();
        voucherItemIds = !isCreated && !StringUtils.isEmpty((CharSequence)purchaseReconciliation.getId()) ? purchaseRecAcceptReturnList.stream().filter(reconciliation -> !purchaseReconciliation.getId().equals(reconciliation.getHeadId())).map(PurchaseRecAcceptReturn::getBusinessId).collect(Collectors.toList()) : purchaseRecAcceptReturnList.stream().map(PurchaseRecAcceptReturn::getBusinessId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(voucherItemIds)) {
            List<Object> voucherItemDTOList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(voucherItemIds);
            if (!CollectionUtils.isEmpty(voucherItemDTOList = voucherItemDTOList.stream().filter(item -> "1".equals(item.getReconciliation())).collect(Collectors.toList()))) {
                log.error("PurchaseReconciliationController edit \u51ed\u8bc1\u5df2\u5bf9\u8d26");
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmWlWYWSUiWWWWWWIIe_3bec8991", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u8d27\u51ed\u8bc1[${0}]\u5df2\u5bf9\u8d26", (String[])new String[]{((PurchaseVoucherItemDTO)voucherItemDTOList.get(0)).getVoucherNumber()}));
            }
        }
    }

    private void handleDocumentInfo(List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, PurchaseReconciliation purchaseReconciliation) {
        HashSet<String> voucherItemIds = new HashSet<String>();
        for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecAcceptReturn.getBusinessId())) continue;
            voucherItemIds.add(purchaseRecAcceptReturn.getBusinessId());
        }
        List<PurchaseVoucherItemDTO> purchaseVoucherItemDTOSList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(new ArrayList<String>(voucherItemIds));
        if (CollectionUtils.isEmpty(purchaseVoucherItemDTOSList)) {
            return;
        }
        Set voucherHeadIds = purchaseVoucherItemDTOSList.stream().map(PurchaseVoucherItemDTO::getHeadId).collect(Collectors.toSet());
        List<PurchaseVoucherHeadDTO> purchaseVoucherHeadDTOList = this.purchaseVoucherHeadLocalRpcService.listByIds(new ArrayList<String>(voucherHeadIds));
        if (CollectionUtils.isEmpty(purchaseVoucherHeadDTOList)) {
            return;
        }
        HashSet<String> documentIds = new HashSet<String>();
        HashSet<String> parentDocumentIds = new HashSet<String>();
        for (PurchaseVoucherHeadDTO dto : purchaseVoucherHeadDTOList) {
            String documentId = dto.getDocumentId();
            this.handleIds(documentIds, documentId);
            parentDocumentIds.add(dto.getId());
        }
        String documentIdsStr = StringUtils.join(documentIds, (String)",");
        String parentDocumentIdsStr = StringUtils.join(parentDocumentIds, (String)",");
        purchaseReconciliation.setDocumentId(documentIdsStr);
        purchaseReconciliation.setDocumentParentId(parentDocumentIdsStr);
        HashMap<String, PurchaseVoucherItemDTO> map = new HashMap<String, PurchaseVoucherItemDTO>();
        for (PurchaseVoucherItemDTO purchaseVoucherItemDTO : purchaseVoucherItemDTOSList) {
            map.put(purchaseVoucherItemDTO.getVoucherNumber(), purchaseVoucherItemDTO);
        }
        for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
            PurchaseVoucherItemDTO purchaseVoucherItemDTO;
            if (StringUtils.isEmpty((CharSequence)purchaseRecAcceptReturn.getVoucherNumber()) || (purchaseVoucherItemDTO = (PurchaseVoucherItemDTO)map.get(purchaseRecAcceptReturn.getVoucherNumber())) == null) continue;
            purchaseRecAcceptReturn.setDocumentId(purchaseVoucherItemDTO.getDocumentId());
            purchaseRecAcceptReturn.setDocumentParentId(purchaseVoucherItemDTO.getId());
        }
    }

    private void handleIds(Set<String> documentIds, String documentId) {
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            return;
        }
        if (documentId.contains(",")) {
            List<String> documentLists = Arrays.asList(documentId.split(","));
            documentIds.addAll(documentLists);
        } else {
            documentIds.add(documentId);
        }
    }

    private void generateReconciliation(PurchaseReconciliation reconciliation, PurchaseReconciliationVO purchaseReconciliationVO) {
        List<PurchaseRecAcceptReturn> acceptReturns = purchaseReconciliationVO.getPurchaseRecAcceptReturnList();
        List<PurchaseRecAdditionalCharges> additionalCharges = purchaseReconciliationVO.getPurchaseRecAdditionalChargesList();
        List<PurchaseRecCharge> charges = purchaseReconciliationVO.getPurchaseRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> writeOffList = purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        this.checkData(acceptReturns);
        Set taxCodeSet = acceptReturns.stream().map(PurchaseRecAcceptReturn::getTaxCode).collect(Collectors.toSet());
        Set currencySet = acceptReturns.stream().map(PurchaseRecAcceptReturn::getCurrency).collect(Collectors.toSet());
        boolean flag = false;
        for (String currency : currencySet) {
            boolean writeOffFlag = false;
            for (String taxCode : taxCodeSet) {
                reconciliation.setTaxCode(taxCode);
                reconciliation.setCurrency(currency);
                this.setTaxRate(reconciliation, taxCode);
                ArrayList<PurchaseRecAcceptReturn> recAcceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
                ArrayList<PurchaseRecAdditionalCharges> recAdditionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
                ArrayList<PurchaseRecCharge> recCharges = new ArrayList<PurchaseRecCharge>();
                ArrayList<PurchasePrePaymentWriteOffReconciliation> writeOffs = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
                BigDecimal amount = new BigDecimal(0);
                for (PurchaseRecAcceptReturn acceptReturn : acceptReturns) {
                    if (!taxCode.equals(acceptReturn.getTaxCode()) || !currency.equals(acceptReturn.getCurrency())) continue;
                    recAcceptReturns.add(acceptReturn);
                    if (acceptReturn.getDirectionBorrowing().equals("+")) {
                        amount = amount.add(acceptReturn.getTotalAmount());
                    }
                    if (!acceptReturn.getDirectionBorrowing().equals("-")) continue;
                    amount = amount.subtract(acceptReturn.getTotalAmount());
                }
                if (recAcceptReturns.isEmpty() || amount.compareTo(new BigDecimal(0)) < 0) continue;
                if (!CollectionUtils.isEmpty(additionalCharges)) {
                    for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : additionalCharges) {
                        if (!taxCode.equals(purchaseRecAdditionalCharges.getTaxCode()) || !currency.equals(purchaseRecAdditionalCharges.getCurrency())) continue;
                        recAdditionalCharges.add(purchaseRecAdditionalCharges);
                    }
                }
                if (!CollectionUtils.isEmpty(charges)) {
                    for (PurchaseRecCharge charge : charges) {
                        if (!taxCode.equals(charge.getTaxCode()) || !currency.equals(charge.getCurrency())) continue;
                        recCharges.add(charge);
                    }
                }
                if (!CollectionUtils.isEmpty(writeOffList)) {
                    for (PurchasePrePaymentWriteOffReconciliation writeOff : writeOffList) {
                        if (!currency.equals(writeOff.getCurrency())) continue;
                        writeOffs.add(writeOff);
                    }
                }
                if (!CollectionUtils.isEmpty(writeOffs) && !writeOffFlag) {
                    writeOffFlag = true;
                }
                if (flag) {
                    PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
                    BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)purchaseReconciliation));
                    purchaseReconciliation.setId(null);
                    String reconciliationNumber = this.invokeBaseRpcService.getNextCode("reconciliation", (Object)purchaseReconciliation);
                    purchaseReconciliation.setReconciliationNumber(reconciliationNumber);
                    PurchaseReconciliationVO reconciliationVO = new PurchaseReconciliationVO(recAcceptReturns, recAdditionalCharges, recCharges, writeOffs);
                    this.calculateMoney(purchaseReconciliation, reconciliationVO);
                    this.checkSettlementAmount(purchaseReconciliation);
                    this.purchaseReconciliationMapper.insert((Object)purchaseReconciliation);
                    this.insertData(purchaseReconciliation, recAcceptReturns, recAdditionalCharges, recCharges, writeOffs);
                    this.handleDocumentInfo(recAcceptReturns, purchaseReconciliation);
                    this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
                    continue;
                }
                PurchaseReconciliationVO reconciliationVO = new PurchaseReconciliationVO(recAcceptReturns, recAdditionalCharges, recCharges, writeOffs);
                this.calculateMoney(reconciliation, reconciliationVO);
                this.checkSettlementAmount(reconciliation);
                this.purchaseReconciliationMapper.updateById((Object)reconciliation);
                this.insertData(reconciliation, recAcceptReturns, recAdditionalCharges, recCharges, writeOffs);
                flag = true;
            }
        }
    }

    private void setTaxRate(PurchaseReconciliation reconciliation, String taxCode) {
        if (reconciliation.getTaxRate() != null) {
            return;
        }
        List<ElsTaxDTO> taxs = this.elsTaxService.findList(reconciliation.getElsAccount(), taxCode);
        if (CollectionUtils.isEmpty(taxs)) {
            return;
        }
        Optional taxOptional = taxs.stream().findFirst();
        if (taxOptional.isPresent()) {
            ElsTaxDTO elsTaxDTO = (ElsTaxDTO)taxOptional.get();
            reconciliation.setTaxRate(elsTaxDTO.getTaxRate());
        }
    }

    private void calculateMoney(PurchaseReconciliation reconciliation, PurchaseReconciliationVO purchaseReconciliationVO) {
        List<PurchaseRecAcceptReturn> acceptReturns = purchaseReconciliationVO.getPurchaseRecAcceptReturnList();
        List<PurchaseRecAdditionalCharges> additionalCharges = purchaseReconciliationVO.getPurchaseRecAdditionalChargesList();
        List<PurchaseRecCharge> charges = purchaseReconciliationVO.getPurchaseRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        BigDecimal deliveryIncludeTaxAmount = new BigDecimal(0);
        for (Object purchaseRecAcceptReturn : acceptReturns) {
            if (purchaseRecAcceptReturn.getDirectionBorrowing().equals("+")) {
                deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.add(purchaseRecAcceptReturn.getTotalAmount());
            }
            if (!purchaseRecAcceptReturn.getDirectionBorrowing().equals("-")) continue;
            deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.subtract(purchaseRecAcceptReturn.getTotalAmount());
        }
        reconciliation.setDeliveryIncludeTaxAmount(deliveryIncludeTaxAmount);
        BigDecimal additionalChangesAmount = new BigDecimal(0);
        for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : additionalCharges) {
            additionalChangesAmount = additionalChangesAmount.add(purchaseRecAdditionalCharges.getTotalAmount());
        }
        reconciliation.setAdditionalChangesAmount(additionalChangesAmount);
        BigDecimal chargeTotalAmount = new BigDecimal(0);
        BigDecimal chargeAmount = new BigDecimal(0);
        BigDecimal buckleTicketsAmount = new BigDecimal(0);
        for (PurchaseRecCharge purchaseRecCharge : charges) {
            chargeTotalAmount = chargeTotalAmount.add(purchaseRecCharge.getTotalAmount());
            if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) {
                chargeAmount = chargeAmount.add(purchaseRecCharge.getTotalAmount());
            }
            if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) continue;
            buckleTicketsAmount = buckleTicketsAmount.add(purchaseRecCharge.getTotalAmount());
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = deliveryIncludeTaxAmount.add(additionalChangesAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(PurchasePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        reconciliation.setWrittenOffAmount(writtenOffAmount);
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
    }

    private void insertData(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList, List<PurchaseRecCharge> purchaseRecChargeList, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        this.deleteDetail(purchaseReconciliation.getId());
        this.insertAcceptReturns(purchaseReconciliation, purchaseRecAcceptReturnList);
        this.insertAddCost(purchaseReconciliation, purchaseRecAdditionalChargesList);
        this.insertDeductCost(purchaseReconciliation, purchaseRecChargeList);
        this.insertPrePaymentWriteOff(purchaseReconciliation, prePaymentWriteOffList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.cancelAcceptReturns(id, null);
        this.cancelAdditionalCharges(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.purchaseReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (String id : idList) {
            this.deleteDetail(id);
            this.purchaseReconciliationMapper.deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public PurchaseReconciliationVO extractReconciliation(PurchaseReconciliationVO reconciliationVO) {
        String elsAccount = !StringUtils.isBlank((CharSequence)reconciliationVO.getElsAccount()) ? reconciliationVO.getElsAccount() : TenantContext.getTenant();
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = this.buildPurchaseVoucherItemDTO(reconciliationVO, elsAccount);
        List<PurchaseVoucherItemDTO> voucherItems = this.purchaseVoucherItemRpcService.selectReconciliationVoucher(purchaseVoucherItemDTO);
        if (CollectionUtils.isEmpty(voucherItems)) {
            reconciliationVO.setPurchaseRecAcceptReturnList(null);
        } else {
            List<PurchaseRecAcceptReturn> acceptReturns = this.getByPurchaseVoucherItemDTO(voucherItems);
            reconciliationVO.setPurchaseRecAcceptReturnList(acceptReturns);
        }
        ReconciliationVO targetReconciliationVO = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)targetReconciliationVO);
        List<PurchaseRecCharge> charges = this.purchaseDeductCostService.getByPurchaseDeductCost(targetReconciliationVO, elsAccount);
        reconciliationVO.setPurchaseRecChargeList(charges);
        List<PurchaseRecAdditionalCharges> additionalCharges = this.purchaseAddCostService.getByPurchaseAddCost(targetReconciliationVO, elsAccount);
        reconciliationVO.setPurchaseRecAdditionalChargesList(additionalCharges);
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.purchasePaymentApplyItemService.getPurchasePrePaymentWriteOffReconciliations(targetReconciliationVO, elsAccount);
        reconciliationVO.setPurchasePrePaymentWriteOffReconciliationList(prePaymentWriteOff);
        return reconciliationVO;
    }

    private PurchaseVoucherItemDTO buildPurchaseVoucherItemDTO(PurchaseReconciliationVO reconciliationVO, String elsAccount) {
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = new PurchaseVoucherItemDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)purchaseVoucherItemDTO);
        purchaseVoucherItemDTO.setElsAccount(elsAccount);
        purchaseVoucherItemDTO.setToElsAccount(reconciliationVO.getToElsAccount());
        purchaseVoucherItemDTO.setVoucherStatus("0");
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            purchaseVoucherItemDTO.setTaxCode(reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            purchaseVoucherItemDTO.setCurrency(reconciliationVO.getCurrency());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getToCompany())) {
            purchaseVoucherItemDTO.setToCompany(reconciliationVO.getToCompany());
        }
        return purchaseVoucherItemDTO;
    }

    public List<PurchaseRecAcceptReturn> getByPurchaseVoucherItemDTO(List<PurchaseVoucherItemDTO> voucherItems) {
        ArrayList<PurchaseRecAcceptReturn> acceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
        for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItems) {
            PurchaseRecAcceptReturn acceptReturn = new PurchaseRecAcceptReturn();
            BeanUtils.copyProperties((Object)purchaseVoucherItem, (Object)((Object)acceptReturn));
            acceptReturn.setItemType(ReconcilationItemTypeEmun.RECEIVING_REFUND.getValue());
            acceptReturn.setVoucherItemNumber(purchaseVoucherItem.getItemNumber());
            acceptReturn.setVoucherTime(purchaseVoucherItem.getVoucherDate());
            acceptReturn.setMobileType(purchaseVoucherItem.getMoveType());
            acceptReturn.setDirectionBorrowing(purchaseVoucherItem.getLoanDirection());
            acceptReturn.setPurchaseFactory(purchaseVoucherItem.getFactory());
            acceptReturn.setInventoryAddress(purchaseVoucherItem.getStorageLocation());
            acceptReturn.setInventoryAddressDesc(purchaseVoucherItem.getStorageLocationName());
            acceptReturn.setUnitQuantity(purchaseVoucherItem.getQuantityUnit());
            acceptReturn.setNoTaxUnitPrice(purchaseVoucherItem.getNetPrice());
            acceptReturn.setTaxRate(StringUtils.isNotBlank((CharSequence)purchaseVoucherItem.getTaxRate()) ? new BigDecimal(purchaseVoucherItem.getTaxRate()) : null);
            if (purchaseVoucherItem.getPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalAmount(purchaseVoucherItem.getPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            if (purchaseVoucherItem.getNetPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalNonTaxAmount(purchaseVoucherItem.getNetPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            acceptReturn.setBusinessId(purchaseVoucherItem.getId());
            acceptReturn.setId(null);
            acceptReturns.add(acceptReturn);
        }
        return acceptReturns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchaseReconciliation purchaseReconciliation, PurchaseReconciliationVO purchaseReconciliationVO) {
        ReconciliationRedisLockVO reconciliationRedisLockVO = this.redisLock(purchaseReconciliation.getToElsAccount());
        try {
            this.purchaseRecAcceptReturnService.checkAcceptReturn(purchaseReconciliationVO);
            this.purchaseRecAdditionalChargesService.checkAdditional(purchaseReconciliationVO);
            this.purchaseRecChargeService.checkReconcilationCharge(purchaseReconciliationVO);
            ReconciliationVO vo = new ReconciliationVO();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliationVO), (Object)vo);
            this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupy(vo, purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList());
            boolean flag = false;
            if (ReconciliationStatusEmun.REFUSED.getValue().equals(purchaseReconciliation.getReconciliationStatus()) && StringUtils.isNotBlank((CharSequence)purchaseReconciliation.getRelationId())) {
                flag = true;
            }
            if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchaseReconciliation.getIsTeamwork())) {
                purchaseReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
                BigDecimal closingAmount = purchaseReconciliation.getClosingAmount();
                if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                    purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
                }
                if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
                }
            } else {
                purchaseReconciliation.setReconciliationStatus(ReconciliationStatusEmun.UNCONFIRMED.getValue());
                purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.SALE_UNCONFIRMED.getValue());
            }
            purchaseReconciliation.setSendStatus("1");
            this.updateMain(purchaseReconciliation, purchaseReconciliationVO);
            this.invokeBaseRpcService.addStatusLog(purchaseReconciliation.getId(), purchaseReconciliation.getReconciliationStatus(), "reconciliation", "publish");
            String id = purchaseReconciliation.getRelationId();
            SaleReconciliation saleReconciliation = new SaleReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)((Object)saleReconciliation));
            saleReconciliation.setElsAccount(purchaseReconciliation.getToElsAccount());
            saleReconciliation.setToElsAccount(purchaseReconciliation.getElsAccount());
            saleReconciliation.setBusAccount(purchaseReconciliation.getElsAccount());
            saleReconciliation.setRelationId(purchaseReconciliation.getId());
            if (flag) {
                saleReconciliation.setId(id);
                saleReconciliation.setReconciliationStatus(purchaseReconciliation.getReconciliationStatus());
                saleReconciliation.setStatus(purchaseReconciliation.getStatus());
                this.saleReconciliationMapper.updateById((Object)saleReconciliation);
                this.handleDetail(saleReconciliation, purchaseReconciliationVO);
            } else {
                saleReconciliation.setId(null);
                this.saleReconciliationMapper.insert((Object)saleReconciliation);
                this.handleDetail(saleReconciliation, purchaseReconciliationVO);
                purchaseReconciliation.setRelationId(saleReconciliation.getId());
                this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            }
            if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchaseReconciliation.getIsTeamwork())) {
                this.handleDocument(purchaseReconciliation);
            }
            this.sendMessage(purchaseReconciliation, saleReconciliation);
        }
        catch (ELSBootException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.redisUtil.releaseDistributedLock(reconciliationRedisLockVO.getLockKey(), reconciliationRedisLockVO.getRequestId());
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hxLRW_c95760c0", (String)"\u53d1\u5e03\u6210\u529f\uff01"));
    }

    private void sendMessage(PurchaseReconciliation purchaseReconciliation, SaleReconciliation saleReconciliation) {
        String url = "id=" + saleReconciliation.getId() + "&createAccount=" + saleReconciliation.getCreateAccount();
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(purchaseReconciliation.getToElsAccount(), "1001");
        String token = JwtUtil.getOutToken((String)(elsSubAccount.getElsAccount() + "_" + elsSubAccount.getSubAccount()), (String)elsSubAccount.getPassword());
        saleReconciliation.setFbk16(serviceAddress + "/els/reconciliation/saleReconciliation/emailConfirmOrRefuesd?token=" + token + "&operation=confirm&id=" + saleReconciliation.getId());
        saleReconciliation.setFbk17(serviceAddress + "/els/reconciliation/saleReconciliation/emailConfirmOrRefuesd?token=" + token + "&operation=refused&id=" + saleReconciliation.getId());
        if (StringUtils.isNotBlank((CharSequence)purchaseReconciliation.getSalePrincipal())) {
            super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), purchaseReconciliation.getSalePrincipal(), (Object)saleReconciliation, url, "reconciliation", "publish");
        } else {
            super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "reconciliation", "publish");
        }
    }

    private MsgParamsVO parameterAssemble(PurchaseReconciliation reconciliation) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(reconciliation.getToElsAccount(), reconciliation.getSalePrincipal().split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(reconciliation.getToElsAccount(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        Map paramMap = (Map)JSON.parse((String)JSONObject.toJSON((Object)((Object)reconciliation)).toString());
        paramMap.put("userName", subAccount.getRealname());
        msgParamsVO.setParams((Object)paramMap);
        return msgParamsVO;
    }

    public void handleDetail(SaleReconciliation saleReconciliation, PurchaseReconciliationVO purchaseReconciliationVO) {
        this.saleRecAcceptReturnMapper.deleteByMainId(saleReconciliation.getId());
        this.saleRecChargeMapper.deleteByMainId(saleReconciliation.getId());
        this.saleRecAdditionalChargesMapper.deleteByMainId(saleReconciliation.getId());
        this.salePrePaymentWriteOffReconciliationMapper.deleteByMainId(saleReconciliation.getId());
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleReconciliation.getId());
        this.handleSaleRecAcceptReturnDetail(saleReconciliation, purchaseReconciliationVO.getPurchaseRecAcceptReturnList());
        this.handleSaleRecChargeDetail(saleReconciliation, purchaseReconciliationVO.getPurchaseRecChargeList());
        this.handleSaleRecAdditionalChargeDetail(saleReconciliation, purchaseReconciliationVO.getPurchaseRecAdditionalChargesList());
        this.handleSaleRecPrePaymentWriteOffDetail(saleReconciliation, purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList());
        this.handleSaleAttachmentDetail(saleReconciliation, purchaseReconciliationVO.getAttachments());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> invoiceRefusedOrConfirm(PurchaseReconciliation purchaseReconciliation, List<PurchaseInvoice> invoices, String operation) {
        String opt = "confirm";
        if ("refused".equals(operation)) {
            opt = "refund";
            purchaseReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.RENTURNED.getValue());
            purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_RENTURNED.getValue());
        } else if ("confirm".equals(operation)) {
            purchaseReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.CONFIRMED.getValue());
            purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_CONFIRMED.getValue());
            if (!CollectionUtils.isEmpty(invoices) && invoices.size() == 1) {
                PurchaseInvoiceHookVO hookVO = new PurchaseInvoiceHookVO();
                BeanUtils.copyProperties((Object)((Object)invoices.get(0)), (Object)((Object)hookVO));
                String id = purchaseReconciliation.getId();
                List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnService.selectByMainId(id);
                hookVO.setPurchaseRecAcceptReturnList(purchaseRecAcceptReturnList);
                List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(id);
                hookVO.setPurchaseRecAdditionalChargesList(purchaseRecAdditionalChargesList);
                List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(id);
                hookVO.setPurchaseRecChargeList(purchaseRecChargeList);
                List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id);
                hookVO.setPurchasePrePaymentWriteOffReconciliationList(prePaymentWriteOffList);
                this.purchaseInvoiceHookInformationService.hook(hookVO);
            }
        }
        this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.saleReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getRelationId())));
        if (saleReconciliation == null) {
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
        }
        saleReconciliation.setPurchaseInvoiceAffirmStatus(purchaseReconciliation.getPurchaseInvoiceAffirmStatus());
        saleReconciliation.setPurchaseRemark(purchaseReconciliation.getPurchaseRemark());
        saleReconciliation.setStatus(purchaseReconciliation.getStatus());
        BigDecimal invoiceTotalAmount = this.saleInvoiceService.invoiceRefusedOrConfirm(invoices, operation);
        if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            saleReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
            String url = "id=" + saleReconciliation.getId() + "&createAccount=" + saleReconciliation.getCreateAccount();
            super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), (Object)purchaseReconciliation, url, "invoice", opt);
        }
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        if ("confirm".equals(operation)) {
            this.handleInvoiceDocumentInfo(purchaseReconciliation, invoices);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    private void handleInvoiceDocumentInfo(PurchaseReconciliation purchaseReconciliation, List<PurchaseInvoice> purchaseInvoices) {
        for (PurchaseInvoice purchaseInvoice : purchaseInvoices) {
            String documentId = purchaseInvoice.getDocumentId();
            if (StringUtils.isEmpty((CharSequence)documentId)) continue;
            if (documentId.contains(",")) {
                String headId = purchaseReconciliation.getId();
                Set<String> voucherItemIds = this.listVoucherItemIdsByPurchaseRecAcceptReturn(headId);
                List<PurchaseVoucherItemDTO> purchaseVoucherItemDTOSList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(new ArrayList<String>(voucherItemIds));
                if (CollectionUtils.isEmpty(purchaseVoucherItemDTOSList)) continue;
                Set<String> voucherHeadIds = purchaseVoucherItemDTOSList.stream().map(PurchaseVoucherItemDTO::getHeadId).collect(Collectors.toSet());
                this.handlePurchaseInvoiceDocumentInfo(purchaseInvoice, purchaseReconciliation, voucherHeadIds);
                continue;
            }
            this.invokeBaseRpcService.updateIntegratedDocumentMain("invoiceId", documentId, purchaseReconciliation.getId(), purchaseInvoice.getId());
        }
    }

    private void handlePurchaseInvoiceDocumentInfo(PurchaseInvoice purchaseInvoice, PurchaseReconciliation purchaseReconciliation, Set<String> voucherHeadIds) {
        List<PurchaseVoucherHeadDTO> purchaseVoucherHeadDTOList = this.purchaseVoucherHeadLocalRpcService.listByIds(new ArrayList<String>(voucherHeadIds));
        if (CollectionUtils.isEmpty(purchaseVoucherHeadDTOList)) {
            return;
        }
        for (PurchaseVoucherHeadDTO dto : purchaseVoucherHeadDTOList) {
            String documentIdz = dto.getDocumentId();
            if (StringUtils.isEmpty((CharSequence)documentIdz) || !documentIdz.contains(",")) continue;
            List<String> documentIds = Arrays.asList(documentIdz.split(","));
            for (String documentId : documentIds) {
                this.invokeBaseRpcService.updateIntegratedDocumentMain("invoiceId", documentId, purchaseReconciliation.getId(), purchaseInvoice.getId());
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> refusedOrConfirm(PurchaseReconciliation purchaseReconciliation, String operation) {
        String opt = "confirm";
        if (OperationEnum.REFUSED.getValue().equals(operation)) {
            purchaseReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.REFUSED.getValue());
            purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.PURCHASDE_REFUSED.getValue());
            opt = "refund";
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountFromSale(purchaseReconciliation.getRelationId());
        } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            purchaseReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.COMFIRMED.getValue());
            BigDecimal closingAmount = purchaseReconciliation.getClosingAmount();
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
            }
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
            }
        }
        SaleReconciliation reconciliation = (SaleReconciliation)((Object)this.saleReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getRelationId())));
        if (reconciliation != null) {
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            SaleReconciliation saleReconciliation = new SaleReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)((Object)saleReconciliation));
            saleReconciliation.setId(reconciliation.getId());
            saleReconciliation.setElsAccount(reconciliation.getElsAccount());
            saleReconciliation.setToElsAccount(reconciliation.getToElsAccount());
            saleReconciliation.setBusAccount(reconciliation.getBusAccount());
            saleReconciliation.setRelationId(purchaseReconciliation.getId());
            saleReconciliation.setStatus(purchaseReconciliation.getStatus());
            this.saleReconciliationMapper.updateById((Object)saleReconciliation);
            String url = "id=" + saleReconciliation.getId() + "&createAccount=" + saleReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)purchaseReconciliation.getSalePrincipal())) {
                super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), purchaseReconciliation.getSalePrincipal(), (Object)purchaseReconciliation, url, "saleReconciliation", opt);
            } else {
                super.sendMsg(purchaseReconciliation.getElsAccount(), purchaseReconciliation.getToElsAccount(), (Object)purchaseReconciliation, url, "saleReconciliation", opt);
            }
            if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                this.handleDocument(purchaseReconciliation);
            }
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
        }
        throw new ELSBootException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
    }

    private void handleDocument(PurchaseReconciliation purchaseReconciliation) {
        String headId = purchaseReconciliation.getId();
        Set<String> voucherItemIds = this.listVoucherItemIdsByPurchaseRecAcceptReturn(headId);
        List<PurchaseVoucherItemDTO> purchaseVoucherItemDTOSList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(new ArrayList<String>(voucherItemIds));
        if (!CollectionUtils.isEmpty(purchaseVoucherItemDTOSList)) {
            Set<String> voucherHeadIds = purchaseVoucherItemDTOSList.stream().map(PurchaseVoucherItemDTO::getHeadId).collect(Collectors.toSet());
            this.handlePurchaseReconciliationDocumentInfo(purchaseReconciliation, voucherHeadIds);
        }
        this.handlePurchaseRecAdditionalChargesListDocumentInfo(purchaseReconciliation, headId);
        this.handlePurchaseRecChargeListDocumentInfo(purchaseReconciliation, headId);
    }

    private Set<String> listVoucherItemIdsByPurchaseRecAcceptReturn(String headId) {
        HashSet<String> voucherItemIds = new HashSet<String>();
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnService.selectByMainId(headId);
        if (CollectionUtils.isEmpty(purchaseRecAcceptReturnList)) {
            return voucherItemIds;
        }
        for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecAcceptReturn.getBusinessId())) continue;
            voucherItemIds.add(purchaseRecAcceptReturn.getBusinessId());
        }
        return voucherItemIds;
    }

    private void handlePurchaseRecChargeListDocumentInfo(PurchaseReconciliation purchaseReconciliation, String headId) {
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(headId);
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecCharge.getDocumentId())) continue;
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", purchaseRecCharge.getDocumentId(), purchaseRecCharge.getDocumentParentId(), purchaseReconciliation.getId());
        }
    }

    private void handlePurchaseRecAdditionalChargesListDocumentInfo(PurchaseReconciliation purchaseReconciliation, String headId) {
        List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(headId);
        if (CollectionUtils.isEmpty(purchaseRecAdditionalChargesList)) {
            return;
        }
        for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : purchaseRecAdditionalChargesList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecAdditionalCharges.getDocumentId())) continue;
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", purchaseRecAdditionalCharges.getDocumentId(), purchaseRecAdditionalCharges.getDocumentParentId(), purchaseReconciliation.getId());
        }
    }

    private void handlePurchaseReconciliationDocumentInfo(PurchaseReconciliation purchaseReconciliation, Set<String> voucherHeadIds) {
        List<PurchaseVoucherHeadDTO> purchaseVoucherHeadDTOList = this.purchaseVoucherHeadLocalRpcService.listByIds(new ArrayList<String>(voucherHeadIds));
        if (CollectionUtils.isEmpty(purchaseVoucherHeadDTOList)) {
            return;
        }
        for (PurchaseVoucherHeadDTO dto : purchaseVoucherHeadDTOList) {
            String documentIdz = dto.getDocumentId();
            if (StringUtils.isEmpty((CharSequence)documentIdz)) continue;
            if (documentIdz.contains(",")) {
                List<String> documentIds = Arrays.asList(documentIdz.split(","));
                for (String documentId : documentIds) {
                    this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", documentId, dto.getId(), purchaseReconciliation.getId());
                }
                continue;
            }
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", documentIdz, dto.getId(), purchaseReconciliation.getId());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)id)));
        if (purchaseReconciliation == null) {
            return;
        }
        String createAccount = purchaseReconciliation.getCreateAccount();
        String elsAccount = purchaseReconciliation.getElsAccount();
        if (!StringUtils.isEmpty((CharSequence)elsAccount) && elsAccount.equals(createAccount)) {
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountByPurchase(id);
        } else {
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountFromSale(purchaseReconciliation.getRelationId());
        }
        this.cancelReconciliation(id);
        this.cancelAcceptReturns(id, null);
        this.cancelAdditionalCharges(id, null);
        this.cancelCharges(id, null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(PurchaseReconciliation purchaseReconciliation, List<PurchaseInvoice> purchaseInvoiceList, String operation) {
        this.purchaseInvoiceMapper.deleteByMainId(purchaseReconciliation.getId());
        this.saleInvoiceMapper.deleteByMainId(purchaseReconciliation.getRelationId());
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.saleReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getRelationId())));
        this.purchaseInvoiceService.saveReconcilationInvoice(purchaseInvoiceList, purchaseReconciliation, saleReconciliation);
        purchaseReconciliation.setInvoiced("1");
        this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        saleReconciliation.setInvoiced("1");
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
    }

    @Override
    public PurchaseReconciliationVO queryReconciliationItemList(PurchaseReconciliation purchaseReconciliation, String id) {
        PurchaseReconciliationVO purchaseReconciliationVO = new PurchaseReconciliationVO();
        PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)this.purchaseInvoiceService.getById((Serializable)((Object)id)));
        String reconciliationNumber = purchaseInvoice.getReconciliationNumber();
        LambdaQueryWrapper purchaseReconciliationLambdaQueryWrapper = new LambdaQueryWrapper();
        purchaseReconciliationLambdaQueryWrapper.eq(PurchaseReconciliation::getReconciliationNumber, (Object)reconciliationNumber);
        PurchaseReconciliation purchaseReconciliations = (PurchaseReconciliation)((Object)this.getOne((Wrapper)purchaseReconciliationLambdaQueryWrapper));
        if (purchaseReconciliations == null) {
            return purchaseReconciliationVO;
        }
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnService.selectByMainId(purchaseReconciliations.getId());
        List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(purchaseReconciliations.getId());
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(purchaseReconciliations.getId());
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(purchaseReconciliations.getId());
        if (!StringUtils.isEmpty((CharSequence)purchaseReconciliations.getReconciliationNumber())) {
            PurchaseInvoiceHookVO vo = PurchaseInvoiceHookVO.builder().build();
            vo.setPurchaseRecAcceptReturnList(purchaseRecAcceptReturnList);
            vo.setPurchaseRecAdditionalChargesList(purchaseRecAdditionalChargesList);
            vo.setPurchaseRecChargeList(purchaseRecChargeList);
            vo.setPurchasePrePaymentWriteOffReconciliationList(purchasePrePaymentWriteOffList);
            this.purchaseInvoiceHookInformationService.handleBusinessList(vo, purchaseReconciliation.getReconciliationNumber());
        }
        purchaseReconciliationVO.setPurchasePrePaymentWriteOffReconciliationList(purchasePrePaymentWriteOffList);
        purchaseReconciliationVO.setPurchaseRecAdditionalChargesList(purchaseRecAdditionalChargesList);
        purchaseReconciliationVO.setPurchaseRecChargeList(purchaseRecChargeList);
        purchaseReconciliationVO.setPurchaseRecAcceptReturnList(purchaseRecAcceptReturnList);
        purchaseReconciliationVO.setHookStatus(purchaseReconciliations.getHookStatus());
        return purchaseReconciliationVO;
    }

    @Override
    public void copyData(String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)id)));
        if (purchaseReconciliation == null) {
            return;
        }
        PurchaseReconciliation newReconciliation = new PurchaseReconciliation();
        newReconciliation.setToElsAccount(purchaseReconciliation.getToElsAccount());
        newReconciliation.setCreateAccount(purchaseReconciliation.getCreateAccount());
        newReconciliation.setPurchaseName(purchaseReconciliation.getPurchaseName());
        newReconciliation.setSupplierName(purchaseReconciliation.getSupplierName());
        newReconciliation.setBeginDate(purchaseReconciliation.getBeginDate());
        newReconciliation.setEndDate(purchaseReconciliation.getEndDate());
        newReconciliation.setCompany(purchaseReconciliation.getCompany());
        newReconciliation.setPurchaseOrg(purchaseReconciliation.getPurchaseOrg());
        newReconciliation.setSupplierCode(purchaseReconciliation.getSupplierCode());
        newReconciliation.setSalePrincipalPhone(purchaseReconciliation.getSalePrincipalPhone());
        newReconciliation.setPaymentClause(purchaseReconciliation.getPaymentClause());
        newReconciliation.setPaymentClauseDesc(purchaseReconciliation.getPaymentClauseDesc());
        newReconciliation.setTaxCode(purchaseReconciliation.getTaxCode());
        newReconciliation.setTaxRate(purchaseReconciliation.getTaxRate());
        newReconciliation.setCurrency(purchaseReconciliation.getCurrency());
        newReconciliation.setExchangeRate(purchaseReconciliation.getExchangeRate());
        newReconciliation.setPayWay(purchaseReconciliation.getPayWay());
        newReconciliation.setPayCycle(purchaseReconciliation.getPayCycle());
        newReconciliation.setPurchasePrincipal(purchaseReconciliation.getPurchasePrincipal());
        newReconciliation.setSalePrincipal(purchaseReconciliation.getSalePrincipal());
        newReconciliation.setPaymentBenchmarkDate(purchaseReconciliation.getPaymentBenchmarkDate());
        newReconciliation.setPaymentExpiredate(purchaseReconciliation.getPaymentExpiredate());
        newReconciliation.setTemplateNumber(purchaseReconciliation.getTemplateNumber());
        newReconciliation.setTemplateVersion(purchaseReconciliation.getTemplateVersion());
        newReconciliation.setTemplateName(purchaseReconciliation.getTemplateName());
        newReconciliation.setTemplateAccount(purchaseReconciliation.getTemplateAccount());
        newReconciliation.setSaveForZero(purchaseReconciliation.getSaveForZero());
        newReconciliation.setChargeCurrency(purchaseReconciliation.getChargeCurrency());
        newReconciliation.setIsTeamwork(purchaseReconciliation.getIsTeamwork());
        this.saveMain(newReconciliation, new PurchaseReconciliationVO());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> hookConfirm(PurchaseReconciliation purchaseReconciliation, List<PurchaseInvoice> invoices) {
        PurchaseReconciliation reconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getId())));
        if (reconciliation == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_field_YxuIetVH_ba87ff35", (String)"\u627e\u4e0d\u5230\u5bf9\u8d26\u5355\u4fe1\u606f"));
        }
        if (ReconciliationHookStatusEnum.CONFIRM.getValue().equals(reconciliation.getHookStatus())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_tFIRLRt_45d3a84e", (String)"\u5355\u636e\u5df2\u786e\u8ba4\u52fe\u7a3d"));
        }
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)reconciliationVO);
        this.purchaseDeliveryWaterService.handleWaterData(invoices, reconciliationVO);
        reconciliation.setHookStatus(ReconciliationHookStatusEnum.CONFIRM.getValue());
        this.updateById((Object)reconciliation);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    public JSONObject getRequestDataById(String id) {
        PurchaseReconciliationVO purchaseReconciliationVO = this.getMessageById(id);
        Result result = Result.ok((Object)((Object)purchaseReconciliationVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getRequestDataById(List<String> ids) {
        ArrayList headVOArrayList = new ArrayList();
        ids.forEach(id -> headVOArrayList.add(this.getMessageById((String)id)));
        Result result = Result.ok(headVOArrayList);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONArray)result.getResult();
    }

    private PurchaseReconciliationVO getMessageById(String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.getById((Serializable)((Object)id)));
        PurchaseReconciliationVO purchaseReconciliationVO = new PurchaseReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)((Object)purchaseReconciliationVO));
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnMapper.selectByMainId(id);
        purchaseReconciliationVO.setPurchaseRecAcceptReturnList(purchaseRecAcceptReturnList);
        return purchaseReconciliationVO;
    }

    private void deleteDetail(String id) {
        this.purchaseRecAcceptReturnService.deleteByMainId(id);
        this.purchaseRecAdditionalChargesService.deleteByMainId(id);
        this.purchaseRecChargeService.deleteByMainId(id);
        this.purchaseInvoiceMapper.deleteByMainId(id);
        this.purchasePrePaymentWriteOffReconciliationService.deleteByMainId(id);
    }

    private void insertDeductCost(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge entity : purchaseRecChargeList) {
            entity.setHeadId(purchaseReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseReconciliation);
            entity.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            ++itemNumber;
        }
        this.purchaseRecChargeService.saveBatch(purchaseRecChargeList, 2000);
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertAddCost(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList) {
        if (CollectionUtils.isEmpty(purchaseRecAdditionalChargesList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
        ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
        for (PurchaseRecAdditionalCharges entity : purchaseRecAdditionalChargesList) {
            entity.setHeadId(purchaseReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseReconciliation);
            entity.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)entity.getBusinessId())));
            addCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            addCost.setCostStatus("1");
            addCost.setDocumentId(entity.getDocumentId());
            addCosts.add(addCost);
            SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)addCost.getRelationId())));
            saleAddCost.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            saleAddCost.setCostStatus("1");
            saleAddCost.setDocumentId(entity.getDocumentId());
            saleAddCosts.add(saleAddCost);
            ++itemNumber;
        }
        if (!purchaseRecAdditionalChargesList.isEmpty()) {
            this.purchaseRecAdditionalChargesService.saveBatch(purchaseRecAdditionalChargesList, 2000);
        }
        if (!addCosts.isEmpty()) {
            this.purchaseAddCostService.updateBatchById(addCosts);
        }
        if (!saleAddCosts.isEmpty()) {
            this.saleAddCostService.updateBatchById(saleAddCosts);
        }
    }

    private void insertAcceptReturns(PurchaseReconciliation purchaseReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList) {
        if (CollectionUtils.isEmpty(purchaseRecAcceptReturnList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
        Date date = new Date();
        for (PurchaseRecAcceptReturn entity : purchaseRecAcceptReturnList) {
            entity.setHeadId(purchaseReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseReconciliation);
            entity.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            BigDecimal totalAmount = entity.getTotalAmount();
            BigDecimal totalNonTaxAmount = entity.getTotalNonTaxAmount();
            if (totalAmount != null && totalNonTaxAmount != null) {
                BigDecimal taxAmount = totalAmount.subtract(totalNonTaxAmount);
                entity.setTaxAmount(taxAmount);
            }
            PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(entity.getBusinessId());
            voucherItem.setReconciliation("1");
            voucherItem.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            voucherItem.setPostDate(date);
            voucherItems.add(voucherItem);
            ++itemNumber;
        }
        if (!purchaseRecAcceptReturnList.isEmpty()) {
            this.purchaseRecAcceptReturnService.saveBatch(purchaseRecAcceptReturnList, 2000);
        }
        if (!voucherItems.isEmpty()) {
            this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
        }
    }

    private void cancelAcceptReturns(String purchaseReconciliationId, List<String> existIds) {
        List<PurchaseRecAcceptReturn> acceptReturns = this.purchaseRecAcceptReturnService.selectByMainId(purchaseReconciliationId);
        if (CollectionUtils.isEmpty(acceptReturns)) {
            return;
        }
        ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
        for (PurchaseRecAcceptReturn acceptReturn : acceptReturns) {
            PurchaseVoucherItemDTO voucherItem;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(acceptReturn.getBusinessId()) || (voucherItem = this.purchaseVoucherItemRpcService.getById(acceptReturn.getBusinessId())) == null) continue;
            voucherItem.setReconciliation("0");
            voucherItem.setReconciliationNumber(null);
            voucherItems.add(voucherItem);
        }
        if (!voucherItems.isEmpty()) {
            this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
        }
    }

    private void cancelReconciliation(String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)id)));
        purchaseReconciliation.setCancellation("1");
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseReconciliation.setCancellationName(loginUser.getRealname());
        purchaseReconciliation.setCancellationSubAccount(loginUser.getSubAccount());
        purchaseReconciliation.setCancellationTime(new Date());
        purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.RENTURNED.getValue());
        this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.saleReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getRelationId())));
        saleReconciliation.setCancellation("1");
        saleReconciliation.setCancellationName(purchaseReconciliation.getCancellationName());
        saleReconciliation.setCancellationSubAccount(purchaseReconciliation.getCancellationSubAccount());
        saleReconciliation.setCancellationTime(purchaseReconciliation.getCancellationTime());
        saleReconciliation.setStatus(purchaseReconciliation.getStatus());
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
    }

    private void cancelCharges(String purchaseReconciliationId, List<String> existIds) {
        List<PurchaseRecCharge> charges = this.purchaseRecChargeService.selectByMainId(purchaseReconciliationId);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge charge : charges) {
            SaleDeductCost saleDeductCost;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId())) continue;
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            if (deductCost != null) {
                deductCost.setDeductStatus("0");
                deductCost.setReconciliationNumber(null);
                deductCosts.add(deductCost);
                saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
                saleDeductCost.setDeductStatus("0");
                saleDeductCost.setReconciliationNumber(null);
                saleDeductCosts.add(saleDeductCost);
            }
            if ((saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())))) == null) continue;
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            purchaseDeductCost.setDeductStatus("0");
            purchaseDeductCost.setReconciliationNumber(null);
            deductCosts.add(purchaseDeductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void cancelAdditionalCharges(String purchaseReconciliationId, List<String> existIds) {
        List<PurchaseRecAdditionalCharges> additionalCharges = this.purchaseRecAdditionalChargesService.selectByMainId(purchaseReconciliationId);
        if (CollectionUtils.isEmpty(additionalCharges)) {
            return;
        }
        ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
        ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
        for (PurchaseRecAdditionalCharges recAdditionalCharges : additionalCharges) {
            SaleAddCost saleAddCost;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(recAdditionalCharges.getBusinessId())) continue;
            PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())));
            if (addCost != null) {
                addCost.setCostStatus("0");
                addCost.setReconciliationNumber(null);
                addCosts.add(addCost);
                saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)addCost.getRelationId())));
                saleAddCost.setReconciliationNumber(null);
                saleAddCost.setCostStatus("0");
                saleAddCosts.add(saleAddCost);
            }
            if ((saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())))) == null) continue;
            saleAddCost.setCostStatus("0");
            saleAddCost.setReconciliationNumber(null);
            saleAddCosts.add(saleAddCost);
            PurchaseAddCost purchaseAddCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
            purchaseAddCost.setReconciliationNumber(null);
            purchaseAddCost.setCostStatus("0");
            addCosts.add(purchaseAddCost);
        }
        if (!addCosts.isEmpty()) {
            this.purchaseAddCostService.updateBatchById(addCosts);
        }
        if (!saleAddCosts.isEmpty()) {
            this.saleAddCostService.updateBatchById(saleAddCosts);
        }
    }

    private void handleSaleAttachmentDetail(SaleReconciliation saleReconciliation, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleReconciliation.getElsAccount());
            saleAttachment.setHeadId(saleReconciliation.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void handleSaleRecAdditionalChargeDetail(SaleReconciliation saleReconciliation, List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList) {
        if (CollectionUtils.isEmpty(purchaseRecAdditionalChargesList)) {
            return;
        }
        ArrayList<SaleRecAdditionalCharges> saleRecAdditionalCharges = new ArrayList<SaleRecAdditionalCharges>();
        for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : purchaseRecAdditionalChargesList) {
            SaleRecAdditionalCharges saleRecAdditionalCharge = new SaleRecAdditionalCharges();
            BeanUtils.copyProperties((Object)((Object)purchaseRecAdditionalCharges), (Object)((Object)saleRecAdditionalCharge));
            saleRecAdditionalCharge.setId(null);
            saleRecAdditionalCharge.setElsAccount(saleReconciliation.getElsAccount());
            saleRecAdditionalCharge.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecAdditionalCharge.setBusAccount(saleReconciliation.getToElsAccount());
            saleRecAdditionalCharge.setHeadId(saleReconciliation.getId());
            saleRecAdditionalCharge.setRelationId(purchaseRecAdditionalCharges.getId());
            saleRecAdditionalCharges.add(saleRecAdditionalCharge);
        }
        this.saleRecAdditionalChargesMapper.insertBatchSomeColumn(saleRecAdditionalCharges);
    }

    private void handleSaleRecPrePaymentWriteOffDetail(SaleReconciliation saleReconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        ArrayList<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = new ArrayList<SalePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation purchasePrePaymentWriteOff : prePaymentWriteOffList) {
            SalePrePaymentWriteOffReconciliation salePrePaymentWriteOff = new SalePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchasePrePaymentWriteOff), (Object)((Object)salePrePaymentWriteOff));
            salePrePaymentWriteOff.setId(null);
            salePrePaymentWriteOff.setElsAccount(saleReconciliation.getElsAccount());
            salePrePaymentWriteOff.setToElsAccount(saleReconciliation.getToElsAccount());
            salePrePaymentWriteOff.setBusAccount(saleReconciliation.getBusAccount());
            salePrePaymentWriteOff.setHeadId(saleReconciliation.getId());
            salePrePaymentWriteOff.setRelationId(purchasePrePaymentWriteOff.getId());
            salePrePaymentWriteOffList.add(salePrePaymentWriteOff);
        }
        this.salePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(salePrePaymentWriteOffList);
    }

    private void handleSaleRecChargeDetail(SaleReconciliation saleReconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        ArrayList<SaleRecCharge> saleRecCharges = new ArrayList<SaleRecCharge>();
        for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
            SaleRecCharge saleRecCharge = new SaleRecCharge();
            BeanUtils.copyProperties((Object)((Object)purchaseRecCharge), (Object)((Object)saleRecCharge));
            saleRecCharge.setId(null);
            saleRecCharge.setElsAccount(saleReconciliation.getElsAccount());
            saleRecCharge.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecCharge.setBusAccount(saleReconciliation.getBusAccount());
            saleRecCharge.setHeadId(saleReconciliation.getId());
            saleRecCharge.setRelationId(purchaseRecCharge.getId());
            saleRecCharges.add(saleRecCharge);
        }
        this.saleRecChargeMapper.insertBatchSomeColumn(saleRecCharges);
    }

    private void handleSaleRecAcceptReturnDetail(SaleReconciliation saleReconciliation, List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList) {
        if (CollectionUtils.isEmpty(purchaseRecAcceptReturnList)) {
            return;
        }
        ArrayList<SaleRecAcceptReturn> saleRecAcceptReturns = new ArrayList<SaleRecAcceptReturn>();
        for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : purchaseRecAcceptReturnList) {
            SaleRecAcceptReturn saleRecAcceptReturn = new SaleRecAcceptReturn();
            BeanUtils.copyProperties((Object)((Object)purchaseRecAcceptReturn), (Object)((Object)saleRecAcceptReturn));
            saleRecAcceptReturn.setId(null);
            saleRecAcceptReturn.setElsAccount(saleReconciliation.getElsAccount());
            saleRecAcceptReturn.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecAcceptReturn.setBusAccount(saleReconciliation.getBusAccount());
            saleRecAcceptReturn.setHeadId(saleReconciliation.getId());
            saleRecAcceptReturn.setRelationId(purchaseRecAcceptReturn.getId());
            saleRecAcceptReturns.add(saleRecAcceptReturn);
        }
        this.saleRecAcceptReturnMapper.insertBatchSomeColumn(saleRecAcceptReturns);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseReconciliation", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseReconciliationList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseReconciliation reconciliation : purchaseReconciliationList) {
            this.pushDataToErp(reconciliation);
        }
    }

    private void pushDataToErp(PurchaseReconciliation reconciliation) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseReconciliation", (Object)reconciliation);
    }

    private ReconciliationRedisLockVO redisLock(String elsAccount) {
        String lockKey;
        String requestId = UUID.randomUUID().toString();
        if (StringUtils.isBlank((CharSequence)elsAccount)) {
            elsAccount = requestId;
        }
        if (!this.redisUtil.tryGetDistributedLock(lockKey = LOCK_KEY_PRIFFIX + elsAccount, requestId, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APRdXAvjDiKtkIeWVRSKKW_a59a17ea", (String)"\u5f53\u524d\u4f9b\u5e94\u5546\u5176\u4ed6\u7528\u6237\u6b63\u5728\u64cd\u4f5c\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01"));
        }
        return new ReconciliationRedisLockVO(lockKey, requestId);
    }
}

