/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.SaleRecContractPromise;
import com.els.modules.reconciliation.mapper.SaleRecContractPromiseMapper;
import com.els.modules.reconciliation.service.SaleRecContractPromiseService;
import com.els.modules.reconciliation.vo.SalePerformanceReconciliationVO;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleRecContractPromiseServiceImpl
extends BaseServiceImpl<SaleRecContractPromiseMapper, SaleRecContractPromise>
implements SaleRecContractPromiseService {
    @Override
    public void add(SaleRecContractPromise saleRecContractPromise) {
        ((SaleRecContractPromiseMapper)this.baseMapper).insert((Object)saleRecContractPromise);
    }

    @Override
    public void edit(SaleRecContractPromise saleRecContractPromise) {
        int count = ((SaleRecContractPromiseMapper)this.baseMapper).updateById((Object)saleRecContractPromise);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleRecContractPromiseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleRecContractPromiseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<SaleRecContractPromise> selectByMainId(String id) {
        return ((SaleRecContractPromiseMapper)this.baseMapper).selectByMainId(id);
    }

    @Override
    public void deleteByMainId(String id) {
        ((SaleRecContractPromiseMapper)this.baseMapper).deleteByMainId(id);
    }

    @Override
    public void checkPromise(SalePerformanceReconciliationVO saleReconciliationVO) {
        List<SaleRecContractPromise> recContractPromiseList = saleReconciliationVO.getSaleRecContractPromiseList();
        if (CollectionUtil.isEmpty(recContractPromiseList)) {
            return;
        }
        Set<String> promiseNumbers = recContractPromiseList.stream().map(SaleRecContractPromise::getPromiseNumber).collect(Collectors.toSet());
        List<SaleRecContractPromise> items = ((SaleRecContractPromiseMapper)this.baseMapper).checkHasReconcilationed(promiseNumbers);
        if (CollectionUtil.isEmpty(items)) {
            return;
        }
        List<SaleRecContractPromise> resultList = this.getIntersection(recContractPromiseList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = saleReconciliationVO.getReconciliationNumber().replace("PPR", "").replace("SPR", "").replace("SR", "").replace("PR", "");
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<SaleRecContractPromise> sourceList = this.getIntersection(resultList, recContractPromiseList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            SaleRecContractPromise saleRecContractPromise = (SaleRecContractPromise)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_neIZtWTyWWWWWIhxIeWVQG_e2d5b71c", (String)"\u5408\u540c\u5c65\u7ea6\u5355 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{saleRecContractPromise.getItemNumber()}));
        }
    }

    private List<SaleRecContractPromise> getIntersection(List<SaleRecContractPromise> targetList, List<SaleRecContractPromise> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(e -> e.getPromiseNumber() + "&" + e.getPromiseNumberItem()).collect(Collectors.toList()).contains(item.getPromiseNumber() + "&" + item.getPromiseNumberItem())).collect(Collectors.toList());
    }
}

