/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.confirm.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmation;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.entity.SaleReconciliationConfirmation;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationBookBalanceService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationDifferenceDescriptionService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationUnpaidAccountService;
import com.els.modules.confirm.service.SaleReconciliationConfirmationService;
import com.els.modules.delivery.api.dto.PurchaseReconciliationConfirmationDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.finance.api.enumerate.ConfirmEsignStatusEnum;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.enumerate.ConfirmElectronicSignStatusEmun;
import com.els.modules.reconciliation.enumerate.ConfirmUnpaidAccountItemStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationConfirmStatusEnum;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.vo.SaleReconciliationConfirmationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleReconciliationConfirmationServiceImpl
extends BaseServiceImpl<SaleReconciliationConfirmationMapper, SaleReconciliationConfirmation>
implements SaleReconciliationConfirmationService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseReconciliationConfirmationMapper purchaseReconciliationConfirmationMapper;
    @Resource
    private SaleReconciliationConfirmationMapper saleReconciliationConfirmationMapper;
    @Resource
    private SaleReconciliationConfirmationBookBalanceMapper saleReconciliationConfirmationBookBalanceMapper;
    @Resource
    private SaleReconciliationConfirmationUnpaidAccountMapper saleReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private SaleReconciliationConfirmationDifferenceDescriptionMapper saleReconciliationConfirmationDifferenceDescriptionMapper;
    @Resource
    private PurchaseReconciliationConfirmationBookBalanceMapper purchaseReconciliationConfirmationBookBalanceMapper;
    @Resource
    private PurchaseReconciliationConfirmationUnpaidAccountMapper purchaseReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private PurchaseReconciliationConfirmationDifferenceDescriptionMapper purchaseReconciliationConfirmationDifferenceDescriptionMapper;
    @Autowired
    private PurchaseReconciliationConfirmationBookBalanceService purchaseReconciliationConfirmationBookBalanceService;
    @Autowired
    private PurchaseReconciliationConfirmationUnpaidAccountService purchaseReconciliationConfirmationUnpaidAccountService;
    @Autowired
    private PurchaseReconciliationConfirmationDifferenceDescriptionService purchaseReconciliationConfirmationDifferenceDescriptionService;
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Autowired
    private StaticConfig staticConfig;
    @Resource
    private TemplateRpcService templateHeadService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private PurchaseVoucherItemLocalRpcService purchaseVoucherItemRpcService;

    @Override
    public void add(SaleReconciliationConfirmation saleReconciliationConfirmation) {
        ((SaleReconciliationConfirmationMapper)this.baseMapper).insert((Object)saleReconciliationConfirmation);
    }

    @Override
    public void edit(SaleReconciliationConfirmation saleReconciliationConfirmation) {
        int count = ((SaleReconciliationConfirmationMapper)this.baseMapper).updateById((Object)saleReconciliationConfirmation);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleReconciliationConfirmationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(id);
        List<SaleReconciliationConfirmationUnpaidAccount> accountList = this.saleReconciliationConfirmationUnpaidAccountMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (SaleReconciliationConfirmationUnpaidAccount unpaidAccount : accountList) {
            String businessNumber = unpaidAccount.getBusinessNumbers();
            if (StringUtils.isEmpty((CharSequence)businessNumber) || !businessNumber.contains(",")) continue;
            List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
            this.releaseConfirmStatus(businessNumbers);
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleReconciliationConfirmationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SaleReconciliationConfirmation saleReconciliationConfirmation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            saleReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            saleReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
            opt = "refund";
        }
        this.updateById((Object)saleReconciliationConfirmation);
        this.invokeBaseRpcService.addStatusLog(saleReconciliationConfirmation.getRelationId(), saleReconciliationConfirmation.getPreparedByStatus(), "saleReconciliationConfirmation", opt);
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = (PurchaseReconciliationConfirmation)((Object)this.purchaseReconciliationConfirmationMapper.selectById((Serializable)((Object)saleReconciliationConfirmation.getRelationId())));
        if (purchaseReconciliationConfirmation != null) {
            purchaseReconciliationConfirmation.setPreparedByStatus(saleReconciliationConfirmation.getPreparedByStatus());
            purchaseReconciliationConfirmation.setRemark(saleReconciliationConfirmation.getRemark());
            purchaseReconciliationConfirmation.setRelationId(saleReconciliationConfirmation.getId());
            this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
            String url = "id=" + saleReconciliationConfirmation.getId();
            if (StringUtils.isNotBlank((CharSequence)purchaseReconciliationConfirmation.getSupplierName())) {
                super.sendMsg(purchaseReconciliationConfirmation.getElsAccount(), purchaseReconciliationConfirmation.getToElsAccount(), purchaseReconciliationConfirmation.getSupplierName(), (Object)purchaseReconciliationConfirmation, url, "saleReconciliationConfirmation", opt);
            } else {
                super.sendMsg(purchaseReconciliationConfirmation.getElsAccount(), purchaseReconciliationConfirmation.getToElsAccount(), (Object)purchaseReconciliationConfirmation, url, "saleReconciliationConfirmation", opt);
            }
        } else {
            throw new RuntimeException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void opponentConfirm(SaleReconciliationConfirmation saleReconciliationConfirmation) {
        String opt = "confirm";
        List<SaleReconciliationConfirmationDifferenceDescription> saleDescriptionList = this.saleReconciliationConfirmationDifferenceDescriptionMapper.selectByMainId(saleReconciliationConfirmation.getId());
        List<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList = this.saleReconciliationConfirmationBookBalanceMapper.selectByMainId(saleReconciliationConfirmation.getId());
        List<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList = this.saleReconciliationConfirmationUnpaidAccountMapper.selectByMainId(saleReconciliationConfirmation.getId());
        if (CollectionUtils.isEmpty(saleDescriptionList)) {
            saleReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
        } else {
            saleReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue());
        }
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = (PurchaseReconciliationConfirmation)((Object)this.purchaseReconciliationConfirmationMapper.selectById((Serializable)((Object)saleReconciliationConfirmation.getRelationId())));
        this.asyBalance(saleReconciliationConfirmationBookBalanceList);
        this.asyUnpaidAccount(saleReconciliationConfirmationUnpaidAccountList);
        this.handlePurchaseReconciliationConfirmationDifferenceDescription(purchaseReconciliationConfirmation, saleDescriptionList);
        this.updateById((Object)saleReconciliationConfirmation);
        this.invokeBaseRpcService.addStatusLog(saleReconciliationConfirmation.getRelationId(), saleReconciliationConfirmation.getPreparedByStatus(), "purchaseReconciliationConfirmation", opt);
        if (purchaseReconciliationConfirmation != null) {
            purchaseReconciliationConfirmation.setPreparedByStatus(saleReconciliationConfirmation.getPreparedByStatus());
            purchaseReconciliationConfirmation.setRemark(saleReconciliationConfirmation.getRemark());
            purchaseReconciliationConfirmation.setRelationId(saleReconciliationConfirmation.getId());
            this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
        }
    }

    @Override
    public List<PurchaseReconciliationConfirmationUnpaidAccount> extractUnPaidAccountItem(SaleReconciliationConfirmationVO saleReconciliationConfirmationVO) {
        ArrayList<PurchaseReconciliationConfirmationUnpaidAccount> result = new ArrayList<PurchaseReconciliationConfirmationUnpaidAccount>();
        if (StringUtils.isEmpty((CharSequence)saleReconciliationConfirmationVO.getLocalCurrency())) {
            saleReconciliationConfirmationVO.setLocalCurrency("CNY");
        }
        if (StringUtils.isEmpty((CharSequence)saleReconciliationConfirmationVO.getToLocalCurrency())) {
            saleReconciliationConfirmationVO.setToLocalCurrency("CNY");
        }
        this.extractReconciliationPreparationConfirmAmount(saleReconciliationConfirmationVO, result);
        this.extractUnReconciliationConfirmationAmount(saleReconciliationConfirmationVO, result);
        return result;
    }

    private void extractReconciliationPreparationConfirmAmount(SaleReconciliationConfirmationVO saleReconciliationConfirmationVO, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        List<PurchasePerformanceReconciliation> purchasePerformanceReconciliationList;
        BigDecimal reconciliationPreparationConfirmAmount = BigDecimal.ZERO;
        ArrayList<String> businessNumbers = new ArrayList<String>();
        List<PurchaseReconciliation> purchaseReconciliationList = this.purchaseReconciliationMapper.saleListReconciliationByConfirm(saleReconciliationConfirmationVO);
        if (!CollectionUtils.isEmpty(purchaseReconciliationList)) {
            for (Object purchaseReconciliation : purchaseReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchaseReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchaseReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)saleReconciliationConfirmationVO.getPreparedByNumber()) && !saleReconciliationConfirmationVO.getPreparedByNumber().equals(purchaseReconciliation.getConfirmNumber());
                if (flag) continue;
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
                businessNumbers.add(purchaseReconciliation.getReconciliationNumber());
            }
        }
        if (!CollectionUtils.isEmpty(purchasePerformanceReconciliationList = this.purchasePerformanceReconciliationMapper.saleListReconciliationByConfirm(saleReconciliationConfirmationVO))) {
            for (PurchasePerformanceReconciliation purchasePerformanceReconciliation : purchasePerformanceReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchasePerformanceReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchasePerformanceReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchasePerformanceReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)saleReconciliationConfirmationVO.getPreparedByNumber()) && !saleReconciliationConfirmationVO.getPreparedByNumber().equals(purchasePerformanceReconciliation.getConfirmNumber());
                if (flag) continue;
                businessNumbers.add(purchasePerformanceReconciliation.getReconciliationNumber());
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
            }
        }
        PurchaseReconciliationConfirmationUnpaidAccount unReconciliationConfirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        unReconciliationConfirmationUnpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue());
        unReconciliationConfirmationUnpaidAccount.setPreparationConfirmAmount(reconciliationPreparationConfirmAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        unReconciliationConfirmationUnpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(unReconciliationConfirmationUnpaidAccount);
    }

    private void extractUnReconciliationConfirmationAmount(SaleReconciliationConfirmationVO saleReconciliationConfirmationVO, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        ArrayList<String> businessNumbers = new ArrayList<String>();
        PurchaseReconciliationConfirmationDTO dto = new PurchaseReconciliationConfirmationDTO();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationConfirmationVO), (Object)dto);
        String elsAccount = dto.getElsAccount();
        dto.setElsAccount(dto.getToElsAccount());
        dto.setToElsAccount(elsAccount);
        List<PurchaseVoucherItemDTO> voucherItemList = this.purchaseVoucherItemRpcService.saleSelectConfirmVoucher(dto);
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(voucherItemList)) {
            for (PurchaseVoucherItemDTO purchaseVoucherItemDTO : voucherItemList) {
                boolean flag;
                BigDecimal dtoTaxAmount = purchaseVoucherItemDTO.getTaxAmount() == null ? BigDecimal.ZERO : purchaseVoucherItemDTO.getTaxAmount();
                if (BigDecimal.ZERO.compareTo(dtoTaxAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchaseVoucherItemDTO.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)saleReconciliationConfirmationVO.getPreparedByNumber()) && !saleReconciliationConfirmationVO.getPreparedByNumber().equals(purchaseVoucherItemDTO.getConfirmNumber());
                if (flag) continue;
                businessNumbers.add(purchaseVoucherItemDTO.getVoucherNumber());
                if ("-".equals(purchaseVoucherItemDTO.getLoanDirection())) {
                    taxAmount = taxAmount.subtract(dtoTaxAmount);
                    continue;
                }
                if (!"+".equals(purchaseVoucherItemDTO.getLoanDirection())) continue;
                taxAmount = taxAmount.add(dtoTaxAmount);
            }
        }
        PurchaseReconciliationConfirmationUnpaidAccount confirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        confirmationUnpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue());
        confirmationUnpaidAccount.setPreparationConfirmAmount(taxAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        confirmationUnpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(confirmationUnpaidAccount);
    }

    private void asyBalance(List<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList) {
        HashMap<String, SaleReconciliationConfirmationBookBalance> balanceMap = new HashMap<String, SaleReconciliationConfirmationBookBalance>();
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationBookBalanceList)) {
            return;
        }
        Set balanceIds = saleReconciliationConfirmationBookBalanceList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(SaleReconciliationConfirmationBookBalance::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(balanceIds)) {
            return;
        }
        List purchaseReconciliationConfirmationBookBalanceList = this.purchaseReconciliationConfirmationBookBalanceMapper.selectBatchIds(balanceIds);
        if (CollectionUtils.isEmpty((Collection)purchaseReconciliationConfirmationBookBalanceList)) {
            return;
        }
        for (SaleReconciliationConfirmationBookBalance saleReconciliationConfirmationBookBalance : saleReconciliationConfirmationBookBalanceList) {
            balanceMap.put(saleReconciliationConfirmationBookBalance.getRelationId(), saleReconciliationConfirmationBookBalance);
        }
        for (PurchaseReconciliationConfirmationBookBalance purchaseReconciliationConfirmationBookBalance : purchaseReconciliationConfirmationBookBalanceList) {
            SaleReconciliationConfirmationBookBalance saleBalance = (SaleReconciliationConfirmationBookBalance)((Object)balanceMap.get(purchaseReconciliationConfirmationBookBalance.getId()));
            if (saleBalance == null) continue;
            purchaseReconciliationConfirmationBookBalance.setDifferenceAmount(saleBalance.getDifferenceAmount());
            purchaseReconciliationConfirmationBookBalance.setOpponentConfirmAmount(saleBalance.getOpponentConfirmAmount());
        }
        this.purchaseReconciliationConfirmationBookBalanceService.updateBatchById(purchaseReconciliationConfirmationBookBalanceList);
    }

    private void asyUnpaidAccount(List<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList) {
        HashMap<String, SaleReconciliationConfirmationUnpaidAccount> unpaidAccountMap = new HashMap<String, SaleReconciliationConfirmationUnpaidAccount>();
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        Set unpaidAccountIds = saleReconciliationConfirmationUnpaidAccountList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(SaleReconciliationConfirmationUnpaidAccount::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(unpaidAccountIds)) {
            return;
        }
        List purchaseReconciliationConfirmationUnpaidAccountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectBatchIds(unpaidAccountIds);
        if (CollectionUtils.isEmpty((Collection)purchaseReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        for (SaleReconciliationConfirmationUnpaidAccount saleReconciliationConfirmationUnpaidAccount : saleReconciliationConfirmationUnpaidAccountList) {
            unpaidAccountMap.put(saleReconciliationConfirmationUnpaidAccount.getRelationId(), saleReconciliationConfirmationUnpaidAccount);
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount purchaseReconciliationConfirmationUnpaidAccount : purchaseReconciliationConfirmationUnpaidAccountList) {
            SaleReconciliationConfirmationUnpaidAccount saleUnpaidAccount = (SaleReconciliationConfirmationUnpaidAccount)((Object)unpaidAccountMap.get(purchaseReconciliationConfirmationUnpaidAccount.getId()));
            if (saleUnpaidAccount == null) continue;
            purchaseReconciliationConfirmationUnpaidAccount.setDifferenceAmount(saleUnpaidAccount.getDifferenceAmount());
            purchaseReconciliationConfirmationUnpaidAccount.setOpponentConfirmAmount(saleUnpaidAccount.getOpponentConfirmAmount());
        }
        this.purchaseReconciliationConfirmationUnpaidAccountService.updateBatchById(purchaseReconciliationConfirmationUnpaidAccountList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(SaleReconciliationConfirmation saleReconciliationConfirmation, SaleReconciliationConfirmationVO saleReconciliationConfirmationVO) {
        Boolean flag = false;
        if (ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue().equals(saleReconciliationConfirmation.getPreparedByStatus()) && StringUtils.isNotBlank((CharSequence)saleReconciliationConfirmation.getRelationId())) {
            flag = true;
        }
        saleReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
        this.updateMain(saleReconciliationConfirmation, saleReconciliationConfirmationVO);
        this.invokeBaseRpcService.addStatusLog(saleReconciliationConfirmation.getRelationId(), saleReconciliationConfirmation.getPreparedByStatus(), "saleReconciliationConfirmation", "publish");
        String id = saleReconciliationConfirmation.getRelationId();
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationConfirmation), (Object)((Object)purchaseReconciliationConfirmation));
        purchaseReconciliationConfirmation.setElsAccount(saleReconciliationConfirmation.getToElsAccount());
        purchaseReconciliationConfirmation.setToElsAccount(saleReconciliationConfirmation.getElsAccount());
        purchaseReconciliationConfirmation.setRelationId(saleReconciliationConfirmation.getId());
        if (flag.booleanValue()) {
            purchaseReconciliationConfirmation.setId(id);
            purchaseReconciliationConfirmation.setPreparedByStatus(purchaseReconciliationConfirmation.getPreparedByStatus());
            this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
            this.handleDetail(purchaseReconciliationConfirmation, saleReconciliationConfirmationVO);
        } else {
            purchaseReconciliationConfirmation.setId(id);
            this.purchaseReconciliationConfirmationMapper.insert((Object)purchaseReconciliationConfirmation);
            this.handleDetail(purchaseReconciliationConfirmation, saleReconciliationConfirmationVO);
            saleReconciliationConfirmation.setRelationId(purchaseReconciliationConfirmation.getId());
        }
        this.sendMessage(saleReconciliationConfirmation, purchaseReconciliationConfirmation);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hxLRW_c95760c0", (String)"\u53d1\u5e03\u6210\u529f\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleReconciliationConfirmation saleReconciliationConfirmation, SaleReconciliationConfirmationVO saleReconciliationConfirmationVO) {
        this.buildReconciliationConfirmation(saleReconciliationConfirmation);
        this.saleReconciliationConfirmationMapper.insert((Object)saleReconciliationConfirmation);
        this.insertReconciliationConfirmationBookBalance(saleReconciliationConfirmation, saleReconciliationConfirmationVO.getBalance());
        this.insertReconciliationConfirmationDifferenceDescription(saleReconciliationConfirmation, saleReconciliationConfirmationVO.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(saleReconciliationConfirmation, saleReconciliationConfirmationVO.getUnpaidAccountItem());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleReconciliationConfirmation saleReconciliationConfirmation, SaleReconciliationConfirmationVO saleReconciliationConfirmationVO) {
        if ("0".equals(saleReconciliationConfirmation.getSign())) {
            saleReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            saleReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(saleReconciliationConfirmation.getSign())) {
            saleReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            saleReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
        this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
        this.saleReconciliationConfirmationBookBalanceMapper.deleteByMainId(saleReconciliationConfirmation.getId());
        this.saleReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(saleReconciliationConfirmation.getId());
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(saleReconciliationConfirmation.getId());
        List<SaleReconciliationConfirmationUnpaidAccount> unpaidAccountItem = saleReconciliationConfirmationVO.getUnpaidAccountItem();
        if (!CollectionUtils.isEmpty(unpaidAccountItem)) {
            for (SaleReconciliationConfirmationUnpaidAccount account : unpaidAccountItem) {
                String businessNumber = account.getBusinessNumbers();
                if (StringUtils.isEmpty((CharSequence)businessNumber)) continue;
                List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
                String preparedByNumber = saleReconciliationConfirmationVO.getPreparedByNumber();
                if (ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue().equals(account.getUnpaidAccountItem())) {
                    this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                    continue;
                }
                if (!ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue().equals(account.getUnpaidAccountItem())) continue;
                this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
            }
        }
        this.insertReconciliationConfirmationBookBalance(saleReconciliationConfirmation, saleReconciliationConfirmationVO.getBalance());
        this.insertReconciliationConfirmationDifferenceDescription(saleReconciliationConfirmation, saleReconciliationConfirmationVO.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(saleReconciliationConfirmation, saleReconciliationConfirmationVO.getUnpaidAccountItem());
    }

    private void releaseConfirmStatus(List<String> businessNumbers) {
        this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
    }

    @Override
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (saleReconciliationConfirmation != null) {
            this.confirmOrRefused(saleReconciliationConfirmation, operation);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void createDifference(SaleReconciliationConfirmationVO saleReconciliationConfirmationVO) {
        List<SaleReconciliationConfirmationBookBalance> balanceList = saleReconciliationConfirmationVO.getBalance();
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(saleReconciliationConfirmationVO.getId());
        ArrayList<SaleReconciliationConfirmationDifferenceDescription> descriptionList = new ArrayList<SaleReconciliationConfirmationDifferenceDescription>();
        for (SaleReconciliationConfirmationBookBalance balance : balanceList) {
            SaleReconciliationConfirmationDifferenceDescription description = new SaleReconciliationConfirmationDifferenceDescription();
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) > 0) {
                description.setAccountAdjustmentDirection("0");
            } else if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) < 0) {
                description.setAccountAdjustmentDirection("1");
            }
            description.setDifferenceDate(new Date());
            description.setDifferencePayment(balance.getCurrentBalance());
            description.setDifferenceAmount(balance.getDifferenceAmount());
            descriptionList.add(description);
        }
        SaleReconciliationConfirmation confirmation = new SaleReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationConfirmationVO), (Object)((Object)confirmation));
        this.insertReconciliationConfirmationDifferenceDescription(confirmation, descriptionList);
    }

    private void handleMessage(SaleReconciliationConfirmation saleReconciliationConfirmation, String opt, PurchaseReconciliationConfirmation purchaseReconciliationConfirmation) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        saleReconciliationConfirmation.setFbk10(serviceAddress + "/srm/reconciliation/sale/saleReconciliationConfirmation?id=" + saleReconciliationConfirmation.getId() + "&open=true");
        if (!StringUtils.isEmpty((CharSequence)opt) && purchaseReconciliationConfirmation != null) {
            String url = "id=" + purchaseReconciliationConfirmation.getId() + "&createAccount=" + purchaseReconciliationConfirmation.getElsAccount();
            if (StringUtils.isNotBlank((CharSequence)saleReconciliationConfirmation.getElsAccountName())) {
                super.sendMsg(saleReconciliationConfirmation.getBusAccount(), saleReconciliationConfirmation.getToElsAccount(), saleReconciliationConfirmation.getElsAccountName(), (Object)saleReconciliationConfirmation, url, "purchaseReconciliationConfirmation", opt);
                super.sendMsg(saleReconciliationConfirmation.getBusAccount(), saleReconciliationConfirmation.getElsAccount(), saleReconciliationConfirmation.getElsAccountName(), (Object)saleReconciliationConfirmation, url, "saleReconciliationConfirmation", opt);
            } else {
                super.sendMsg(saleReconciliationConfirmation.getBusAccount(), saleReconciliationConfirmation.getToElsAccount(), (Object)saleReconciliationConfirmation, url, "purchaseReconciliationConfirmation", opt);
                super.sendMsg(saleReconciliationConfirmation.getBusAccount(), saleReconciliationConfirmation.getElsAccount(), (Object)saleReconciliationConfirmation, url, "saleReconciliationConfirmation", opt);
            }
        }
    }

    private void buildReconciliationConfirmation(SaleReconciliationConfirmation saleReconciliationConfirmation) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        String nextCode = this.invokeBaseRpcService.getNextCode("salePreparedByNumber", (Object)saleReconciliationConfirmation);
        saleReconciliationConfirmation.setPreparedByNumber(nextCode);
        saleReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.NEW.getValue());
        saleReconciliationConfirmation.setBusAccount(saleReconciliationConfirmation.getToElsAccount());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(saleReconciliationConfirmation.getTemplateNumber());
        if (templateHead != null) {
            saleReconciliationConfirmation.setTemplateName(templateHead.getTemplateName());
            saleReconciliationConfirmation.setTemplateNumber(templateHead.getTemplateNumber());
            saleReconciliationConfirmation.setTemplateVersion(templateHead.getTemplateVersion() + "");
            saleReconciliationConfirmation.setTemplateAccount(templateHead.getElsAccount());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            saleReconciliationConfirmation.setSupplierName(enterpriseInfo.getName());
            saleReconciliationConfirmation.setElsAccountName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(saleReconciliationConfirmation.getToElsAccount())) != null) {
            saleReconciliationConfirmation.setSupplierName(enterpriseInfo.getName());
            saleReconciliationConfirmation.setElsAccountName(enterpriseInfo.getName());
        }
        saleReconciliationConfirmation.setRelationId(IdWorker.getIdStr());
        saleReconciliationConfirmation.setCreateAccount(TenantContext.getTenant());
        if ("0".equals(saleReconciliationConfirmation.getSign())) {
            saleReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            saleReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(saleReconciliationConfirmation.getSign())) {
            saleReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            saleReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
    }

    private void insertReconciliationConfirmationBookBalance(SaleReconciliationConfirmation saleReconciliationConfirmation, List<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList) {
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationBookBalanceList)) {
            return;
        }
        for (SaleReconciliationConfirmationBookBalance entity : saleReconciliationConfirmationBookBalanceList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliationConfirmation);
            BigDecimal bookBalance = entity.getBookBalance() == null ? BigDecimal.ZERO : entity.getBookBalance();
            BigDecimal opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            entity.setHeadId(saleReconciliationConfirmation.getId());
            entity.setToElsAccount(saleReconciliationConfirmation.getToElsAccount());
            entity.setBusAccount(saleReconciliationConfirmation.getBusAccount());
            if (StringUtils.isEmpty((CharSequence)saleReconciliationConfirmation.getElsAccount()) || saleReconciliationConfirmation.getElsAccount().equals(saleReconciliationConfirmation.getCreateAccount())) continue;
            BigDecimal result = bookBalance.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!CollectionUtils.isEmpty(saleReconciliationConfirmationBookBalanceList)) {
            this.saleReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(saleReconciliationConfirmationBookBalanceList);
        }
    }

    private void insertReconciliationConfirmationUnpaidAccount(SaleReconciliationConfirmation saleReconciliationConfirmation, List<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList) {
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        for (SaleReconciliationConfirmationUnpaidAccount entity : saleReconciliationConfirmationUnpaidAccountList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliationConfirmation);
            BigDecimal preparationConfirmAmount = entity.getPreparationConfirmAmount() == null ? BigDecimal.ZERO : entity.getPreparationConfirmAmount();
            BigDecimal opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            entity.setHeadId(saleReconciliationConfirmation.getId());
            entity.setToElsAccount(saleReconciliationConfirmation.getToElsAccount());
            entity.setBusAccount(saleReconciliationConfirmation.getBusAccount());
            if (StringUtils.isEmpty((CharSequence)saleReconciliationConfirmation.getElsAccount()) || saleReconciliationConfirmation.getElsAccount().equals(saleReconciliationConfirmation.getCreateAccount())) continue;
            BigDecimal result = preparationConfirmAmount.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!CollectionUtils.isEmpty(saleReconciliationConfirmationUnpaidAccountList)) {
            this.saleReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(saleReconciliationConfirmationUnpaidAccountList);
        }
    }

    private void insertReconciliationConfirmationDifferenceDescription(SaleReconciliationConfirmation saleReconciliationConfirmation, List<SaleReconciliationConfirmationDifferenceDescription> saleReconciliationConfirmationDifferenceDescriptionList) {
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationDifferenceDescriptionList)) {
            return;
        }
        for (SaleReconciliationConfirmationDifferenceDescription entity : saleReconciliationConfirmationDifferenceDescriptionList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliationConfirmation);
            entity.setHeadId(saleReconciliationConfirmation.getId());
            entity.setToElsAccount(saleReconciliationConfirmation.getToElsAccount());
            entity.setBusAccount(saleReconciliationConfirmation.getBusAccount());
            BigDecimal bigDecimal = entity.getPreparationConfirmAmount() == null ? BigDecimal.ZERO : entity.getPreparationConfirmAmount();
        }
        if (!CollectionUtils.isEmpty(saleReconciliationConfirmationDifferenceDescriptionList)) {
            this.saleReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(saleReconciliationConfirmationDifferenceDescriptionList);
        }
    }

    private void handleDetail(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, SaleReconciliationConfirmationVO saleReconciliationConfirmationVO) {
        List<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList = saleReconciliationConfirmationVO.getBalance();
        List<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList = saleReconciliationConfirmationVO.getUnpaidAccountItem();
        List<SaleReconciliationConfirmationDifferenceDescription> saleReconciliationConfirmationDifferenceDescriptionList = saleReconciliationConfirmationVO.getDifferenceDescription();
        List<SaleAttachmentDTO> attachments = saleReconciliationConfirmationVO.getAttachments();
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseReconciliationConfirmation.getId());
        this.handlePurchaseReconciliationConfirmationBookBalance(purchaseReconciliationConfirmation, saleReconciliationConfirmationBookBalanceList);
        this.handlePurchaseReconciliationConfirmationUnpaidAccount(purchaseReconciliationConfirmation, saleReconciliationConfirmationUnpaidAccountList);
        this.handlePurchaseReconciliationConfirmationDifferenceDescription(purchaseReconciliationConfirmation, saleReconciliationConfirmationDifferenceDescriptionList);
        this.handlePurchaseAttachmentDetail(purchaseReconciliationConfirmation, attachments);
    }

    private void handlePurchaseReconciliationConfirmationBookBalance(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, List<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList) {
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationBookBalanceList)) {
            return;
        }
        ArrayList<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList = new ArrayList<PurchaseReconciliationConfirmationBookBalance>();
        for (SaleReconciliationConfirmationBookBalance saleReconciliationConfirmationBookBalance : saleReconciliationConfirmationBookBalanceList) {
            PurchaseReconciliationConfirmationBookBalance purchaseReconciliationConfirmationBookBalance = new PurchaseReconciliationConfirmationBookBalance();
            BeanUtils.copyProperties((Object)((Object)saleReconciliationConfirmationBookBalance), (Object)((Object)purchaseReconciliationConfirmationBookBalance));
            purchaseReconciliationConfirmationBookBalance.setId(null);
            purchaseReconciliationConfirmationBookBalance.setElsAccount(purchaseReconciliationConfirmation.getElsAccount());
            purchaseReconciliationConfirmationBookBalance.setToElsAccount(purchaseReconciliationConfirmation.getToElsAccount());
            purchaseReconciliationConfirmationBookBalance.setHeadId(purchaseReconciliationConfirmation.getId());
            purchaseReconciliationConfirmationBookBalance.setRelationId(saleReconciliationConfirmationBookBalance.getId());
            purchaseReconciliationConfirmationBookBalanceList.add(purchaseReconciliationConfirmationBookBalance);
        }
        this.purchaseReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(purchaseReconciliationConfirmationBookBalanceList);
    }

    private void handlePurchaseReconciliationConfirmationUnpaidAccount(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, List<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList) {
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationUnpaidAccountList)) {
            return;
        }
        ArrayList<PurchaseReconciliationConfirmationUnpaidAccount> purchaseReconciliationConfirmationUnpaidAccountList = new ArrayList<PurchaseReconciliationConfirmationUnpaidAccount>();
        for (SaleReconciliationConfirmationUnpaidAccount saleReconciliationConfirmationBookUnpaidAccount : saleReconciliationConfirmationUnpaidAccountList) {
            PurchaseReconciliationConfirmationUnpaidAccount purchaseReconciliationConfirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
            BeanUtils.copyProperties((Object)((Object)saleReconciliationConfirmationBookUnpaidAccount), (Object)((Object)purchaseReconciliationConfirmationUnpaidAccount));
            purchaseReconciliationConfirmationUnpaidAccount.setId(null);
            purchaseReconciliationConfirmationUnpaidAccount.setElsAccount(purchaseReconciliationConfirmation.getElsAccount());
            purchaseReconciliationConfirmationUnpaidAccount.setToElsAccount(purchaseReconciliationConfirmation.getToElsAccount());
            purchaseReconciliationConfirmationUnpaidAccount.setHeadId(purchaseReconciliationConfirmation.getId());
            purchaseReconciliationConfirmationUnpaidAccount.setRelationId(saleReconciliationConfirmationBookUnpaidAccount.getId());
            purchaseReconciliationConfirmationUnpaidAccountList.add(purchaseReconciliationConfirmationUnpaidAccount);
        }
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(purchaseReconciliationConfirmationUnpaidAccountList);
    }

    private void handlePurchaseReconciliationConfirmationDifferenceDescription(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, List<SaleReconciliationConfirmationDifferenceDescription> saleReconciliationConfirmationDifferenceDescriptionList) {
        if (CollectionUtils.isEmpty(saleReconciliationConfirmationDifferenceDescriptionList)) {
            return;
        }
        ArrayList<PurchaseReconciliationConfirmationDifferenceDescription> purchaseReconciliationConfirmationDifferenceDescriptionList = new ArrayList<PurchaseReconciliationConfirmationDifferenceDescription>();
        for (SaleReconciliationConfirmationDifferenceDescription saleReconciliationConfirmationDifferenceDescription : saleReconciliationConfirmationDifferenceDescriptionList) {
            PurchaseReconciliationConfirmationDifferenceDescription purchaseReconciliationConfirmationDifferenceDescription = new PurchaseReconciliationConfirmationDifferenceDescription();
            BeanUtils.copyProperties((Object)((Object)saleReconciliationConfirmationDifferenceDescription), (Object)((Object)purchaseReconciliationConfirmationDifferenceDescription));
            purchaseReconciliationConfirmationDifferenceDescription.setId(null);
            purchaseReconciliationConfirmationDifferenceDescription.setElsAccount(purchaseReconciliationConfirmation.getElsAccount());
            purchaseReconciliationConfirmationDifferenceDescription.setToElsAccount(purchaseReconciliationConfirmation.getToElsAccount());
            purchaseReconciliationConfirmationDifferenceDescription.setHeadId(purchaseReconciliationConfirmation.getId());
            purchaseReconciliationConfirmationDifferenceDescription.setRelationId(saleReconciliationConfirmationDifferenceDescription.getId());
            purchaseReconciliationConfirmationDifferenceDescriptionList.add(purchaseReconciliationConfirmationDifferenceDescription);
        }
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(purchaseReconciliationConfirmationDifferenceDescriptionList);
    }

    private void handlePurchaseAttachmentDetail(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, List<SaleAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO saleAttachment : attachments) {
            saleAttachment.setSendStatus("1");
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(purchaseReconciliationConfirmation.getElsAccount());
            purchaseAttachment.setHeadId(purchaseReconciliationConfirmation.getId());
            purchaseAttachment.setRelationId(saleAttachment.getId());
            purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachment);
        }
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
    }

    private void sendMessage(SaleReconciliationConfirmation saleReconciliationConfirmation, PurchaseReconciliationConfirmation purchaseReconciliationConfirmation) {
        String url = "id=" + saleReconciliationConfirmation.getId() + "&createAccount=" + saleReconciliationConfirmation.getElsAccount();
        if (StringUtils.isNotBlank((CharSequence)saleReconciliationConfirmation.getElsAccountName())) {
            super.sendMsg(saleReconciliationConfirmation.getElsAccount(), saleReconciliationConfirmation.getToElsAccount(), saleReconciliationConfirmation.getElsAccountName(), (Object)saleReconciliationConfirmation, url, "saleReconciliationConfirmation", "publish");
        } else {
            super.sendMsg(saleReconciliationConfirmation.getElsAccount(), saleReconciliationConfirmation.getToElsAccount(), (Object)saleReconciliationConfirmation, url, "saleReconciliationConfirmation", "publish");
        }
    }
}

