/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.rebate.entity.PurchaseRebateRule;
import com.els.modules.rebate.entity.PurchaseRebateRuleItem;
import com.els.modules.rebate.entity.PurchaseRebateRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateRuleThreshold;
import com.els.modules.rebate.mapper.PurchaseRebateRuleMapper;
import com.els.modules.rebate.service.PurchaseRebateRuleItemService;
import com.els.modules.rebate.service.PurchaseRebateRuleService;
import com.els.modules.rebate.service.PurchaseRebateRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateRuleThresholdService;
import com.els.modules.rebate.vo.PurchaseRebateRuleVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurchaseRebateRuleAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Resource
    private PurchaseRebateRuleMapper purchaseRebateRuleMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchaseRebateRuleService purchaseRebateRuleService;
    @Autowired
    private PurchaseRebateRuleItemService purchaseRebateRuleItemService;
    @Autowired
    private PurchaseRebateRuleThresholdService purchaseRebateRuleThresholdService;
    @Autowired
    private PurchaseRebateRuleSupplementService purchaseRebateRuleSupplementService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        this.updateStatus(inputParamVO, outputParamVO);
        PurchaseRebateRuleVO purchaseRebateRuleVO = (PurchaseRebateRuleVO)((Object)JSONObject.parseObject((String)params, PurchaseRebateRuleVO.class));
        PurchaseRebateRule purchaseRebateRule = new PurchaseRebateRule();
        BeanUtils.copyProperties((Object)((Object)purchaseRebateRuleVO), (Object)((Object)purchaseRebateRule));
        this.purchaseRebateRuleService.publishCheckRule(purchaseRebateRule, purchaseRebateRuleVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
            PurchaseRebateRuleVO vo = new PurchaseRebateRuleVO();
            PurchaseRebateRule purchaseRebateRule = (PurchaseRebateRule)((Object)this.purchaseRebateRuleService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
            BeanUtils.copyProperties((Object)((Object)purchaseRebateRule), (Object)((Object)vo));
            List<PurchaseRebateRuleItem> ruleItems = this.purchaseRebateRuleItemService.selectByMainId(inputParamVO.getBusinessId());
            vo.setRebateRuleItems(ruleItems);
            List<PurchaseRebateRuleThreshold> thresholds = this.purchaseRebateRuleThresholdService.selectByMainId(inputParamVO.getBusinessId());
            vo.setRebateRuleThresholds(thresholds);
            List<PurchaseRebateRuleSupplement> supplements = this.purchaseRebateRuleSupplementService.selectByMainId(inputParamVO.getBusinessId());
            vo.setRebateRuleSupplements(supplements);
            this.purchaseRebateRuleService.publish(purchaseRebateRule, vo);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseRebateRule head = new PurchaseRebateRule();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseRebateRuleMapper.updateById((Object)head);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PurchaseRebateRule head = (PurchaseRebateRule)((Object)this.purchaseRebateRuleMapper.selectById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

