/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCertificate;
import com.els.modules.rebate.entity.SaleRebateCalculationSheet;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetCertificate;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationSheetStatusEnum;
import com.els.modules.rebate.mapper.PurchaseRebateCalculationSheetMapper;
import com.els.modules.rebate.mapper.SaleRebateCalculationSheetMapper;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCertificateService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetCertificateService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetRuleSupplementService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetRuleThresholdService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetService;
import com.els.modules.rebate.vo.SaleRebateCalculationSheetVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleRebateCalculationSheetServiceImpl
extends BaseServiceImpl<SaleRebateCalculationSheetMapper, SaleRebateCalculationSheet>
implements SaleRebateCalculationSheetService {
    @Resource
    private PurchaseRebateCalculationSheetMapper purchaseRebateCalculationSheetMapper;
    @Resource
    private SaleRebateCalculationSheetCertificateService saleRebateCalculationSheetCertificateService;
    @Resource
    private PurchaseRebateCalculationSheetCertificateService purchaseRebateCalculationSheetCertificateService;
    @Autowired
    private SaleRebateCalculationSheetRuleThresholdService saleRebateCalculationSheetRuleThresholdService;
    @Autowired
    private SaleRebateCalculationSheetRuleSupplementService saleRebateCalculationSheetRuleSupplementService;

    @Override
    public void add(SaleRebateCalculationSheet saleRebateCalculationSheet) {
        ((SaleRebateCalculationSheetMapper)this.baseMapper).insert((Object)saleRebateCalculationSheet);
    }

    @Override
    public void edit(SaleRebateCalculationSheet saleRebateCalculationSheet) {
        int count = ((SaleRebateCalculationSheetMapper)this.baseMapper).updateById((Object)saleRebateCalculationSheet);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleRebateCalculationSheetMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleRebateCalculationSheetMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void confirmOrRefused(SaleRebateCalculationSheet saleRebateCalculationSheet, String operation) {
        if ("confirm".equals(operation)) {
            saleRebateCalculationSheet.setRebateStatus(CalculationSheetStatusEnum.CONFIRMED.getValue());
        } else if ("refused".equals(operation)) {
            saleRebateCalculationSheet.setRebateStatus(CalculationSheetStatusEnum.RENTURNED.getValue());
        }
        this.updateById((Object)saleRebateCalculationSheet);
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetMapper.selectById((Serializable)((Object)saleRebateCalculationSheet.getRelationId())));
        if (purchaseRebateCalculationSheet != null) {
            purchaseRebateCalculationSheet.setRebateStatus(saleRebateCalculationSheet.getRebateStatus());
            this.purchaseRebateCalculationSheetMapper.updateById((Object)purchaseRebateCalculationSheet);
        }
        this.sendMessage(saleRebateCalculationSheet, purchaseRebateCalculationSheet, operation);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleRebateCalculationSheetVO saleRebateCalculationSheetVO, SaleRebateCalculationSheet saleRebateCalculationSheet) {
        this.insertSaleRebateCalculationSheetCertificate(saleRebateCalculationSheet, saleRebateCalculationSheetVO.getRebateCalculationSheetCertificates());
        this.insertRebateCalculationSheetRuleThreshold(saleRebateCalculationSheet, saleRebateCalculationSheetVO.getRebateCalculationSheetRuleThresholds());
        this.insertRebateCalculationSheetRuleSupplement(saleRebateCalculationSheet, saleRebateCalculationSheetVO.getRebateCalculationSheetRuleSupplements());
    }

    private void insertRebateCalculationSheetRuleSupplement(SaleRebateCalculationSheet saleRebateCalculationSheet, List<SaleRebateCalculationSheetRuleSupplement> rebateCalculationSheetRuleSupplementList) {
        if (!CollectionUtils.isEmpty(rebateCalculationSheetRuleSupplementList)) {
            int itemNumber = 1;
            for (SaleRebateCalculationSheetRuleSupplement supplement : rebateCalculationSheetRuleSupplementList) {
                supplement.setHeadId(saleRebateCalculationSheet.getId());
                SysUtil.setSysParam((BaseEntity)supplement, (BaseEntity)saleRebateCalculationSheet);
                supplement.setItemNumber(String.valueOf(itemNumber));
                supplement.setId(null);
                ++itemNumber;
            }
            this.saleRebateCalculationSheetRuleSupplementService.saveBatch(rebateCalculationSheetRuleSupplementList);
        }
    }

    private void insertRebateCalculationSheetRuleThreshold(SaleRebateCalculationSheet saleRebateCalculationSheet, List<SaleRebateCalculationSheetRuleThreshold> rebateCalculationSheetRuleThresholdList) {
        if (!CollectionUtils.isEmpty(rebateCalculationSheetRuleThresholdList)) {
            int itemNumber = 1;
            for (SaleRebateCalculationSheetRuleThreshold threshold : rebateCalculationSheetRuleThresholdList) {
                threshold.setHeadId(saleRebateCalculationSheet.getId());
                SysUtil.setSysParam((BaseEntity)threshold, (BaseEntity)saleRebateCalculationSheet);
                threshold.setItemNumber(String.valueOf(itemNumber));
                threshold.setId(null);
                ++itemNumber;
            }
            this.saleRebateCalculationSheetRuleThresholdService.saveBatch(rebateCalculationSheetRuleThresholdList);
        }
    }

    @Override
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SaleRebateCalculationSheet saleRebateCalculationSheet = (SaleRebateCalculationSheet)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (saleRebateCalculationSheet != null) {
            this.confirmOrRefused(saleRebateCalculationSheet, operation);
        }
    }

    private void insertSaleRebateCalculationSheetCertificate(SaleRebateCalculationSheet saleRebateCalculationSheet, List<SaleRebateCalculationSheetCertificate> rebateCalculationSheetCertificateList) {
        if (CollectionUtils.isEmpty(rebateCalculationSheetCertificateList)) {
            return;
        }
        int itemNumber = 1;
        for (SaleRebateCalculationSheetCertificate certificate : rebateCalculationSheetCertificateList) {
            certificate.setHeadId(saleRebateCalculationSheet.getId());
            certificate.setId(null);
            SysUtil.setSysParam((BaseEntity)certificate, (BaseEntity)saleRebateCalculationSheet);
            certificate.setItemNumber(String.valueOf(itemNumber));
            certificate.setBusAccount(saleRebateCalculationSheet.getBusAccount());
            certificate.setToElsAccount(saleRebateCalculationSheet.getToElsAccount());
            ++itemNumber;
        }
        this.saleRebateCalculationSheetCertificateService.saveBatch(rebateCalculationSheetCertificateList);
        ArrayList<PurchaseRebateCalculationSheetCertificate> purchaseCertificateList = new ArrayList<PurchaseRebateCalculationSheetCertificate>();
        for (SaleRebateCalculationSheetCertificate certificate : rebateCalculationSheetCertificateList) {
            PurchaseRebateCalculationSheetCertificate purchaseCertificate = new PurchaseRebateCalculationSheetCertificate();
            BeanUtils.copyProperties((Object)((Object)certificate), (Object)((Object)purchaseCertificate));
            purchaseCertificate.setId(null);
            purchaseCertificate.setElsAccount(certificate.getToElsAccount());
            purchaseCertificate.setToElsAccount(certificate.getElsAccount());
            purchaseCertificate.setRelationId(certificate.getId());
            purchaseCertificate.setHeadId(saleRebateCalculationSheet.getRelationId());
            purchaseCertificateList.add(purchaseCertificate);
        }
        this.purchaseRebateCalculationSheetCertificateService.saveBatch(purchaseCertificateList);
    }

    private void sendMessage(SaleRebateCalculationSheet saleRebateCalculationSheet, PurchaseRebateCalculationSheet purchaseRebateCalculationSheet, String operation) {
        String url = "id=" + purchaseRebateCalculationSheet.getId();
        if (StringUtils.isNotBlank((CharSequence)saleRebateCalculationSheet.getSupplierName())) {
            super.sendMsg(saleRebateCalculationSheet.getElsAccount(), saleRebateCalculationSheet.getToElsAccount(), saleRebateCalculationSheet.getSupplierName(), (Object)saleRebateCalculationSheet, url, "saleRebateCalculationSheet", operation);
        } else {
            super.sendMsg(saleRebateCalculationSheet.getElsAccount(), saleRebateCalculationSheet.getToElsAccount(), (Object)saleRebateCalculationSheet, url, "saleRebateCalculationSheet", operation);
        }
    }
}

