/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCase;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.mapper.ElsPurchaseStatisticsSourceCaseMapper;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsPurchaseStatisticsSourceCaseServiceImpl
extends BaseServiceImpl<ElsPurchaseStatisticsSourceCaseMapper, ElsPurchaseStatisticsSourceCase>
implements ElsPurchaseStatisticsSourceCaseService {
    @Override
    public void saveElsPurchaseStatisticsSourceCase(ElsPurchaseStatisticsSourceCase elsPurchaseStatisticsSourceCase) {
        ((ElsPurchaseStatisticsSourceCaseMapper)this.baseMapper).insert((Object)elsPurchaseStatisticsSourceCase);
    }

    @Override
    public void updateElsPurchaseStatisticsSourceCase(ElsPurchaseStatisticsSourceCase elsPurchaseStatisticsSourceCase) {
        ((ElsPurchaseStatisticsSourceCaseMapper)this.baseMapper).updateById((Object)elsPurchaseStatisticsSourceCase);
    }

    @Override
    public void delElsPurchaseStatisticsSourceCase(String id) {
        ((ElsPurchaseStatisticsSourceCaseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsPurchaseStatisticsSourceCase(List<String> idList) {
        ((ElsPurchaseStatisticsSourceCaseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void handleReconciliationStatisticsInfo(List<PurchaseReconciliation> records) {
        HashSet<String> sourceIdSet = new HashSet<String>();
        for (PurchaseReconciliation record : records) {
            sourceIdSet.add(record.getId());
        }
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(sourceIdSet);
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        for (PurchaseReconciliation record : records) {
            ElsPurchaseStatisticsSourceCase sourceCase;
            if (record == null || StringUtils.isEmpty((CharSequence)record.getId()) || (sourceCase = map.get(record.getId())) == null) continue;
            record.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            record.setSourcePaymentAmount(sourceCase.getSourcePaymentAmount());
        }
    }

    @Override
    public void handlePurchasePerformanceReconciliationStatisticsInfo(List<PurchasePerformanceReconciliation> records) {
        HashSet<String> sourceIdSet = new HashSet<String>();
        for (PurchasePerformanceReconciliation record : records) {
            sourceIdSet.add(record.getId());
        }
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(sourceIdSet);
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        for (PurchasePerformanceReconciliation record : records) {
            ElsPurchaseStatisticsSourceCase sourceCase;
            if (record == null || StringUtils.isEmpty((CharSequence)record.getId()) || (sourceCase = map.get(record.getId())) == null) continue;
            record.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            record.setSourcePaymentAmount(sourceCase.getSourcePaymentAmount());
        }
    }

    private Map<String, ElsPurchaseStatisticsSourceCase> getStatisticsSourceMap(Set<String> sourceIdSet) {
        HashMap<String, ElsPurchaseStatisticsSourceCase> map = new HashMap<String, ElsPurchaseStatisticsSourceCase>();
        if (CollectionUtils.isEmpty(sourceIdSet)) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", sourceIdSet);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        for (ElsPurchaseStatisticsSourceCase elsPurchaseStatisticsSourceCase : list) {
            map.put(elsPurchaseStatisticsSourceCase.getSourceId(), elsPurchaseStatisticsSourceCase);
        }
        return map;
    }
}

