/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.finance.entity.PurchasePaymentApplyWriteOff;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.enumerate.WriteOffStatusEnum;
import com.els.modules.finance.enumerate.WriteOffTypeEnum;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOffRecord;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.mapper.ElsPurchaseStatisticsWriteOffMapper;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffRecordService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsPurchaseStatisticsWriteOffServiceImpl
extends BaseServiceImpl<ElsPurchaseStatisticsWriteOffMapper, ElsPurchaseStatisticsWriteOff>
implements ElsPurchaseStatisticsWriteOffService {
    private static final Logger log = LoggerFactory.getLogger(ElsPurchaseStatisticsWriteOffServiceImpl.class);
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffRecordService elsPurchaseStatisticsWriteOffRecordService;
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;

    @Override
    public void saveelsPurchaseStatisticsWriteOff(ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).insert((Object)elsPurchaseStatisticsWriteOff);
    }

    @Override
    public void updateelsPurchaseStatisticsWriteOff(ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).updateById((Object)elsPurchaseStatisticsWriteOff);
    }

    @Override
    public void delelsPurchaseStatisticsWriteOff(String id) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchelsPurchaseStatisticsWriteOff(List<String> idList) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void cancelReleaseAmountByPurchase(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchasePrePaymentWriteOffList)) {
            return;
        }
        this.cancelReleaseAmount(purchasePrePaymentWriteOffList);
    }

    @Override
    public void releaseWriteOffAmount(List<PurchasePaymentApplyWriteOff> paymentWriteOffList) {
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsWriteOffMapFromPayment(paymentWriteOffList);
        ArrayList<ElsPurchaseStatisticsWriteOff> elsPurchaseStatisticsWriteOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        for (PurchasePaymentApplyWriteOff paymentWriteOff : paymentWriteOffList) {
            boolean recordResult;
            BigDecimal thisWriteOffAmount;
            BigDecimal bigDecimal = thisWriteOffAmount = paymentWriteOff.getThisWriteOffAmount() == null ? BigDecimal.ZERO : paymentWriteOff.getThisWriteOffAmount();
            String businessId = paymentWriteOff.getBusinessId();
            ElsPurchaseStatisticsWriteOff writeOff = map.get(businessId);
            if (writeOff == null || (recordResult = this.handleElsPurchaseStatisticsWriteOffRecord(thisWriteOffAmount, businessId, writeOff))) continue;
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.subtract(thisWriteOffAmount);
            writeOff.setSourceApplyAmount(applyAmount);
            BigDecimal sourceWrittenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal sourceUnWrittenOffAmount = sourcePayAmount.subtract(sourceWrittenOffAmount).subtract(applyAmount);
            writeOff.setSourceUnWrittenOffAmount(sourceUnWrittenOffAmount);
            elsPurchaseStatisticsWriteOffList.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(elsPurchaseStatisticsWriteOffList)) {
            this.updateBatchById(elsPurchaseStatisticsWriteOffList);
        }
    }

    @Override
    public void cancelReleaseAmountBySale(String purchaseHeadId, String elsAccount, String toElsAccount) {
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectFromSale(purchaseHeadId, elsAccount, toElsAccount);
        this.cancelReleaseAmount(purchasePrePaymentWriteOffList);
    }

    @Override
    public void cancelReleaseAmountFromSale(String saleHeadId) {
        ArrayList<ElsPurchaseStatisticsWriteOff> elsPurchaseStatisticsWriteOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        List<SalePrePaymentWriteOffReconciliation> writeOffReconciliationList = this.salePrePaymentWriteOffReconciliationService.selectByMainId(saleHeadId);
        Map<String, String> purchaseSaleIdsMap = this.getPurchaseIdMapFromSale(writeOffReconciliationList);
        HashSet<String> businessIdSet = new HashSet<String>(purchaseSaleIdsMap.values());
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsWriteOffMapFromSale(businessIdSet);
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : writeOffReconciliationList) {
            boolean recordResult;
            ElsPurchaseStatisticsWriteOff writeOff;
            BigDecimal thisWriteOffAmount;
            BigDecimal bigDecimal = thisWriteOffAmount = prePaymentWriteOff.getThisWriteOffAmount() == null ? BigDecimal.ZERO : prePaymentWriteOff.getThisWriteOffAmount();
            String businessId = purchaseSaleIdsMap.get(prePaymentWriteOff.getBusinessId());
            if (StringUtils.isEmpty((CharSequence)businessId) || (writeOff = map.get(businessId)) == null || (recordResult = this.handleElsPurchaseStatisticsWriteOffRecord(thisWriteOffAmount, businessId, writeOff))) continue;
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.subtract(thisWriteOffAmount);
            writeOff.setSourceApplyAmount(applyAmount);
            BigDecimal sourceWrittenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal sourceUnWrittenOffAmount = sourcePayAmount.subtract(sourceWrittenOffAmount).subtract(applyAmount);
            writeOff.setSourceUnWrittenOffAmount(sourceUnWrittenOffAmount);
            elsPurchaseStatisticsWriteOffList.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(elsPurchaseStatisticsWriteOffList)) {
            this.updateBatchById(elsPurchaseStatisticsWriteOffList);
        }
    }

    private boolean handleElsPurchaseStatisticsWriteOffRecord(BigDecimal thisWriteOffAmount, String businessId, ElsPurchaseStatisticsWriteOff writeOff) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"used", (Object)0);
        queryWrapper.eq((Object)"source_id", (Object)businessId);
        queryWrapper.eq((Object)"head_id", (Object)writeOff.getId());
        List recordList = this.elsPurchaseStatisticsWriteOffRecordService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return true;
        }
        Set recordAmount = recordList.stream().filter(record -> record.getAmount() != null).map(ElsPurchaseStatisticsWriteOffRecord::getAmount).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(recordAmount)) {
            return true;
        }
        if (!recordAmount.contains(thisWriteOffAmount)) {
            return true;
        }
        ElsPurchaseStatisticsWriteOffRecord target = new ElsPurchaseStatisticsWriteOffRecord();
        for (ElsPurchaseStatisticsWriteOffRecord record2 : recordList) {
            if (!thisWriteOffAmount.equals(record2.getAmount())) continue;
            target = record2;
        }
        target.setUsed("1");
        this.elsPurchaseStatisticsWriteOffRecordService.updateById((Object)target);
        return false;
    }

    private void cancelReleaseAmount(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList) {
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsWriteOffMap(purchasePrePaymentWriteOffList);
        ArrayList<ElsPurchaseStatisticsWriteOff> elsPurchaseStatisticsWriteOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : purchasePrePaymentWriteOffList) {
            boolean recordResult;
            BigDecimal thisWriteOffAmount;
            BigDecimal bigDecimal = thisWriteOffAmount = prePaymentWriteOff.getThisWriteOffAmount() == null ? BigDecimal.ZERO : prePaymentWriteOff.getThisWriteOffAmount();
            String businessId = prePaymentWriteOff.getBusinessId();
            ElsPurchaseStatisticsWriteOff writeOff = map.get(businessId);
            if (writeOff == null || (recordResult = this.handleElsPurchaseStatisticsWriteOffRecord(thisWriteOffAmount, businessId, writeOff))) continue;
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.subtract(thisWriteOffAmount);
            writeOff.setSourceApplyAmount(applyAmount);
            BigDecimal sourceWrittenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal sourceUnWrittenOffAmount = sourcePayAmount.subtract(sourceWrittenOffAmount).subtract(applyAmount);
            writeOff.setSourceUnWrittenOffAmount(sourceUnWrittenOffAmount);
            elsPurchaseStatisticsWriteOffList.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(elsPurchaseStatisticsWriteOffList)) {
            this.updateBatchById(elsPurchaseStatisticsWriteOffList);
        }
    }

    private Map<String, ElsPurchaseStatisticsWriteOff> getStatisticsWriteOffMapFromSale(Set<String> businessIdSet) {
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        if (CollectionUtils.isEmpty(businessIdSet)) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", businessIdSet);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        for (ElsPurchaseStatisticsWriteOff writeOff : list) {
            map.put(writeOff.getSourceId(), writeOff);
        }
        return map;
    }

    @Override
    public void writeOffAmountOccupy(ReconciliationVO reconciliationVO, List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList) {
        BigDecimal writtenOffAmount;
        ArrayList<ElsPurchaseStatisticsWriteOff> list = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsWriteOffMap(purchasePrePaymentWriteOffReconciliationList);
        this.saveStatisticsWriteOff(purchasePrePaymentWriteOffReconciliationList, list, map);
        BigDecimal closingAmount = reconciliationVO.getClosingAmount() == null ? BigDecimal.ZERO : reconciliationVO.getClosingAmount();
        this.checkOverAmount(purchasePrePaymentWriteOffReconciliationList, map);
        BigDecimal bigDecimal = writtenOffAmount = reconciliationVO.getWrittenOffAmount() == null ? BigDecimal.ZERO : reconciliationVO.getWrittenOffAmount();
        if (closingAmount.compareTo(writtenOffAmount) < 0) {
            throw new ELSBootException("\u9884\u4ed8\u6838\u9500\u603b\u989d\u5927\u4e8e\u5bf9\u8d26\u5355\u5e94\u4ed8\u91d1\u989d");
        }
        this.updateWriteOff(list);
    }

    @Override
    public void writeOffAmountOccupy(List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList) {
        ArrayList<ElsPurchaseStatisticsWriteOff> list = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsWriteOffMapFromPayment(purchasePaymentApplyWriteOffList);
        this.saveStatisticsWriteOffFromPayment(purchasePaymentApplyWriteOffList, list, map);
        for (PurchasePaymentApplyWriteOff paymentWriteOff : purchasePaymentApplyWriteOffList) {
            ElsPurchaseStatisticsWriteOff writeOff = map.get(paymentWriteOff.getBusinessId());
            List sameWfList = purchasePaymentApplyWriteOffList.stream().filter(wo -> paymentWriteOff.getBusinessId().equals(wo.getBusinessId())).collect(Collectors.toList());
            BigDecimal thisWriteOffAmount = sameWfList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(PurchasePaymentApplyWriteOff::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal unWrittenOffAmount = writeOff.getSourceUnWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceUnWrittenOffAmount();
            boolean flag = WriteOffTypeEnum.PAYMENT.getValue().equals(paymentWriteOff.getWriteOffType()) && !WriteOffStatusEnum.WRITE_OFFED.getValue().equals(paymentWriteOff.getWriteOffStatus()) && thisWriteOffAmount.compareTo(unWrittenOffAmount) > 0;
            if (!flag) continue;
            throw new ELSBootException("\u7b2c " + paymentWriteOff.getSerialNumber() + " \u884c\u672c\u6b21\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d");
        }
        this.updateWriteOff(list);
    }

    @Override
    public void writeOffAmountOccupyBySale(ReconciliationVO reconciliationVO, List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffReconciliationList) {
        BigDecimal writtenOffAmount;
        ArrayList<ElsPurchaseStatisticsWriteOff> list = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        Map<String, String> purchaseSaleIdsMap = this.getPurchaseIdMapFromSale(salePrePaymentWriteOffReconciliationList);
        HashSet<String> businessIdSet = new HashSet<String>(purchaseSaleIdsMap.values());
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsSourceMap(businessIdSet);
        this.saveStatisticsWriteOffBySale(salePrePaymentWriteOffReconciliationList, list, map, purchaseSaleIdsMap);
        BigDecimal closingAmount = reconciliationVO.getClosingAmount() == null ? BigDecimal.ZERO : reconciliationVO.getClosingAmount();
        this.checkOverAmountBySale(salePrePaymentWriteOffReconciliationList, map, purchaseSaleIdsMap);
        BigDecimal bigDecimal = writtenOffAmount = reconciliationVO.getWrittenOffAmount() == null ? BigDecimal.ZERO : reconciliationVO.getWrittenOffAmount();
        if (closingAmount.compareTo(writtenOffAmount) < 0) {
            throw new ELSBootException("\u9884\u4ed8\u6838\u9500\u603b\u989d\u5927\u4e8e\u5bf9\u8d26\u5355\u5e94\u4ed8\u91d1\u989d");
        }
        this.updateWriteOff(list);
    }

    private Map<String, String> getPurchaseIdMapFromSale(List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffReconciliationList) {
        HashMap<String, String> purchaseSaleIdsMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(salePrePaymentWriteOffReconciliationList)) {
            return purchaseSaleIdsMap;
        }
        Set<String> salePaymentItemIds = salePrePaymentWriteOffReconciliationList.stream().map(SalePrePaymentWriteOffReconciliation::getBusinessId).collect(Collectors.toSet());
        List<SalePaymentApplyItem> salePaymentApplyItemList = this.salePaymentApplyItemMapper.listByItemIds(salePaymentItemIds);
        if (CollectionUtils.isEmpty(salePaymentApplyItemList)) {
            return purchaseSaleIdsMap;
        }
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItemList) {
            purchaseSaleIdsMap.put(salePaymentApplyItem.getId(), salePaymentApplyItem.getRelationId());
        }
        return purchaseSaleIdsMap;
    }

    private void checkOverAmountBySale(List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffReconciliationList, Map<String, ElsPurchaseStatisticsWriteOff> map, Map<String, String> purchaseSaleIdsMap) {
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation : salePrePaymentWriteOffReconciliationList) {
            ElsPurchaseStatisticsWriteOff writeOff;
            String businessId;
            BigDecimal thisWriteOffAmount = prePaymentWriteOffReconciliation.getThisWriteOffAmount();
            if (thisWriteOffAmount == null || StringUtils.isEmpty((CharSequence)(businessId = purchaseSaleIdsMap.get(prePaymentWriteOffReconciliation.getBusinessId()))) || (writeOff = map.get(businessId)) == null) continue;
            BigDecimal sourceUnWrittenOffAmount = writeOff.getSourceUnWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceUnWrittenOffAmount();
            log.error("thisWriteOffAmount: {} , sourceUnWrittenOffAmount: {}", (Object)thisWriteOffAmount, (Object)sourceUnWrittenOffAmount);
            if (BigDecimal.ZERO.compareTo(sourceUnWrittenOffAmount) == 0 || sourceUnWrittenOffAmount.compareTo(thisWriteOffAmount) >= 0 || StringUtils.isEmpty((CharSequence)prePaymentWriteOffReconciliation.getItemNumber())) continue;
            log.error("checkOverAmount : thisWriteOffAmount, {}", (Object)thisWriteOffAmount);
            throw new ELSBootException("\u7b2c " + prePaymentWriteOffReconciliation.getItemNumber() + " \u884c\u672c\u6b21\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d");
        }
    }

    private void saveStatisticsWriteOffBySale(List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffReconciliationList, List<ElsPurchaseStatisticsWriteOff> list, Map<String, ElsPurchaseStatisticsWriteOff> map, Map<String, String> purchaseSaleIdsMap) {
        ArrayList<ElsPurchaseStatisticsWriteOffRecord> recordList = new ArrayList<ElsPurchaseStatisticsWriteOffRecord>();
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation : salePrePaymentWriteOffReconciliationList) {
            String businessId;
            if (prePaymentWriteOffReconciliation.getThisWriteOffAmount() == null || StringUtils.isEmpty((CharSequence)prePaymentWriteOffReconciliation.getBusinessId()) || StringUtils.isEmpty((CharSequence)(businessId = purchaseSaleIdsMap.get(prePaymentWriteOffReconciliation.getBusinessId())))) continue;
            ElsPurchaseStatisticsWriteOff writeOff = map.get(businessId);
            if (writeOff == null) {
                writeOff = new ElsPurchaseStatisticsWriteOff();
                writeOff.setId(IdWorker.getIdStr());
                writeOff.setSourceId(businessId);
                writeOff.setSourcePayAmount(prePaymentWriteOffReconciliation.getPayAmount());
            }
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.add(prePaymentWriteOffReconciliation.getThisWriteOffAmount());
            writeOff.setSourceApplyAmount(applyAmount);
            ElsPurchaseStatisticsWriteOffRecord record = new ElsPurchaseStatisticsWriteOffRecord();
            record.setHeadId(writeOff.getId());
            record.setAmount(prePaymentWriteOffReconciliation.getThisWriteOffAmount());
            record.setSourceId(businessId);
            recordList.add(record);
            list.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.saveOrUpdateBatch(list);
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        if (!CollectionUtils.isEmpty(recordList)) {
            this.elsPurchaseStatisticsWriteOffRecordService.saveBatch(recordList);
        }
    }

    @Override
    public void handlePrePaymentWriteOffList(List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList, String reconciliationNumber) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        HashMap<String, String> purchaseSaleIdsMap = new HashMap<String, String>();
        if (reconciliationNumber.contains("SR") || reconciliationNumber.contains("SPR")) {
            Set<String> salePaymentItemIds = prePaymentWriteOffList.stream().map(PurchasePrePaymentWriteOffReconciliation::getBusinessId).collect(Collectors.toSet());
            List<SalePaymentApplyItem> salePaymentApplyItemList = this.salePaymentApplyItemMapper.listByItemIds(salePaymentItemIds);
            if (CollectionUtils.isEmpty(salePaymentApplyItemList)) {
                return;
            }
            for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItemList) {
                purchaseSaleIdsMap.put(salePaymentApplyItem.getId(), salePaymentApplyItem.getRelationId());
            }
            HashSet<String> purchaseBusiness = new HashSet<String>(purchaseSaleIdsMap.values());
            Map<String, ElsPurchaseStatisticsWriteOff> writeOffMap = this.getStatisticsSourceMap(purchaseBusiness);
            for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
                ElsPurchaseStatisticsWriteOff writeOff;
                String businessId = prePaymentWriteOff.getBusinessId();
                if (StringUtils.isEmpty((CharSequence)businessId) || StringUtils.isEmpty((CharSequence)(businessId = (String)purchaseSaleIdsMap.get(businessId))) || (writeOff = writeOffMap.get(businessId)) == null) continue;
                prePaymentWriteOff.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
                prePaymentWriteOff.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
            }
        } else {
            HashSet<String> idSet = new HashSet<String>();
            for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
                idSet.add(prePaymentWriteOff.getBusinessId());
            }
            HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"source_id", idSet);
            List list = this.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                    map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
                }
            }
            for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
                ElsPurchaseStatisticsWriteOff writeOff;
                String businessId = prePaymentWriteOff.getBusinessId();
                if (StringUtils.isEmpty((CharSequence)businessId) || (writeOff = (ElsPurchaseStatisticsWriteOff)((Object)map.get(businessId))) == null) continue;
                prePaymentWriteOff.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
                prePaymentWriteOff.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
            }
        }
    }

    @Override
    public void handleSalePrePaymentWriteOffList(List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            idSet.add(prePaymentWriteOff.getBusinessId());
        }
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", idSet);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            ElsPurchaseStatisticsWriteOff writeOff;
            String businessId = prePaymentWriteOff.getBusinessId();
            if (StringUtils.isEmpty((CharSequence)businessId) || (writeOff = (ElsPurchaseStatisticsWriteOff)((Object)map.get(businessId))) == null) continue;
            prePaymentWriteOff.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
            prePaymentWriteOff.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
        }
    }

    @Override
    public Map<String, ElsPurchaseStatisticsWriteOff> getStatisticsSourceMap(Set<String> businessIds) {
        HashMap<String, ElsPurchaseStatisticsWriteOff> writeOffMap = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        if (CollectionUtils.isEmpty(businessIds)) {
            return writeOffMap;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ElsPurchaseStatisticsWriteOff::getSourceId, businessIds);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsWriteOff writeOff : list) {
                writeOffMap.put(writeOff.getSourceId(), writeOff);
            }
        }
        return writeOffMap;
    }

    private Map<String, ElsPurchaseStatisticsWriteOff> getStatisticsWriteOffMapFromPayment(List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList) {
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        Set businessIds = purchasePaymentApplyWriteOffList.stream().map(PurchasePaymentApplyWriteOff::getBusinessId).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(businessIds)) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", businessIds);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
            map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
        }
        return map;
    }

    private Map<String, ElsPurchaseStatisticsWriteOff> getStatisticsWriteOffMap(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList) {
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        Set businessIds = purchasePrePaymentWriteOffReconciliationList.stream().map(PurchasePrePaymentWriteOffReconciliation::getBusinessId).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(businessIds)) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", businessIds);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
            map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
        }
        return map;
    }

    private void saveStatisticsWriteOff(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList, List<ElsPurchaseStatisticsWriteOff> list, Map<String, ElsPurchaseStatisticsWriteOff> map) {
        ArrayList<ElsPurchaseStatisticsWriteOffRecord> recordList = new ArrayList<ElsPurchaseStatisticsWriteOffRecord>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation : purchasePrePaymentWriteOffReconciliationList) {
            if (prePaymentWriteOffReconciliation.getThisWriteOffAmount() == null || StringUtils.isEmpty((CharSequence)prePaymentWriteOffReconciliation.getBusinessId())) continue;
            ElsPurchaseStatisticsWriteOff writeOff = map.get(prePaymentWriteOffReconciliation.getBusinessId());
            if (writeOff == null) {
                writeOff = new ElsPurchaseStatisticsWriteOff();
                writeOff.setId(IdWorker.getIdStr());
                writeOff.setSourceId(prePaymentWriteOffReconciliation.getBusinessId());
                writeOff.setSourcePayAmount(prePaymentWriteOffReconciliation.getPayAmount());
            }
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.add(prePaymentWriteOffReconciliation.getThisWriteOffAmount());
            writeOff.setSourceApplyAmount(applyAmount);
            ElsPurchaseStatisticsWriteOffRecord record = new ElsPurchaseStatisticsWriteOffRecord();
            record.setHeadId(writeOff.getId());
            record.setAmount(prePaymentWriteOffReconciliation.getThisWriteOffAmount());
            record.setSourceId(prePaymentWriteOffReconciliation.getBusinessId());
            recordList.add(record);
            list.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.saveOrUpdateBatch(list);
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        if (!CollectionUtils.isEmpty(recordList)) {
            this.elsPurchaseStatisticsWriteOffRecordService.saveBatch(recordList);
        }
    }

    private void saveStatisticsWriteOffFromPayment(List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList, List<ElsPurchaseStatisticsWriteOff> list, Map<String, ElsPurchaseStatisticsWriteOff> map) {
        ArrayList<ElsPurchaseStatisticsWriteOffRecord> recordList = new ArrayList<ElsPurchaseStatisticsWriteOffRecord>();
        for (PurchasePaymentApplyWriteOff purchasePaymentApplyWriteOff : purchasePaymentApplyWriteOffList) {
            if (purchasePaymentApplyWriteOff.getThisWriteOffAmount() == null || StringUtils.isEmpty((CharSequence)purchasePaymentApplyWriteOff.getBusinessId())) continue;
            ElsPurchaseStatisticsWriteOff writeOff = map.get(purchasePaymentApplyWriteOff.getBusinessId());
            if (writeOff == null) {
                writeOff = new ElsPurchaseStatisticsWriteOff();
                writeOff.setId(IdWorker.getIdStr());
                writeOff.setSourceId(purchasePaymentApplyWriteOff.getBusinessId());
                writeOff.setSourcePayAmount(purchasePaymentApplyWriteOff.getPayAmount());
            }
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.add(purchasePaymentApplyWriteOff.getThisWriteOffAmount());
            writeOff.setSourceApplyAmount(applyAmount);
            ElsPurchaseStatisticsWriteOffRecord record = new ElsPurchaseStatisticsWriteOffRecord();
            record.setHeadId(writeOff.getId());
            record.setAmount(purchasePaymentApplyWriteOff.getThisWriteOffAmount());
            record.setSourceId(purchasePaymentApplyWriteOff.getBusinessId());
            recordList.add(record);
            list.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.saveOrUpdateBatch(list);
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        if (!CollectionUtils.isEmpty(recordList)) {
            this.elsPurchaseStatisticsWriteOffRecordService.saveBatch(recordList);
        }
    }

    private void checkOverAmount(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList, Map<String, ElsPurchaseStatisticsWriteOff> map) {
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation : purchasePrePaymentWriteOffReconciliationList) {
            ElsPurchaseStatisticsWriteOff writeOff;
            BigDecimal thisWriteOffAmount = prePaymentWriteOffReconciliation.getThisWriteOffAmount();
            if (thisWriteOffAmount == null || (writeOff = map.get(prePaymentWriteOffReconciliation.getBusinessId())) == null) continue;
            BigDecimal sourceUnWrittenOffAmount = writeOff.getSourceUnWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceUnWrittenOffAmount();
            log.error("thisWriteOffAmount: {} , sourceUnWrittenOffAmount: {}", (Object)thisWriteOffAmount, (Object)sourceUnWrittenOffAmount);
            if (BigDecimal.ZERO.compareTo(sourceUnWrittenOffAmount) == 0 || sourceUnWrittenOffAmount.compareTo(thisWriteOffAmount) >= 0 || StringUtils.isEmpty((CharSequence)prePaymentWriteOffReconciliation.getItemNumber())) continue;
            log.error("checkOverAmount : thisWriteOffAmount, {}", (Object)thisWriteOffAmount);
            throw new ELSBootException("\u7b2c " + prePaymentWriteOffReconciliation.getItemNumber() + " \u884c\u672c\u6b21\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d");
        }
    }

    private void updateWriteOff(List<ElsPurchaseStatisticsWriteOff> list) {
        ArrayList<ElsPurchaseStatisticsWriteOff> writeOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        for (ElsPurchaseStatisticsWriteOff writeOff : list) {
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            BigDecimal sourceWrittenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal sourceUnWrittenOffAmount = sourcePayAmount.subtract(sourceWrittenOffAmount).subtract(applyAmount);
            writeOff.setSourceUnWrittenOffAmount(sourceUnWrittenOffAmount);
            writeOffList.add(writeOff);
        }
        this.saveOrUpdateBatch(list);
    }
}

