/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.mapper.PurchaseRecContractAcceptanceMapper;
import com.els.modules.reconciliation.service.PurchaseRecContractAcceptanceService;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRecContractAcceptanceServiceImpl
extends BaseServiceImpl<PurchaseRecContractAcceptanceMapper, PurchaseRecContractAcceptance>
implements PurchaseRecContractAcceptanceService {
    @Override
    public void savePurchaseRecContractAcceptance(PurchaseRecContractAcceptance purchaseRecContractAcceptance) {
        ((PurchaseRecContractAcceptanceMapper)this.baseMapper).insert((Object)purchaseRecContractAcceptance);
    }

    @Override
    public void updatePurchaseRecContractAcceptance(PurchaseRecContractAcceptance purchaseRecContractAcceptance) {
        ((PurchaseRecContractAcceptanceMapper)this.baseMapper).updateById((Object)purchaseRecContractAcceptance);
    }

    @Override
    public void delPurchaseRecContractAcceptance(String id) {
        ((PurchaseRecContractAcceptanceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseRecContractAcceptance(List<String> idList) {
        ((PurchaseRecContractAcceptanceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void deleteByMainId(String id) {
        ((PurchaseRecContractAcceptanceMapper)this.baseMapper).deleteByMainId(id);
    }

    @Override
    public List<PurchaseRecContractAcceptance> selectByMainId(String id) {
        return ((PurchaseRecContractAcceptanceMapper)this.baseMapper).selectByMainId(id);
    }

    @Override
    public void checkAcceptance(PurchasePerformanceReconciliationVO reconciliationVO) {
        List<PurchaseRecContractAcceptance> recContractAcceptanceList = reconciliationVO.getPurchaseRecContractAcceptanceList();
        if (CollectionUtil.isEmpty(recContractAcceptanceList)) {
            return;
        }
        Set<String> acceptanceNumbers = recContractAcceptanceList.stream().map(PurchaseRecContractAcceptance::getAcceptanceNumbers).collect(Collectors.toSet());
        List<PurchaseRecContractAcceptance> items = ((PurchaseRecContractAcceptanceMapper)this.baseMapper).checkHasReconcilationed(acceptanceNumbers);
        List<PurchaseRecContractAcceptance> resultList = this.getIntersection(recContractAcceptanceList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = reconciliationVO.getReconciliationNumber().replace("PPR", "").replace("SPR", "").replace("SR", "").replace("PR", "");
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<PurchaseRecContractAcceptance> sourceList = this.getIntersection(resultList, recContractAcceptanceList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            PurchaseRecContractAcceptance purchaseRecContractAcceptance = (PurchaseRecContractAcceptance)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_neOltWTyWWWWWIhxIeWVQG_c051c425", (String)"\u5408\u540c\u9a8c\u6536\u5355 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{purchaseRecContractAcceptance.getItemNumber()}));
        }
    }

    private List<PurchaseRecContractAcceptance> getIntersection(List<PurchaseRecContractAcceptance> targetList, List<PurchaseRecContractAcceptance> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(PurchaseRecContractAcceptance::getAcceptanceNumbers).collect(Collectors.toList()).contains(item.getAcceptanceNumbers())).collect(Collectors.toList());
    }
}

