/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ElsTaxRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.contract.dto.PurchaseContractAcceptanceDTO;
import com.els.modules.contract.dto.PurchaseContractPromiseDTO;
import com.els.modules.contract.dto.SaleContractAcceptanceDTO;
import com.els.modules.contract.dto.SaleContractItemDTO;
import com.els.modules.contract.dto.SaleContractPromiseDTO;
import com.els.modules.contract.enumerate.ContractTargetTypeEnum;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.FinanceEnterpriseOutinvoice;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.service.FinanceEnterpriseOutinvoiceService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.rebate.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleRecContractAcceptance;
import com.els.modules.reconciliation.entity.SaleRecContractPromise;
import com.els.modules.reconciliation.enumerate.AcceptanceProjectEnum;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.NuonuoTaxFlagEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationBillStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchasePrePaymentWriteOffReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecChargeMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractAcceptanceMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractPromiseMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SalePerformanceReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseContractPromiseLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractItemLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractPromiseLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.SalePerformanceReconciliationService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleRecContractAcceptanceService;
import com.els.modules.reconciliation.service.SaleRecContractPromiseService;
import com.els.modules.reconciliation.vo.InvoiceDetailVO;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.reconciliation.vo.SalePerformanceReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePerformanceReconciliationServiceImpl
extends BaseServiceImpl<SalePerformanceReconciliationMapper, SalePerformanceReconciliation>
implements SalePerformanceReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(SalePerformanceReconciliationServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private TemplateRpcService templateHeadService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private SalePerformanceReconciliationMapper salePerformanceReconciliationMapper;
    @Resource
    private SaleRecChargeService saleRecChargeService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Resource
    private PurchaseRecChargeMapper purchaseRecChargeMapper;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Resource
    private PurchaseContractPromiseLocalRpcService purchaseContractPromiseLocalRpcService;
    @Resource
    private PurchaseContractAcceptanceLocalRpcService purchaseContractAcceptanceLocalRpcService;
    @Resource
    private SaleContractPromiseLocalRpcService saleContractPromiseLocalRpcService;
    @Resource
    private SaleContractAcceptanceLocalRpcService saleContractAcceptanceLocalRpcService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private SaleRecContractPromiseService saleRecContractPromiseService;
    @Autowired
    private SaleRecContractAcceptanceService saleRecContractAcceptanceService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Resource
    private ElsTaxRpcService elsTaxRpcService;
    @Resource
    private PurchaseRecContractPromiseMapper purchaseRecContractPromiseMapper;
    @Resource
    private PurchaseRecContractAcceptanceMapper purchaseRecContractAcceptanceMapper;
    @Resource
    private PurchasePrePaymentWriteOffReconciliationMapper purchasePrePaymentWriteOffReconciliationMapper;
    @Autowired
    private FinanceEnterpriseOutinvoiceService financeEnterpriseOutinvoiceService;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private SaleContractItemLocalRpcService saleContractItemLocalRpcService;
    @Autowired
    private StaticConfig staticConfig;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO saleReconciliationPage) {
        this.buildReconciliation(salePerformanceReconciliation);
        this.salePerformanceReconciliationMapper.insert((Object)salePerformanceReconciliation);
        this.insertData(salePerformanceReconciliation, saleReconciliationPage);
        this.calculateMoney(salePerformanceReconciliation, saleReconciliationPage);
        this.invokeBaseRpcService.addStatusLog(salePerformanceReconciliation.getRelationId(), ReconciliationStatusEmun.NEW.getValue(), "salePerformanceReconciliation", "inster");
    }

    private void insertData(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO salePerformanceReconciliationVO) {
        this.deleteDetail(salePerformanceReconciliation.getId());
        List<SaleRecCharge> saleRecChargeList = salePerformanceReconciliationVO.getSaleRecChargeList();
        List<SaleRecContractPromise> saleRecContractPromiseList = salePerformanceReconciliationVO.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = salePerformanceReconciliationVO.getSaleRecContractAcceptanceList();
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList = salePerformanceReconciliationVO.getSalePrePaymentWriteOffReconciliationList();
        this.insertContractPromise(salePerformanceReconciliation, saleRecContractPromiseList);
        this.insertContractAcceptance(salePerformanceReconciliation, saleRecContractAcceptanceList);
        this.insertDeductCost(salePerformanceReconciliation, saleRecChargeList);
        this.insertPrePaymentWriteOff(salePerformanceReconciliation, prePaymentWriteOffList);
    }

    private void generateReconciliation(SalePerformanceReconciliation reconciliation, SalePerformanceReconciliationVO vo) {
        boolean flag = false;
        List<SaleRecContractPromise> contractPromiseList = vo.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> contractAcceptanceList = vo.getSaleRecContractAcceptanceList();
        List<SaleRecCharge> chargeList = vo.getSaleRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> writeOffList = vo.getSalePrePaymentWriteOffReconciliationList();
        HashSet currencySet = new HashSet();
        Set promiseCurrencySet = contractPromiseList.stream().filter(items -> !StringUtils.isEmpty((CharSequence)items.getCurrency())).map(SaleRecContractPromise::getCurrency).collect(Collectors.toSet());
        Set acceptanceCurrencySet = contractAcceptanceList.stream().map(SaleRecContractAcceptance::getCurrency).collect(Collectors.toSet());
        currencySet.addAll(promiseCurrencySet);
        currencySet.addAll(acceptanceCurrencySet);
        if (CollectionUtils.isEmpty(currencySet)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmneIZtSneOltlqLV_76c274e8", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u5408\u540c\u5c65\u7ea6\u5355\u6216\u5408\u540c\u9a8c\u6536\u5355 \u5e01\u522b\u4e3a\u7a7a"));
        }
        for (String currency : currencySet) {
            Set taxCodes;
            boolean taxCodeFlag = true;
            String taxCode = "";
            ArrayList<SaleRecContractPromise> promises = new ArrayList();
            if (!CollectionUtils.isEmpty(contractPromiseList)) {
                promises = contractPromiseList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
                Set taxCodes2 = contractPromiseList.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getTaxCode())).map(SaleRecContractPromise::getTaxCode).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(taxCodes2) && taxCodes2.size() == 1) {
                    Optional taxCodeOption = taxCodes2.stream().findFirst();
                    taxCode = (String)taxCodeOption.get();
                } else {
                    taxCodeFlag = false;
                }
            }
            ArrayList<SaleRecContractAcceptance> acceptances = new ArrayList();
            if (!CollectionUtils.isEmpty(contractAcceptanceList)) {
                acceptances = contractAcceptanceList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
                Set taxCodes3 = contractAcceptanceList.stream().map(SaleRecContractAcceptance::getTaxCode).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(taxCodes3) || taxCodes3.size() != 1 || !taxCodes3.contains(taxCode)) {
                    taxCodeFlag = false;
                }
            }
            if (CollectionUtils.isEmpty(promises) && CollectionUtils.isEmpty(acceptances)) continue;
            List<Object> charges = new ArrayList();
            if (!(CollectionUtils.isEmpty(chargeList) || !CollectionUtils.isEmpty(taxCodes = (charges = chargeList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList())).stream().map(SaleRecCharge::getTaxCode).collect(Collectors.toSet())) && taxCodes.size() == 1 && taxCodes.contains(taxCode))) {
                taxCodeFlag = false;
            }
            ArrayList<SalePrePaymentWriteOffReconciliation> writeOffs = new ArrayList();
            if (!CollectionUtils.isEmpty(writeOffList)) {
                writeOffs = writeOffList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
            }
            reconciliation.setCurrency(currency);
            if (taxCodeFlag) {
                reconciliation.setTaxCode(taxCode);
                this.setTaxRate(reconciliation, taxCode);
            }
            if (flag) {
                SalePerformanceReconciliation saleReconciliation = new SalePerformanceReconciliation();
                BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)saleReconciliation));
                saleReconciliation.setId(null);
                String reconciliationNumber = this.invokeBaseRpcService.getNextCode("salePerformanceReconciliation", (Object)saleReconciliation);
                saleReconciliation.setReconciliationNumber(reconciliationNumber);
                SalePerformanceReconciliationVO reconciliationVO = new SalePerformanceReconciliationVO(promises, acceptances, charges, writeOffs);
                this.calculateMoney(saleReconciliation, reconciliationVO);
                this.checkSettlementAmount(saleReconciliation);
                this.salePerformanceReconciliationMapper.insert((Object)saleReconciliation);
                this.insertData(saleReconciliation, reconciliationVO);
                this.salePerformanceReconciliationMapper.updateById((Object)saleReconciliation);
                continue;
            }
            SalePerformanceReconciliationVO reconciliationVO = new SalePerformanceReconciliationVO(promises, acceptances, charges, writeOffs);
            this.calculateMoney(reconciliation, reconciliationVO);
            this.checkSettlementAmount(reconciliation);
            this.salePerformanceReconciliationMapper.updateById((Object)reconciliation);
            this.insertData(reconciliation, reconciliationVO);
            flag = true;
        }
    }

    private void checkSettlementAmount(SalePerformanceReconciliation saleReconciliation) {
        if ("1".equals(saleReconciliation.getSaveForZero())) {
            if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                throw new ELSBootException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + saleReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
            }
        } else if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
            throw new ELSBootException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + saleReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e\u7b49\u4e8e0\u90fd\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
        }
    }

    private void setTaxRate(SalePerformanceReconciliation reconciliation, String taxCode) {
        if (reconciliation.getTaxRate() == null) {
            return;
        }
        List taxs = this.elsTaxRpcService.findList(reconciliation.getElsAccount(), taxCode);
        if (CollectionUtils.isEmpty((Collection)taxs)) {
            return;
        }
        Optional taxOptional = taxs.stream().findFirst();
        if (taxOptional.isPresent()) {
            ElsTaxDTO elsTaxDTO = (ElsTaxDTO)taxOptional.get();
            reconciliation.setTaxRate(elsTaxDTO.getTaxRate());
        }
    }

    private void insertPrePaymentWriteOff(SalePerformanceReconciliation salePerformanceReconciliation, List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(salePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)salePerformanceReconciliation);
            prePaymentWriteOff.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            prePaymentWriteOff.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.salePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    public void calculateMoney(SalePerformanceReconciliation reconciliation, SalePerformanceReconciliationVO saleReconciliationVO) {
        List<SaleRecContractPromise> saleRecContractPromiseList = saleReconciliationVO.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = saleReconciliationVO.getSaleRecContractAcceptanceList();
        List<SaleRecCharge> charges = saleReconciliationVO.getSaleRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList = saleReconciliationVO.getSalePrePaymentWriteOffReconciliationList();
        BigDecimal performanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            performanceIncludeTaxAmount = saleRecContractPromiseList.parallelStream().filter(item -> item.getAmount() != null).map(SaleRecContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setPerformanceIncludeTaxAmount(performanceIncludeTaxAmount);
        }
        BigDecimal acceptanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            acceptanceIncludeTaxAmount = saleRecContractAcceptanceList.parallelStream().filter(item -> item.getTaxAmount() != null).map(SaleRecContractAcceptance::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setAcceptanceIncludeTaxAmount(acceptanceIncludeTaxAmount);
        }
        BigDecimal chargeTotalAmount = BigDecimal.ZERO;
        BigDecimal chargeAmount = BigDecimal.ZERO;
        BigDecimal buckleTicketsAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(charges)) {
            for (SaleRecCharge saleRecCharge : charges) {
                chargeTotalAmount = chargeTotalAmount.add(saleRecCharge.getTotalAmount());
                if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(saleRecCharge.getDeductionType())) {
                    chargeAmount = chargeAmount.add(saleRecCharge.getTotalAmount());
                }
                if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(saleRecCharge.getDeductionType())) continue;
                buckleTicketsAmount = buckleTicketsAmount.add(saleRecCharge.getTotalAmount());
            }
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = performanceIncludeTaxAmount.add(acceptanceIncludeTaxAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(SalePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setWrittenOffAmount(writtenOffAmount);
        }
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
        this.salePerformanceReconciliationMapper.updateById((Object)reconciliation);
    }

    private void insertDeductCost(SalePerformanceReconciliation saleReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge entity : saleRecChargeList) {
            entity.setHeadId(saleReconciliation.getId());
            entity.setId(null);
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            ++itemNumber;
        }
        if (!saleRecChargeList.isEmpty()) {
            this.saleRecChargeService.saveBatch(saleRecChargeList, 2000);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertContractAcceptance(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleRecContractAcceptance> saleRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        for (SaleRecContractAcceptance saleRecContractAcceptance : saleRecContractAcceptanceList) {
            saleRecContractAcceptance.setId(null);
            saleRecContractAcceptance.setHeadId(salePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)saleRecContractAcceptance, (BaseEntity)salePerformanceReconciliation);
            saleRecContractAcceptance.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleRecContractAcceptance.setItemNumber(String.valueOf(itemNumber));
            saleRecContractAcceptance.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            saleRecContractAcceptance.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
            SaleContractAcceptanceDTO saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(saleRecContractAcceptance.getBusinessId());
            if (saleContractAcceptance != null) {
                saleContractAcceptance.setCostStatus("1");
                saleContractAcceptance.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
                saleContractAcceptanceList.add(saleContractAcceptance);
                PurchaseContractAcceptanceDTO purchaseContractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(saleContractAcceptance.getRelationId());
                if (purchaseContractAcceptance != null) {
                    purchaseContractAcceptance.setCostStatus("1");
                    purchaseContractAcceptance.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
                    purchaseContractAcceptanceList.add(purchaseContractAcceptance);
                }
            }
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            this.saleRecContractAcceptanceService.saveBatch(saleRecContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
    }

    private void insertContractPromise(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleRecContractPromise> saleRecContractPromiseList) {
        if (CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            return;
        }
        ArrayList<SaleContractPromiseDTO> saleContractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        ArrayList<PurchaseContractPromiseDTO> purchaseContractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        int itemNumber = 1;
        for (SaleRecContractPromise saleRecContractPromise : saleRecContractPromiseList) {
            saleRecContractPromise.setHeadId(salePerformanceReconciliation.getId());
            saleRecContractPromise.setId(null);
            SysUtil.setSysParam((BaseEntity)saleRecContractPromise, (BaseEntity)salePerformanceReconciliation);
            saleRecContractPromise.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleRecContractPromise.setItemNumber(String.valueOf(itemNumber));
            saleRecContractPromise.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            saleRecContractPromise.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
            SaleContractPromiseDTO saleContractPromise = this.saleContractPromiseLocalRpcService.getById(saleRecContractPromise.getBusinessId());
            if (saleContractPromise != null) {
                saleContractPromise.setReconciliationStatus("1");
                saleContractPromise.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
                saleContractPromiseList.add(saleContractPromise);
                PurchaseContractPromiseDTO purchaseContractPromise = this.purchaseContractPromiseLocalRpcService.getById(saleContractPromise.getRelationId());
                if (purchaseContractPromise != null) {
                    purchaseContractPromise.setReconciliationStatus("1");
                    purchaseContractPromise.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
                    purchaseContractPromiseList.add(purchaseContractPromise);
                }
            }
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            this.saleRecContractPromiseService.saveBatch(saleRecContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(saleContractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(saleContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(purchaseContractPromiseList);
        }
    }

    private void deleteDetail(String id) {
        this.saleRecContractPromiseService.deleteByMainId(id);
        this.saleRecContractAcceptanceService.deleteByMainId(id);
        this.saleRecChargeService.deleteByMainId(id);
        this.salePrePaymentWriteOffReconciliationService.deleteByMainId(id);
        this.saleInvoiceMapper.deleteByMainId(id);
    }

    private void buildReconciliation(SalePerformanceReconciliation salePerformanceReconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("salePerformanceReconciliation", (Object)salePerformanceReconciliation, salePerformanceReconciliation.getBusAccount());
        salePerformanceReconciliation.setReconciliationNumber(reconciliationNumber);
        salePerformanceReconciliation.setBusAccount(salePerformanceReconciliation.getToElsAccount());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(salePerformanceReconciliation.getTemplateNumber());
        if (templateHead != null) {
            salePerformanceReconciliation.setTemplateName(templateHead.getTemplateName());
            salePerformanceReconciliation.setTemplateNumber(templateHead.getTemplateNumber());
            salePerformanceReconciliation.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            salePerformanceReconciliation.setTemplateAccount(templateHead.getElsAccount());
        }
        salePerformanceReconciliation.setCreateAccount(TenantContext.getTenant());
        salePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.NEW.getValue());
        salePerformanceReconciliation.setSaleRecSendStatus("0");
        salePerformanceReconciliation.setInvoiced("0");
        salePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.NEW.getValue());
        salePerformanceReconciliation.setCancellation("0");
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            salePerformanceReconciliation.setSupplierName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(salePerformanceReconciliation.getToElsAccount())) != null) {
            salePerformanceReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        salePerformanceReconciliation.setRelationId(IdWorker.getIdStr());
        salePerformanceReconciliation.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
        this.handlePaymentExpireDate(salePerformanceReconciliation);
    }

    private void handlePaymentExpireDate(SalePerformanceReconciliation salePerformanceReconciliation) {
        if (StringUtils.isEmpty((CharSequence)salePerformanceReconciliation.getPayCycle()) || salePerformanceReconciliation.getPaymentBenchmarkDate() == null) {
            return;
        }
        Integer payCycle = Integer.valueOf(salePerformanceReconciliation.getPayCycle());
        if (payCycle > 0) {
            DateTime paymentExpireDate = DateUtil.offsetDay((Date)salePerformanceReconciliation.getPaymentBenchmarkDate(), (int)payCycle);
            salePerformanceReconciliation.setPaymentExpiredate((Date)paymentExpireDate);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> updateMain(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO saleReconciliationPage) {
        List<SaleRecContractPromise> saleRecContractPromiseList = saleReconciliationPage.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = saleReconciliationPage.getSaleRecContractAcceptanceList();
        List<SaleRecCharge> saleRecChargeList = saleReconciliationPage.getSaleRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffReconciliationList = saleReconciliationPage.getSalePrePaymentWriteOffReconciliationList();
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            this.cancelCharges(salePerformanceReconciliation.getId(), null);
            this.saleRecChargeService.deleteByMainId(salePerformanceReconciliation.getId());
        }
        if (CollectionUtils.isEmpty(salePrePaymentWriteOffReconciliationList)) {
            this.salePrePaymentWriteOffReconciliationService.deleteByMainId(salePerformanceReconciliation.getId());
        }
        if (CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            this.cancelContractPromise(salePerformanceReconciliation.getId(), null);
            this.saleRecContractPromiseService.deleteByMainId(salePerformanceReconciliation.getId());
        }
        if (CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            this.cancelContractAcceptance(salePerformanceReconciliation.getId(), null);
            this.saleRecContractAcceptanceService.deleteByMainId(salePerformanceReconciliation.getId());
        }
        if (CollectionUtils.isEmpty(saleRecContractPromiseList) && CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            this.calculateMoney(salePerformanceReconciliation, saleReconciliationPage);
            this.checkSettlementAmount(salePerformanceReconciliation);
            this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
            return Result.ok();
        }
        this.cancelContractPromise(salePerformanceReconciliation.getId(), null);
        this.cancelContractAcceptance(salePerformanceReconciliation.getId(), null);
        this.cancelCharges(salePerformanceReconciliation.getId(), null);
        this.handlePaymentExpireDate(salePerformanceReconciliation);
        this.generateReconciliation(salePerformanceReconciliation, saleReconciliationPage);
        return Result.ok();
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.salePerformanceReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    private void cancelContractPromise(String id, List<String> existIds) {
        List<SaleRecContractPromise> saleRecContractPromiseList = this.saleRecContractPromiseService.selectByMainId(id);
        if (CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            return;
        }
        ArrayList<SaleContractPromiseDTO> contractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        ArrayList<PurchaseContractPromiseDTO> purchaseContractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        for (SaleRecContractPromise saleRecContractPromise : saleRecContractPromiseList) {
            PurchaseContractPromiseDTO purchaseContractPromise;
            SaleContractPromiseDTO contractPromise;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(saleRecContractPromise.getBusinessId()) || (contractPromise = this.saleContractPromiseLocalRpcService.getById(saleRecContractPromise.getBusinessId())) == null) continue;
            contractPromise.setReconciliationStatus("0");
            contractPromise.setReconciliationNumber(null);
            contractPromiseList.add(contractPromise);
            String relationId = contractPromise.getRelationId();
            if (StringUtils.isEmpty((CharSequence)relationId) || (purchaseContractPromise = this.purchaseContractPromiseLocalRpcService.getById(relationId)) == null) continue;
            purchaseContractPromise.setReconciliationStatus("0");
            purchaseContractPromise.setReconciliationNumber(null);
            purchaseContractPromiseList.add(purchaseContractPromise);
        }
        if (!CollectionUtils.isEmpty(contractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(contractPromiseList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(purchaseContractPromiseList);
        }
    }

    private void cancelContractAcceptance(String id, List<String> existIds) {
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = this.saleRecContractAcceptanceService.selectByMainId(id);
        if (CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            return;
        }
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        for (SaleRecContractAcceptance saleRecContractAcceptance : saleRecContractAcceptanceList) {
            PurchaseContractAcceptanceDTO purchaseContractAcceptance;
            SaleContractAcceptanceDTO saleContractAcceptance;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(saleRecContractAcceptance.getBusinessId()) || (saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(saleRecContractAcceptance.getBusinessId())) == null) continue;
            saleContractAcceptance.setCostStatus("0");
            saleContractAcceptance.setReconciliationNumber(null);
            saleContractAcceptanceList.add(saleContractAcceptance);
            String relationId = saleContractAcceptance.getRelationId();
            if (StringUtils.isEmpty((CharSequence)relationId) || (purchaseContractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(relationId)) == null) continue;
            purchaseContractAcceptance.setCostStatus("0");
            purchaseContractAcceptance.setReconciliationNumber(null);
            purchaseContractAcceptanceList.add(purchaseContractAcceptance);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
    }

    private void cancelCharges(String id, List<String> existIds) {
        List<SaleRecCharge> charges = this.saleRecChargeService.selectByMainId(id);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge charge : charges) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId())) continue;
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("0");
            deductCost.setReconciliationNumber(null);
            deductCosts.add(deductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SalePerformanceReconciliation saleReconciliation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
            BigDecimal closingAmount = saleReconciliation.getClosingAmount();
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                saleReconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
            } else if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                saleReconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
            }
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.REFUSED.getValue());
            saleReconciliation.setStatus(ReconciliationBillStatusEnum.SALE_REFUSED.getValue());
            opt = "refund";
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountBySale(saleReconciliation.getRelationId(), saleReconciliation.getToElsAccount(), saleReconciliation.getElsAccount());
        }
        this.updateById((Object)saleReconciliation);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "reconciliation", opt);
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setReconciliationStatus(saleReconciliation.getReconciliationStatus());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            purchaseReconciliation.setStatus(saleReconciliation.getStatus());
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        this.handleMessage(saleReconciliation, opt, purchaseReconciliation);
    }

    private void handleMessage(SalePerformanceReconciliation saleReconciliation, String opt, PurchasePerformanceReconciliation purchaseReconciliation) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        saleReconciliation.setFbk18(serviceAddress + "/srm/reconciliation/sale/SaleReconciliation?id=" + saleReconciliation.getId() + "&open=true&toInvoice=true");
        if (!StringUtils.isEmpty((CharSequence)opt) && purchaseReconciliation != null) {
            String url = "id=" + purchaseReconciliation.getId() + "&createAccount=" + purchaseReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)saleReconciliation.getPurchasePrincipal())) {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "reconciliation", opt);
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "saleReconciliation", opt);
            } else {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "reconciliation", opt);
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getElsAccount(), (Object)saleReconciliation, url, "saleReconciliation", opt);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleInvoice> saleInvoiceList, String operation) {
        this.saleInvoiceMapper.deleteByMainId(salePerformanceReconciliation.getId());
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        BigDecimal notIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (SaleInvoice saleInvoice : saleInvoiceList) {
            saleInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)saleInvoice.getInvoiceNumber())) {
                saleInvoice.setInvoiceNumber(this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)saleInvoice, salePerformanceReconciliation.getToElsAccount()));
            }
            if ("save".equals(operation)) {
                if (!InvoiceStatusEnum.RENTURNED.getValue().equals(saleInvoice.getStatus())) {
                    saleInvoice.setStatus(InvoiceStatusEnum.NEW.getValue());
                }
            } else if ("send".equals(operation)) {
                saleInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            }
            if (saleInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = saleInvoice.getTaxRate().divide(new BigDecimal(100)).add(BigDecimal.ONE);
                saleInvoice.setNotIncludeTaxAmount(saleInvoice.getIncludeTaxAmount().divide(tax, 5));
            }
            if (saleInvoice.getTaxAmount() == null) {
                saleInvoice.setTaxAmount(saleInvoice.getIncludeTaxAmount().subtract(saleInvoice.getNotIncludeTaxAmount()));
            }
            saleInvoice.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleInvoice.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            saleInvoice.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
            saleInvoice.setHeadId(salePerformanceReconciliation.getId());
            String documentId = salePerformanceReconciliation.getDocumentId();
            if (!StringUtils.isEmpty((CharSequence)documentId)) {
                saleInvoice.setDocumentId(documentId);
            }
            saleInvoice.setDocumentParentId(salePerformanceReconciliation.getRelationId());
            SysUtil.setSysParam((BaseEntity)saleInvoice, (BaseEntity)salePerformanceReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(saleInvoice.getIncludeTaxAmount());
            notIncludeTaxAmount = notIncludeTaxAmount.add(saleInvoice.getNotIncludeTaxAmount());
            taxAmount = taxAmount.add(saleInvoice.getTaxAmount());
        }
        salePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)salePerformanceReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
            purchaseReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
            purchaseReconciliation.setTaxAmount(taxAmount);
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        if (!saleInvoiceList.isEmpty()) {
            this.saleInvoiceMapper.insertBatchSomeColumn(saleInvoiceList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void sendInvoice(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleInvoice> saleInvoiceList) {
        salePerformanceReconciliation.setInvoiced("1");
        salePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
        salePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_UNCONFIRMED.getValue());
        this.saveInvoice(salePerformanceReconciliation, saleInvoiceList, "send");
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)salePerformanceReconciliation.getRelationId())));
        if (purchasePerformanceReconciliation != null) {
            purchasePerformanceReconciliation.setInvoiced("1");
            purchasePerformanceReconciliation.setRelationId(salePerformanceReconciliation.getId());
            purchasePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
            purchasePerformanceReconciliation.setTotalInvoiceAmount(salePerformanceReconciliation.getTotalInvoiceAmount());
            purchasePerformanceReconciliation.setSaleRemark(salePerformanceReconciliation.getSaleRemark());
            purchasePerformanceReconciliation.setStatus(salePerformanceReconciliation.getStatus());
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
            this.purchaseInvoiceMapper.deleteByMainId(purchasePerformanceReconciliation.getId());
            ArrayList<PurchaseInvoice> purchaseInvoices = new ArrayList<PurchaseInvoice>();
            for (SaleInvoice saleInvoice : saleInvoiceList) {
                PurchaseInvoice purchaseInvoice = new PurchaseInvoice();
                BeanUtils.copyProperties((Object)((Object)saleInvoice), (Object)((Object)purchaseInvoice));
                purchaseInvoice.setRelationId(saleInvoice.getId());
                purchaseInvoice.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
                purchaseInvoice.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
                purchaseInvoice.setHeadId(purchasePerformanceReconciliation.getId());
                purchaseInvoice.setId(null);
                purchaseInvoices.add(purchaseInvoice);
            }
            this.sendMessage(salePerformanceReconciliation, purchasePerformanceReconciliation, "invoice");
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoices);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SalePerformanceReconciliationVO extractReconciliation(SalePerformanceReconciliationVO reconciliationVO) {
        ReconciliationVO vo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)vo);
        SaleContractPromiseDTO saleContractPromiseDTO = new SaleContractPromiseDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)saleContractPromiseDTO);
        List<SaleContractPromiseDTO> saleContractPromiseList = this.saleContractPromiseLocalRpcService.listSaleContractPromiseDTO(saleContractPromiseDTO);
        List<SaleRecContractPromise> saleRecContractPromiseList = this.getSaleRecContractPromiseList(saleContractPromiseList);
        reconciliationVO.setSaleRecContractPromiseList(saleRecContractPromiseList);
        SaleContractAcceptanceDTO saleContractAcceptanceDTO = new SaleContractAcceptanceDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)saleContractAcceptanceDTO);
        List<SaleContractAcceptanceDTO> saleContractAcceptanceList = this.saleContractAcceptanceLocalRpcService.listSaleContractAcceptanceDTO(saleContractAcceptanceDTO);
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = this.getSaleRecContractAcceptanceList(saleContractAcceptanceList);
        reconciliationVO.setSaleRecContractAcceptanceList(saleRecContractAcceptanceList);
        List<SaleRecCharge> charges = this.saleDeductCostService.getBySaleDeductCost(vo);
        reconciliationVO.setSaleRecChargeList(charges);
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.salePaymentApplyItemService.getSalePrePaymentWriteOffReconciliations(vo);
        reconciliationVO.setSalePrePaymentWriteOffReconciliationList(prePaymentWriteOff);
        return reconciliationVO;
    }

    private List<SaleRecContractAcceptance> getSaleRecContractAcceptanceList(List<SaleContractAcceptanceDTO> saleContractAcceptanceList) {
        ArrayList<SaleRecContractAcceptance> list = new ArrayList<SaleRecContractAcceptance>();
        for (SaleContractAcceptanceDTO saleContractAcceptanceDTO : saleContractAcceptanceList) {
            SaleRecContractAcceptance dto = new SaleRecContractAcceptance();
            BeanUtils.copyProperties((Object)saleContractAcceptanceDTO, (Object)((Object)dto));
            dto.setId(null);
            dto.setBusinessId(saleContractAcceptanceDTO.getId());
            list.add(dto);
        }
        return list;
    }

    private List<SaleRecContractPromise> getSaleRecContractPromiseList(List<SaleContractPromiseDTO> saleContractPromiseList) {
        ArrayList<SaleRecContractPromise> list = new ArrayList<SaleRecContractPromise>();
        if (CollectionUtils.isEmpty(saleContractPromiseList)) {
            return list;
        }
        for (SaleContractPromiseDTO saleContractPromiseDTO : saleContractPromiseList) {
            SaleRecContractPromise dto = new SaleRecContractPromise();
            BeanUtils.copyProperties((Object)saleContractPromiseDTO, (Object)((Object)dto));
            dto.setMasterContractNumber(saleContractPromiseDTO.getContractNumber());
            dto.setContractParties(saleContractPromiseDTO.getSupplierName());
            dto.setContractPromise(saleContractPromiseDTO.getPerformingPartyName());
            dto.setContractDrawer(saleContractPromiseDTO.getInvoicedName());
            dto.setContractReceiver(saleContractPromiseDTO.getPayeeName());
            dto.setBusinessId(saleContractPromiseDTO.getId());
            dto.setCurrency(saleContractPromiseDTO.getCurreny());
            dto.setId(null);
            list.add(dto);
        }
        return list;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO saleReconciliationVO) {
        this.saleRecContractPromiseService.checkPromise(saleReconciliationVO);
        this.saleRecContractAcceptanceService.checkAcceptance(saleReconciliationVO);
        this.saleRecChargeService.checkPerformanceReconcilationedCharge(saleReconciliationVO);
        ReconciliationVO vo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)salePerformanceReconciliation), (Object)vo);
        this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupyBySale(vo, saleReconciliationVO.getSalePrePaymentWriteOffReconciliationList());
        boolean flag = false;
        if (SaleStatusEmun.REFUSED.getValue().equals(salePerformanceReconciliation.getSaleRecAffirmStatus()) && StringUtils.isNotBlank((CharSequence)salePerformanceReconciliation.getRelationId())) {
            flag = true;
        }
        salePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.UNCONFIRMED.getValue());
        salePerformanceReconciliation.setSaleRecSendStatus("1");
        salePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.PURCHASDE_UNCONFIRMED.getValue());
        this.updateMain(salePerformanceReconciliation, saleReconciliationVO);
        this.invokeBaseRpcService.addStatusLog(salePerformanceReconciliation.getRelationId(), salePerformanceReconciliation.getReconciliationStatus(), "saleReconciliation", "publish");
        String id = salePerformanceReconciliation.getRelationId();
        PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)salePerformanceReconciliation), (Object)((Object)purchaseReconciliation));
        purchaseReconciliation.setElsAccount(salePerformanceReconciliation.getToElsAccount());
        purchaseReconciliation.setToElsAccount(salePerformanceReconciliation.getElsAccount());
        purchaseReconciliation.setRelationId(salePerformanceReconciliation.getId());
        purchaseReconciliation.setStatus(salePerformanceReconciliation.getStatus());
        if (flag) {
            purchaseReconciliation.setId(id);
            purchaseReconciliation.setSaleRecAffirmStatus(salePerformanceReconciliation.getSaleRecAffirmStatus());
            purchaseReconciliation.setSaleRecSendStatus(salePerformanceReconciliation.getSaleRecSendStatus());
            purchaseReconciliation.setStatus(salePerformanceReconciliation.getStatus());
            purchaseReconciliation.setDataVersion(null);
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleReconciliationVO);
        } else {
            purchaseReconciliation.setId(id);
            this.purchasePerformanceReconciliationMapper.insert((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleReconciliationVO);
            salePerformanceReconciliation.setRelationId(purchaseReconciliation.getId());
        }
        this.sendMessage(salePerformanceReconciliation, purchaseReconciliation, "saleReconciliation");
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hxLRW_c95760c0", (String)"\u53d1\u5e03\u6210\u529f\uff01"));
    }

    private void handleDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, SalePerformanceReconciliationVO reconciliationVO) {
        List<SaleRecContractPromise> saleRecContractPromiseList = reconciliationVO.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = reconciliationVO.getSaleRecContractAcceptanceList();
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = reconciliationVO.getSalePrePaymentWriteOffReconciliationList();
        List<SaleRecCharge> saleRecChargeList = reconciliationVO.getSaleRecChargeList();
        List<SaleAttachmentDTO> attachments = reconciliationVO.getAttachments();
        this.purchasePerformanceReconciliationService.deleteDetail(purchasePerformanceReconciliation.getId());
        this.handlePurchaseRecContractPromiseDetail(purchasePerformanceReconciliation, saleRecContractPromiseList);
        this.handlePurchaseRecContractAcceptanceDetail(purchasePerformanceReconciliation, saleRecContractAcceptanceList);
        this.handlePurchaseRecChargeDetail(purchasePerformanceReconciliation, saleRecChargeList);
        this.handlePurchaseRecPrePaymentWriteOffDetail(purchasePerformanceReconciliation, salePrePaymentWriteOffList);
        this.handlePurchaseAttachmentDetail(purchasePerformanceReconciliation, attachments);
    }

    private void handlePurchaseRecPrePaymentWriteOffDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(salePrePaymentWriteOffList)) {
            return;
        }
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : salePrePaymentWriteOffList) {
            PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation = new PurchasePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)prePaymentWriteOff), (Object)((Object)prePaymentWriteOffReconciliation));
            prePaymentWriteOffReconciliation.setId(null);
            prePaymentWriteOffReconciliation.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
            prePaymentWriteOffReconciliation.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            prePaymentWriteOffReconciliation.setHeadId(purchasePerformanceReconciliation.getId());
            prePaymentWriteOffReconciliation.setRelationId(prePaymentWriteOff.getId());
            purchasePrePaymentWriteOffList.add(prePaymentWriteOffReconciliation);
        }
        this.purchasePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(purchasePrePaymentWriteOffList);
    }

    private void handlePurchaseRecContractAcceptanceDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<SaleRecContractAcceptance> saleRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            return;
        }
        ArrayList<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = new ArrayList<PurchaseRecContractAcceptance>();
        for (SaleRecContractAcceptance saleRecContractAcceptance : saleRecContractAcceptanceList) {
            PurchaseRecContractAcceptance purchaseRecContractAcceptance = new PurchaseRecContractAcceptance();
            BeanUtils.copyProperties((Object)((Object)saleRecContractAcceptance), (Object)((Object)purchaseRecContractAcceptance));
            purchaseRecContractAcceptance.setId(null);
            purchaseRecContractAcceptance.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
            purchaseRecContractAcceptance.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            purchaseRecContractAcceptance.setHeadId(purchasePerformanceReconciliation.getId());
            purchaseRecContractAcceptance.setRelationId(saleRecContractAcceptance.getId());
            purchaseRecContractAcceptanceList.add(purchaseRecContractAcceptance);
        }
        this.purchaseRecContractAcceptanceMapper.insertBatchSomeColumn(purchaseRecContractAcceptanceList);
    }

    private void handlePurchaseRecContractPromiseDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<SaleRecContractPromise> saleRecContractPromiseList) {
        if (CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseRecContractPromise> purchaseRecContractPromiseList = new ArrayList<PurchaseRecContractPromise>();
        for (SaleRecContractPromise saleRecContractPromise : saleRecContractPromiseList) {
            PurchaseRecContractPromise purchaseRecContractPromise = new PurchaseRecContractPromise();
            BeanUtils.copyProperties((Object)((Object)saleRecContractPromise), (Object)((Object)purchaseRecContractPromise));
            purchaseRecContractPromise.setId(null);
            purchaseRecContractPromise.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
            purchaseRecContractPromise.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            purchaseRecContractPromise.setHeadId(purchasePerformanceReconciliation.getId());
            purchaseRecContractPromise.setRelationId(saleRecContractPromise.getId());
            purchaseRecContractPromiseList.add(purchaseRecContractPromise);
        }
        this.purchaseRecContractPromiseMapper.insertBatchSomeColumn(purchaseRecContractPromiseList);
    }

    private void handlePurchaseRecChargeDetail(PurchasePerformanceReconciliation purchaseReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        ArrayList<PurchaseRecCharge> purchaseRecCharges = new ArrayList<PurchaseRecCharge>();
        for (SaleRecCharge saleRecCharge : saleRecChargeList) {
            PurchaseRecCharge purchaseRecCharge = new PurchaseRecCharge();
            BeanUtils.copyProperties((Object)((Object)saleRecCharge), (Object)((Object)purchaseRecCharge));
            purchaseRecCharge.setId(null);
            purchaseRecCharge.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecCharge.setHeadId(purchaseReconciliation.getId());
            purchaseRecCharge.setRelationId(saleRecCharge.getId());
            purchaseRecCharges.add(purchaseRecCharge);
        }
        this.purchaseRecChargeMapper.insertBatchSomeColumn(purchaseRecCharges);
    }

    private void handlePurchaseAttachmentDetail(PurchasePerformanceReconciliation purchaseReconciliation, List<SaleAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO saleAttachment : attachments) {
            saleAttachment.setSendStatus("1");
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseAttachment.setHeadId(purchaseReconciliation.getId());
            purchaseAttachment.setRelationId(saleAttachment.getId());
            purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachment);
        }
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (salePerformanceReconciliation != null) {
            this.confirmOrRefused(salePerformanceReconciliation, operation);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        ((SalePerformanceReconciliationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatch(List<String> idList) {
        ((SalePerformanceReconciliationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private void sendMessage(SalePerformanceReconciliation salePerformanceReconciliation, PurchasePerformanceReconciliation purchasePerformanceReconciliation, String invoice) {
        String url = "id=" + purchasePerformanceReconciliation.getId() + "&createAccount=" + purchasePerformanceReconciliation.getCreateAccount();
        if (StringUtils.isNotBlank((CharSequence)salePerformanceReconciliation.getPurchasePrincipal())) {
            super.sendMsg(salePerformanceReconciliation.getBusAccount(), salePerformanceReconciliation.getToElsAccount(), salePerformanceReconciliation.getPurchasePrincipal(), (Object)salePerformanceReconciliation, url, invoice, "publish");
        } else {
            super.sendMsg(salePerformanceReconciliation.getBusAccount(), salePerformanceReconciliation.getToElsAccount(), (Object)salePerformanceReconciliation, url, invoice, "publish");
        }
    }

    @Override
    public SalePerformanceReconciliationVO queryReconciliationItemList(SalePerformanceReconciliation salePerformanceReconciliation, String id) {
        SalePerformanceReconciliationVO saleReconciliationVO = new SalePerformanceReconciliationVO();
        LambdaQueryWrapper reconciliationLambdaQueryWrapper = new LambdaQueryWrapper();
        reconciliationLambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SalePerformanceReconciliation saleReconciliations = (SalePerformanceReconciliation)((Object)this.getOne((Wrapper)reconciliationLambdaQueryWrapper));
        if (saleReconciliations == null) {
            return saleReconciliationVO;
        }
        List<SaleRecContractPromise> saleRecContractPromiseList = this.saleRecContractPromiseService.selectByMainId(id);
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = this.saleRecContractAcceptanceService.selectByMainId(id);
        List<SaleRecCharge> saleRecChargeList = this.saleRecChargeService.selectByMainId(id);
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = this.salePrePaymentWriteOffReconciliationService.selectByMainId(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account", (Collection)this.invokeBaseRpcService.getPurchaseListByElsAccount(TenantContext.getTenant()));
        queryWrapper.eq((Object)"bus_type", (Object)"purchase");
        List purchaseOutinvoiceList = this.financeEnterpriseOutinvoiceService.list((Wrapper)queryWrapper);
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"bus_type", (Object)"sale");
        List saleOutinvoiceList = this.financeEnterpriseOutinvoiceService.list((Wrapper)queryWrapper);
        saleReconciliationVO.setSaleRecContractPromiseList(saleRecContractPromiseList);
        saleReconciliationVO.setSaleRecChargeList(saleRecChargeList);
        saleReconciliationVO.setSaleRecContractAcceptanceList(saleRecContractAcceptanceList);
        saleReconciliationVO.setSalePrePaymentWriteOffReconciliationList(salePrePaymentWriteOffList);
        saleReconciliationVO.setPurchaseOutinvoiceList(purchaseOutinvoiceList);
        saleReconciliationVO.setSaleOutinvoiceList(saleOutinvoiceList);
        return saleReconciliationVO;
    }

    @Override
    public Result<?> billing(SalePerformanceReconciliationVO vo) {
        List<FinanceEnterpriseOutinvoice> saleOutinvoiceList = vo.getSaleOutinvoiceList();
        List<FinanceEnterpriseOutinvoice> purchaseOutinvoiceList = vo.getPurchaseOutinvoiceList();
        Optional saleOutinvoiceOption = saleOutinvoiceList.stream().findFirst();
        Optional purchaseOutinvoiceOption = purchaseOutinvoiceList.stream().findFirst();
        if (!saleOutinvoiceOption.isPresent()) {
            return Result.error((String)"\u8bf7\u586b\u5199\u9500\u552e\u5f00\u7968\u4fe1\u606f");
        }
        if (!purchaseOutinvoiceOption.isPresent()) {
            return Result.error((String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u5f00\u7968\u4fe1\u606f");
        }
        FinanceEnterpriseOutinvoice saleOutinvoice = (FinanceEnterpriseOutinvoice)((Object)saleOutinvoiceOption.get());
        FinanceEnterpriseOutinvoice purchaseOutinvoice = (FinanceEnterpriseOutinvoice)((Object)purchaseOutinvoiceOption.get());
        ArrayList<InvoiceDetailVO> details = new ArrayList<InvoiceDetailVO>();
        this.billingContractPromise(vo.getSaleRecContractPromiseList(), details);
        this.billingContractAcceptance(vo.getSaleRecContractAcceptanceList(), details);
        List<InvoiceDetailVO> invoiceDetailList = this.saleRecChargeService.billingRecCharge(vo.getSaleRecChargeList(), details);
        SaleInvoice saleInvoice = new SaleInvoice();
        saleInvoice.setElsAccount(vo.getElsAccount());
        saleInvoice.setBusAccount(vo.getToElsAccount());
        saleInvoice.setToElsAccount(vo.getToElsAccount());
        saleInvoice.setHeadId(vo.getId());
        saleInvoice.setReconciliationNumber(vo.getReconciliationNumber());
        return this.saleInvoiceService.billing(invoiceDetailList, saleOutinvoice, purchaseOutinvoice, saleInvoice);
    }

    private void billingContractAcceptance(List<SaleRecContractAcceptance> acceptanceList, List<InvoiceDetailVO> details) {
        if (CollectionUtils.isEmpty(acceptanceList)) {
            return;
        }
        for (SaleRecContractAcceptance acceptance : acceptanceList) {
            String taxRate;
            InvoiceDetailVO detail = new InvoiceDetailVO();
            if (!StringUtils.isEmpty((CharSequence)acceptance.getAcceptanceProject())) {
                String desc = AcceptanceProjectEnum.parse(acceptance.getAcceptanceProject()).getDesc();
                detail.setGoodsName(desc);
            }
            if (!StringUtils.isEmpty((CharSequence)(taxRate = acceptance.getTaxRate()))) {
                BigDecimal taxRateDecimal = new BigDecimal(taxRate);
                detail.setTaxRate(taxRateDecimal.divide(new BigDecimal("100")) + "");
            }
            BigDecimal taxAmount = acceptance.getTaxAmount();
            BigDecimal netAmount = acceptance.getNetAmount();
            if (netAmount != null) {
                detail.setTaxExcludedAmount(netAmount + "");
                if (taxAmount != null) {
                    BigDecimal tax = taxAmount.subtract(netAmount);
                    detail.setTax(tax + "");
                    detail.setTaxIncludedAmount(taxAmount + "");
                }
            }
            detail.setWithTaxFlag(NuonuoTaxFlagEnum.TAX_NOT_INCLUDED.getValue());
            details.add(detail);
        }
    }

    private void billingContractPromise(List<SaleRecContractPromise> promiseList, List<InvoiceDetailVO> details) {
        List<PurchaseMaterialHeadDTO> materialHeadList;
        if (CollectionUtils.isEmpty(promiseList)) {
            return;
        }
        HashMap<String, PurchaseMaterialHeadDTO> materialHeadMap = new HashMap<String, PurchaseMaterialHeadDTO>();
        List<String> materialNumbers = promiseList.stream().map(SaleRecContractPromise::getMaterialNumber).collect(Collectors.toList());
        String busAccount = "";
        Optional saleRecContractPromiseOptional = promiseList.stream().findFirst();
        if (saleRecContractPromiseOptional.isPresent()) {
            SaleRecContractPromise saleRecContractPromise = (SaleRecContractPromise)((Object)saleRecContractPromiseOptional.get());
            busAccount = saleRecContractPromise.getBusAccount();
        }
        if (!CollectionUtils.isEmpty(materialHeadList = this.purchaseMaterialHeadLocalRpcService.listByNumbersBySale(materialNumbers, busAccount))) {
            for (PurchaseMaterialHeadDTO dto : materialHeadList) {
                materialHeadMap.put(dto.getMaterialNumber(), dto);
            }
        }
        HashMap<String, String> dictMap = new HashMap<String, String>();
        List dictList = this.invokeBaseRpcService.queryDictItemsByCode("unitCode", busAccount);
        for (DictDTO dict : dictList) {
            dictMap.put(dict.getValue(), dict.getText());
        }
        for (SaleRecContractPromise promise : promiseList) {
            InvoiceDetailVO detail = new InvoiceDetailVO();
            PurchaseMaterialHeadDTO dto = (PurchaseMaterialHeadDTO)materialHeadMap.get(promise.getMaterialNumber());
            if (dto != null) {
                detail.setGoodsName(dto.getMaterialName());
                detail.setSpecType(dto.getMaterialSpec());
            }
            BigDecimal amount = promise.getAmount();
            String taxRate = promise.getTaxRate();
            if (!StringUtils.isEmpty((CharSequence)taxRate)) {
                BigDecimal taxRateDecimal = new BigDecimal(taxRate).divide(new BigDecimal("100"));
                detail.setTaxRate(taxRateDecimal + "");
                if (amount != null && BigDecimal.ZERO.compareTo(amount) < 0) {
                    BigDecimal temp = taxRateDecimal.add(BigDecimal.ONE);
                    BigDecimal unTaxedAmount = amount.divide(temp, 2, 4);
                    detail.setTaxExcludedAmount(unTaxedAmount + "");
                    BigDecimal taxAmount = amount.subtract(unTaxedAmount);
                    detail.setTax(taxAmount + "");
                    detail.setTaxIncludedAmount(amount + "");
                }
            }
            detail.setWithTaxFlag(NuonuoTaxFlagEnum.TAX_INCLUDED.getValue());
            this.handleContractInfo(dictMap, promise, detail);
            this.handlePromiseInfo(promise, detail);
            details.add(detail);
        }
    }

    private void handleContractInfo(Map<String, String> dictMap, SaleRecContractPromise promise, InvoiceDetailVO detail) {
        String purchaseUnit;
        SaleContractItemDTO contractItemDTO = new SaleContractItemDTO();
        contractItemDTO.setContractNumber(promise.getMasterContractNumber());
        contractItemDTO.setMaterialNumber(promise.getMaterialNumber());
        List<SaleContractItemDTO> saleContractItemDTOS = this.saleContractItemLocalRpcService.listSaleContractItem(contractItemDTO);
        Optional saleContractItemDTOOptional = saleContractItemDTOS.stream().findFirst();
        if (!saleContractItemDTOOptional.isPresent()) {
            return;
        }
        SaleContractItemDTO contractItem = (SaleContractItemDTO)saleContractItemDTOOptional.get();
        if (contractItem.getPrice() != null) {
            detail.setPrice(contractItem.getPrice() + "");
        }
        if (!StringUtils.isEmpty((CharSequence)(purchaseUnit = contractItem.getPurchaseUnit())) && !StringUtils.isEmpty((CharSequence)dictMap.get(purchaseUnit))) {
            String union = dictMap.get(purchaseUnit);
            detail.setUnit(union);
        }
    }

    private void handlePromiseInfo(SaleRecContractPromise promise, InvoiceDetailVO detail) {
        SaleContractPromiseDTO contractPromiseDTO = new SaleContractPromiseDTO();
        contractPromiseDTO.setPromiseNumber(promise.getPromiseNumber());
        contractPromiseDTO.setMaterialNumber(promise.getMaterialNumber());
        List<SaleContractPromiseDTO> saleContractPromiseList = this.saleContractPromiseLocalRpcService.listSaleContractPromiseItemDTO(contractPromiseDTO);
        if (CollectionUtils.isEmpty(saleContractPromiseList)) {
            return;
        }
        Optional contractPromiseOptional = saleContractPromiseList.stream().findFirst();
        if (!contractPromiseOptional.isPresent()) {
            return;
        }
        SaleContractPromiseDTO contractPromise = (SaleContractPromiseDTO)contractPromiseOptional.get();
        String targetType = contractPromise.getTargetType();
        if (contractPromise.getQuantity() == null) {
            return;
        }
        if (ContractTargetTypeEnum.MONEY.getValue().equals(targetType)) {
            String taxIncludedAmount = detail.getTaxIncludedAmount();
            String price = detail.getPrice();
            if (!StringUtils.isEmpty((CharSequence)taxIncludedAmount) && !StringUtils.isEmpty((CharSequence)price)) {
                BigDecimal num = new BigDecimal(taxIncludedAmount).divide(new BigDecimal(price), 4, 4);
                detail.setNum(num + "");
            }
        } else if (ContractTargetTypeEnum.QUANTITY.getValue().equals(targetType)) {
            detail.setNum(contractPromise.getQuantity() + "");
        }
    }
}

