/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.confirm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsEsignDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmation;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.entity.SaleReconciliationConfirmation;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.rpc.ElsEsignRpcService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationService;
import com.els.modules.confirm.service.SaleReconciliationConfirmationBookBalanceService;
import com.els.modules.confirm.service.SaleReconciliationConfirmationUnpaidAccountService;
import com.els.modules.delivery.api.dto.PurchaseReconciliationConfirmationDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.finance.api.enumerate.ConfirmEsignStatusEnum;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.enumerate.ConfirmElectronicSignStatusEmun;
import com.els.modules.reconciliation.enumerate.ConfirmUnpaidAccountItemStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationConfirmStatusEnum;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationConfirmationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseReconciliationConfirmationServiceImpl
extends BaseServiceImpl<PurchaseReconciliationConfirmationMapper, PurchaseReconciliationConfirmation>
implements PurchaseReconciliationConfirmationService {
    @Resource
    private PurchaseReconciliationConfirmationMapper purchaseReconciliationConfirmationMapper;
    @Resource
    private PurchaseReconciliationConfirmationBookBalanceMapper purchaseReconciliationConfirmationBookBalanceMapper;
    @Resource
    private PurchaseReconciliationConfirmationDifferenceDescriptionMapper purchaseReconciliationConfirmationDifferenceDescriptionMapper;
    @Resource
    private PurchaseReconciliationConfirmationUnpaidAccountMapper purchaseReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleReconciliationConfirmationMapper saleReconciliationConfirmationMapper;
    @Resource
    private SaleReconciliationConfirmationBookBalanceMapper saleReconciliationConfirmationBookBalanceMapper;
    @Resource
    private SaleReconciliationConfirmationUnpaidAccountMapper saleReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private SaleReconciliationConfirmationDifferenceDescriptionMapper saleReconciliationConfirmationDifferenceDescriptionMapper;
    @Autowired
    private SaleReconciliationConfirmationBookBalanceService saleReconciliationConfirmationBookBalanceService;
    @Autowired
    private SaleReconciliationConfirmationUnpaidAccountService saleReconciliationConfirmationUnpaidAccountService;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private StaticConfig staticConfig;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseVoucherItemLocalRpcService purchaseVoucherItemRpcService;
    @Resource
    private ElsEsignRpcService elsEsignRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, PurchaseReconciliationConfirmationVO vo) {
        List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList = vo.getBalance();
        String nextCode = this.invokeBaseRpcService.getNextCode("preparedByNumber", (Object)purchaseReconciliationConfirmation);
        purchaseReconciliationConfirmation.setCreateAccount(purchaseReconciliationConfirmation.getElsAccount());
        purchaseReconciliationConfirmation.setPreparedByNumber(nextCode);
        purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.NEW.getValue());
        if ("0".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
        this.purchaseReconciliationConfirmationMapper.insert((Object)purchaseReconciliationConfirmation);
        this.insertReconciliationConfirmationBookBalance(purchaseReconciliationConfirmation, purchaseReconciliationConfirmationBookBalanceList);
        this.insertReconciliationConfirmationDifferenceDescription(purchaseReconciliationConfirmation, vo.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(purchaseReconciliationConfirmation, vo.getUnpaidAccountItem());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, PurchaseReconciliationConfirmationVO vo) {
        if ("0".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(purchaseReconciliationConfirmation.getSign())) {
            purchaseReconciliationConfirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            purchaseReconciliationConfirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
        this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(purchaseReconciliationConfirmation.getId());
        List<PurchaseReconciliationConfirmationUnpaidAccount> unpaidAccountItem = vo.getUnpaidAccountItem();
        if (!CollectionUtils.isEmpty(unpaidAccountItem)) {
            for (PurchaseReconciliationConfirmationUnpaidAccount account : unpaidAccountItem) {
                String businessNumber = account.getBusinessNumbers();
                if (StringUtils.isEmpty((CharSequence)businessNumber)) continue;
                List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
                String preparedByNumber = purchaseReconciliationConfirmation.getPreparedByNumber();
                if (ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue().equals(account.getUnpaidAccountItem())) {
                    this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                    continue;
                }
                if (!ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue().equals(account.getUnpaidAccountItem())) continue;
                this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
            }
        }
        this.insertReconciliationConfirmationBookBalance(purchaseReconciliationConfirmation, vo.getBalance());
        this.insertReconciliationConfirmationDifferenceDescription(purchaseReconciliationConfirmation, vo.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(purchaseReconciliationConfirmation, unpaidAccountItem);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        List<PurchaseReconciliationConfirmationUnpaidAccount> accountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectByMainId(id);
        ((PurchaseReconciliationConfirmationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(id);
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount unpaidAccount : accountList) {
            String businessNumber = unpaidAccount.getBusinessNumbers();
            if (StringUtils.isEmpty((CharSequence)businessNumber) || !businessNumber.contains(",")) continue;
            List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
            this.releaseConfirmStatus(businessNumbers);
        }
    }

    private void releaseConfirmStatus(List<String> businessNumbers) {
        this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseReconciliationConfirmationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, PurchaseReconciliationConfirmationVO vo) {
        Boolean flag = false;
        if (ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue().equals(purchaseReconciliationConfirmation.getPreparedByStatus()) && StringUtils.isNotBlank((CharSequence)purchaseReconciliationConfirmation.getRelationId())) {
            flag = true;
        }
        if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchaseReconciliationConfirmation.getTeamwork())) {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
        } else {
            purchaseReconciliationConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
        }
        this.updateMain(purchaseReconciliationConfirmation, vo);
        this.invokeBaseRpcService.addStatusLog(purchaseReconciliationConfirmation.getId(), purchaseReconciliationConfirmation.getPreparedByStatus(), "purchaseReconciliationConfirmation", "publish");
        String id = purchaseReconciliationConfirmation.getRelationId();
        SaleReconciliationConfirmation saleReconciliationConfirmation = new SaleReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmation), (Object)((Object)saleReconciliationConfirmation));
        saleReconciliationConfirmation.setToElsAccount(purchaseReconciliationConfirmation.getElsAccount());
        saleReconciliationConfirmation.setBusAccount(purchaseReconciliationConfirmation.getElsAccount());
        saleReconciliationConfirmation.setRelationId(purchaseReconciliationConfirmation.getId());
        saleReconciliationConfirmation.setElsAccount(purchaseReconciliationConfirmation.getToElsAccount());
        if (flag.booleanValue()) {
            saleReconciliationConfirmation.setId(id);
            saleReconciliationConfirmation.setPreparedByStatus(purchaseReconciliationConfirmation.getPreparedByStatus());
            this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
            this.handleDetail(saleReconciliationConfirmation, vo);
        } else {
            saleReconciliationConfirmation.setId(null);
            this.saleReconciliationConfirmationMapper.insert((Object)saleReconciliationConfirmation);
            this.handleDetail(saleReconciliationConfirmation, vo);
            purchaseReconciliationConfirmation.setRelationId(saleReconciliationConfirmation.getId());
            this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
        }
        this.sendMessage(purchaseReconciliationConfirmation, saleReconciliationConfirmation);
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    private void sendMessage(PurchaseReconciliationConfirmation purchaseConfirmation, SaleReconciliationConfirmation saleConfirmation) {
        String url = "id=" + saleConfirmation.getId() + "&toElsAccount" + saleConfirmation.getToElsAccount();
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(purchaseConfirmation.getToElsAccount(), "1001");
        String token = JwtUtil.getOutToken((String)(elsSubAccount.getElsAccount() + "_" + elsSubAccount.getSubAccount()), (String)elsSubAccount.getPassword());
        saleConfirmation.setFbk7(serviceAddress + "/els/reconciliation/saleReconciliationConfirmation/emailConfirmOrRefuesd?token=" + token + "&operation=confirm&id=" + saleConfirmation.getId());
        saleConfirmation.setFbk8(serviceAddress + "/els/reconciliation/saleReconciliationConfirmation/emailConfirmOrRefuesd?token=" + token + "&operation=refused&id=" + saleConfirmation.getId());
        if (StringUtils.isNotBlank((CharSequence)purchaseConfirmation.getSupplierName())) {
            super.sendMsg(purchaseConfirmation.getElsAccount(), purchaseConfirmation.getToElsAccount(), purchaseConfirmation.getSupplierName(), (Object)saleConfirmation, url, "purchaseReconciliationConfirmation", "publish");
        } else {
            super.sendMsg(purchaseConfirmation.getElsAccount(), purchaseConfirmation.getToElsAccount(), (Object)saleConfirmation, url, "purchaseReconciliationConfirmation", "publish");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> confirmOrRefused(PurchaseReconciliationConfirmation confirmation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
            opt = "refund";
        }
        this.updateById((Object)confirmation);
        this.invokeBaseRpcService.addStatusLog(confirmation.getRelationId(), confirmation.getPreparedByStatus(), "saleReconciliationConfirmation", opt);
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.saleReconciliationConfirmationMapper.selectById((Serializable)((Object)confirmation.getRelationId())));
        if (saleReconciliationConfirmation != null) {
            saleReconciliationConfirmation.setPreparedByStatus(confirmation.getPreparedByStatus());
            saleReconciliationConfirmation.setRemark(confirmation.getRemark());
            saleReconciliationConfirmation.setRelationId(confirmation.getId());
            this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
            String url = "id=" + saleReconciliationConfirmation.getId();
            if (StringUtils.isNotBlank((CharSequence)confirmation.getSupplierName())) {
                super.sendMsg(confirmation.getElsAccount(), confirmation.getToElsAccount(), confirmation.getSupplierName(), (Object)confirmation, url, "saleReconciliationConfirmation", opt);
            } else {
                super.sendMsg(confirmation.getElsAccount(), confirmation.getToElsAccount(), (Object)confirmation, url, "saleReconciliationConfirmation", opt);
            }
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
        }
        throw new RuntimeException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void opponentConfirm(PurchaseReconciliationConfirmation confirmation) {
        String opt = "confirm";
        List<PurchaseReconciliationConfirmationDifferenceDescription> purchaseDescriptionList = this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.selectByMainId(confirmation.getId());
        List<PurchaseReconciliationConfirmationBookBalance> purchaseReconciliationConfirmationBookBalanceList = this.purchaseReconciliationConfirmationBookBalanceMapper.selectByMainId(confirmation.getId());
        List<PurchaseReconciliationConfirmationUnpaidAccount> purchaseReconciliationConfirmationUnpaidAccountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectByMainId(confirmation.getId());
        if (CollectionUtils.isEmpty(purchaseDescriptionList)) {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
        } else {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue());
        }
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.saleReconciliationConfirmationMapper.selectById((Serializable)((Object)confirmation.getRelationId())));
        this.asyBalance(purchaseReconciliationConfirmationBookBalanceList);
        this.asyUnpaidAccount(purchaseReconciliationConfirmationUnpaidAccountList);
        this.handleSaleReconciliationConfirmationDifferenceDescription(saleReconciliationConfirmation, purchaseDescriptionList);
        this.updateById((Object)confirmation);
        if (saleReconciliationConfirmation != null) {
            saleReconciliationConfirmation.setPreparedByStatus(confirmation.getPreparedByStatus());
            saleReconciliationConfirmation.setRemark(confirmation.getRemark());
            saleReconciliationConfirmation.setRelationId(confirmation.getId());
            this.saleReconciliationConfirmationMapper.updateById((Object)saleReconciliationConfirmation);
        }
    }

    @Override
    public Result<?> batchSign(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        if (CollectionUtils.isEmpty(idList)) {
            throw new RuntimeException(I18nUtil.translate((String)"i18n_field_IdnRLxxMK_432d5df", (String)"\u5bf9\u5e94\u7684\u786e\u8ba4\u51fd\u4e0d\u5b58\u5728"));
        }
        List confirmationList = this.listByIds(idList);
        if (CollectionUtils.isEmpty((Collection)confirmationList)) {
            throw new RuntimeException(I18nUtil.translate((String)"i18n_field_IdnRLxxMK_432d5df", (String)"\u5bf9\u5e94\u7684\u786e\u8ba4\u51fd\u4e0d\u5b58\u5728"));
        }
        int succeed = 0;
        int fail = 0;
        ArrayList<ElsEsignDTO> elsEsignDTOList = new ArrayList<ElsEsignDTO>();
        for (PurchaseReconciliationConfirmation confirmation : confirmationList) {
            boolean signStatusFlag;
            boolean flag = ReconciliationConfirmStatusEnum.CONFIRMED.getValue().equals(confirmation.getPreparedByStatus()) && "1".equals(confirmation.getSign());
            boolean createAccountFlag = !StringUtils.isEmpty((CharSequence)confirmation.getElsAccount()) && confirmation.getElsAccount().equals(confirmation.getCreateAccount());
            boolean bl = signStatusFlag = StringUtils.isEmpty((CharSequence)confirmation.getSignStatus()) || ConfirmEsignStatusEnum.NO_START.getValue().equals(confirmation.getSignStatus()) || ConfirmEsignStatusEnum.BACK.getValue().equals(confirmation.getSignStatus());
            if (flag && createAccountFlag && signStatusFlag) {
                ElsEsignDTO dto = new ElsEsignDTO();
                dto.setBusNumber(confirmation.getPreparedByNumber());
                dto.setBusType("reconciliationConfirmation");
                dto.setRelationId(confirmation.getId());
                dto.setToElsAccount(confirmation.getToElsAccount());
                dto.setSupplierName(confirmation.getSupplierName());
                elsEsignDTOList.add(dto);
                ++succeed;
                continue;
            }
            ++fail;
        }
        this.elsEsignRpcService.saveMain(elsEsignDTOList);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLRWWWRirWWWWWWTWWWLRhAPWWWWWWWTWWKmWWWWWWT_fcb37836", (String)"\u64cd\u4f5c\u6210\u529f,  \u52fe\u9009\u4e86[${0}]\u6761,  \u6210\u529f\u53d1\u8d77\u7b7e\u7f72[${1}]\u6761, \u5931\u8d25[${2}]\u6761", (String[])new String[]{idList.size() + "", succeed + "", fail + ""}));
    }

    private void asyBalance(List<PurchaseReconciliationConfirmationBookBalance> balanceList) {
        HashMap<String, PurchaseReconciliationConfirmationBookBalance> balanceMap = new HashMap<String, PurchaseReconciliationConfirmationBookBalance>();
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        Set balanceIds = balanceList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(PurchaseReconciliationConfirmationBookBalance::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(balanceIds)) {
            return;
        }
        List saleBalanceList = this.saleReconciliationConfirmationBookBalanceMapper.selectBatchIds(balanceIds);
        if (CollectionUtils.isEmpty((Collection)saleBalanceList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationBookBalance purchaseReconciliationConfirmationBookBalance : balanceList) {
            balanceMap.put(purchaseReconciliationConfirmationBookBalance.getRelationId(), purchaseReconciliationConfirmationBookBalance);
        }
        for (SaleReconciliationConfirmationBookBalance saleReconciliationConfirmationBookBalance : saleBalanceList) {
            PurchaseReconciliationConfirmationBookBalance purchaseBalance = (PurchaseReconciliationConfirmationBookBalance)((Object)balanceMap.get(saleReconciliationConfirmationBookBalance.getId()));
            if (purchaseBalance == null) continue;
            saleReconciliationConfirmationBookBalance.setDifferenceAmount(purchaseBalance.getDifferenceAmount());
            saleReconciliationConfirmationBookBalance.setOpponentConfirmAmount(purchaseBalance.getOpponentConfirmAmount());
        }
        this.saleReconciliationConfirmationBookBalanceService.updateBatchById(saleBalanceList);
    }

    private void asyUnpaidAccount(List<PurchaseReconciliationConfirmationUnpaidAccount> unpaidAccountList) {
        HashMap<String, PurchaseReconciliationConfirmationUnpaidAccount> unpaidAccountMap = new HashMap<String, PurchaseReconciliationConfirmationUnpaidAccount>();
        if (CollectionUtils.isEmpty(unpaidAccountList)) {
            return;
        }
        Set unpaidAccountIds = unpaidAccountList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(PurchaseReconciliationConfirmationUnpaidAccount::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(unpaidAccountIds)) {
            return;
        }
        List saleUnpaidAccountList = this.saleReconciliationConfirmationUnpaidAccountMapper.selectBatchIds(unpaidAccountIds);
        if (CollectionUtils.isEmpty((Collection)saleUnpaidAccountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount purchaseReconciliationConfirmationUnpaidAccount : unpaidAccountList) {
            unpaidAccountMap.put(purchaseReconciliationConfirmationUnpaidAccount.getRelationId(), purchaseReconciliationConfirmationUnpaidAccount);
        }
        for (SaleReconciliationConfirmationUnpaidAccount saleReconciliationConfirmationUnpaidAccount : saleUnpaidAccountList) {
            PurchaseReconciliationConfirmationUnpaidAccount purchaseUnpaidAccount = (PurchaseReconciliationConfirmationUnpaidAccount)((Object)unpaidAccountMap.get(saleReconciliationConfirmationUnpaidAccount.getId()));
            if (purchaseUnpaidAccount == null) continue;
            saleReconciliationConfirmationUnpaidAccount.setDifferenceAmount(purchaseUnpaidAccount.getDifferenceAmount());
            saleReconciliationConfirmationUnpaidAccount.setOpponentConfirmAmount(purchaseUnpaidAccount.getOpponentConfirmAmount());
        }
        this.saleReconciliationConfirmationUnpaidAccountService.updateBatchById(saleUnpaidAccountList);
    }

    public void handleDetail(SaleReconciliationConfirmation saleReconciliationConfirmation, PurchaseReconciliationConfirmationVO vo) {
        List<PurchaseAttachmentDTO> attachments = vo.getAttachments();
        String id = saleReconciliationConfirmation.getId();
        this.saleReconciliationConfirmationBookBalanceMapper.deleteByMainId(id);
        this.saleReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(id);
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.handleSaleReconciliationConfirmationBookBalance(saleReconciliationConfirmation, vo.getBalance());
        this.handleSaleReconciliationConfirmationUnpaidAccount(saleReconciliationConfirmation, vo.getUnpaidAccountItem());
        this.handleSaleReconciliationConfirmationDifferenceDescription(saleReconciliationConfirmation, vo.getDifferenceDescription());
        this.handleSaleAttachmentDetail(saleReconciliationConfirmation, attachments);
    }

    private void handleSaleReconciliationConfirmationBookBalance(SaleReconciliationConfirmation confirmation, List<PurchaseReconciliationConfirmationBookBalance> balanceList) {
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        ArrayList<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList = new ArrayList<SaleReconciliationConfirmationBookBalance>();
        for (PurchaseReconciliationConfirmationBookBalance bookBalance : balanceList) {
            SaleReconciliationConfirmationBookBalance saleBookBalance = new SaleReconciliationConfirmationBookBalance();
            BeanUtils.copyProperties((Object)((Object)bookBalance), (Object)((Object)saleBookBalance));
            saleBookBalance.setId(null);
            saleBookBalance.setElsAccount(saleBookBalance.getElsAccount());
            saleBookBalance.setToElsAccount(confirmation.getToElsAccount());
            saleBookBalance.setBusAccount(confirmation.getBusAccount());
            saleBookBalance.setHeadId(confirmation.getId());
            saleBookBalance.setRelationId(bookBalance.getId());
            saleReconciliationConfirmationBookBalanceList.add(saleBookBalance);
        }
        this.saleReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(saleReconciliationConfirmationBookBalanceList);
    }

    private void handleSaleReconciliationConfirmationUnpaidAccount(SaleReconciliationConfirmation confirmation, List<PurchaseReconciliationConfirmationUnpaidAccount> unpaidAccountList) {
        if (CollectionUtils.isEmpty(unpaidAccountList)) {
            return;
        }
        ArrayList<SaleReconciliationConfirmationUnpaidAccount> saleUnpaidAccountList = new ArrayList<SaleReconciliationConfirmationUnpaidAccount>();
        for (PurchaseReconciliationConfirmationUnpaidAccount unpaidAccount : unpaidAccountList) {
            SaleReconciliationConfirmationUnpaidAccount saleUnpaidAccount = new SaleReconciliationConfirmationUnpaidAccount();
            BeanUtils.copyProperties((Object)((Object)unpaidAccount), (Object)((Object)saleUnpaidAccount));
            saleUnpaidAccount.setId(null);
            saleUnpaidAccount.setElsAccount(confirmation.getElsAccount());
            saleUnpaidAccount.setToElsAccount(confirmation.getToElsAccount());
            saleUnpaidAccount.setBusAccount(confirmation.getBusAccount());
            saleUnpaidAccount.setHeadId(confirmation.getId());
            saleUnpaidAccount.setRelationId(unpaidAccount.getId());
            saleUnpaidAccountList.add(saleUnpaidAccount);
        }
        this.saleReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(saleUnpaidAccountList);
    }

    private void handleSaleReconciliationConfirmationDifferenceDescription(SaleReconciliationConfirmation confirmation, List<PurchaseReconciliationConfirmationDifferenceDescription> descriptionList) {
        if (CollectionUtils.isEmpty(descriptionList)) {
            return;
        }
        ArrayList<SaleReconciliationConfirmationDifferenceDescription> saleDescriptionList = new ArrayList<SaleReconciliationConfirmationDifferenceDescription>();
        for (PurchaseReconciliationConfirmationDifferenceDescription description : descriptionList) {
            SaleReconciliationConfirmationDifferenceDescription saleDescription = new SaleReconciliationConfirmationDifferenceDescription();
            BeanUtils.copyProperties((Object)((Object)description), (Object)((Object)saleDescription));
            saleDescription.setId(null);
            saleDescription.setElsAccount(confirmation.getElsAccount());
            saleDescription.setToElsAccount(confirmation.getToElsAccount());
            saleDescription.setBusAccount(confirmation.getBusAccount());
            saleDescription.setHeadId(confirmation.getId());
            saleDescription.setRelationId(description.getId());
            saleDescriptionList.add(saleDescription);
        }
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(saleDescriptionList);
    }

    private void handleSaleAttachmentDetail(SaleReconciliationConfirmation saleReconciliation, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleReconciliation.getElsAccount());
            saleAttachment.setHeadId(saleReconciliation.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void insertReconciliationConfirmationBookBalance(PurchaseReconciliationConfirmation confirmation, List<PurchaseReconciliationConfirmationBookBalance> balanceList) {
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationBookBalance entity : balanceList) {
            BigDecimal opponentConfirmAmount;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)confirmation);
            entity.setHeadId(confirmation.getId());
            BigDecimal bookBalance = entity.getBookBalance() == null ? BigDecimal.ZERO : entity.getBookBalance();
            BigDecimal bigDecimal = opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            if (StringUtils.isEmpty((CharSequence)confirmation.getElsAccount()) || confirmation.getElsAccount().equals(confirmation.getCreateAccount())) continue;
            BigDecimal result = bookBalance.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!balanceList.isEmpty()) {
            this.purchaseReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(balanceList);
        }
    }

    private void insertReconciliationConfirmationDifferenceDescription(PurchaseReconciliationConfirmation confirmation, List<PurchaseReconciliationConfirmationDifferenceDescription> descriptionList) {
        if (CollectionUtils.isEmpty(descriptionList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationDifferenceDescription entity : descriptionList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)confirmation);
            entity.setHeadId(confirmation.getId());
        }
        if (!descriptionList.isEmpty()) {
            this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(descriptionList);
        }
    }

    private void insertReconciliationConfirmationUnpaidAccount(PurchaseReconciliationConfirmation confirmation, List<PurchaseReconciliationConfirmationUnpaidAccount> UnpaidAccountList) {
        if (CollectionUtils.isEmpty(UnpaidAccountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount entity : UnpaidAccountList) {
            BigDecimal opponentConfirmAmount;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)confirmation);
            entity.setHeadId(confirmation.getId());
            BigDecimal preparationConfirmAmount = entity.getPreparationConfirmAmount() == null ? BigDecimal.ZERO : entity.getPreparationConfirmAmount();
            BigDecimal bigDecimal = opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            if (StringUtils.isEmpty((CharSequence)confirmation.getElsAccount()) || confirmation.getElsAccount().equals(confirmation.getCreateAccount())) continue;
            BigDecimal result = preparationConfirmAmount.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!UnpaidAccountList.isEmpty()) {
            this.purchaseReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(UnpaidAccountList);
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseReconciliationConfirmation", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseReconciliationConfirmationList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseReconciliationConfirmation purchaseReconciliationConfirmation : purchaseReconciliationConfirmationList) {
            this.pushDataToErp(purchaseReconciliationConfirmation);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        List<PurchaseReconciliationConfirmationUnpaidAccount> accountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectByMainId(id);
        PurchaseReconciliationConfirmation confirmation = (PurchaseReconciliationConfirmation)((Object)this.purchaseReconciliationConfirmationMapper.selectById((Serializable)((Object)id)));
        confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.RENTURNED.getValue());
        this.purchaseReconciliationConfirmationMapper.updateById((Object)confirmation);
        SaleReconciliationConfirmation saleConfirmation = (SaleReconciliationConfirmation)((Object)this.saleReconciliationConfirmationMapper.selectById((Serializable)((Object)confirmation.getRelationId())));
        saleConfirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.RENTURNED.getValue());
        this.saleReconciliationConfirmationMapper.updateById((Object)saleConfirmation);
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount unpaidAccount : accountList) {
            String businessNumber = unpaidAccount.getBusinessNumbers();
            if (StringUtils.isEmpty((CharSequence)businessNumber) || !businessNumber.contains(",")) continue;
            List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
            this.releaseConfirmStatus(businessNumbers);
        }
    }

    private void pushDataToErp(PurchaseReconciliationConfirmation confirmation) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseReconciliationConfirmation", (Object)confirmation);
    }

    @Override
    public List<PurchaseReconciliationConfirmationUnpaidAccount> extractUnPaidAccountItem(PurchaseReconciliationConfirmationVO vo) {
        ArrayList<PurchaseReconciliationConfirmationUnpaidAccount> result = new ArrayList<PurchaseReconciliationConfirmationUnpaidAccount>();
        if (StringUtils.isEmpty((CharSequence)vo.getLocalCurrency())) {
            vo.setLocalCurrency("CNY");
        }
        if (StringUtils.isEmpty((CharSequence)vo.getToLocalCurrency())) {
            vo.setToLocalCurrency("CNY");
        }
        this.extractReconciliationPreparationConfirmAmount(vo, result);
        this.extractUnReconciliationConfirmationAmount(vo, result);
        return result;
    }

    private void extractUnReconciliationConfirmationAmount(PurchaseReconciliationConfirmationVO vo, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        ArrayList<String> businessNumbers = new ArrayList<String>();
        PurchaseReconciliationConfirmationDTO dto = new PurchaseReconciliationConfirmationDTO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)dto);
        List<PurchaseVoucherItemDTO> voucherItemList = this.purchaseVoucherItemRpcService.selectConfirmVoucher(dto);
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(voucherItemList)) {
            PurchaseReconciliationConfirmationUnpaidAccount unReconciliationConfirmationUnpaidAccounts = new PurchaseReconciliationConfirmationUnpaidAccount();
            unReconciliationConfirmationUnpaidAccounts.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue());
            unReconciliationConfirmationUnpaidAccounts.setPreparationConfirmAmount(BigDecimal.ZERO);
            result.add(unReconciliationConfirmationUnpaidAccounts);
            return;
        }
        for (PurchaseVoucherItemDTO purchaseVoucherItemDTO : voucherItemList) {
            boolean batchCreateFlag;
            boolean flag;
            BigDecimal dtoTaxAmount = purchaseVoucherItemDTO.getTaxAmount() == null ? BigDecimal.ZERO : purchaseVoucherItemDTO.getTaxAmount();
            if (BigDecimal.ZERO.compareTo(dtoTaxAmount) == 0 || (flag = "1".equals(purchaseVoucherItemDTO.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)vo.getPreparedByNumber()) && !vo.getPreparedByNumber().equals(purchaseVoucherItemDTO.getConfirmNumber())) || (batchCreateFlag = StringUtils.isEmpty((CharSequence)vo.getPreparedByNumber()) && "1".equals(purchaseVoucherItemDTO.getConfirmStatus()))) continue;
            if ("-".equals(purchaseVoucherItemDTO.getLoanDirection())) {
                taxAmount = taxAmount.subtract(dtoTaxAmount);
            } else if ("+".equals(purchaseVoucherItemDTO.getLoanDirection())) {
                taxAmount = taxAmount.add(dtoTaxAmount);
            }
            businessNumbers.add(purchaseVoucherItemDTO.getVoucherNumber());
        }
        PurchaseReconciliationConfirmationUnpaidAccount unpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        unpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue());
        unpaidAccount.setPreparationConfirmAmount(taxAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        unpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(unpaidAccount);
    }

    private void extractReconciliationPreparationConfirmAmount(PurchaseReconciliationConfirmationVO vo, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        List<PurchasePerformanceReconciliation> purchasePerformanceReconciliationList;
        BigDecimal reconciliationPreparationConfirmAmount = BigDecimal.ZERO;
        ArrayList<String> businessNumbers = new ArrayList<String>();
        List<PurchaseReconciliation> purchaseReconciliationList = this.purchaseReconciliationMapper.listReconciliationByConfirm(vo);
        if (!CollectionUtils.isEmpty(purchaseReconciliationList)) {
            for (Object purchaseReconciliation : purchaseReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchaseReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchaseReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)vo.getPreparedByNumber()) && !vo.getPreparedByNumber().equals(purchaseReconciliation.getConfirmNumber());
                if (flag) continue;
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
                businessNumbers.add(purchaseReconciliation.getReconciliationNumber());
            }
        }
        if (!CollectionUtils.isEmpty(purchasePerformanceReconciliationList = this.purchasePerformanceReconciliationMapper.listReconciliationByConfirm(vo))) {
            for (PurchasePerformanceReconciliation purchasePerformanceReconciliation : purchasePerformanceReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchasePerformanceReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchasePerformanceReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchasePerformanceReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)vo.getPreparedByNumber()) && !vo.getPreparedByNumber().equals(purchasePerformanceReconciliation.getConfirmNumber());
                if (flag) continue;
                businessNumbers.add(purchasePerformanceReconciliation.getReconciliationNumber());
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
            }
        }
        PurchaseReconciliationConfirmationUnpaidAccount reconciliationConfirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        reconciliationConfirmationUnpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue());
        reconciliationConfirmationUnpaidAccount.setPreparationConfirmAmount(reconciliationPreparationConfirmAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        reconciliationConfirmationUnpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(reconciliationConfirmationUnpaidAccount);
    }

    @Override
    public void createDifference(PurchaseReconciliationConfirmationVO vo) {
        List<PurchaseReconciliationConfirmationBookBalance> balanceList = vo.getBalance();
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(vo.getId());
        ArrayList<PurchaseReconciliationConfirmationDifferenceDescription> descriptionList = new ArrayList<PurchaseReconciliationConfirmationDifferenceDescription>();
        for (PurchaseReconciliationConfirmationBookBalance balance : balanceList) {
            PurchaseReconciliationConfirmationDifferenceDescription description = new PurchaseReconciliationConfirmationDifferenceDescription();
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) > 0) {
                description.setAccountAdjustmentDirection("0");
            } else if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) < 0) {
                description.setAccountAdjustmentDirection("1");
            }
            description.setDifferenceDate(new Date());
            description.setDifferencePayment(balance.getCurrentBalance());
            description.setDifferenceAmount(balance.getDifferenceAmount());
            descriptionList.add(description);
        }
        PurchaseReconciliationConfirmation confirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)confirmation));
        this.insertReconciliationConfirmationDifferenceDescription(confirmation, descriptionList);
    }
}

