/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.mapper.PurchasePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyItemMapper;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class PurchasePaymentAdapter
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentAdapter.class);
    @Resource
    private PurchasePaymentApplyHeadMapper purchasePaymentApplyHeadMapper;
    @Resource
    private PurchasePaymentApplyItemMapper purchasePaymentApplyItemMapper;
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String sourceType;
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO = (PurchasePaymentApplyHeadVO)((Object)JSONObject.parseObject((String)params, PurchasePaymentApplyHeadVO.class));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPaymentApplyItemList();
        if (!CollectionUtil.isEmpty(purchasePaymentApplyItemList) && ((sourceType = purchasePaymentApplyItemList.get(0).getSourceType()).equals("reconciliation") || sourceType.equals("performanceReconciliation")) && purchasePaymentApplyHeadVO.getPaymentApplyType().equals("0")) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xRuIethAUB_627d1a63", (String)"\u4e0d\u652f\u6301\u5bf9\u8d26\u5355\u53d1\u8d77\u9884\u4ed8"));
        }
        PurchasePaymentApplyHead headVO = (PurchasePaymentApplyHead)((Object)JSON.parseObject((String)params, PurchasePaymentApplyHead.class));
        this.checkParams(headVO);
        this.purchasePaymentApplyHeadService.checkAmount(headVO.getId());
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    private void checkParams(PurchasePaymentApplyHead deductCost) {
        Assert.hasText((String)deductCost.getPurchaseOrg(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectOrg", (String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u7ec4\u7ec7"));
        Assert.hasText((String)deductCost.getCompany(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectCompany", (String)"\u8bf7\u586b\u5199\u516c\u53f8"));
        Assert.hasText((String)deductCost.getToElsAccount(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectSupplier", (String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546"));
        Assert.hasText((String)deductCost.getCurrency(), (String)I18nUtil.translate((String)"i18n_alert_ViFls_f7546863", (String)"\u8bf7\u9009\u62e9\u5e01\u79cd"));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(deductCost.getId());
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(purchasePaymentApplyItems), (String)I18nUtil.translate((String)"i18n_alert_VWRRsMImBVUVctH_7ed1abb3", (String)"\u8bf7\u5148\u81f3\u5c11\u4fdd\u5b58\u4e00\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u884c\u8bb0\u5f55"));
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (outputParamVO != null && !CollectionUtil.isEmpty((Collection)outputParamVO.getNextAuditUserList())) {
            this.purchasePaymentApplyHeadService.cancelReleaseAmount(inputParamVO.getBusinessId());
            this.purchasePaymentApplyHeadService.releaseWriteOffStatus(inputParamVO.getBusinessId());
        }
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchasePaymentApplyHead head = new PurchasePaymentApplyHead();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        head.setWorkFlowType(outputParamVO.getBpmnType());
        this.purchasePaymentApplyHeadMapper.updateById((Object)head);
        try {
            PurchasePaymentApplyHead applyHead = (PurchasePaymentApplyHead)((Object)JSON.parseObject((String)inputParamVO.getParams(), PurchasePaymentApplyHead.class));
            if ("1".equals(applyHead.getSendStatus())) {
                PurchasePaymentApplyHeadVO vo = new PurchasePaymentApplyHeadVO();
                BeanUtils.copyProperties((Object)((Object)applyHead), (Object)((Object)vo));
                this.purchasePaymentApplyHeadService.synchr(vo);
            }
        }
        catch (Exception e) {
            log.error("updateStatus: {} ", (Object)e.getMessage());
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PurchasePaymentApplyHead head = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

