/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.rebate.entity.PurchaseRebateRule;
import com.els.modules.rebate.entity.PurchaseRebateRuleItem;
import com.els.modules.rebate.entity.PurchaseRebateRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateRuleThreshold;
import com.els.modules.rebate.service.PurchaseRebateRuleItemService;
import com.els.modules.rebate.service.PurchaseRebateRuleService;
import com.els.modules.rebate.service.PurchaseRebateRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateRuleThresholdService;
import com.els.modules.rebate.vo.PurchaseRebateRuleVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u8fd4\u5229\u89c4\u5219\u8868"})
@RestController
@RequestMapping(value={"/finance/purchaseRebateRule"})
public class PurchaseRebateRuleController
extends BaseController<PurchaseRebateRule, PurchaseRebateRuleService> {
    @Autowired
    private PurchaseRebateRuleService purchaseRebateRuleService;
    @Autowired
    private PurchaseRebateRuleItemService purchaseRebateRuleItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseRebateRuleThresholdService purchaseRebateRuleThresholdService;
    @Autowired
    private PurchaseRebateRuleSupplementService purchaseRebateRuleSupplementService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:list"})
    public Result<?> queryPageList(PurchaseRebateRule purchaseRebateRule, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRebateRule), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRebateRuleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u89c4\u5219\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:add"})
    public Result<?> add(@RequestBody PurchaseRebateRuleVO purchaseRebateRulePage) {
        PurchaseRebateRule purchaseRebateRule = new PurchaseRebateRule();
        BeanUtils.copyProperties((Object)((Object)purchaseRebateRulePage), (Object)((Object)purchaseRebateRule));
        this.purchaseRebateRuleService.saveMain(purchaseRebateRule, purchaseRebateRulePage);
        return Result.ok((Object)((Object)purchaseRebateRule));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u89c4\u5219\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:edit"})
    public Result<?> edit(@RequestBody PurchaseRebateRuleVO purchaseRebateRulePage) {
        PurchaseRebateRule purchaseRebateRule = new PurchaseRebateRule();
        BeanUtils.copyProperties((Object)((Object)purchaseRebateRulePage), (Object)((Object)purchaseRebateRule));
        this.purchaseRebateRuleService.updateMain(purchaseRebateRule, purchaseRebateRulePage);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u89c4\u5219\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseRebateRuleService.delete(id);
        return this.commonSuccessResult(4);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u89c4\u5219-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:publish"})
    public Result<?> publish(@RequestBody PurchaseRebateRuleVO purchaseRebateRuleVO) {
        PurchaseRebateRule purchaseRebateRule = new PurchaseRebateRule();
        BeanUtils.copyProperties((Object)((Object)purchaseRebateRuleVO), (Object)((Object)purchaseRebateRule));
        return this.purchaseRebateRuleService.publish(purchaseRebateRule, purchaseRebateRuleVO);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseRebateRuleVO vo = new PurchaseRebateRuleVO();
        PurchaseRebateRule purchaseRebateRule = (PurchaseRebateRule)((Object)this.purchaseRebateRuleService.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchaseRebateRule), (Object)((Object)vo));
        List<PurchaseRebateRuleItem> purchaseRebateRuleItemList = this.purchaseRebateRuleItemService.selectByMainId(id);
        vo.setRebateRuleItems(purchaseRebateRuleItemList);
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        vo.setAttachments(attachments);
        List<PurchaseRebateRuleThreshold> thresholds = this.purchaseRebateRuleThresholdService.selectByMainId(id);
        vo.setRebateRuleThresholds(thresholds);
        List<PurchaseRebateRuleSupplement> supplements = this.purchaseRebateRuleSupplementService.selectByMainId(id);
        vo.setRebateRuleSupplements(supplements);
        return Result.ok((Object)((Object)vo));
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:list"})
    public Result<?> counts(PurchaseRebateRule purchaseRebateRule, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRebateRule), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"rule_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"rule_status");
        List list = ((PurchaseRebateRuleService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseRebateRule::getRuleStatus, PurchaseRebateRule::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "ruleStatus", null, all));
        List srmRebateRuleStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmRebateRuleStatus", TenantContext.getTenant());
        for (DictDTO status : srmRebateRuleStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "ruleStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseRebateRuleService.pushDataToErp(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseRebateRuleService.getDataByErp();
        return Result.ok();
    }

    @AutoLog(value="\u89c4\u5219\u5355-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:cancellation"})
    public Result<?> cancellation(@RequestParam(name="id", required=true) String id) {
        this.purchaseRebateRuleService.cancellation(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8fd4\u5229\u89c4\u5219\u8868", value="\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copyData"})
    @RequiresPermissions(value={"finance#purchaseRebateRule:copy"})
    public Result<?> copyData(@RequestParam(value="id") String id) {
        this.purchaseRebateRuleService.copyData(id);
        return Result.ok();
    }
}

