/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.rebate.entity.SaleRebateCalculationSheet;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetCertificate;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRegister;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.service.SaleRebateCalculationSheetCalculateDetailService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetCertificateService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetRegisterService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetRuleDetailService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetRuleSupplementService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetRuleThresholdService;
import com.els.modules.rebate.service.SaleRebateCalculationSheetService;
import com.els.modules.rebate.vo.SaleRebateCalculationSheetVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u8fd4\u5229\u8ba1\u7b97\u5355\u8868"})
@RestController
@RequestMapping(value={"/finance/saleRebateCalculationSheet"})
public class SaleRebateCalculationSheetController
extends BaseController<SaleRebateCalculationSheet, SaleRebateCalculationSheetService> {
    @Autowired
    private SaleRebateCalculationSheetService saleRebateCalculationSheetService;
    @Autowired
    private SaleRebateCalculationSheetCalculateDetailService saleRebateCalculationSheetCalculateDetailService;
    @Autowired
    private SaleRebateCalculationSheetCertificateService saleRebateCalculationSheetCertificateService;
    @Autowired
    private SaleRebateCalculationSheetRegisterService saleRebateCalculationSheetRegisterService;
    @Autowired
    private SaleRebateCalculationSheetRuleDetailService saleRebateCalculationSheetRuleDetailService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleRebateCalculationSheetRuleThresholdService saleRebateCalculationSheetRuleThresholdService;
    @Autowired
    private SaleRebateCalculationSheetRuleSupplementService saleRebateCalculationSheetRuleSupplementService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#saleRebateCalculationSheet:list"})
    public Result<?> queryPageList(SaleRebateCalculationSheet saleRebateCalculationSheet, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleRebateCalculationSheet), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleRebateCalculationSheetService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#saleRebateCalculationSheet:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleRebateCalculationSheetVO vo = new SaleRebateCalculationSheetVO();
        SaleRebateCalculationSheet saleRebateCalculationSheet = (SaleRebateCalculationSheet)((Object)this.saleRebateCalculationSheetService.getById((Serializable)((Object)id)));
        List<SaleRebateCalculationSheetCalculateDetail> calculateDetails = this.saleRebateCalculationSheetCalculateDetailService.selectByMainId(id);
        List<SaleRebateCalculationSheetCertificate> certificates = this.saleRebateCalculationSheetCertificateService.selectByMainId(id);
        List<SaleRebateCalculationSheetRegister> registers = this.saleRebateCalculationSheetRegisterService.selectByMainId(id);
        List<SaleRebateCalculationSheetRuleDetail> ruleDetails = this.saleRebateCalculationSheetRuleDetailService.selectByMainId(id);
        List attachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        List<SaleRebateCalculationSheetRuleThreshold> thresholds = this.saleRebateCalculationSheetRuleThresholdService.selectByMainId(id);
        List<SaleRebateCalculationSheetRuleSupplement> supplements = this.saleRebateCalculationSheetRuleSupplementService.selectByMainId(id);
        BeanUtils.copyProperties((Object)((Object)saleRebateCalculationSheet), (Object)((Object)vo));
        vo.setRebateCalculationSheetCalculateDetails(calculateDetails);
        vo.setRebateCalculationSheetCertificates(certificates);
        vo.setRebateCalculationSheetRegisters(registers);
        vo.setRebateCalculationSheetRuleDetails(ruleDetails);
        vo.setAttachments(attachments);
        vo.setRebateCalculationSheetRuleThresholds(thresholds);
        vo.setRebateCalculationSheetRuleSupplements(supplements);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u9500\u552e\u8ba1\u7b97\u5355-\u9500\u552e\u786e\u8ba4")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4", notes="\u9500\u552e\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"finance#saleRebateCalculationSheet:confirm"})
    public Result<?> confirm(@RequestBody SaleRebateCalculationSheetVO saleRebateCalculationSheetVO) {
        SaleRebateCalculationSheet saleRebateCalculationSheet = new SaleRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)saleRebateCalculationSheetVO), (Object)((Object)saleRebateCalculationSheet));
        this.saleRebateCalculationSheetService.confirmOrRefused(saleRebateCalculationSheet, "confirm");
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u8ba1\u7b97\u5355-\u9500\u552e\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u62d2\u7edd", notes="\u9500\u552e\u62d2\u7edd")
    @PostMapping(value={"/refuesd"})
    @RequiresPermissions(value={"finance#saleRebateCalculationSheet:refuesd"})
    public Result<?> refuesd(@RequestBody SaleRebateCalculationSheetVO saleRebateCalculationSheetVO) {
        SaleRebateCalculationSheet saleRebateCalculationSheet = new SaleRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)saleRebateCalculationSheetVO), (Object)((Object)saleRebateCalculationSheet));
        this.saleRebateCalculationSheetService.confirmOrRefused(saleRebateCalculationSheet, "refused");
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u8fd4\u5229\u8ba1\u7b97\u5355\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#saleRebateCalculationSheet:edit"})
    public Result<?> edit(@RequestBody SaleRebateCalculationSheetVO saleRebateCalculationSheetVO) {
        SaleRebateCalculationSheet saleRebateCalculationSheet = new SaleRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)saleRebateCalculationSheetVO), (Object)((Object)saleRebateCalculationSheet));
        this.saleRebateCalculationSheetService.updateMain(saleRebateCalculationSheetVO, saleRebateCalculationSheet);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u8ba1\u7b97\u5355-\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd")
    @ApiOperation(value="\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd", notes="\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd")
    @GetMapping(value={"/emailConfirmOrRefuesd"})
    @RequiresPermissions(value={"finance#saleRebateCalculationSheet:emailConfirmOrRefuesd"})
    public Result<?> emailConfirmOrRefuesd(@RequestParam(name="operation") String operation, @RequestParam(name="id") String id) {
        this.saleRebateCalculationSheetService.emailConfirmOrRefuesd(id, operation);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#saleRebateCalculationSheet:list"})
    public Result<?> counts(SaleRebateCalculationSheet saleRebateCalculationSheet, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleRebateCalculationSheet), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"rebate_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"rebate_status");
        List list = ((SaleRebateCalculationSheetService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleRebateCalculationSheet::getRebateStatus, SaleRebateCalculationSheet::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "rebateStatus", null, all));
        List srmCalculationSheetStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmCalculationSheetStatus", TenantContext.getTenant());
        for (DictDTO status : srmCalculationSheetStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "rebateStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

