/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.job;

import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.rebate.service.PurchaseRebateRuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RebateRuleJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(RebateRuleJob.class);
    private final String LOCK_PREFIX = "purchaseRebateRule_schedule_RebateRuleJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseRebateRuleService purchaseRebateRuleService;

    public void execute(String parameter) {
        String requestId = "100000";
        if (!this.redisUtil.tryGetDistributedLock("purchaseRebateRule_schedule_RebateRuleJob", requestId, 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFzEHrLSiKRcWVxPVBRc_268e90d8", (String)" \u89c4\u5219\u5355\u66f4\u65b0\u72b6\u6001\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            log.info(":::RebateRuleJob start");
            this.purchaseRebateRuleService.updateInvalidStatus();
            log.info(":::RebateRuleJob end");
        }
        catch (Exception e) {
            log.info(Thread.currentThread().getName() + "\u89c4\u5219\u5355\u66f4\u65b0\u72b6\u6001\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("purchaseRebateRule_schedule_RebateRuleJob", requestId);
        }
    }
}

