/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.entity.PurchaseRebateProgress;
import com.els.modules.rebate.entity.PurchaseRebateProgressRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateProgressSupplement;
import com.els.modules.rebate.entity.PurchaseRebateProgressThreshold;
import com.els.modules.rebate.entity.PurchaseRebateRule;
import com.els.modules.rebate.entity.PurchaseRebateRuleItem;
import com.els.modules.rebate.entity.PurchaseRebateRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateRuleThreshold;
import com.els.modules.rebate.enumerate.RebateRuleSettlementCycleEnum;
import com.els.modules.rebate.mapper.PurchaseRebateProgressMapper;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetService;
import com.els.modules.rebate.service.PurchaseRebateProgressRuleDetailService;
import com.els.modules.rebate.service.PurchaseRebateProgressService;
import com.els.modules.rebate.service.PurchaseRebateProgressSupplementService;
import com.els.modules.rebate.service.PurchaseRebateProgressThresholdService;
import com.els.modules.rebate.service.PurchaseRebateRuleItemService;
import com.els.modules.rebate.service.PurchaseRebateRuleService;
import com.els.modules.rebate.service.PurchaseRebateRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateRuleThresholdService;
import com.els.modules.rebate.service.impl.PurchaseRebateProcessService;
import com.els.modules.rebate.utils.DateUtils;
import com.els.modules.rebate.vo.PurchaseRebateCalculationSheetVO;
import com.els.modules.rebate.vo.PurchaseRebateProcessItemVO;
import com.els.modules.rebate.vo.PurchaseRebateProcessVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseRebateProgressServiceImpl
extends BaseServiceImpl<PurchaseRebateProgressMapper, PurchaseRebateProgress>
implements PurchaseRebateProgressService {
    @Autowired
    private PurchaseRebateProgressThresholdService purchaseRebateProgressThresholdService;
    @Autowired
    private PurchaseRebateProgressRuleDetailService purchaseRebateProgressRuleDetailService;
    @Autowired
    private PurchaseRebateProgressSupplementService purchaseRebateProgressSupplementService;
    @Autowired
    private PurchaseRebateRuleService purchaseRebateRuleService;
    @Autowired
    private PurchaseRebateRuleItemService purchaseRebateRuleItemService;
    @Autowired
    private PurchaseRebateRuleThresholdService purchaseRebateRuleThresholdService;
    @Autowired
    private PurchaseRebateRuleSupplementService purchaseRebateRuleSupplementService;
    @Autowired
    private PurchaseRebateProcessService purchaseRebateProcessService;
    @Autowired
    private PurchaseRebateCalculationSheetService purchaseRebateCalculationSheetService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRebateProgressMapper purchaseRebateProgressMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getId, (Object)"1601117957587312641");
        List list = this.purchaseRebateRuleService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (PurchaseRebateRule rebateRule : list) {
            PurchaseRebateRuleItem ruleItem;
            String rebateSettlementCycle;
            Date endDate;
            Optional optional;
            Optional optional2;
            String id = rebateRule.getId();
            List<PurchaseRebateRuleThreshold> thresholdList = this.purchaseRebateRuleThresholdService.selectByMainId(id);
            List<PurchaseRebateRuleItem> ruleItemList = this.purchaseRebateRuleItemService.selectByMainId(id);
            List<PurchaseRebateRuleSupplement> supplements = this.purchaseRebateRuleSupplementService.selectByMainId(id);
            PurchaseRebateProgress progress = new PurchaseRebateProgress();
            BeanUtils.copyProperties((Object)((Object)rebateRule), (Object)((Object)progress));
            progress.setId(null);
            List template = this.invokeBaseRpcService.getDefaultTemplateByType("rebateProgress");
            if (!CollectionUtils.isEmpty((Collection)template) && (optional2 = template.stream().findFirst()).isPresent()) {
                TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)optional2.get();
                progress.setTemplateAccount(templateHeadDTO.getElsAccount());
                progress.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                progress.setTemplateVersion(templateHeadDTO.getTemplateVersion());
                progress.setTemplateName(templateHeadDTO.getTemplateName());
            }
            progress.setCreateBy(null);
            progress.setCreateTime(null);
            progress.setCreateById(null);
            progress.setUpdateBy(null);
            progress.setUpdateTime(null);
            progress.setUpdateById(null);
            progress.setBusinessId(rebateRule.getId());
            LambdaQueryWrapper progressQueryWrapper = new LambdaQueryWrapper();
            progressQueryWrapper.eq(PurchaseRebateProgress::getRuleNumber, (Object)rebateRule.getRuleNumber());
            PurchaseRebateProgress oldProgress = (PurchaseRebateProgress)((Object)((PurchaseRebateProgressMapper)this.baseMapper).selectOne((Wrapper)progressQueryWrapper));
            if (oldProgress != null) {
                ((PurchaseRebateProgressMapper)this.baseMapper).deleteById((Serializable)((Object)oldProgress));
                this.purchaseRebateProgressThresholdService.deleteByMainId(oldProgress.getId());
                this.purchaseRebateProgressRuleDetailService.deleteByMainId(oldProgress.getId());
                this.purchaseRebateProgressSupplementService.deleteByMainId(oldProgress.getId());
            }
            ((PurchaseRebateProgressMapper)this.baseMapper).insert((Object)progress);
            if (!CollectionUtils.isEmpty(ruleItemList) && (optional = ruleItemList.stream().findFirst()).isPresent() && (endDate = this.handleCalculationSheetEndDate(rebateSettlementCycle = (ruleItem = (PurchaseRebateRuleItem)((Object)optional.get())).getRebateSettlementCycle(), progress.getEndDate())) != null) {
                progress.setEndDate(endDate);
            }
            PurchaseRebateProcessVO vo = new PurchaseRebateProcessVO();
            vo.setThresholdList(thresholdList);
            vo.setRuleItemList(ruleItemList);
            vo.setSupplementList(supplements);
            this.purchaseRebateProcessService.calculateAll(progress, vo);
            this.updateById((Object)progress);
        }
    }

    protected Date handleCalculationSheetEndDate(String rebateSettlementCycle, Date endDate) {
        Date calculationSheetEndDate = null;
        if (RebateRuleSettlementCycleEnum.RANDOM.getValue().equals(rebateSettlementCycle)) {
            return null;
        }
        if (RebateRuleSettlementCycleEnum.MONTH.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getMonth(endDate);
        } else if (RebateRuleSettlementCycleEnum.QUARTER.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getQuarter(endDate);
        } else if (RebateRuleSettlementCycleEnum.HALF_YEAR.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getHalfYear(endDate);
        } else if (RebateRuleSettlementCycleEnum.YEAR.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getYear(endDate);
        }
        return calculationSheetEndDate;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<?> createCalculationSheet(PurchaseRebateProgress progress) {
        String ids = progress.getIds();
        List<String> idList = Arrays.asList(ids.split(","));
        if (CollectionUtils.isEmpty(idList)) {
            throw new RuntimeException(I18nUtil.translate((String)"i18n_alert_IdjHzBxMK_9c608a49", (String)"\u5bf9\u5e94\u7684\u8fdb\u5ea6\u8868\u4e0d\u5b58\u5728"));
        }
        for (String id : idList) {
            PurchaseRebateProgress purchaseRebateProgress = (PurchaseRebateProgress)((Object)this.getById((Serializable)((Object)id)));
            List<PurchaseRebateProgressThreshold> thresholds = this.purchaseRebateProgressThresholdService.selectByMainId(id);
            List<PurchaseRebateProgressRuleDetail> ruleDetails = this.purchaseRebateProgressRuleDetailService.selectByMainId(id);
            List<PurchaseRebateProgressSupplement> supplements = this.purchaseRebateProgressSupplementService.selectByMainId(id);
            PurchaseRebateCalculationSheet sheet = this.handleRule(purchaseRebateProgress);
            sheet.setId(null);
            sheet.setTemplateAccount(progress.getTemplateAccount());
            sheet.setTemplateVersion(progress.getTemplateVersion() + "");
            sheet.setTemplateNumber(progress.getTemplateNumber());
            sheet.setTemplateName(progress.getTemplateName());
            sheet.setCreateBy(null);
            sheet.setCreateTime(null);
            sheet.setCreateById(null);
            sheet.setUpdateBy(null);
            sheet.setUpdateTime(null);
            sheet.setUpdateById(null);
            List<PurchaseRebateCalculationSheetRuleThreshold> thresholdList = this.handleThreshold(sheet, thresholds);
            List<PurchaseRebateCalculationSheetRuleDetail> detailList = this.handleRuleDetail(sheet, ruleDetails);
            List<PurchaseRebateCalculationSheetRuleSupplement> supplementList = this.handleSupplement(sheet, supplements);
            PurchaseRebateCalculationSheetVO vo = new PurchaseRebateCalculationSheetVO();
            vo.setRebateCalculationSheetRuleThresholds(thresholdList);
            vo.setRebateCalculationSheetRuleDetails(detailList);
            vo.setRebateCalculationSheetRuleSupplements(supplementList);
            this.purchaseRebateCalculationSheetService.saveMain(vo, sheet);
        }
        return Result.ok();
    }

    private PurchaseRebateCalculationSheet handleRule(PurchaseRebateProgress purchaseRebateProgress) {
        String ruleId = purchaseRebateProgress.getBusinessId();
        if (StringUtils.isEmpty((Object)ruleId)) {
            return null;
        }
        PurchaseRebateRule rule = (PurchaseRebateRule)((Object)this.purchaseRebateRuleService.getById((Serializable)((Object)ruleId)));
        if (rule == null) {
            return null;
        }
        PurchaseRebateCalculationSheet sheet = new PurchaseRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)rule), (Object)((Object)sheet));
        return sheet;
    }

    private List<PurchaseRebateCalculationSheetRuleSupplement> handleSupplement(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateProgressSupplement> supplements) {
        ArrayList<PurchaseRebateCalculationSheetRuleSupplement> resultList = new ArrayList<PurchaseRebateCalculationSheetRuleSupplement>();
        ArrayList<String> supplementIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty(supplements)) {
            return resultList;
        }
        for (PurchaseRebateProgressSupplement supplement : supplements) {
            supplementIds.add(supplement.getBusinessId());
        }
        if (CollectionUtils.isEmpty(supplementIds)) {
            return resultList;
        }
        List supplementList = this.purchaseRebateRuleSupplementService.listByIds(supplementIds);
        if (CollectionUtils.isEmpty((Collection)supplementList)) {
            return resultList;
        }
        for (PurchaseRebateRuleSupplement supplement : supplementList) {
            PurchaseRebateCalculationSheetRuleSupplement sheetSupplement = new PurchaseRebateCalculationSheetRuleSupplement();
            BeanUtils.copyProperties((Object)((Object)supplement), (Object)((Object)sheetSupplement));
            sheetSupplement.setId(null);
            sheetSupplement.setHeadId(sheet.getId());
            resultList.add(sheetSupplement);
        }
        return resultList;
    }

    private List<PurchaseRebateCalculationSheetRuleDetail> handleRuleDetail(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateProgressRuleDetail> ruleDetails) {
        ArrayList<PurchaseRebateCalculationSheetRuleDetail> resultList = new ArrayList<PurchaseRebateCalculationSheetRuleDetail>();
        ArrayList<String> ruleIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty(ruleDetails)) {
            return resultList;
        }
        for (PurchaseRebateProgressRuleDetail ruleDetail : ruleDetails) {
            ruleIds.add(ruleDetail.getBusinessId());
        }
        if (CollectionUtils.isEmpty(ruleIds)) {
            return resultList;
        }
        List ruleItemList = this.purchaseRebateRuleItemService.listByIds(ruleIds);
        if (CollectionUtils.isEmpty((Collection)ruleItemList)) {
            return resultList;
        }
        for (PurchaseRebateRuleItem item : ruleItemList) {
            PurchaseRebateCalculationSheetRuleDetail sheetRuleDetail = new PurchaseRebateCalculationSheetRuleDetail();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)sheetRuleDetail));
            sheetRuleDetail.setId(null);
            sheetRuleDetail.setHeadId(sheet.getId());
            resultList.add(sheetRuleDetail);
        }
        return resultList;
    }

    private List<PurchaseRebateCalculationSheetRuleThreshold> handleThreshold(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateProgressThreshold> thresholds) {
        ArrayList<PurchaseRebateCalculationSheetRuleThreshold> resultList = new ArrayList<PurchaseRebateCalculationSheetRuleThreshold>();
        ArrayList<String> thresholdIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty(thresholds)) {
            return resultList;
        }
        for (PurchaseRebateProgressThreshold threshold : thresholds) {
            thresholdIds.add(threshold.getBusinessId());
        }
        if (CollectionUtils.isEmpty(thresholdIds)) {
            return resultList;
        }
        List thresholdList = this.purchaseRebateRuleThresholdService.listByIds(thresholdIds);
        if (CollectionUtils.isEmpty((Collection)thresholdList)) {
            return resultList;
        }
        for (PurchaseRebateRuleThreshold threshold : thresholdList) {
            PurchaseRebateCalculationSheetRuleThreshold sheetThreshold = new PurchaseRebateCalculationSheetRuleThreshold();
            BeanUtils.copyProperties((Object)((Object)threshold), (Object)((Object)sheetThreshold));
            sheetThreshold.setId(null);
            sheetThreshold.setHeadId(sheet.getId());
            resultList.add(sheetThreshold);
        }
        return resultList;
    }

    @Override
    public IPage<PurchaseRebateProcessItemVO> queryCardPageList(Page<PurchaseRebateProgress> page, PurchaseRebateProgress purchaseRebateProgress) {
        IPage<PurchaseRebateProcessItemVO> pageList = this.purchaseRebateProgressMapper.queryCardPageList(page, purchaseRebateProgress);
        List records = pageList.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return pageList;
        }
        List<String> ids = records.stream().map(PurchaseRebateProcessItemVO::getId).collect(Collectors.toList());
        List<PurchaseRebateProcessItemVO> list = this.purchaseRebateProgressMapper.listCardPage(ids);
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<PurchaseRebateProcessItemVO> resultList = new ArrayList<PurchaseRebateProcessItemVO>();
            Map<String, PurchaseRebateProcessItemVO> map = list.stream().collect(Collectors.toMap(PurchaseRebateProcessItemVO::getId, item -> item));
            for (String id : ids) {
                PurchaseRebateProcessItemVO vo = map.get(id);
                if (vo == null) continue;
                resultList.add(vo);
            }
            pageList.setRecords(resultList);
        }
        return pageList;
    }
}

