/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.modules.delivery.api.dto.PurchaseRebateVoucherDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.api.service.PurchaseVoucherItemRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationRebateFormEnum;
import com.els.modules.rebate.enumerate.CalculationRebateMethodEnum;
import com.els.modules.rebate.enumerate.CalculationRebatePayTypeEnum;
import com.els.modules.rebate.enumerate.CalculationRebateProjectEnum;
import com.els.modules.rebate.enumerate.CalculationRebateTypeEnum;
import com.els.modules.rebate.enumerate.PricingBasisEnum;
import com.els.modules.rebate.enumerate.RebateConditionEnum;
import com.els.modules.rebate.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.rebate.rpc.SupplierLocalRpcService;
import com.els.modules.rebate.service.impl.PurchaseRebateCalculationService;
import com.els.modules.rebate.vo.CalculationResultDTO;
import com.els.modules.rebate.vo.GoodLadderVO;
import com.els.modules.rebate.vo.GoodRebateVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RebateCalculationPurchaseReturnService
extends PurchaseRebateCalculationService {
    private static final Logger log = LoggerFactory.getLogger(RebateCalculationPurchaseReturnService.class);
    @Resource
    private PurchaseVoucherItemRpcService purchaseVoucherItemRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private SupplierLocalRpcService supplierLocalRpcService;

    @Override
    protected CalculationResultDTO beforeCalculate(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleDetail rule) {
        CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO = new CalculationResultDTO<List<PurchaseVoucherItemDTO>>();
        List<PurchaseVoucherItemDTO> voucherItems = this.getPurchaseVoucherItem(sheet, rule);
        log.info("rebate:  rule get voucher list , ruleId : , {} ,  data : {} ", (Object)rule.getId(), (Object)JSON.toJSONString(voucherItems));
        if (CollectionUtils.isEmpty(voucherItems)) {
            log.info("\u89c4\u5219 ,{} \u6ca1\u6709\u5bf9\u5e94\u51ed\u8bc1\u5355 ", (Object)rule.getId());
            return resultDTO;
        }
        this.handleTotalAmountOrNumber(resultDTO, voucherItems, rule.getRebateCondition(), rule.getPricingBasis(), rule.getPriceJudgment(), rule.getAssessmentPrice());
        resultDTO.setObj(voucherItems);
        return resultDTO;
    }

    @Override
    protected void afterCalculate(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetCalculateDetail> detailList, PurchaseRebateCalculationSheetRuleDetail rule, CalculationResultDTO dto) {
        List voucherItems = JSON.parseArray((String)JSON.toJSONString(dto.getObj()), PurchaseVoucherItemDTO.class);
        if (CollectionUtils.isEmpty((Collection)voucherItems)) {
            return;
        }
        BigDecimal rebateAmount = dto.getRebateAmount();
        String rebateForm = sheet.getRebateForm();
        PurchaseRebateCalculationSheetCalculateDetail calculateDetail = this.buildCalculateDetail(voucherItems, rule.getRuleNumber(), CalculationRebateProjectEnum.DETAIL);
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            calculateDetail.setRebateQuantity(rebateAmount);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            calculateDetail.setRebateAmount(rebateAmount);
        }
        String rebateType = StringUtils.isEmpty((CharSequence)rule.getRebateType()) ? CalculationRebateTypeEnum.PURCHASE_RETURN.getValue() : rule.getRebateType();
        String rebateCondition = StringUtils.isEmpty((CharSequence)rule.getRebateCondition()) ? RebateConditionEnum.AMOUNT.getValue() : rule.getRebateCondition();
        String detail = "\u67e5\u8be2\u51ed\u8bc1\u7ba1\u7406\u8868\uff0c\u5171" + voucherItems.size() + "\u6761\u8bb0\u5f55, \u8fd4\u5229\u5546\u54c1" + CalculationRebateTypeEnum.parse(rebateType).getDesc() + RebateConditionEnum.parse(rebateCondition).getDesc();
        if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
            detail = detail + dto.getTotalNumber().setScale(6, 1);
        } else if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
            detail = detail + dto.getTotalAmount().setScale(2, 1);
        }
        calculateDetail.setDetail(detail);
        calculateDetail.setCompletionRate(dto.getCompletionRate());
        calculateDetail.setTotalCompletionRate(dto.getTotalCompletionRate());
        detailList.add(calculateDetail);
    }

    @Override
    protected void afterCalculateThreshold(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetCalculateDetail> detailList, PurchaseRebateCalculationSheetRuleThreshold threshold, CalculationResultDTO dto) {
        List voucherItems = JSON.parseArray((String)JSON.toJSONString(dto.getObj()), PurchaseVoucherItemDTO.class);
        if (CollectionUtils.isEmpty((Collection)voucherItems)) {
            return;
        }
        BigDecimal rebateAmount = dto.getRebateAmount();
        String rebateForm = sheet.getRebateForm();
        PurchaseRebateCalculationSheetCalculateDetail calculateDetail = this.buildCalculateDetail(voucherItems, threshold.getRuleNumber(), CalculationRebateProjectEnum.THRESHOLD);
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            calculateDetail.setRebateQuantity(rebateAmount);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            calculateDetail.setRebateAmount(rebateAmount);
        }
        String rebateType = StringUtils.isEmpty((CharSequence)threshold.getRebateType()) ? CalculationRebateTypeEnum.PURCHASE_RETURN.getValue() : threshold.getRebateType();
        String rebateCondition = StringUtils.isEmpty((CharSequence)threshold.getRebateCondition()) ? RebateConditionEnum.AMOUNT.getValue() : threshold.getRebateCondition();
        String payType = StringUtils.isEmpty((CharSequence)threshold.getPayType()) ? CalculationRebatePayTypeEnum.WIRE_TRANSFER.getValue() : threshold.getPayType();
        String detail = "\u67e5\u8be2\u51ed\u8bc1\u7ba1\u7406\u8868\uff0c\u5171" + voucherItems.size() + "\u6761\u8bb0\u5f55,";
        if (CalculationRebateMethodEnum.RATE.getValue().equals(threshold.getRebateMethod())) {
            detail = detail + " \u8fd4\u5229\u5546\u54c1" + CalculationRebateTypeEnum.parse(rebateType).getDesc() + RebateConditionEnum.parse(rebateCondition).getDesc() + ": " + dto.getTotalAmount().setScale(2, 1);
        }
        detail = detail + "\u95e8\u69db\u5546\u54c1" + CalculationRebatePayTypeEnum.parse(payType).getDesc() + CalculationRebateTypeEnum.parse(rebateType).getDesc() + RebateConditionEnum.parse(rebateCondition).getDesc() + ": ";
        if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
            detail = detail + dto.getTotalNumber().setScale(6, 1);
        } else if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
            detail = detail + dto.getTotalAmount().setScale(2, 1);
        }
        if (CalculationRebateMethodEnum.FIX.getValue().equals(threshold.getRebateMethod())) {
            detail = detail + ", \u95e8\u69db\u503c: " + threshold.getThresholdValue();
        }
        calculateDetail.setDetail(detail);
        calculateDetail.setCompletionRate(dto.getCompletionRate());
        calculateDetail.setTotalCompletionRate(dto.getTotalCompletionRate());
        detailList.add(calculateDetail);
    }

    @Override
    protected CalculationResultDTO beforeCalculateThreshold(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleThreshold threshold) {
        CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO = new CalculationResultDTO<List<PurchaseVoucherItemDTO>>();
        List<PurchaseVoucherItemDTO> voucherItems = this.getPurchaseVoucherItemByThreshold(sheet, threshold);
        log.info("rebate: sheetId : {} ,  rule get voucher list , thresholdId : , {} ,  data : {} ", new Object[]{sheet.getId(), threshold.getId(), JSON.toJSONString(voucherItems)});
        if (CollectionUtils.isEmpty(voucherItems)) {
            log.info("\u95e8\u69dbid: {} \u6ca1\u6709\u5bf9\u5e94\u51ed\u8bc1\u5355 ", (Object)threshold.getId());
            return resultDTO;
        }
        this.handleTotalAmountOrNumber(resultDTO, voucherItems, threshold.getRebateCondition(), threshold.getPricingBasis(), threshold.getPriceJudgment(), threshold.getAssessmentPrice());
        resultDTO.setObj(voucherItems);
        return resultDTO;
    }

    @Override
    protected CalculationResultDTO beforeCalculateSupplement(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleSupplement supplement) {
        CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO = new CalculationResultDTO<List<PurchaseVoucherItemDTO>>();
        List<PurchaseVoucherItemDTO> voucherItems = this.getPurchaseVoucherItemBySupplement(sheet, supplement);
        log.info("rebate:  rule get voucher list , ruleId : , {} ,  data : {} ", (Object)supplement.getId(), (Object)JSON.toJSONString(voucherItems));
        if (CollectionUtils.isEmpty(voucherItems)) {
            log.info("\u89c4\u5219 ,{} \u6ca1\u6709\u5bf9\u5e94\u51ed\u8bc1\u5355 ", (Object)supplement.getId());
            return resultDTO;
        }
        this.handleTotalAmountOrNumber(resultDTO, voucherItems, supplement.getRebateCondition(), supplement.getPricingBasis(), supplement.getPriceJudgment(), supplement.getAssessmentPrice());
        resultDTO.setObj(voucherItems);
        return resultDTO;
    }

    @Override
    protected void afterCalculateSupplement(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetCalculateDetail> detailList, PurchaseRebateCalculationSheetRuleSupplement supplement, CalculationResultDTO dto) {
        List voucherItems = JSON.parseArray((String)JSON.toJSONString(dto.getObj()), PurchaseVoucherItemDTO.class);
        if (CollectionUtils.isEmpty((Collection)voucherItems)) {
            return;
        }
        BigDecimal rebateAmount = dto.getRebateAmount();
        String rebateForm = sheet.getRebateForm();
        PurchaseRebateCalculationSheetCalculateDetail calculateDetail = this.buildCalculateDetail(voucherItems, supplement.getRuleNumber(), CalculationRebateProjectEnum.SUPPLEMENT);
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            calculateDetail.setRebateQuantity(rebateAmount);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            calculateDetail.setRebateAmount(rebateAmount);
        }
        String rebateType = StringUtils.isEmpty((CharSequence)supplement.getRebateType()) ? CalculationRebateTypeEnum.PURCHASE_RETURN.getValue() : supplement.getRebateType();
        String rebateCondition = StringUtils.isEmpty((CharSequence)supplement.getRebateCondition()) ? RebateConditionEnum.AMOUNT.getValue() : supplement.getRebateCondition();
        String detail = "\u67e5\u8be2\u51ed\u8bc1\u7ba1\u7406\u8868\uff0c\u5171" + voucherItems.size() + "\u6761\u8bb0\u5f55,";
        if (CalculationRebateMethodEnum.RATE.getValue().equals(supplement.getRebateMethod())) {
            detail = detail + " \u8fd4\u5229\u5546\u54c1" + CalculationRebateTypeEnum.parse(rebateType).getDesc() + RebateConditionEnum.parse(rebateCondition).getDesc() + ": ";
            if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
                detail = detail + dto.getTotalNumber().setScale(6, 1);
            } else if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
                detail = detail + dto.getTotalAmount().setScale(2, 1);
            }
        }
        detail = detail + "\u8ffd\u52a0\u8fd4\u5229" + CalculationRebateTypeEnum.parse(rebateType).getDesc() + RebateConditionEnum.parse(rebateCondition).getDesc() + ": ";
        if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
            detail = detail + dto.getTotalNumber().setScale(6, 1);
        } else if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
            detail = detail + dto.getTotalAmount().setScale(2, 1);
        }
        if (CalculationRebateMethodEnum.FIX.getValue().equals(supplement.getRebateMethod())) {
            detail = detail + ", \u95e8\u69db\u503c: " + supplement.getThresholdValue();
        }
        calculateDetail.setDetail(detail);
        calculateDetail.setCompletionRate(dto.getCompletionRate());
        calculateDetail.setTotalCompletionRate(dto.getTotalCompletionRate());
        detailList.add(calculateDetail);
    }

    private PurchaseRebateCalculationSheetCalculateDetail buildCalculateDetail(List<PurchaseVoucherItemDTO> voucherItems, String ruleNumber, CalculationRebateProjectEnum calculationRebateProject) {
        PurchaseRebateCalculationSheetCalculateDetail calculateDetail = new PurchaseRebateCalculationSheetCalculateDetail();
        calculateDetail.setRuleNumber(ruleNumber);
        calculateDetail.setCalculateProject(calculationRebateProject.getValue());
        HashSet<String> material = new HashSet<String>();
        StringJoiner sj = new StringJoiner("\u3001");
        for (PurchaseVoucherItemDTO voucherItem : voucherItems) {
            String key = voucherItem.getMaterialName() + "-" + voucherItem.getMaterialNumber();
            if (material.contains(key)) continue;
            material.add(key);
            sj.add(voucherItem.getMaterialName() + "(" + voucherItem.getMaterialNumber() + ")");
        }
        calculateDetail.setRebateProduct(sj.toString());
        return calculateDetail;
    }

    private void handleTotalAmountOrNumber(CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO, List<PurchaseVoucherItemDTO> voucherItems, String rebateCondition, String pricingBasis, BigDecimal priceJudgment, BigDecimal assessmentPrice) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalNumber = BigDecimal.ZERO;
        BigDecimal totalVoucherQuantity = voucherItems.parallelStream().filter(item -> item.getVoucherQuantity() != null).map(PurchaseVoucherItemDTO::getVoucherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
            if (PricingBasisEnum.PRICE.getValue().equals(pricingBasis)) {
                for (PurchaseVoucherItemDTO item2 : voucherItems) {
                    totalAmount = this.handlePriceJudgmentAmount(priceJudgment, item2, item2.getPrice(), totalAmount);
                    totalNumber = this.handlePriceJudgmentNumber(priceJudgment, item2, item2.getPrice(), totalNumber);
                }
            } else if (PricingBasisEnum.NET_PRICE.getValue().equals(pricingBasis)) {
                for (PurchaseVoucherItemDTO item3 : voucherItems) {
                    totalAmount = this.handlePriceJudgmentAmount(priceJudgment, item3, item3.getNetPrice(), totalAmount);
                    totalNumber = this.handlePriceJudgmentNumber(priceJudgment, item3, item3.getNetPrice(), totalNumber);
                }
            } else if (PricingBasisEnum.ASSESSMENT_PRICE.getValue().equals(pricingBasis) && BigDecimal.ZERO.compareTo(totalVoucherQuantity) != 0 && BigDecimal.ZERO.compareTo(assessmentPrice) != 0) {
                totalAmount = totalVoucherQuantity.multiply(assessmentPrice);
            }
        } else if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
            totalNumber = totalVoucherQuantity;
        }
        resultDTO.setTotalAmount(totalAmount);
        resultDTO.setTotalNumber(totalNumber);
    }

    private BigDecimal handlePriceJudgmentAmount(BigDecimal priceJudgment, PurchaseVoucherItemDTO item, BigDecimal price, BigDecimal amount) {
        if (price != null && item.getVoucherQuantity() != null) {
            boolean flag;
            boolean bl = flag = priceJudgment != null && BigDecimal.ZERO.compareTo(priceJudgment) != 0 && price.compareTo(priceJudgment) < 0;
            if (flag) {
                log.info("rebate: \u91d1\u989d\u4e3a: " + price + "  \u4ef7\u683c\u5224\u65ad\u4e3a: " + priceJudgment);
                return amount;
            }
            BigDecimal positiveAmount = BigDecimal.ZERO;
            BigDecimal negativeAmount = BigDecimal.ZERO;
            if ("+".equals(item.getLoanDirection())) {
                positiveAmount = price.multiply(item.getVoucherQuantity());
            }
            if ("-".equals(item.getLoanDirection())) {
                negativeAmount = price.multiply(item.getVoucherQuantity());
            }
            BigDecimal current = positiveAmount.subtract(negativeAmount);
            current = this.handleScientificNotation(current);
            amount = amount.add(current);
        }
        return amount;
    }

    private BigDecimal handlePriceJudgmentNumber(BigDecimal priceJudgment, PurchaseVoucherItemDTO item, BigDecimal price, BigDecimal number) {
        if (price != null && item.getVoucherQuantity() != null) {
            boolean flag;
            boolean bl = flag = priceJudgment != null && BigDecimal.ZERO.compareTo(priceJudgment) != 0 && price.compareTo(priceJudgment) < 0;
            if (flag) {
                log.info("rebate: \u91d1\u989d\u4e3a: " + price + "  \u4ef7\u683c\u5224\u65ad\u4e3a: " + priceJudgment);
                return number;
            }
            BigDecimal positiveNumber = BigDecimal.ZERO;
            BigDecimal negativeNumber = BigDecimal.ZERO;
            if ("+".equals(item.getLoanDirection())) {
                positiveNumber = item.getVoucherQuantity();
            }
            if ("-".equals(item.getLoanDirection())) {
                negativeNumber = item.getVoucherQuantity();
            }
            BigDecimal current = positiveNumber.subtract(negativeNumber);
            current = this.handleScientificNotation(current);
            number = number.add(current);
        }
        return number;
    }

    private List<PurchaseVoucherItemDTO> getPurchaseVoucherItem(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleDetail rule) {
        PurchaseRebateVoucherDTO dto = new PurchaseRebateVoucherDTO();
        Date calculationSheetEndDate = this.handleCalculationSheetEndDate(rule.getRebateSettlementCycle(), sheet.getEndDate());
        String rebateProduct = rule.getRebateProduct();
        this.handleProducts(dto, rebateProduct);
        String sourceRestriction = rule.getSourceRestriction();
        this.handleSourceRestriction(dto, sourceRestriction);
        dto.setRuleBeginDate(rule.getBeginDate());
        dto.setRuleEndDate(rule.getEndDate());
        dto.setSheetBeginDate(sheet.getBeginDate());
        dto.setSheetEndDate(calculationSheetEndDate);
        dto.setCurrency(rule.getCurrency());
        if (calculationSheetEndDate == null) {
            dto.setSheetEndDate(sheet.getEndDate());
            dto.setRuleBeginDate(null);
            dto.setRuleEndDate(null);
        }
        dto.setCompany(sheet.getCompany());
        dto.setToElsAccount(sheet.getToElsAccount());
        log.info("rebate: sheetId: {},  ruleId: {}, queryParam: {} , products: {}", new Object[]{sheet.getId(), rule.getId(), JSON.toJSONString((Object)dto), JSON.toJSONString((Object)rebateProduct)});
        return this.purchaseVoucherItemRpcService.selectCalculationVoucher(dto);
    }

    private List<PurchaseVoucherItemDTO> getPurchaseVoucherItemBySupplement(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleSupplement supplement) {
        PurchaseRebateVoucherDTO dto = new PurchaseRebateVoucherDTO();
        String rebateProduct = supplement.getRebateProduct();
        this.handleProducts(dto, rebateProduct);
        String sourceRestriction = supplement.getSourceRestriction();
        this.handleSourceRestriction(dto, sourceRestriction);
        Date calculationSheetEndDate = this.handleCalculationSheetEndDate(supplement.getRebateSettlementCycle(), sheet.getEndDate());
        dto.setSheetBeginDate(sheet.getBeginDate());
        dto.setSheetEndDate(calculationSheetEndDate);
        if (calculationSheetEndDate == null) {
            dto.setSheetEndDate(sheet.getEndDate());
        }
        dto.setCurrency(supplement.getCurrency());
        dto.setCompany(sheet.getCompany());
        dto.setToElsAccount(sheet.getToElsAccount());
        log.info("rebate: sheetId: {},  supplementId: {}, queryParam: {} , products: {}", new Object[]{sheet.getId(), supplement.getId(), JSON.toJSONString((Object)dto), JSON.toJSONString((Object)rebateProduct)});
        return this.purchaseVoucherItemRpcService.selectCalculationVoucher(dto);
    }

    private List<PurchaseVoucherItemDTO> getPurchaseVoucherItemByThreshold(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleThreshold threshold) {
        PurchaseRebateVoucherDTO dto = new PurchaseRebateVoucherDTO();
        String rebateProduct = threshold.getRebateProduct();
        this.handleProducts(dto, rebateProduct);
        String sourceRestriction = threshold.getSourceRestriction();
        this.handleSourceRestriction(dto, sourceRestriction);
        Date calculationSheetEndDate = this.handleCalculationSheetEndDate(threshold.getRebateSettlementCycle(), sheet.getEndDate());
        dto.setSheetBeginDate(sheet.getBeginDate());
        dto.setSheetEndDate(calculationSheetEndDate);
        if (calculationSheetEndDate == null) {
            dto.setSheetEndDate(sheet.getEndDate());
        }
        dto.setCurrency(threshold.getCurrency());
        dto.setCompany(sheet.getCompany());
        dto.setToElsAccount(sheet.getToElsAccount());
        log.info("rebate: sheetId: {},  thresholdId: {}, queryParam: {} , products: {}", new Object[]{sheet.getId(), threshold.getId(), JSON.toJSONString((Object)dto), JSON.toJSONString((Object)rebateProduct)});
        return this.purchaseVoucherItemRpcService.selectCalculationVoucher(dto);
    }

    private void handleSourceRestriction(PurchaseRebateVoucherDTO dto, String sourceRestriction) {
        if (StringUtils.isEmpty((CharSequence)sourceRestriction)) {
            return;
        }
        ArrayList sourceRestrictions = Lists.newArrayList((Object[])sourceRestriction.split(","));
        if (CollectionUtils.isEmpty((Collection)sourceRestrictions)) {
            return;
        }
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.supplierLocalRpcService.listByIds(sourceRestrictions);
        if (!CollectionUtils.isEmpty(supplierMasterDataDTOList)) {
            List sourceRestrictionCodes = supplierMasterDataDTOList.stream().map(SupplierMasterDataDTO::getToElsAccount).collect(Collectors.toList());
            dto.setSourceRestrictions(sourceRestrictionCodes);
        }
    }

    private void handleProducts(PurchaseRebateVoucherDTO dto, String rebateProduct) {
        if (StringUtils.isEmpty((CharSequence)rebateProduct)) {
            return;
        }
        ArrayList products = Lists.newArrayList((Object[])rebateProduct.split(","));
        if (CollectionUtils.isEmpty((Collection)products)) {
            return;
        }
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOList = this.purchaseMaterialHeadLocalRpcService.listByIds(products);
        if (!CollectionUtils.isEmpty(purchaseMaterialHeadDTOList)) {
            List productsCodes = purchaseMaterialHeadDTOList.stream().map(PurchaseMaterialHeadDTO::getMaterialNumber).collect(Collectors.toList());
            dto.setRebateProducts(productsCodes);
        }
    }

    @Override
    protected void handleGoodRebate(CalculationResultDTO resultDTO, GoodLadderVO ladderVO, GoodRebateVO goodRebateVO) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(ladderVO.getId());
        List<PurchaseMaterialHeadDTO> materialHeadList = this.purchaseMaterialHeadLocalRpcService.listByIds(ids);
        if (CollectionUtils.isEmpty(materialHeadList)) {
            return;
        }
        Optional purchaseMaterialHeadOptional = materialHeadList.stream().findFirst();
        if (purchaseMaterialHeadOptional.isPresent() && resultDTO.getObj() != null) {
            PurchaseMaterialHeadDTO dto = (PurchaseMaterialHeadDTO)purchaseMaterialHeadOptional.get();
            if (StringUtils.isEmpty((CharSequence)dto.getMaterialNumber())) {
                return;
            }
            List voucherItems = JSON.parseArray((String)JSON.toJSONString(resultDTO.getObj()), PurchaseVoucherItemDTO.class);
            if (CollectionUtils.isEmpty((Collection)voucherItems)) {
                return;
            }
            List<PurchaseVoucherItemDTO> voucherItemList = voucherItems.stream().filter(voucherItem -> dto.getMaterialNumber().equals(voucherItem.getMaterialNumber())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(voucherItemList)) {
                this.handleTotalAmountOrNumber(resultDTO, voucherItemList, goodRebateVO.getRebateCondition(), goodRebateVO.getPricingBasis(), goodRebateVO.getPriceJudgment(), goodRebateVO.getAssessmentPrice());
            }
        }
    }
}

