/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseInvoiceHookInformation;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceHookInformationMapper;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseInvoiceServiceImpl
extends ServiceImpl<PurchaseInvoiceMapper, PurchaseInvoice>
implements PurchaseInvoiceService {
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private PurchaseInvoiceHookInformationMapper purchaseInvoiceHookInformationMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;

    @Override
    public void savePurchaseInvoice(PurchaseInvoice purchaseInvoice) {
        ((PurchaseInvoiceMapper)this.baseMapper).insert((Object)purchaseInvoice);
    }

    @Override
    public void updatePurchaseInvoice(PurchaseInvoice purchaseInvoice) {
        ((PurchaseInvoiceMapper)this.baseMapper).updateById((Object)purchaseInvoice);
    }

    @Override
    public void delPurchaseInvoice(String id) {
        ((PurchaseInvoiceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseInvoice(List<String> idList) {
        ((PurchaseInvoiceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PurchaseInvoice> selectByMainId(String mainId) {
        return this.purchaseInvoiceMapper.selectByMainId(mainId);
    }

    @Override
    public JSONObject getRequestDataById(String id) {
        PurchaseInvoiceVO purchaseInvoiceVO = this.getMessageById(id);
        Result result = Result.ok((Object)((Object)purchaseInvoiceVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getRequestDataById(List<String> ids) {
        ArrayList headVOArrayList = new ArrayList();
        ids.forEach(id -> headVOArrayList.add(this.getMessageById((String)id)));
        Result result = Result.ok(headVOArrayList);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONArray)result.getResult();
    }

    @Override
    public void savePerformanceReconcilationInvoice(List<PurchaseInvoice> purchaseInvoiceList, PurchasePerformanceReconciliation purchasePerformanceReconciliation, SalePerformanceReconciliation salePerformanceReconciliation) {
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        BigDecimal notIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (PurchaseInvoice purchaseInvoice : purchaseInvoiceList) {
            purchaseInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)purchaseInvoice.getInvoiceNumber())) {
                String invoiceNumber = this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)purchaseInvoice);
                purchaseInvoice.setInvoiceNumber(invoiceNumber);
            }
            purchaseInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            if (purchaseInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = purchaseInvoice.getTaxRate().divide(new BigDecimal(100)).add(BigDecimal.ONE);
                purchaseInvoice.setNotIncludeTaxAmount(purchaseInvoice.getIncludeTaxAmount().divide(tax, 5));
            }
            if (purchaseInvoice.getTaxAmount() == null) {
                purchaseInvoice.setTaxAmount(purchaseInvoice.getIncludeTaxAmount().subtract(purchaseInvoice.getNotIncludeTaxAmount()));
            }
            purchaseInvoice.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseInvoice.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            purchaseInvoice.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseInvoice, (BaseEntity)purchasePerformanceReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(purchaseInvoice.getIncludeTaxAmount());
            notIncludeTaxAmount = notIncludeTaxAmount.add(purchaseInvoice.getNotIncludeTaxAmount());
            taxAmount = taxAmount.add(purchaseInvoice.getTaxAmount());
        }
        if (!purchaseInvoiceList.isEmpty()) {
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoiceList);
        }
        List<SaleInvoice> saleInvoiceList = this.saveSaleInvoice(purchaseInvoiceList, salePerformanceReconciliation.getElsAccount(), salePerformanceReconciliation.getToElsAccount(), salePerformanceReconciliation.getId());
        this.updatePurchaseInvoice(purchaseInvoiceList, saleInvoiceList);
        purchasePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        purchasePerformanceReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
        purchasePerformanceReconciliation.setTaxAmount(taxAmount);
        salePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        salePerformanceReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
        salePerformanceReconciliation.setTaxAmount(taxAmount);
    }

    private List<SaleInvoice> saveSaleInvoice(List<PurchaseInvoice> purchaseInvoiceList, String elsAccount, String toElsAccount, String id) {
        ArrayList<SaleInvoice> saleInvoiceList = new ArrayList<SaleInvoice>();
        if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
            for (PurchaseInvoice purchaseInvoice : purchaseInvoiceList) {
                SaleInvoice saleInvoice = new SaleInvoice();
                BeanUtils.copyProperties((Object)((Object)purchaseInvoice), (Object)((Object)saleInvoice));
                saleInvoice.setRelationId(purchaseInvoice.getId());
                saleInvoice.setElsAccount(elsAccount);
                saleInvoice.setToElsAccount(toElsAccount);
                saleInvoice.setBusAccount(toElsAccount);
                saleInvoice.setHeadId(id);
                saleInvoice.setId(null);
                saleInvoiceList.add(saleInvoice);
            }
            this.saleInvoiceMapper.insertBatchSomeColumn(saleInvoiceList);
        }
        return saleInvoiceList;
    }

    @Override
    public void saveReconcilationInvoice(List<PurchaseInvoice> purchaseInvoiceList, PurchaseReconciliation purchaseReconciliation, SaleReconciliation saleReconciliation) {
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        BigDecimal notIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (PurchaseInvoice purchaseInvoice : purchaseInvoiceList) {
            purchaseInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)purchaseInvoice.getInvoiceNumber())) {
                purchaseInvoice.setInvoiceNumber(this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)purchaseInvoice));
            }
            purchaseInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            if (purchaseInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = purchaseInvoice.getTaxRate().divide(new BigDecimal(100)).add(BigDecimal.ONE);
                purchaseInvoice.setNotIncludeTaxAmount(purchaseInvoice.getIncludeTaxAmount().divide(tax, 5));
            }
            if (purchaseInvoice.getTaxAmount() == null) {
                purchaseInvoice.setTaxAmount(purchaseInvoice.getIncludeTaxAmount().subtract(purchaseInvoice.getNotIncludeTaxAmount()));
            }
            purchaseInvoice.setReconciliationNumber(purchaseReconciliation.getReconciliationNumber());
            purchaseInvoice.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseInvoice.setHeadId(purchaseReconciliation.getId());
            String documentId = purchaseReconciliation.getDocumentId();
            if (!StringUtils.isEmpty((CharSequence)documentId)) {
                purchaseInvoice.setDocumentId(documentId);
                purchaseInvoice.setDocumentParentId(purchaseReconciliation.getId());
            }
            SysUtil.setSysParam((BaseEntity)purchaseInvoice, (BaseEntity)purchaseReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(purchaseInvoice.getIncludeTaxAmount());
            notIncludeTaxAmount = notIncludeTaxAmount.add(purchaseInvoice.getNotIncludeTaxAmount());
            taxAmount = taxAmount.add(purchaseInvoice.getTaxAmount());
        }
        if (!purchaseInvoiceList.isEmpty()) {
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoiceList);
        }
        List<SaleInvoice> saleInvoiceList = this.saveSaleInvoice(purchaseInvoiceList, saleReconciliation.getElsAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getId());
        this.updatePurchaseInvoice(purchaseInvoiceList, saleInvoiceList);
        purchaseReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        purchaseReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
        purchaseReconciliation.setTaxAmount(taxAmount);
        saleReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        saleReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
        saleReconciliation.setTaxAmount(taxAmount);
    }

    private void updatePurchaseInvoice(List<PurchaseInvoice> purchaseInvoiceList, List<SaleInvoice> saleInvoiceList) {
        HashMap<String, String> relationMap = new HashMap<String, String>();
        for (SaleInvoice saleInvoice : saleInvoiceList) {
            relationMap.put(saleInvoice.getRelationId(), saleInvoice.getId());
        }
        for (PurchaseInvoice purchaseInvoice : purchaseInvoiceList) {
            String relationId = (String)relationMap.get(purchaseInvoice.getId());
            if (StringUtils.isEmpty((CharSequence)relationId)) continue;
            purchaseInvoice.setRelationId(relationId);
            this.purchaseInvoiceMapper.updateById((Object)purchaseInvoice);
        }
    }

    private PurchaseInvoiceVO getMessageById(String id) {
        PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)this.getById((Serializable)((Object)id)));
        PurchaseInvoiceVO purchaseInvoiceVO = new PurchaseInvoiceVO();
        BeanUtils.copyProperties((Object)((Object)purchaseInvoice), (Object)((Object)purchaseInvoiceVO));
        List<PurchaseInvoiceHookInformation> purchaseInvoiceList = this.purchaseInvoiceHookInformationMapper.selectByMainId(id);
        purchaseInvoiceVO.setInvoiceHookInformationList(purchaseInvoiceList);
        return purchaseInvoiceVO;
    }
}

