/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.mapper.PurchaseRecAdditionalChargesMapper;
import com.els.modules.reconciliation.service.PurchaseRecAdditionalChargesService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRecAdditionalChargesServiceImpl
extends ServiceImpl<PurchaseRecAdditionalChargesMapper, PurchaseRecAdditionalCharges>
implements PurchaseRecAdditionalChargesService {
    @Resource
    private PurchaseRecAdditionalChargesMapper purchaseRecAdditionalChargesMapper;

    @Override
    public List<PurchaseRecAdditionalCharges> selectByMainId(String mainId) {
        return this.purchaseRecAdditionalChargesMapper.selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        this.purchaseRecAdditionalChargesMapper.deleteByMainId(mainId);
    }

    @Override
    public void checkAdditional(PurchaseReconciliationVO purchaseReconciliationVO) {
        List<PurchaseRecAdditionalCharges> recAdditionalChargesList = purchaseReconciliationVO.getRecAdditionalChargesList();
        if (CollectionUtil.isEmpty(recAdditionalChargesList)) {
            return;
        }
        Set<String> voucherNumbers = recAdditionalChargesList.stream().map(PurchaseRecAdditionalCharges::getVoucherNumber).collect(Collectors.toSet());
        List<PurchaseRecAdditionalCharges> items = this.purchaseRecAdditionalChargesMapper.checkAdditional(voucherNumbers);
        List<PurchaseRecAdditionalCharges> resultList = this.getIntersection(recAdditionalChargesList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = purchaseReconciliationVO.getReconciliationNumber().replace("PPR", "").replace("SPR", "").replace("SR", "").replace("PR", "");
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<PurchaseRecAdditionalCharges> sourceList = this.getIntersection(resultList, recAdditionalChargesList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            PurchaseRecAdditionalCharges purchaseRecAdditionalCharges = (PurchaseRecAdditionalCharges)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVRHWTyWWWWWIhxIeWVQG_d3c7fd99", (String)"\u9644\u52a0\u8d39\u7528 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{purchaseRecAdditionalCharges.getItemNumber()}));
        }
    }

    private List<PurchaseRecAdditionalCharges> getIntersection(List<PurchaseRecAdditionalCharges> targetList, List<PurchaseRecAdditionalCharges> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(PurchaseRecAdditionalCharges::getVoucherNumber).collect(Collectors.toList()).contains(item.getVoucherNumber())).collect(Collectors.toList());
    }
}

