/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.mapper.PurchaseRecContractPromiseMapper;
import com.els.modules.reconciliation.service.PurchaseRecContractPromiseService;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRecContractPromiseServiceImpl
extends BaseServiceImpl<PurchaseRecContractPromiseMapper, PurchaseRecContractPromise>
implements PurchaseRecContractPromiseService {
    @Override
    public void savePurchaseRecContractPromise(PurchaseRecContractPromise purchaseRecContractPromise) {
        ((PurchaseRecContractPromiseMapper)this.baseMapper).insert((Object)purchaseRecContractPromise);
    }

    @Override
    public void updatePurchaseRecContractPromise(PurchaseRecContractPromise purchaseRecContractPromise) {
        ((PurchaseRecContractPromiseMapper)this.baseMapper).updateById((Object)purchaseRecContractPromise);
    }

    @Override
    public void delPurchaseRecContractPromise(String id) {
        ((PurchaseRecContractPromiseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseRecContractPromise(List<String> idList) {
        ((PurchaseRecContractPromiseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PurchaseRecContractPromise> selectByMainId(String id) {
        return ((PurchaseRecContractPromiseMapper)this.baseMapper).selectByMainId(id);
    }

    @Override
    public void deleteByMainId(String id) {
        ((PurchaseRecContractPromiseMapper)this.baseMapper).deleteByMainId(id);
    }

    @Override
    public void checkPromise(PurchasePerformanceReconciliationVO reconciliationVO) {
        List<PurchaseRecContractPromise> recContractPromiseList = reconciliationVO.getRecContractPromiseList();
        if (CollectionUtil.isEmpty(recContractPromiseList)) {
            return;
        }
        Set<String> promiseNumbers = recContractPromiseList.stream().map(PurchaseRecContractPromise::getPromiseNumber).collect(Collectors.toSet());
        List<PurchaseRecContractPromise> items = ((PurchaseRecContractPromiseMapper)this.baseMapper).checkHasReconcilationed(promiseNumbers);
        if (CollectionUtil.isEmpty(items)) {
            return;
        }
        List<PurchaseRecContractPromise> resultList = this.getIntersection(recContractPromiseList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = reconciliationVO.getReconciliationNumber().replace("PPR", "").replace("SPR", "").replace("SR", "").replace("PR", "");
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<PurchaseRecContractPromise> sourceList = this.getIntersection(resultList, recContractPromiseList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            PurchaseRecContractPromise purchaseRecContractPromise = (PurchaseRecContractPromise)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_neIZtWTyWWWWWIhxIeWVQG_e2d5b71c", (String)"\u5408\u540c\u5c65\u7ea6\u5355 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{purchaseRecContractPromise.getItemNumber()}));
        }
    }

    private List<PurchaseRecContractPromise> getIntersection(List<PurchaseRecContractPromise> targetList, List<PurchaseRecContractPromise> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(e -> e.getPromiseNumber() + "&" + e.getPromiseNumberItem()).collect(Collectors.toList()).contains(item.getPromiseNumber() + "&" + item.getPromiseNumberItem())).collect(Collectors.toList());
    }
}

