/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.UUIDGenerator;
import com.els.modules.config.MuonuoProperties;
import com.els.modules.finance.entity.FinanceEnterpriseOutinvoice;
import com.els.modules.reconciliation.entity.InvoiceOcrData;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFour;
import com.els.modules.reconciliation.entity.InvoiceOcrDataOne;
import com.els.modules.reconciliation.entity.InvoiceOcrDataThree;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTwo;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceTypeEnum;
import com.els.modules.reconciliation.enumerate.InvoiceTypeToClass;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.third.NuonuoCallBackStatusEnum;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.service.InvoiceOcrDataFourService;
import com.els.modules.reconciliation.service.InvoiceOcrDataOneService;
import com.els.modules.reconciliation.service.InvoiceOcrDataThreeService;
import com.els.modules.reconciliation.service.InvoiceOcrDataTwoService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.vo.InvoiceDetailVO;
import com.els.modules.reconciliation.vo.OrderVO;
import com.els.modules.reconciliation.vo.response.DataVO;
import com.els.modules.reconciliation.vo.response.InvoiceResultVO;
import com.els.modules.reconciliation.vo.response.ResultVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleInvoiceServiceImpl
extends ServiceImpl<SaleInvoiceMapper, SaleInvoice>
implements SaleInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvoiceServiceImpl.class);
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Autowired
    private InvoiceOcrDataOneService invoiceOcrDataOneService;
    @Autowired
    private InvoiceOcrDataTwoService invoiceOcrDataTwoService;
    @Autowired
    private InvoiceOcrDataThreeService invoiceOcrDataThreeService;
    @Autowired
    private InvoiceOcrDataFourService invoiceOcrDataFourService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MuonuoProperties muonuoProperties;

    @Override
    public List<SaleInvoice> selectByMainId(String mainId) {
        return this.saleInvoiceMapper.selectByMainId(mainId);
    }

    @Override
    public void saveSaleInvoice(SaleInvoice saleInvoice) {
        ((SaleInvoiceMapper)this.baseMapper).insert((Object)saleInvoice);
    }

    @Override
    public void updateSaleInvoice(SaleInvoice saleInvoice) {
        ((SaleInvoiceMapper)this.baseMapper).updateById((Object)saleInvoice);
    }

    @Override
    public void delSaleInvoice(String id) {
        ((SaleInvoiceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleInvoice(List<String> idList) {
        ((SaleInvoiceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<SaleInvoice> invoiceOCRToSaleInvoice(List<InvoiceOcrData> invoiceOcrDataList) throws ParseException {
        ArrayList<SaleInvoice> saleInvoiceArrayList = new ArrayList<SaleInvoice>();
        if (CollectionUtil.isNotEmpty(invoiceOcrDataList)) {
            for (InvoiceOcrData invoiceOcrData : invoiceOcrDataList) {
                BigDecimal taxTotal;
                BigDecimal netToatal;
                BigDecimal bigDecimal;
                Date invoiceDate;
                String vatInvoiceIssueDate;
                SaleInvoice saleInvoice = new SaleInvoice();
                String invoiceType = invoiceOcrData.getInvoiceType();
                String id = invoiceOcrData.getId();
                InvoiceTypeToClass invoiceTypeToClass = new InvoiceTypeToClass();
                if (invoiceTypeToClass.getOne().contains(invoiceType)) {
                    List<InvoiceOcrDataOne> invoiceOcrDataOneList = this.invoiceOcrDataOneService.selectByMainId(id);
                    InvoiceOcrDataOne invoiceOcrDataOne = invoiceOcrDataOneList.get(0);
                    vatInvoiceIssueDate = invoiceOcrDataOne.getVatInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataOne.getVatInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataOne.getVatInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataOne.getVatInvoicePayerName());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTotalCoverTaxDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    netToatal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTotal());
                    saleInvoice.setNotIncludeTaxAmount(netToatal);
                    taxTotal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTaxTotal());
                    saleInvoice.setTaxAmount(taxTotal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (invoiceTypeToClass.getTwo().contains(invoiceType)) {
                    List<InvoiceOcrDataTwo> invoiceOcrDataTwoList = this.invoiceOcrDataTwoService.selectByMainId(id);
                    InvoiceOcrDataTwo invoiceOcrDataTwo = invoiceOcrDataTwoList.get(0);
                    String vehicleInvoiceIssueDate = invoiceOcrDataTwo.getVehicleInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vehicleInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataTwo.getVehicleInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataTwo.getVehicleInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataTwo.getVehicleInvoiceBuyer());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoiceTotalPriceDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    netToatal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoicePriceWithoutTax());
                    saleInvoice.setNotIncludeTaxAmount(netToatal);
                    taxTotal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoiceTaxAmount());
                    saleInvoice.setIncludeTaxAmount(taxTotal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (invoiceTypeToClass.getThree().contains(invoiceType)) {
                    List<InvoiceOcrDataThree> invoiceOcrDataThreeList = this.invoiceOcrDataThreeService.selectByMainId(id);
                    InvoiceOcrDataThree invoiceOcrDataThree = invoiceOcrDataThreeList.get(0);
                    vatInvoiceIssueDate = invoiceOcrDataThree.getVehicleInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataThree.getVehicleInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataThree.getVehicleInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataThree.getVehicleInvoiceBuyer());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataThree.getVehicleInvoiceTotalPriceDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (!invoiceTypeToClass.getFour().contains(invoiceType)) continue;
                List<InvoiceOcrDataFour> invoiceOcrDataFourList = this.invoiceOcrDataFourService.selectByMainId(id);
                InvoiceOcrDataFour invoiceOcrDataFour = invoiceOcrDataFourList.get(0);
                vatInvoiceIssueDate = invoiceOcrDataFour.getDateOfInvoice();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                saleInvoice.setInvoiceTime(invoiceDate);
                saleInvoice.setInvoiceNo(invoiceOcrDataFour.getInvoiceNumber());
                saleInvoice.setInvoiceCode(invoiceOcrDataFour.getInvoiceCode());
                saleInvoice.setInvoiceTitle(invoiceOcrDataFour.getInvoiceHead());
                saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                bigDecimal = new BigDecimal(invoiceOcrDataFour.getTotalMoney());
                saleInvoice.setIncludeTaxAmount(bigDecimal);
                saleInvoiceArrayList.add(saleInvoice);
            }
        }
        return saleInvoiceArrayList;
    }

    @Override
    public BigDecimal invoiceRefusedOrConfirm(List<PurchaseInvoice> invoices, String operation) {
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        for (PurchaseInvoice purchaseInvoice : invoices) {
            if (OperationEnum.REFUSED.getValue().equals(operation)) {
                purchaseInvoice.setStatus(InvoiceStatusEnum.RENTURNED.getValue());
            } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                purchaseInvoice.setStatus(InvoiceStatusEnum.CONFIRMED.getValue());
            }
            this.purchaseInvoiceMapper.updateById((Object)purchaseInvoice);
            SaleInvoice saleInvoice = (SaleInvoice)((Object)this.saleInvoiceMapper.selectById((Serializable)((Object)purchaseInvoice.getRelationId())));
            if (saleInvoice == null) {
                return invoiceTotalAmount;
            }
            if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                SaleInvoice invoice = new SaleInvoice();
                BeanUtils.copyProperties((Object)((Object)purchaseInvoice), (Object)((Object)invoice));
                invoice.setId(saleInvoice.getId());
                invoice.setElsAccount(saleInvoice.getElsAccount());
                invoice.setToElsAccount(saleInvoice.getToElsAccount());
                invoice.setBusAccount(saleInvoice.getBusAccount());
                invoice.setHeadId(saleInvoice.getHeadId());
                invoice.setNotIncludeTaxAmount(invoice.getIncludeTaxAmount().subtract(invoice.getTaxAmount()));
                this.saleInvoiceMapper.updateById((Object)invoice);
                invoiceTotalAmount = invoiceTotalAmount.add(invoice.getIncludeTaxAmount());
                continue;
            }
            saleInvoice.setPurchaseRemark(purchaseInvoice.getPurchaseRemark());
            saleInvoice.setStatus(purchaseInvoice.getStatus());
            this.saleInvoiceMapper.updateById((Object)saleInvoice);
        }
        return invoiceTotalAmount;
    }

    @Override
    public Result<?> billing(List<InvoiceDetailVO> details, FinanceEnterpriseOutinvoice saleOutinvoice, FinanceEnterpriseOutinvoice purchaseOutinvoice, SaleInvoice saleInvoice) {
        HashMap data = new HashMap();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("taxnum", saleOutinvoice.getTaxpayerRegNumber());
        data.put("header", headerMap);
        HashMap<String, OrderVO> bodyMap = new HashMap<String, OrderVO>();
        OrderVO orderVO = new OrderVO();
        data.put("body", bodyMap);
        orderVO.setBuyerName(purchaseOutinvoice.getEnterpriseName());
        if (!StringUtils.isEmpty((CharSequence)purchaseOutinvoice.getTaxpayerRegNumber())) {
            orderVO.setBuyerTaxNum(purchaseOutinvoice.getTaxpayerRegNumber());
        }
        if (!StringUtils.isEmpty((CharSequence)purchaseOutinvoice.getRegisterTelephone())) {
            orderVO.setBuyerTel(purchaseOutinvoice.getRegisterTelephone());
        }
        orderVO.setBuyerPhone(purchaseOutinvoice.getPhone());
        orderVO.setBuyerAddress(purchaseOutinvoice.getRegisterAddress());
        orderVO.setBuyerAccount(purchaseOutinvoice.getDepositBank() + purchaseOutinvoice.getBankAccount());
        orderVO.setEmail(purchaseOutinvoice.getEmail());
        orderVO.setSalerTaxNum(saleOutinvoice.getTaxpayerRegNumber());
        orderVO.setSalerAddress(purchaseOutinvoice.getRegisterAddress());
        orderVO.setSalerTel(saleOutinvoice.getRegisterTelephone());
        orderVO.setClerk(saleOutinvoice.getDrawer());
        orderVO.setPayee(saleOutinvoice.getPayee());
        orderVO.setChecker(saleOutinvoice.getReviewer());
        String depositBank = !StringUtils.isEmpty((CharSequence)saleOutinvoice.getDepositBank()) ? saleOutinvoice.getDepositBank() : "";
        String bankAccount = !StringUtils.isEmpty((CharSequence)saleOutinvoice.getBankAccount()) ? saleOutinvoice.getBankAccount() : "";
        orderVO.setSalerAccount(depositBank + bankAccount);
        String orderNo = UUIDGenerator.generate();
        this.redisUtil.set(orderNo, (Object)JSON.toJSONString((Object)((Object)saleInvoice)));
        orderVO.setOrderNo(orderNo);
        Date date = new Date();
        String invoiceDate = DateUtils.date2Str((Date)date, (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        saleInvoice.setInvoiceTime(date);
        orderVO.setInvoiceDate(invoiceDate);
        orderVO.setPushMode("0");
        orderVO.setInvoiceType("1");
        orderVO.setInvoiceLine(InvoiceTypeEnum.FREE_TEXT_INVOICE_ELECTRIC_TICKET.getValue());
        log.info("callback url : {} ", (Object)this.muonuoProperties.getNuonuo());
        orderVO.setCallBackUrl(this.muonuoProperties.getNuonuo() + "/finance/nuonuo/noToken/invoice/callback/");
        orderVO.setInvoiceDetail(details);
        bodyMap.put("order", orderVO);
        JSONObject result = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString(data)), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("invoice_nuonuo_billing"));
        log.info("billing: {}", (Object)JSON.toJSONString((Object)result));
        ResultVO resultVO = (ResultVO)JSON.parseObject((String)JSON.toJSONString((Object)result), ResultVO.class);
        DataVO dataVO = resultVO.getData();
        if ("E0000".equals(dataVO.getCode())) {
            return Result.ok((String)I18nUtil.translate((String)"", (String)"\u5f00\u7968\u63d0\u4ea4\u6210\u529f\uff01"));
        }
        return Result.error((String)dataVO.getDescribe());
    }

    @Override
    public void createSaleInvoice(InvoiceResultVO resultVO) {
        String status = resultVO.getC_status();
        String orderno = resultVO.getC_orderno();
        if (NuonuoCallBackStatusEnum.BILLING_COMPLETE.getValue().equals(status)) {
            if (StringUtils.isEmpty((CharSequence)orderno)) {
                return;
            }
            Object obj = this.redisUtil.get(orderno);
            SaleInvoice saleInvoice = (SaleInvoice)((Object)JSON.parseObject((String)(obj + ""), SaleInvoice.class));
            if (saleInvoice == null) {
                return;
            }
            String bhsje = resultVO.getC_bhsje();
            String hjse = resultVO.getC_hjse();
            if (!StringUtils.isEmpty((CharSequence)hjse) && !StringUtils.isEmpty((CharSequence)bhsje)) {
                saleInvoice.setNotIncludeTaxAmount(new BigDecimal(bhsje));
                saleInvoice.setTaxAmount(new BigDecimal(hjse));
                BigDecimal includeTaxAmount = new BigDecimal(bhsje).add(new BigDecimal(hjse));
                saleInvoice.setIncludeTaxAmount(includeTaxAmount);
            }
            String fpdm = resultVO.getC_fpdm();
            saleInvoice.setInvoiceCode(fpdm);
            String fphm = resultVO.getC_fphm();
            saleInvoice.setInvoiceNo(fphm);
            ((SaleInvoiceMapper)this.baseMapper).insert((Object)saleInvoice);
            this.redisUtil.del(new String[]{orderno});
        }
    }
}

