/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.mapper.SaleRecAdditionalChargesMapper;
import com.els.modules.reconciliation.service.SaleRecAdditionalChargesService;
import com.els.modules.reconciliation.vo.SaleReconciliationVO;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SaleRecAdditionalChargesServiceImpl
extends ServiceImpl<SaleRecAdditionalChargesMapper, SaleRecAdditionalCharges>
implements SaleRecAdditionalChargesService {
    @Resource
    private SaleRecAdditionalChargesMapper saleRecAdditionalChargesMapper;

    @Override
    public List<SaleRecAdditionalCharges> selectByMainId(String mainId) {
        return this.saleRecAdditionalChargesMapper.selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        this.saleRecAdditionalChargesMapper.deleteByMainId(mainId);
    }

    @Override
    public void checkAdditional(SaleReconciliationVO saleReconciliationVO) {
        List<SaleRecAdditionalCharges> recAdditionalChargesList = saleReconciliationVO.getRecAdditionalChargesList();
        if (CollectionUtil.isEmpty(recAdditionalChargesList)) {
            return;
        }
        Set<String> voucherNumbers = recAdditionalChargesList.stream().map(SaleRecAdditionalCharges::getVoucherNumber).collect(Collectors.toSet());
        List<SaleRecAdditionalCharges> items = this.saleRecAdditionalChargesMapper.checkAdditional(voucherNumbers);
        List<SaleRecAdditionalCharges> resultList = this.getIntersection(recAdditionalChargesList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = saleReconciliationVO.getReconciliationNumber().replace("PPR", "").replace("SPR", "").replace("SR", "").replace("PR", "");
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<SaleRecAdditionalCharges> sourceList = this.getIntersection(resultList, recAdditionalChargesList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            SaleRecAdditionalCharges saleRecAdditionalCharges = (SaleRecAdditionalCharges)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVRHWTyWWWWWIhxIeWVQG_d3c7fd99", (String)"\u9644\u52a0\u8d39\u7528 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{saleRecAdditionalCharges.getItemNumber()}));
        }
    }

    private List<SaleRecAdditionalCharges> getIntersection(List<SaleRecAdditionalCharges> targetList, List<SaleRecAdditionalCharges> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(SaleRecAdditionalCharges::getVoucherNumber).collect(Collectors.toList()).contains(item.getVoucherNumber())).collect(Collectors.toList());
    }
}

