/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchaseDeductCostItem;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseDeductCostAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)JSON.parseObject((String)params, PurchaseDeductCost.class));
        purchaseDeductCost.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseDeductCost.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseDeductCostService.updatePurchaseDeductCost(purchaseDeductCost, new ArrayList<PurchaseDeductCostItem>());
    }

    private void checkParams(PurchaseDeductCost deductCost) {
        Assert.hasText((String)deductCost.getPurchaseOrg(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectOrg", (String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u7ec4\u7ec7"));
        Assert.hasText((String)deductCost.getCompany(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectCompany", (String)"\u8bf7\u586b\u5199\u516c\u53f8"));
        Assert.hasText((String)deductCost.getToElsAccount(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectSupplier", (String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546"));
        Assert.notNull((Object)deductCost.getDeductTime(), (String)I18nUtil.translate((String)"i18n_alert_VSMVVKI_9991677e", (String)"\u8bf7\u586b\u5199\u6263\u6b3e\u65f6\u95f4"));
        Assert.hasText((String)deductCost.getDeductType(), (String)I18nUtil.translate((String)"i18n_alert_VSMVVAc_9993e330", (String)"\u8bf7\u586b\u5199\u6263\u6b3e\u7c7b\u578b"));
        Assert.notNull((Object)deductCost.getTaxAmount(), (String)I18nUtil.translate((String)"i18n_alert_VSMxfHf_9357adb4", (String)"\u8bf7\u586b\u5199\u542b\u7a0e\u91d1\u989d"));
        Assert.hasText((String)deductCost.getCurrency(), (String)I18nUtil.translate((String)"i18n_alert_ViFls_f7546863", (String)"\u8bf7\u9009\u62e9\u5e01\u79cd"));
        Assert.hasText((String)deductCost.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_ViFfo_f757cc2a", (String)"\u8bf7\u9009\u62e9\u7a0e\u7801"));
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateDeductCost(inputParamVO, outputParamVO);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateDeductCost(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateDeductCost(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseDeductCost head = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void updateDeductCost(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseDeductCost purchaseDeductCost = new PurchaseDeductCost();
        purchaseDeductCost.setId(inputParamVO.getBusinessId());
        purchaseDeductCost.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseDeductCost.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseDeductCostService.updateById((Object)purchaseDeductCost);
    }
}

