/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseAddCostItem;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleAddCostItem;
import com.els.modules.finance.enumerate.AddCostCoordinationWayEnum;
import com.els.modules.finance.mapper.SaleAddCostMapper;
import com.els.modules.finance.service.PurchaseAddCostItemService;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.SaleAddCostItemService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.vo.PurchaseAddCostVO;
import com.els.modules.finance.vo.SaleAddCostVO;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.vo.SaleReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleAddCostServiceImpl
extends BaseServiceImpl<SaleAddCostMapper, SaleAddCost>
implements SaleAddCostService {
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleAddCostMapper saleAddCostMapper;
    @Autowired
    private SaleAddCostItemService saleAddCostItemService;
    @Autowired
    private PurchaseAddCostItemService purchaseAddCostItemService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveSaleAddCost(SaleAddCost saleAddCost, List<SaleAddCostItem> saleAddCostItemList) {
        if (StringUtils.isBlank((CharSequence)saleAddCost.getCostNumber())) {
            saleAddCost.setCostNumber(this.invokeBaseRpcService.getNextCode("srmAddCostNumber", (Object)saleAddCost, saleAddCost.getBusAccount()));
        }
        this.calculatePrice(saleAddCost, saleAddCostItemList);
        saleAddCost.setCreateAccount(saleAddCost.getElsAccount());
        saleAddCost.setIsTeamwork(AddCostCoordinationWayEnum.SYNERGISM.getValue());
        ((SaleAddCostMapper)this.baseMapper).insert((Object)saleAddCost);
        this.insertSaleAddCostItemList(saleAddCost, saleAddCostItemList);
    }

    private void insertSaleAddCostItemList(SaleAddCost saleAddCost, List<SaleAddCostItem> saleAddCostItemList) {
        if (CollectionUtil.isEmpty(saleAddCostItemList)) {
            return;
        }
        for (SaleAddCostItem saleAddCostItem : saleAddCostItemList) {
            saleAddCostItem.setId(null);
            saleAddCostItem.setHeadId(saleAddCost.getId());
            saleAddCostItem.setToElsAccount(saleAddCost.getToElsAccount());
            saleAddCostItem.setBusAccount(saleAddCost.getBusAccount());
            SysUtil.setSysParam((BaseEntity)saleAddCostItem, (BaseEntity)saleAddCost);
        }
        this.saleAddCostItemService.saveBatch(saleAddCostItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updateSaleAddCost(SaleAddCost saleAddCost, List<SaleAddCostItem> saleAddCostItemList) {
        this.calculatePrice(saleAddCost, saleAddCostItemList);
        saleAddCost.setCreateAccount(saleAddCost.getElsAccount());
        ((SaleAddCostMapper)this.baseMapper).updateById((Object)saleAddCost);
        if (CollectionUtil.isEmpty(saleAddCostItemList)) {
            return;
        }
        this.saleAddCostItemService.deleteByMainId(saleAddCost.getId());
        this.insertSaleAddCostItemList(saleAddCost, saleAddCostItemList);
    }

    private void calculatePrice(SaleAddCost addCost, List<SaleAddCostItem> saleAddCostItemList) {
        BigDecimal taxRate = addCost.getTaxRate() == null ? BigDecimal.ZERO : addCost.getTaxRate().divide(BigDecimal.valueOf(100L));
        BigDecimal taxAmount = addCost.getTaxAmount() == null ? BigDecimal.ZERO : addCost.getTaxAmount();
        BigDecimal netAmount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        addCost.setNetAmount(netAmount);
        BigDecimal headTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtil.isEmpty(saleAddCostItemList)) {
            for (SaleAddCostItem saleAddCostItem : saleAddCostItemList) {
                BigDecimal itemTaxAmount = saleAddCostItem.getTaxAmount() == null ? BigDecimal.ZERO : saleAddCostItem.getTaxAmount();
                headTaxAmount = headTaxAmount.add(itemTaxAmount);
            }
            addCost.setTaxAmount(headTaxAmount);
        }
    }

    @Override
    public void sendAddCost(SaleAddCost saleAddCost, List<SaleAddCostItem> saleAddCostItemList) {
        List saleAttachmentList;
        SaleAddCost dbAddCost = (SaleAddCost)((Object)this.getById((Serializable)((Object)saleAddCost.getId())));
        if (dbAddCost != null && AddCostConfirmStatusEnum.WAIT_CONFIRM.getValue().equals(dbAddCost.getConfirmStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
        }
        boolean firstSend = true;
        String id = saleAddCost.getId();
        String relationId = saleAddCost.getRelationId();
        String elsAccount = saleAddCost.getElsAccount();
        String toElsAccount = saleAddCost.getToElsAccount();
        if (saleAddCost.getTaxAmount() == null || BigDecimal.ZERO.compareTo(saleAddCost.getTaxAmount()) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BuujRHcxfHflTfUW_cd0e11bb", (String)"\u9644\u52a0\u8d39\u7528\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0"));
        }
        if (StringUtils.isBlank((CharSequence)relationId)) {
            relationId = IdWorker.getIdStr();
            saleAddCost.setRelationId(relationId);
        } else {
            firstSend = false;
        }
        saleAddCost.setConfirmStatus(AddCostConfirmStatusEnum.WAIT_CONFIRM.getValue());
        this.updateSaleAddCost(saleAddCost, saleAddCostItemList);
        PurchaseAddCostVO purchaseAddCost = new PurchaseAddCostVO();
        BeanUtils.copyProperties((Object)((Object)saleAddCost), (Object)((Object)purchaseAddCost));
        purchaseAddCost.setId(relationId);
        purchaseAddCost.setRelationId(id);
        purchaseAddCost.setElsAccount(toElsAccount);
        purchaseAddCost.setToElsAccount(elsAccount);
        if (firstSend) {
            this.purchaseAddCostService.savePurchaseAddCost(purchaseAddCost);
        } else {
            this.purchaseAddCostService.updatePurchaseAddCost(purchaseAddCost);
            this.purchaseAddCostItemService.deleteByMainId(purchaseAddCost.getId());
        }
        String idStr = IdWorker.getIdStr();
        if (StringUtils.isEmpty((CharSequence)purchaseAddCost.getDocumentId())) {
            saleAddCost.setDocumentId(idStr);
            purchaseAddCost.setDocumentId(idStr);
            ((SaleAddCostMapper)this.baseMapper).updateById((Object)saleAddCost);
            this.purchaseAddCostService.updateById((Object)purchaseAddCost);
            IntegratedDocumentDTO integratedDocument = new IntegratedDocumentDTO();
            integratedDocument.setId(idStr);
            integratedDocument.setAddCostId(purchaseAddCost.getId());
            this.invokeBaseRpcService.saveIntegratedDocument(integratedDocument);
        }
        if (CollectionUtil.isNotEmpty((Collection)(saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id)))) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(elsAccount);
            sendVO.setHeadId(id);
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(relationId, toElsAccount);
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendSaleFile(sendVO);
        }
        ArrayList<PurchaseAddCostItem> purchaseAddCostItemList = new ArrayList<PurchaseAddCostItem>();
        if (!CollectionUtil.isEmpty(saleAddCostItemList)) {
            for (SaleAddCostItem saleAddCostItem : saleAddCostItemList) {
                PurchaseAddCostItem purchaseAddCostItem = new PurchaseAddCostItem();
                BeanUtils.copyProperties((Object)((Object)saleAddCostItem), (Object)((Object)purchaseAddCostItem));
                purchaseAddCostItem.setId(null);
                purchaseAddCostItem.setElsAccount(purchaseAddCost.getElsAccount());
                purchaseAddCostItem.setToElsAccount(purchaseAddCost.getToElsAccount());
                purchaseAddCostItem.setHeadId(purchaseAddCost.getId());
                purchaseAddCostItem.setRelationId(saleAddCostItem.getId());
                purchaseAddCostItemList.add(purchaseAddCostItem);
            }
        }
        if (!CollectionUtil.isEmpty(purchaseAddCostItemList)) {
            this.purchaseAddCostItemService.saveBatch(purchaseAddCostItemList);
        }
        super.sendMessage(saleAddCost.getBusAccount(), "addCost", "publish", saleAddCost.getId(), "addCostBusDataServiceImpl", Arrays.asList(saleAddCost.getToElsAccount()));
    }

    @Override
    public void delSaleAddCost(String id) {
        ((SaleAddCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.saleAddCostItemService.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
    }

    @Override
    public void delBatchSaleAddCost(List<String> idList) {
        ((SaleAddCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void invalidSaleAddCost(SaleAddCost saleAddCost) {
        SaleAddCost addCost = (SaleAddCost)((Object)((SaleAddCostMapper)this.baseMapper).selectById((Serializable)((Object)saleAddCost.getId())));
        if ("1".equals(addCost.getCostStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tFIOIeWxiTku_286b37be", (String)"\u5355\u636e\u5df2\u7ecf\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f"));
        }
        addCost.setConfirmStatus(AddCostConfirmStatusEnum.INVALID.getValue());
        this.updateById((Object)addCost);
        if (StringUtils.isNotBlank((CharSequence)addCost.getRelationId())) {
            PurchaseAddCost purchaseAddCost = new PurchaseAddCost();
            purchaseAddCost.setId(addCost.getRelationId());
            purchaseAddCost.setConfirmStatus(AddCostConfirmStatusEnum.INVALID.getValue());
            this.purchaseAddCostService.updateById((Object)purchaseAddCost);
            super.sendMessage(saleAddCost.getBusAccount(), "addCost", "cancel", saleAddCost.getId(), "addCostBusDataServiceImpl", Arrays.asList(saleAddCost.getToElsAccount()));
        }
    }

    @Override
    public List<SaleAddCost> listSaleAddCosts(SaleReconciliationVO reconciliationVO) {
        QueryWrapper addCostWapper = new QueryWrapper();
        addCostWapper.eq((Object)"els_account", (Object)reconciliationVO.getElsAccount());
        addCostWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        addCostWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        addCostWapper.ge((Object)"cost_time", (Object)reconciliationVO.getBeginDate());
        addCostWapper.le((Object)"cost_time", (Object)reconciliationVO.getEndDate());
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            addCostWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            addCostWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        addCostWapper.eq((Object)"confirm_status", (Object)AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        addCostWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"cost_status")).or()).eq((Object)"cost_status", (Object)"0"));
        return this.list((Wrapper)addCostWapper);
    }

    @Override
    public List<SaleRecAdditionalCharges> getBySaleAddCost(SaleReconciliationVO reconciliationVO) {
        List<SaleAddCost> saleAddCosts = this.listSaleAddCosts(reconciliationVO);
        ArrayList<SaleRecAdditionalCharges> additionalCharges = new ArrayList<SaleRecAdditionalCharges>();
        if (CollectionUtil.isEmpty(saleAddCosts)) {
            return null;
        }
        for (SaleAddCost saleAddCost : saleAddCosts) {
            SaleRecAdditionalCharges charges = new SaleRecAdditionalCharges();
            BeanUtils.copyProperties((Object)((Object)saleAddCost), (Object)((Object)charges));
            charges.setVoucherNumber(saleAddCost.getCostNumber());
            charges.setBusinessType(saleAddCost.getCostType());
            charges.setTotalAmount(saleAddCost.getTaxAmount());
            charges.setTotalNonTaxAmount(saleAddCost.getNetAmount());
            charges.setSource(saleAddCost.getSourceType());
            charges.setBusinessId(saleAddCost.getId());
            charges.setItemType(ReconcilationItemTypeEmun.ADDITIONAL_CHARGES.getValue());
            charges.setDocumentId(saleAddCost.getDocumentId());
            charges.setDocumentParentId(saleAddCost.getRelationId());
            charges.setId(null);
            additionalCharges.add(charges);
        }
        return additionalCharges;
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleAddCost byId = (SaleAddCost)((Object)this.getById((Serializable)((Object)id)));
        SaleAddCostVO saleAddCostVO = (SaleAddCostVO)((Object)BeanUtil.copyProperties((Object)((Object)byId), SaleAddCostVO.class, (String[])new String[0]));
        List<SaleAddCostItem> saleAddCostItems = this.saleAddCostItemService.selectByMainId(id);
        saleAddCostVO.setAddCostItemList(saleAddCostItems);
        Result result = Result.ok((Object)((Object)saleAddCostVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public List<SaleAddCost> checkHasReconciliation(Set<String> voucherNumbers) {
        if (CollectionUtil.isEmpty(voucherNumbers)) {
            return new ArrayList<SaleAddCost>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SaleAddCost::getCostNumber, voucherNumbers);
        return this.list((Wrapper)queryWrapper);
    }
}

