/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.rebate.entity.SaleRebateRule;
import com.els.modules.rebate.entity.SaleRebateRuleItem;
import com.els.modules.rebate.entity.SaleRebateRuleSupplement;
import com.els.modules.rebate.entity.SaleRebateRuleThreshold;
import com.els.modules.rebate.service.SaleRebateRuleItemService;
import com.els.modules.rebate.service.SaleRebateRuleService;
import com.els.modules.rebate.service.SaleRebateRuleSupplementService;
import com.els.modules.rebate.service.SaleRebateRuleThresholdService;
import com.els.modules.rebate.vo.SaleRebateRuleVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u8fd4\u5229\u89c4\u5219\u8868"})
@RestController
@RequestMapping(value={"/finance/saleRebateRule"})
public class SaleRebateRuleController
extends BaseController<SaleRebateRule, SaleRebateRuleService> {
    @Autowired
    private SaleRebateRuleService saleRebateRuleService;
    @Autowired
    private SaleRebateRuleItemService saleRebateRuleItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleRebateRuleThresholdService saleRebateRuleThresholdService;
    @Autowired
    private SaleRebateRuleSupplementService saleRebateRuleSupplementService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_saleRebateRule_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#saleRebateRule:list"})
    public Result<?> queryPageList(SaleRebateRule saleRebateRule, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleRebateRule), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleRebateRuleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#saleRebateRule:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleRebateRuleVO vo = new SaleRebateRuleVO();
        SaleRebateRule saleRebateRule = (SaleRebateRule)((Object)this.saleRebateRuleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<SaleRebateRuleItem> rebateRuleItemList = this.saleRebateRuleItemService.selectByMainId(id);
        List attachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        List<SaleRebateRuleThreshold> thresholds = this.saleRebateRuleThresholdService.selectByMainId(id);
        List<SaleRebateRuleSupplement> supplements = this.saleRebateRuleSupplementService.selectByMainId(id);
        BeanUtils.copyProperties((Object)((Object)saleRebateRule), (Object)((Object)vo));
        vo.setRebateRuleItems(rebateRuleItemList);
        vo.setAttachments(attachments);
        vo.setRebateRuleThresholds(thresholds);
        vo.setRebateRuleSupplements(supplements);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u9500\u552e\u89c4\u5219\u5355-\u9500\u552e\u786e\u8ba4")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4", notes="\u9500\u552e\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"finance#saleRebateRule:confirm"})
    public Result<?> confirm(@RequestBody SaleRebateRuleVO saleRebateRuleVO) {
        SaleRebateRule saleRebateRule = new SaleRebateRule();
        BeanUtils.copyProperties((Object)((Object)saleRebateRuleVO), (Object)((Object)saleRebateRule));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, saleRebateRuleVO.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APLFtiKRcsSTVBtk_e44a6123", (String)"\u5f53\u524d\u89c4\u5219\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleRebateRuleService.confirmOrRefused(saleRebateRule, "confirm");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, saleRebateRuleVO.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u89c4\u5219\u5355-\u9500\u552e\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u62d2\u7edd", notes="\u9500\u552e\u62d2\u7edd")
    @PostMapping(value={"/refuesd"})
    @RequiresPermissions(value={"finance#saleRebateRule:refuesd"})
    public Result<?> refuesd(@RequestBody SaleRebateRuleVO saleRebateRuleVO) {
        SaleRebateRule saleRebateRule = new SaleRebateRule();
        BeanUtils.copyProperties((Object)((Object)saleRebateRuleVO), (Object)((Object)saleRebateRule));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, saleRebateRuleVO.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APLFtiKRcsSTVBtk_e44a6123", (String)"\u5f53\u524d\u89c4\u5219\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleRebateRuleService.confirmOrRefused(saleRebateRule, "refused");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, saleRebateRuleVO.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u89c4\u5219\u5355-\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd")
    @ApiOperation(value="\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd", notes="\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd")
    @GetMapping(value={"/emailConfirmOrRefuesd"})
    @RequiresPermissions(value={"finance#saleRebateRule:emailConfirmOrRefuesd"})
    public Result<?> emailConfirmOrRefuesd(@RequestParam(name="operation") String operation, @RequestParam(name="id") String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APLFtiKRcsSTVBtk_e44a6123", (String)"\u5f53\u524d\u89c4\u5219\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleRebateRuleService.emailConfirmOrRefuesd(id, operation);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#saleRebateRule:list"})
    public Result<?> counts(SaleRebateRule saleRebateRule, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleRebateRule), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"rule_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"rule_status");
        List list = ((SaleRebateRuleService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleRebateRule::getRuleStatus, SaleRebateRule::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "ruleStatus", null, all));
        List srmRebateRuleStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmRebateRuleStatus", TenantContext.getTenant());
        for (DictDTO status : srmRebateRuleStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "ruleStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

