/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRegister;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.entity.SaleRebateCalculationSheet;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRegister;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.SaleRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationRebateCalculateResultEnum;
import com.els.modules.rebate.enumerate.CalculationSheetStatusEnum;
import com.els.modules.rebate.enumerate.RebateRuleSettlementCycleEnum;
import com.els.modules.rebate.mapper.PurchaseRebateCalculationSheetMapper;
import com.els.modules.rebate.mapper.SaleRebateCalculationSheetCalculateDetailMapper;
import com.els.modules.rebate.mapper.SaleRebateCalculationSheetMapper;
import com.els.modules.rebate.mapper.SaleRebateCalculationSheetRegisterMapper;
import com.els.modules.rebate.mapper.SaleRebateCalculationSheetRuleDetailMapper;
import com.els.modules.rebate.mapper.SaleRebateCalculationSheetRuleSupplementMapper;
import com.els.modules.rebate.mapper.SaleRebateCalculationSheetRuleThresholdMapper;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCalculateDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCertificateService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRegisterService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleThresholdService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetService;
import com.els.modules.rebate.service.PurchaseRebateRuleItemService;
import com.els.modules.rebate.service.PurchaseRebateRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateRuleThresholdService;
import com.els.modules.rebate.service.impl.PurchaseRebateCalculationService;
import com.els.modules.rebate.vo.PurchaseRebateCalculationSheetVO;
import com.els.modules.rebate.vo.PurchaseRebateRuleItemVO;
import com.els.modules.rebate.vo.PurchaseRebateSupplementVO;
import com.els.modules.rebate.vo.PurchaseRebateThresholdVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRebateCalculationSheetServiceImpl
extends BaseServiceImpl<PurchaseRebateCalculationSheetMapper, PurchaseRebateCalculationSheet>
implements PurchaseRebateCalculationSheetService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRebateCalculationSheetServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseRebateCalculationSheetCalculateDetailService purchaseRebateCalculationSheetCalculateDetailService;
    @Autowired
    private PurchaseRebateCalculationSheetCertificateService purchaseRebateCalculationSheetCertificateService;
    @Autowired
    private PurchaseRebateCalculationSheetRegisterService purchaseRebateCalculationSheetRegisterService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleDetailService purchaseRebateCalculationSheetRuleDetailService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private StaticConfig staticConfig;
    @Resource
    private SaleRebateCalculationSheetMapper saleRebateCalculationSheetMapper;
    @Resource
    private PurchaseRebateCalculationSheetMapper purchaseRebateCalculationSheetMapper;
    @Autowired
    private PurchaseRebateRuleItemService purchaseRebateRuleItemService;
    @Autowired
    private PurchaseRebateRuleSupplementService purchaseRebateRuleSupplementService;
    @Autowired
    private PurchaseRebateRuleThresholdService purchaseRebateRuleThresholdService;
    @Resource
    private SaleRebateCalculationSheetCalculateDetailMapper saleRebateCalculationSheetCalculateDetailMapper;
    @Resource
    private SaleRebateCalculationSheetRuleThresholdMapper saleRebateCalculationSheetRuleThresholdMapper;
    @Resource
    private SaleRebateCalculationSheetRuleSupplementMapper saleRebateCalculationSheetRuleSupplementMapper;
    @Autowired
    private PurchaseRebateCalculationSheetRuleThresholdService purchaseRebateCalculationSheetRuleThresholdService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleSupplementService purchaseRebateCalculationSheetRuleSupplementService;
    @Resource
    private SaleRebateCalculationSheetRegisterMapper saleRebateCalculationSheetRegisterMapper;
    @Resource
    private SaleRebateCalculationSheetRuleDetailMapper saleRebateCalculationSheetRuleDetailMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchaseRebateCalculationService purchaseRebateCalculationService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseRebateCalculationSheetVO vo, PurchaseRebateCalculationSheet sheet) {
        boolean flag;
        String rebateNumber = this.invokeBaseRpcService.getNextCode("purchaseRebateCalculationSheetNumber", (Object)vo);
        sheet.setRebateNumber(rebateNumber);
        sheet.setRebateStatus(CalculationSheetStatusEnum.NEW.getValue());
        List<PurchaseRebateCalculationSheetRuleDetail> ruleDetailList = vo.getRebateCalculationSheetRuleDetails();
        for (PurchaseRebateCalculationSheetRuleDetail ruleDetail : ruleDetailList) {
            log.info("rebate: rebateSettlementCycle " + ruleDetail.getRebateSettlementCycle() + " rebateType " + ruleDetail.getRebateType() + " pricingBasis " + ruleDetail.getPricingBasis() + "rebate: progressiveApproach " + ruleDetail.getProgressiveApproach());
        }
        sheet.setCalculateResult(CalculationRebateCalculateResultEnum.CALCULATING.getValue());
        boolean bl = flag = !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleDetails()) && !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleThresholds()) && !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleSupplements());
        if (flag) {
            sheet.setCalculateResult(CalculationRebateCalculateResultEnum.CALCULATING.getValue());
        } else {
            sheet.setCalculateResult(CalculationRebateCalculateResultEnum.NOT_CALCULATED.getValue());
        }
        ((PurchaseRebateCalculationSheetMapper)this.baseMapper).insert((Object)sheet);
        List<PurchaseRebateCalculationSheetRegister> rebateCalculationSheetRegisters = vo.getRebateCalculationSheetRegisters();
        List<PurchaseRebateCalculationSheetRuleThreshold> rebateCalculationSheetRuleThresholdList = vo.getRebateCalculationSheetRuleThresholds();
        List<PurchaseRebateCalculationSheetRuleSupplement> rebateCalculationSheetRuleSupplementList = vo.getRebateCalculationSheetRuleSupplements();
        this.insertPurchaseRebateCalculationSheetRuleDetail(sheet, vo.getRebateCalculationSheetRuleDetails());
        this.insertPurchaseRebateCalculationSheetRegister(sheet, rebateCalculationSheetRegisters);
        this.insertPurchaseRebateCalculationSheetRuleThreshold(sheet, rebateCalculationSheetRuleThresholdList);
        this.insertPurchaseRebateCalculationSheetRuleSupplement(sheet, rebateCalculationSheetRuleSupplementList);
        this.saveOrUpdate(vo, sheet);
    }

    private void insertPurchaseRebateCalculationSheetRuleSupplement(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetRuleSupplement> supplementList) {
        if (CollectionUtils.isEmpty(supplementList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateCalculationSheetRuleSupplement supplement : supplementList) {
            supplement.setId(null);
            supplement.setHeadId(sheet.getId());
            SysUtil.setSysParam((BaseEntity)supplement, (BaseEntity)sheet);
            supplement.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        this.purchaseRebateCalculationSheetRuleSupplementService.saveBatch(supplementList);
    }

    private void insertPurchaseRebateCalculationSheetRuleThreshold(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetRuleThreshold> thresholdList) {
        if (CollectionUtils.isEmpty(thresholdList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateCalculationSheetRuleThreshold threshold : thresholdList) {
            threshold.setId(null);
            threshold.setHeadId(sheet.getId());
            SysUtil.setSysParam((BaseEntity)threshold, (BaseEntity)sheet);
            threshold.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        this.purchaseRebateCalculationSheetRuleThresholdService.saveBatch(thresholdList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseRebateCalculationSheetVO vo, PurchaseRebateCalculationSheet sheet) {
        boolean flag;
        this.purchaseRebateCalculationSheetRuleDetailService.deleteByMainId(sheet.getId());
        this.purchaseRebateCalculationSheetCalculateDetailService.deleteByMainId(sheet.getId());
        this.purchaseRebateCalculationSheetRegisterService.deleteByMainId(sheet.getId());
        this.purchaseRebateCalculationSheetRuleThresholdService.deleteByMainId(sheet.getId());
        this.purchaseRebateCalculationSheetRuleSupplementService.deleteByMainId(sheet.getId());
        boolean bl = flag = !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleDetails()) && !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleThresholds()) && !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleSupplements());
        if (flag) {
            sheet.setCalculateResult(CalculationRebateCalculateResultEnum.CALCULATING.getValue());
        } else {
            sheet.setCalculateResult(CalculationRebateCalculateResultEnum.NOT_CALCULATED.getValue());
        }
        ((PurchaseRebateCalculationSheetMapper)this.baseMapper).updateById((Object)sheet);
        this.saveOrUpdate(vo, sheet);
    }

    @Override
    public void rebateRegistration(PurchaseRebateCalculationSheetVO vo, PurchaseRebateCalculationSheet sheet) {
        this.purchaseRebateCalculationSheetRegisterService.deleteByMainId(sheet.getId());
        this.insertPurchaseRebateCalculationSheetRegister(sheet, vo.getRebateCalculationSheetRegisters());
    }

    private void saveOrUpdate(PurchaseRebateCalculationSheetVO vo, PurchaseRebateCalculationSheet sheet) {
        boolean flag;
        List<PurchaseRebateCalculationSheetRuleDetail> ruleDetailList = vo.getRebateCalculationSheetRuleDetails();
        for (PurchaseRebateCalculationSheetRuleDetail ruleDetail : ruleDetailList) {
            log.info("rebate: {}, rebateSettlementCycle: {} , rebateCondition: {} , pricingBasis: {} , progressiveApproach: {}" + vo.getRebateNumber(), new Object[]{ruleDetail.getRebateSettlementCycle(), ruleDetail.getRebateCondition(), ruleDetail.getPricingBasis(), ruleDetail.getProgressiveApproach()});
        }
        this.insertPurchaseRebateCalculationSheetRuleDetail(sheet, vo.getRebateCalculationSheetRuleDetails());
        this.insertPurchaseRebateCalculationSheetRegister(sheet, vo.getRebateCalculationSheetRegisters());
        this.insertPurchaseRebateCalculationSheetRuleThreshold(sheet, vo.getRebateCalculationSheetRuleThresholds());
        this.insertPurchaseRebateCalculationSheetRuleSupplement(sheet, vo.getRebateCalculationSheetRuleSupplements());
        boolean bl = flag = !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleDetails()) && !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleThresholds()) && !CollectionUtils.isEmpty(vo.getRebateCalculationSheetRuleSupplements());
        if (flag) {
            this.purchaseRebateCalculationService.calculateAll(sheet, vo);
        }
    }

    private void insertPurchaseRebateCalculationSheetRegister(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetRegister> registerList) {
        if (CollectionUtils.isEmpty(registerList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateCalculationSheetRegister register : registerList) {
            register.setId(null);
            register.setHeadId(sheet.getId());
            SysUtil.setSysParam((BaseEntity)register, (BaseEntity)sheet);
            register.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        this.purchaseRebateCalculationSheetRegisterService.saveBatch(registerList);
    }

    private void insertPurchaseRebateCalculationSheetRuleDetail(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetRuleDetail> ruleDetailList) {
        if (CollectionUtils.isEmpty(ruleDetailList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateCalculationSheetRuleDetail ruleDetail : ruleDetailList) {
            ruleDetail.setId(null);
            ruleDetail.setHeadId(sheet.getId());
            SysUtil.setSysParam((BaseEntity)ruleDetail, (BaseEntity)sheet);
            ruleDetail.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        this.purchaseRebateCalculationSheetRuleDetailService.saveBatch(ruleDetailList);
    }

    @Override
    public void delete(String id) {
        ((PurchaseRebateCalculationSheetMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseRebateCalculationSheetCalculateDetailService.deleteByMainId(id);
        this.purchaseRebateCalculationSheetCertificateService.deleteByMainId(id);
        this.purchaseRebateCalculationSheetRegisterService.deleteByMainId(id);
        this.purchaseRebateCalculationSheetRuleDetailService.deleteByMainId(id);
        this.purchaseRebateCalculationSheetRuleThresholdService.deleteByMainId(id);
        this.purchaseRebateCalculationSheetRuleSupplementService.deleteByMainId(id);
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseRebateCalculationSheetMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseRebateCalculationSheetList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getRebateStatus())).collect(Collectors.toList());
        for (PurchaseRebateCalculationSheet calculationSheet : purchaseRebateCalculationSheetList) {
            this.pushDataToErp(calculationSheet);
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseRebateCalculationSheet", (Object)new JSONObject());
    }

    private void pushDataToErp(PurchaseRebateCalculationSheet calculationSheet) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseRebateCalculationSheet", (Object)calculationSheet);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetVO vo) {
        PurchaseRebateCalculationSheet dbCalculationSheet = (PurchaseRebateCalculationSheet)((Object)this.getById((Serializable)((Object)sheet.getId())));
        if (dbCalculationSheet != null) {
            boolean flag;
            boolean bl = flag = CalculationSheetStatusEnum.UNCONFIRMED.getValue().equals(dbCalculationSheet.getRebateStatus()) || CalculationSheetStatusEnum.CONFIRMED.getValue().equals(dbCalculationSheet.getRebateStatus()) && SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(dbCalculationSheet.getTeamwork());
            if (flag) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
            }
        }
        String calculateResult = sheet.getCalculateResult();
        if (!CalculationRebateCalculateResultEnum.CALCULATED_SUCCESS.getValue().equals(calculateResult)) {
            throw new ELSBootException("\u8fd4\u5229\u5355\u8ba1\u7b97\u6210\u529f\u624d\u53ef\u53d1\u5e03");
        }
        BigDecimal rebateAmount = sheet.getRebateAmount();
        BigDecimal rebateQuantity = sheet.getRebateQuantity();
        if (!(rebateAmount != null && BigDecimal.ZERO.compareTo(rebateAmount) != 0 || rebateQuantity != null && BigDecimal.ZERO.compareTo(rebateQuantity) != 0)) {
            throw new ELSBootException("\u8fd4\u5229\u91d1\u989d/\u8fd4\u5229\u6570\u91cf=0\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u8fd4\u5229\u8ba1\u7b97\u5355");
        }
        Boolean flag = false;
        if (CalculationSheetStatusEnum.RENTURNED.getValue().equals(sheet.getRebateStatus()) && StringUtils.isNotBlank((CharSequence)sheet.getRelationId())) {
            flag = true;
        }
        if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(sheet.getTeamwork())) {
            sheet.setRebateStatus(CalculationSheetStatusEnum.CONFIRMED.getValue());
        } else {
            sheet.setRebateStatus(CalculationSheetStatusEnum.UNCONFIRMED.getValue());
        }
        this.updateById((Object)sheet);
        String relationId = sheet.getRelationId();
        SaleRebateCalculationSheet saleRebateCalculationSheet = new SaleRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)sheet), (Object)((Object)saleRebateCalculationSheet));
        saleRebateCalculationSheet.setToElsAccount(sheet.getElsAccount());
        saleRebateCalculationSheet.setElsAccount(sheet.getToElsAccount());
        saleRebateCalculationSheet.setBusAccount(sheet.getElsAccount());
        saleRebateCalculationSheet.setRelationId(sheet.getId());
        if (flag.booleanValue()) {
            saleRebateCalculationSheet.setId(relationId);
            saleRebateCalculationSheet.setRebateStatus(sheet.getRebateStatus());
            this.saleRebateCalculationSheetMapper.updateById((Object)saleRebateCalculationSheet);
            this.handleDetail(saleRebateCalculationSheet, vo);
        } else {
            saleRebateCalculationSheet.setId(null);
            this.saleRebateCalculationSheetMapper.insert((Object)saleRebateCalculationSheet);
            sheet.setRelationId(saleRebateCalculationSheet.getId());
            ((PurchaseRebateCalculationSheetMapper)this.baseMapper).updateById((Object)sheet);
            this.handleDetail(saleRebateCalculationSheet, vo);
        }
        this.sendMessage(sheet, saleRebateCalculationSheet);
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    @Override
    public PurchaseRebateCalculationSheetVO extractRule(PurchaseRebateCalculationSheetVO vo) {
        PurchaseRebateCalculationSheetVO resultVo = new PurchaseRebateCalculationSheetVO();
        List<PurchaseRebateRuleItemVO> itemList = this.purchaseRebateRuleItemService.extractRule(vo);
        List<PurchaseRebateCalculationSheetRuleDetail> detailList = this.getPurchaseRebateCalculationSheetRuleDetails(vo, itemList);
        resultVo.setRebateCalculationSheetRuleDetails(detailList);
        List<PurchaseRebateCalculationSheetRuleThreshold> thresholdList = this.getPurchaseRebateCalculationSheetRuleThresholds(vo);
        resultVo.setRebateCalculationSheetRuleThresholds(thresholdList);
        List<PurchaseRebateCalculationSheetRuleSupplement> supplementList = this.getPurchaseRebateCalculationSheetRuleSupplements(vo);
        resultVo.setRebateCalculationSheetRuleSupplements(supplementList);
        return resultVo;
    }

    private List<PurchaseRebateCalculationSheetRuleSupplement> getPurchaseRebateCalculationSheetRuleSupplements(PurchaseRebateCalculationSheetVO vo) {
        List<PurchaseRebateSupplementVO> supplementVOList = this.purchaseRebateRuleSupplementService.extract(vo);
        ArrayList<PurchaseRebateCalculationSheetRuleSupplement> supplementList = new ArrayList<PurchaseRebateCalculationSheetRuleSupplement>();
        if (!CollectionUtils.isEmpty(supplementVOList)) {
            for (PurchaseRebateSupplementVO supplementVO : supplementVOList) {
                PurchaseRebateCalculationSheetRuleSupplement supplement = new PurchaseRebateCalculationSheetRuleSupplement();
                BeanUtils.copyProperties((Object)((Object)supplementVO), (Object)((Object)supplement));
                supplementList.add(supplement);
            }
        }
        return supplementList;
    }

    private List<PurchaseRebateCalculationSheetRuleThreshold> getPurchaseRebateCalculationSheetRuleThresholds(PurchaseRebateCalculationSheetVO vo) {
        List<PurchaseRebateThresholdVO> thresholdVOList = this.purchaseRebateRuleThresholdService.extract(vo);
        ArrayList<PurchaseRebateCalculationSheetRuleThreshold> thresholdList = new ArrayList<PurchaseRebateCalculationSheetRuleThreshold>();
        if (!CollectionUtils.isEmpty(thresholdVOList)) {
            for (PurchaseRebateThresholdVO thresholdVO : thresholdVOList) {
                PurchaseRebateCalculationSheetRuleThreshold threshold = new PurchaseRebateCalculationSheetRuleThreshold();
                BeanUtils.copyProperties((Object)((Object)thresholdVO), (Object)((Object)threshold));
                thresholdList.add(threshold);
            }
        }
        return thresholdList;
    }

    private List<PurchaseRebateCalculationSheetRuleDetail> getPurchaseRebateCalculationSheetRuleDetails(PurchaseRebateCalculationSheetVO vo, List<PurchaseRebateRuleItemVO> itemList) {
        ArrayList<PurchaseRebateCalculationSheetRuleDetail> detailList = new ArrayList<PurchaseRebateCalculationSheetRuleDetail>();
        for (PurchaseRebateRuleItemVO itemVO : itemList) {
            long l;
            Date beginDay3;
            DateTime lastTime;
            PurchaseRebateCalculationSheetRuleDetail detail = new PurchaseRebateCalculationSheetRuleDetail();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int day = calendar.get(5);
            Integer settlementDate = Integer.valueOf(itemVO.getSettlementDate());
            String rebateSettlementCycle = itemVO.getRebateSettlementCycle();
            Date date = new Date();
            long currentEndDateTime = date.getTime();
            long beginDateTime = vo.getBeginDate().getTime();
            long endDateTime = vo.getEndDate().getTime();
            if (RebateRuleSettlementCycleEnum.YEAR.getValue().equals(rebateSettlementCycle)) {
                DateTime dateTime = DateUtil.beginOfYear((Date)date);
                lastTime = DateUtil.offset((Date)dateTime, (DateField)DateField.MONTH, (int)-12);
                beginDay3 = lastTime.toJdkDate();
                l = beginDay3.getTime();
            } else if (RebateRuleSettlementCycleEnum.HALF_YEAR.getValue().equals(rebateSettlementCycle)) {
                DateTime dateTime = DateUtil.offset((Date)date, (DateField)DateField.MONTH, (int)-6);
                Date beginDay2 = dateTime.toJdkDate();
                long beginDay3 = beginDay2.getTime();
            } else if (RebateRuleSettlementCycleEnum.QUARTER.getValue().equals(rebateSettlementCycle)) {
                DateTime dateTime = DateUtil.beginOfQuarter((Date)date);
                lastTime = DateUtil.offset((Date)dateTime, (DateField)DateField.MONTH, (int)-3);
                beginDay3 = lastTime.toJdkDate();
                l = beginDay3.getTime();
            } else if (RebateRuleSettlementCycleEnum.MONTH.getValue().equals(rebateSettlementCycle) && day < settlementDate) continue;
            boolean flag = this.handleProduct(vo.getRebateProduct(), itemVO.getRebateProduct());
            if (flag) continue;
            BeanUtils.copyProperties((Object)((Object)itemVO), (Object)((Object)detail));
            detail.setRuleItemNumber(itemVO.getItemNumber());
            detail.setItemNumber(null);
            detailList.add(detail);
        }
        return detailList;
    }

    private boolean handleOther(String sheet, String rule) {
        HashSet sheets = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)sheet)) {
            sheets = Sets.newHashSet((Object[])sheet.split(","));
        }
        if (CollectionUtils.isEmpty(sheets)) {
            return false;
        }
        HashSet rules = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)rule)) {
            rules = Sets.newHashSet((Object[])rule.split(","));
        }
        return !sheets.contains(rules);
    }

    private boolean handleProduct(String sheetProduct, String ruleProduct) {
        HashSet sheetProducts = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)sheetProduct)) {
            sheetProducts = Sets.newHashSet((Object[])sheetProduct.split(","));
        }
        if (CollectionUtils.isEmpty(sheetProducts)) {
            return false;
        }
        HashSet ruleProducts = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)ruleProduct)) {
            ruleProducts = Sets.newHashSet((Object[])ruleProduct.split(","));
        }
        boolean productFlag = ruleProducts.containsAll(sheetProducts) && sheetProducts.containsAll(ruleProducts);
        return !productFlag;
    }

    @Override
    public void cancellation(String id) {
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetMapper.selectById((Serializable)((Object)id)));
        purchaseRebateCalculationSheet.setRebateStatus(CalculationSheetStatusEnum.CANCEL.getValue());
        this.purchaseRebateCalculationSheetMapper.updateById((Object)purchaseRebateCalculationSheet);
        SaleRebateCalculationSheet saleRebateCalculationSheet = (SaleRebateCalculationSheet)((Object)this.saleRebateCalculationSheetMapper.selectById((Serializable)((Object)purchaseRebateCalculationSheet.getRelationId())));
        saleRebateCalculationSheet.setRebateStatus(CalculationSheetStatusEnum.CANCEL.getValue());
        this.saleRebateCalculationSheetMapper.updateById((Object)saleRebateCalculationSheet);
        super.sendMessage(purchaseRebateCalculationSheet.getElsAccount(), "purchaseRebateCalculationSheet", "cancel", purchaseRebateCalculationSheet.getId(), "rebateCalculationSheetBusDataServiceImpl", Arrays.asList(purchaseRebateCalculationSheet.getToElsAccount()));
    }

    @Override
    public void archive(String id) {
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = (PurchaseRebateCalculationSheet)((Object)((PurchaseRebateCalculationSheetMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (purchaseRebateCalculationSheet == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tFxMK_c4afc444", (String)"\u5355\u636e\u4e0d\u5b58\u5728"));
        }
        if (!CalculationSheetStatusEnum.CONFIRMED.getValue().equals(purchaseRebateCalculationSheet.getRebateStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IRLjtFnOLA_75a5b1f6", (String)"\u5df2\u786e\u8ba4\u7684\u5355\u636e\u624d\u80fd\u5f52\u6863"));
        }
        purchaseRebateCalculationSheet.setRebateStatus(CalculationSheetStatusEnum.ARCHIVED.getValue());
        ((PurchaseRebateCalculationSheetMapper)this.baseMapper).updateById((Object)purchaseRebateCalculationSheet);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copyData(String id) {
        PurchaseRebateCalculationSheet calculationSheet = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetMapper.selectById((Serializable)((Object)id)));
        calculationSheet.setId(null);
        calculationSheet.setBeginDate(null);
        calculationSheet.setEndDate(null);
        calculationSheet.setRebateAmount(null);
        calculationSheet.setConfirmAmount(null);
        calculationSheet.setReceivedAmount(null);
        calculationSheet.setOutstandingAmount(null);
        calculationSheet.setRebateQuantity(null);
        calculationSheet.setAuditStatus(null);
        calculationSheet.setCalculateResult(null);
        calculationSheet.setFlowId(null);
        calculationSheet.setCreateBy(null);
        calculationSheet.setCreateTime(null);
        calculationSheet.setCreateById(null);
        calculationSheet.setUpdateBy(null);
        calculationSheet.setUpdateTime(null);
        calculationSheet.setUpdateById(null);
        String nextCode = this.invokeBaseRpcService.getNextCode("purchaseRebateCalculationSheetNumber", (Object)calculationSheet);
        calculationSheet.setRebateNumber(nextCode);
        calculationSheet.setRebateStatus(CalculationSheetStatusEnum.NEW.getValue());
        this.purchaseRebateCalculationSheetMapper.insert((Object)calculationSheet);
        List<PurchaseRebateCalculationSheetRuleThreshold> thresholds = this.purchaseRebateCalculationSheetRuleThresholdService.selectByMainId(id);
        for (PurchaseRebateCalculationSheetRuleThreshold purchaseRebateCalculationSheetRuleThreshold : thresholds) {
            purchaseRebateCalculationSheetRuleThreshold.setHeadId(calculationSheet.getId());
            purchaseRebateCalculationSheetRuleThreshold.setId(null);
        }
        List<PurchaseRebateCalculationSheetRuleDetail> details = this.purchaseRebateCalculationSheetRuleDetailService.selectByMainId(id);
        for (PurchaseRebateCalculationSheetRuleDetail detail : details) {
            detail.setHeadId(calculationSheet.getId());
            detail.setId(null);
        }
        List<PurchaseRebateCalculationSheetRuleSupplement> list = this.purchaseRebateCalculationSheetRuleSupplementService.selectByMainId(id);
        for (PurchaseRebateCalculationSheetRuleSupplement supplement : list) {
            supplement.setHeadId(calculationSheet.getId());
            supplement.setId(null);
        }
        if (!CollectionUtils.isEmpty(thresholds)) {
            this.purchaseRebateCalculationSheetRuleThresholdService.saveBatch(thresholds);
        }
        if (!CollectionUtils.isEmpty(details)) {
            this.purchaseRebateCalculationSheetRuleDetailService.saveBatch(details);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.purchaseRebateCalculationSheetRuleSupplementService.saveBatch(list);
        }
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = (PurchaseRebateCalculationSheet)((Object)this.getById((Serializable)((Object)id)));
        PurchaseRebateCalculationSheetVO headVO = (PurchaseRebateCalculationSheetVO)((Object)BeanUtil.copyProperties((Object)((Object)purchaseRebateCalculationSheet), PurchaseRebateCalculationSheetVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    public void handleDetail(SaleRebateCalculationSheet sheet, PurchaseRebateCalculationSheetVO vo) {
        String id = sheet.getId();
        this.saleRebateCalculationSheetCalculateDetailMapper.deleteByMainId(id);
        this.saleRebateCalculationSheetRegisterMapper.deleteByMainId(id);
        this.saleRebateCalculationSheetRuleDetailMapper.deleteByMainId(id);
        this.saleRebateCalculationSheetRuleThresholdMapper.deleteByMainId(id);
        this.saleRebateCalculationSheetRuleSupplementMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        this.handleSaleRebateCalculationSheetCalculateDetail(sheet, vo.getRebateCalculationSheetCalculateDetails());
        this.handleSaleRebateCalculationSheetRegister(sheet, vo.getRebateCalculationSheetRegisters());
        this.handleSaleRebateCalculationSheetRuleDetail(sheet, vo.getRebateCalculationSheetRuleDetails());
        this.handleSaleRebateCalculationSheetThreshold(sheet, vo.getRebateCalculationSheetRuleThresholds());
        this.handleSaleRebateCalculationSheetRuleSupplement(sheet, vo.getRebateCalculationSheetRuleSupplements());
        this.handleSaleAttachmentDetail(sheet, vo.getAttachments());
    }

    private void handleSaleRebateCalculationSheetThreshold(SaleRebateCalculationSheet saleSheet, List<PurchaseRebateCalculationSheetRuleThreshold> thresholdList) {
        if (CollectionUtils.isEmpty(thresholdList)) {
            return;
        }
        ArrayList<SaleRebateCalculationSheetRuleThreshold> saleRebateCalculationSheetRegisterList = new ArrayList<SaleRebateCalculationSheetRuleThreshold>();
        for (PurchaseRebateCalculationSheetRuleThreshold threshold : thresholdList) {
            SaleRebateCalculationSheetRuleThreshold saleThreshold = new SaleRebateCalculationSheetRuleThreshold();
            BeanUtils.copyProperties((Object)((Object)threshold), (Object)((Object)saleThreshold));
            saleThreshold.setId(null);
            saleThreshold.setElsAccount(saleSheet.getElsAccount());
            saleThreshold.setToElsAccount(saleSheet.getToElsAccount());
            saleThreshold.setBusAccount(saleSheet.getBusAccount());
            saleThreshold.setHeadId(saleSheet.getId());
            saleThreshold.setRelationId(threshold.getId());
            saleRebateCalculationSheetRegisterList.add(saleThreshold);
        }
        this.saleRebateCalculationSheetRuleThresholdMapper.insertBatchSomeColumn(saleRebateCalculationSheetRegisterList);
    }

    private void handleSaleRebateCalculationSheetRuleSupplement(SaleRebateCalculationSheet saleSheet, List<PurchaseRebateCalculationSheetRuleSupplement> supplementList) {
        if (CollectionUtils.isEmpty(supplementList)) {
            return;
        }
        ArrayList<SaleRebateCalculationSheetRuleSupplement> saleRebateCalculationSheetRuleSupplementList = new ArrayList<SaleRebateCalculationSheetRuleSupplement>();
        for (PurchaseRebateCalculationSheetRuleSupplement supplement : supplementList) {
            SaleRebateCalculationSheetRuleSupplement saleSupplement = new SaleRebateCalculationSheetRuleSupplement();
            BeanUtils.copyProperties((Object)((Object)supplement), (Object)((Object)saleSupplement));
            saleSupplement.setId(null);
            saleSupplement.setElsAccount(saleSheet.getElsAccount());
            saleSupplement.setToElsAccount(saleSheet.getToElsAccount());
            saleSupplement.setBusAccount(saleSheet.getBusAccount());
            saleSupplement.setHeadId(saleSheet.getId());
            saleSupplement.setRelationId(supplement.getId());
            saleRebateCalculationSheetRuleSupplementList.add(saleSupplement);
        }
        this.saleRebateCalculationSheetRuleSupplementMapper.insertBatchSomeColumn(saleRebateCalculationSheetRuleSupplementList);
    }

    private void handleSaleAttachmentDetail(SaleRebateCalculationSheet saleSheet, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleSheet.getElsAccount());
            saleAttachment.setHeadId(saleSheet.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void handleSaleRebateCalculationSheetRuleDetail(SaleRebateCalculationSheet saleSheet, List<PurchaseRebateCalculationSheetRuleDetail> ruleDetailList) {
        if (CollectionUtils.isEmpty(ruleDetailList)) {
            return;
        }
        ArrayList<SaleRebateCalculationSheetRuleDetail> saleRebateCalculationSheetRuleDetailList = new ArrayList<SaleRebateCalculationSheetRuleDetail>();
        for (PurchaseRebateCalculationSheetRuleDetail detail : ruleDetailList) {
            SaleRebateCalculationSheetRuleDetail saleDetail = new SaleRebateCalculationSheetRuleDetail();
            BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)saleDetail));
            saleDetail.setId(null);
            saleDetail.setElsAccount(saleSheet.getElsAccount());
            saleDetail.setToElsAccount(saleSheet.getToElsAccount());
            saleDetail.setBusAccount(saleSheet.getBusAccount());
            saleDetail.setHeadId(saleSheet.getId());
            saleDetail.setRelationId(detail.getId());
            saleRebateCalculationSheetRuleDetailList.add(saleDetail);
        }
        this.saleRebateCalculationSheetRuleDetailMapper.insertBatchSomeColumn(saleRebateCalculationSheetRuleDetailList);
    }

    private void handleSaleRebateCalculationSheetRegister(SaleRebateCalculationSheet saleSheet, List<PurchaseRebateCalculationSheetRegister> registerList) {
        if (CollectionUtils.isEmpty(registerList)) {
            return;
        }
        ArrayList<SaleRebateCalculationSheetRegister> saleRebateCalculationSheetRegisterList = new ArrayList<SaleRebateCalculationSheetRegister>();
        for (PurchaseRebateCalculationSheetRegister register : registerList) {
            SaleRebateCalculationSheetRegister saleRegister = new SaleRebateCalculationSheetRegister();
            BeanUtils.copyProperties((Object)((Object)register), (Object)((Object)saleRegister));
            saleRegister.setId(null);
            saleRegister.setElsAccount(saleSheet.getElsAccount());
            saleRegister.setToElsAccount(saleSheet.getToElsAccount());
            saleRegister.setBusAccount(saleSheet.getBusAccount());
            saleRegister.setHeadId(saleSheet.getId());
            saleRegister.setRelationId(register.getId());
            saleRebateCalculationSheetRegisterList.add(saleRegister);
        }
        this.saleRebateCalculationSheetRegisterMapper.insertBatchSomeColumn(saleRebateCalculationSheetRegisterList);
    }

    private void handleSaleRebateCalculationSheetCalculateDetail(SaleRebateCalculationSheet saleSheet, List<PurchaseRebateCalculationSheetCalculateDetail> calculateDetailList) {
        if (CollectionUtils.isEmpty(calculateDetailList)) {
            return;
        }
        ArrayList<SaleRebateCalculationSheetCalculateDetail> saleRebateCalculationSheetCalculateDetailList = new ArrayList<SaleRebateCalculationSheetCalculateDetail>();
        for (PurchaseRebateCalculationSheetCalculateDetail detail : calculateDetailList) {
            SaleRebateCalculationSheetCalculateDetail saleDetail = new SaleRebateCalculationSheetCalculateDetail();
            BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)saleDetail));
            saleDetail.setId(null);
            saleDetail.setElsAccount(saleSheet.getElsAccount());
            saleDetail.setToElsAccount(saleSheet.getToElsAccount());
            saleDetail.setBusAccount(saleSheet.getBusAccount());
            saleDetail.setHeadId(saleSheet.getId());
            saleDetail.setRelationId(detail.getId());
            saleRebateCalculationSheetCalculateDetailList.add(saleDetail);
        }
        this.saleRebateCalculationSheetCalculateDetailMapper.insertBatchSomeColumn(saleRebateCalculationSheetCalculateDetailList);
    }

    private void sendMessage(PurchaseRebateCalculationSheet sheet, SaleRebateCalculationSheet saleSheet) {
        String url = "id=" + saleSheet.getId() + "&toElsAccount" + saleSheet.getToElsAccount();
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(sheet.getToElsAccount(), "1001");
        String token = JwtUtil.getOutToken((String)(elsSubAccount.getElsAccount() + "_" + elsSubAccount.getSubAccount()), (String)elsSubAccount.getPassword());
        saleSheet.setFbk7(serviceAddress + "/els/finance/saleRebateRule/emailConfirmOrRefuesd?token=" + token + "&operation=confirm&id=" + saleSheet.getId());
        saleSheet.setFbk8(serviceAddress + "/els/finance/saleRebateRule/emailConfirmOrRefuesd?token=" + token + "&operation=refused&id=" + saleSheet.getId());
        super.sendMessage(sheet.getElsAccount(), "purchaseRebateCalculationSheet", "publish", sheet.getId(), "rebateCalculationSheetBusDataServiceImpl", Arrays.asList(sheet.getToElsAccount()));
    }
}

