/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ElsStatusLog;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsStatusLogDTO;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.excel.PurchasePerformanceReconciliationExportServiceImpl;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseRecContractAcceptanceService;
import com.els.modules.reconciliation.service.PurchaseRecContractPromiseService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceHookVO;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/reconciliation/purchasePerformanceReconciliation"})
public class PurchasePerformanceReconciliationController
extends BaseController<PurchasePerformanceReconciliation, PurchasePerformanceReconciliationService> {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReconciliationController.class);
    @Autowired
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Autowired
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Autowired
    private PurchaseRecContractPromiseService purchaseRecContractPromiseService;
    @Autowired
    private PurchaseRecContractAcceptanceService purchaseRecContractAcceptanceService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsPurchaseStatisticsSourceCaseService elsPurchaseStatisticsSourceCaseService;
    @Autowired
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    private static final String LOCK_KEY = "srm_performance_reconciliation_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:list"})
    public Result<?> queryPageList(PurchasePerformanceReconciliation purchasePerformanceReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePerformanceReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Result.ok((Object)pageList);
        }
        this.elsPurchaseStatisticsSourceCaseService.handlePurchasePerformanceReconciliationStatisticsInfo(records);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:add"})
    @FormCommit
    public Result<?> add(@RequestBody PurchasePerformanceReconciliationVO vo) {
        PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        this.purchasePerformanceReconciliationService.saveMain(purchaseReconciliation, vo);
        return Result.ok((Object)((Object)purchaseReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:edit"})
    public Result<?> edit(@RequestBody PurchasePerformanceReconciliationVO vo) {
        PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePerformanceReconciliationService.updateMain(purchaseReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchasePerformanceReconciliationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchasePerformanceReconciliationVO vo = new PurchasePerformanceReconciliationVO();
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)((Object)vo));
        vo.setRecContractPromiseList(this.purchaseRecContractPromiseService.selectByMainId(id));
        vo.setRecContractAcceptanceList(this.purchaseRecContractAcceptanceService.selectByMainId(id));
        vo.setRecChargeList(this.purchaseRecChargeService.selectByMainId(id));
        vo.setInvoiceList(this.purchaseInvoiceService.selectByMainId(id));
        vo.setAttachments(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id));
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id);
        this.elsPurchaseStatisticsWriteOffService.handlePrePaymentWriteOffList(prePaymentWriteOffList, purchasePerformanceReconciliation.getReconciliationNumber());
        vo.setPrePaymentWriteOffList(prePaymentWriteOffList);
        vo.setElsStatusLogList(this.listStatusLog(id, "srmReconciliationStatus"));
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u5bf9\u8d26-\u63d0\u53d6\u5bf9\u8d26\u5355", logType=2)
    @ApiOperation(value="\u63d0\u53d6\u5bf9\u8d26\u5355", notes="\u63d0\u53d6\u5bf9\u8d26\u5355")
    @PostMapping(value={"/extractReconciliation"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:extractReconciliation"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchasePerformanceReconciliationService.class)
    public Result<?> extractReconciliation(@RequestBody PurchasePerformanceReconciliationVO vo) {
        PurchasePerformanceReconciliationVO purchasePerformanceReconciliationVO = this.purchasePerformanceReconciliationService.extractReconciliation(vo);
        return Result.ok((Object)((Object)purchasePerformanceReconciliationVO));
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:publish"})
    public Result<?> publish(@RequestBody PurchasePerformanceReconciliationVO vo) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchasePerformanceReconciliation));
        Result result = new Result();
        if (!this.redisUtil.tryGetDistributedLock("supplier_performanceReconciliation_", purchasePerformanceReconciliation.getToElsAccount(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AvjDiKUmRdXIeVRSsK_72c19add", (String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4e0e\u6b64\u4f9b\u5e94\u5546\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01"));
        }
        try {
            result = this.purchasePerformanceReconciliationService.publish(purchasePerformanceReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock("supplier_performanceReconciliation_", purchasePerformanceReconciliation.getToElsAccount());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u7968\u62d2\u7edd", logType=2)
    @ApiOperation(value="\u53d1\u7968\u62d2\u7edd", notes="\u53d1\u7968\u62d2\u7edd")
    @PostMapping(value={"/invoiceRefused"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:invoiceRefused"})
    public Result<?> invoicerefused(@RequestBody PurchasePerformanceReconciliationVO vo) {
        Result result = new Result();
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchasePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchasePerformanceReconciliationService.invoiceRefusedOrConfirm(purchasePerformanceReconciliation, vo.getInvoiceList(), OperationEnum.REFUSED.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u7968\u786e\u8ba4", logType=2)
    @ApiOperation(value="\u53d1\u7968\u786e\u8ba4", notes="\u53d1\u7968\u786e\u8ba4")
    @PostMapping(value={"/invoiceConfirmed"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:invoiceConfirmed"})
    @PermissionDataOpt(businessType="performanceReconciliation", beanClass=PurchasePerformanceReconciliationService.class)
    public Result<?> invoiceConfirmed(@RequestBody PurchasePerformanceReconciliationVO vo) {
        Result result = new Result();
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchasePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchasePerformanceReconciliationService.invoiceRefusedOrConfirm(purchasePerformanceReconciliation, vo.getInvoiceList(), OperationEnum.CONFIRM.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u7968\u62d2\u7edd", logType=2)
    @ApiOperation(value="\u52fe\u7a3d\u786e\u8ba4", notes="\u52fe\u7a3d\u786e\u8ba4")
    @PostMapping(value={"/hookConfirm"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:hookConfirm"})
    public Result<?> hookConfirm(@RequestBody PurchaseReconciliationVO vo) {
        Result result = new Result();
        PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchasePerformanceReconciliationService.hookConfirm(purchaseReconciliation, vo.getInvoiceList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u5bf9\u8d26\u5355\u786e\u8ba4", logType=2)
    @ApiOperation(value="\u5bf9\u8d26\u5355\u786e\u8ba4", notes="\u5bf9\u8d26\u5355\u786e\u8ba4")
    @PostMapping(value={"/confirmed"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:confirmed"})
    @PermissionDataOpt(businessType="performanceReconciliation", beanClass=PurchasePerformanceReconciliationService.class)
    public Result<?> confirmed(@RequestBody PurchasePerformanceReconciliationVO vo) {
        Result result = new Result();
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchasePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchasePerformanceReconciliationService.refusedOrConfirm(purchasePerformanceReconciliation, OperationEnum.CONFIRM.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u5bf9\u8d26\u5355\u62d2\u7edd", logType=2)
    @ApiOperation(value="\u5bf9\u8d26\u5355\u62d2\u7edd", notes="\u5bf9\u8d26\u5355\u62d2\u7edd")
    @PostMapping(value={"/refused"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:refused"})
    public Result<?> refused(@RequestBody PurchasePerformanceReconciliationVO vo) {
        Result result = new Result();
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchasePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchasePerformanceReconciliationService.refusedOrConfirm(purchasePerformanceReconciliation, OperationEnum.REFUSED.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:cancellation"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchasePerformanceReconciliationService.class)
    public Result<?> cancellation(@RequestParam(name="id", required=true) String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePerformanceReconciliationService.cancellation(id);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(4);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchasePerformanceReconciliationExportServiceImpl.class);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u5934-\u53d1\u7968\u4fdd\u5b58", logType=2)
    @ApiOperation(value="\u53d1\u7968\u4fdd\u5b58", notes="\u53d1\u7968\u4fdd\u5b58")
    @PostMapping(value={"/saveInvoice"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:saveInvoice"})
    public Result<?> saveInvoice(@RequestBody PurchasePerformanceReconciliationVO vo) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchasePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePerformanceReconciliationService.saveInvoice(purchasePerformanceReconciliation, vo.getInvoiceList(), "save");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return Result.ok((Object)((Object)purchasePerformanceReconciliation));
    }

    private List<ElsStatusLog> listStatusLog(String id, String dictCode) {
        List list = this.invokeBaseRpcService.listStatusLog(id);
        ArrayList<ElsStatusLog> objects = new ArrayList<ElsStatusLog>();
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode(dictCode, TenantContext.getTenant());
        if (!CollectionUtils.isEmpty((Collection)srmReconciliationStatus)) {
            Map collect = srmReconciliationStatus.parallelStream().collect(Collectors.toMap(DictDTO::getValue, Function.identity()));
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (ElsStatusLogDTO elsStatusLog : list) {
                    if (!collect.containsKey(elsStatusLog.getBusinessStatus())) continue;
                    DictDTO dictDTO = (DictDTO)collect.get(elsStatusLog.getBusinessStatus());
                    elsStatusLog.setBusinessStatus_dictText(I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText()));
                }
            }
            HashMap collect1 = CollectionUtils.isEmpty((Collection)list) ? new HashMap() : list.parallelStream().collect(Collectors.toMap(ElsStatusLogDTO::getBusinessStatus, Function.identity(), (Key1, key2) -> key2));
            for (DictDTO dict : srmReconciliationStatus) {
                if (collect1.containsKey(dict.getValue())) {
                    objects.add((ElsStatusLog)SysUtil.copyProperties(collect1.get(dict.getValue()), ElsStatusLog.class));
                    continue;
                }
                objects.add(new ElsStatusLog().setBusinessType("reconciliation").setBusinessId(id).setBusinessStatus(dict.getValue()).setBusinessStatus_dictText(I18nUtil.translate((String)dict.getTextI18nKey(), (String)dict.getText())));
            }
        }
        return objects;
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:list"})
    public Result<?> counts(PurchasePerformanceReconciliation purchasePerformanceReconciliation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceReconciliation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((PurchasePerformanceReconciliationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchasePerformanceReconciliation::getStatus, PurchasePerformanceReconciliation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("reconciliationBillStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @AutoLog(value="\u52fe\u7a3d", logType=2)
    @ApiOperation(value="\u52fe\u7a3d", notes="\u52fe\u7a3d")
    @PostMapping(value={"/hook"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:hook"})
    public Result<?> hook(@RequestBody PurchaseInvoiceHookVO vo) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseInvoiceHookInformationService.hook(vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryReconciliationItemList"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:queryReconciliationItemList"})
    public Result<?> queryReconciliationItemList(PurchasePerformanceReconciliation purchaseReconciliation) {
        JSONObject jsonObject = JSONObject.parseObject((String)purchaseReconciliation.getId());
        String id = jsonObject.getString("id");
        PurchasePerformanceReconciliationVO purchaseReconciliationVO = this.purchasePerformanceReconciliationService.queryReconciliationItemList(purchaseReconciliation, id);
        return Result.ok((Object)((Object)purchaseReconciliationVO));
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchasePerformanceReconciliationService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchasePerformanceReconciliationService.pushDataToErp(ids);
        return Result.ok();
    }

    @SrmValidated
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copyData"})
    @RequiresPermissions(value={"reconciliation#purchasePerformanceReconciliation:copy"})
    public Result<?> copyData(@RequestParam(name="id", required=true) String id) {
        this.purchasePerformanceReconciliationService.copyData(id);
        return this.commonSuccessResult(3);
    }
}

