/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.SalePerformanceReconciliationService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleRecContractAcceptanceService;
import com.els.modules.reconciliation.service.SaleRecContractPromiseService;
import com.els.modules.reconciliation.vo.SalePerformanceReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/reconciliation/salePerformanceReconciliation"})
public class SalePerformanceReconciliationController
extends BaseController<SalePerformanceReconciliation, SalePerformanceReconciliationService> {
    private static final Logger log = LoggerFactory.getLogger(SalePerformanceReconciliationController.class);
    @Autowired
    private SalePerformanceReconciliationService salePerformanceReconciliationService;
    @Autowired
    private SaleRecChargeService saleRecChargeService;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleRecContractPromiseService saleRecContractPromiseService;
    @Autowired
    private SaleRecContractAcceptanceService saleRecContractAcceptanceService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_salePerformanceReconciliation_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:list"})
    public Result<?> queryPageList(SalePerformanceReconciliation salePerformanceReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)salePerformanceReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.salePerformanceReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:add"})
    @FormCommit
    public Result<?> add(@RequestBody SalePerformanceReconciliationVO vo) {
        SalePerformanceReconciliation saleReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        this.salePerformanceReconciliationService.saveMain(saleReconciliation, vo);
        return Result.ok((Object)((Object)saleReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:edit"})
    public Result<?> edit(@RequestBody SalePerformanceReconciliationVO vo) {
        SalePerformanceReconciliation saleReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.salePerformanceReconciliationService.updateMain(saleReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.salePerformanceReconciliationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SalePerformanceReconciliationVO vo = new SalePerformanceReconciliationVO();
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (salePerformanceReconciliation == null) {
            return Result.ok((Object)((Object)vo));
        }
        BeanUtils.copyProperties((Object)((Object)salePerformanceReconciliation), (Object)((Object)vo));
        vo.setRecContractPromiseList(this.saleRecContractPromiseService.selectByMainId(id));
        vo.setRecContractAcceptanceList(this.saleRecContractAcceptanceService.selectByMainId(id));
        vo.setRecChargeList(this.saleRecChargeService.selectByMainId(id));
        vo.setInvoiceList(this.saleInvoiceService.selectByMainId(id));
        vo.setAttachments(this.invokeBaseRpcService.selectSaleAttachmentByMainId(id));
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = this.salePrePaymentWriteOffReconciliationService.selectByMainId(id);
        this.elsPurchaseStatisticsWriteOffService.handleSalePrePaymentWriteOffList(salePrePaymentWriteOffList);
        vo.setPrePaymentWriteOffList(salePrePaymentWriteOffList);
        return Result.ok((Object)((Object)vo));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u9500\u552e\u786e\u8ba4")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4", notes="\u9500\u552e\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:confirm"})
    public Result<?> confirm(@RequestBody SalePerformanceReconciliationVO vo) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)salePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.salePerformanceReconciliationService.confirmOrRefused(salePerformanceReconciliation, "confirm");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(4);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u53d1\u7968\u4fdd\u5b58", logType=2)
    @ApiOperation(value="\u53d1\u7968\u4fdd\u5b58", notes="\u53d1\u7968\u4fdd\u5b58")
    @PostMapping(value={"/saveInvoice"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:saveInvoice"})
    public Result<?> saveInvoice(@RequestBody SalePerformanceReconciliationVO vo) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)salePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.salePerformanceReconciliationService.saveInvoice(salePerformanceReconciliation, vo.getInvoiceList(), "save");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return Result.ok((Object)((Object)salePerformanceReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u53d1\u7968\u53d1\u9001", logType=2)
    @ApiOperation(value="\u53d1\u7968\u53d1\u9001", notes="\u53d1\u7968\u53d1\u9001")
    @PostMapping(value={"/sendInvoice"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:sendInvoice"})
    public Result<?> sendInvoice(@RequestBody SalePerformanceReconciliationVO vo) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)salePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.salePerformanceReconciliationService.sendInvoice(salePerformanceReconciliation, vo.getInvoiceList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return Result.ok((Object)((Object)salePerformanceReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u9500\u552e\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u62d2\u7edd", notes="\u9500\u552e\u62d2\u7edd")
    @PostMapping(value={"/refuesd"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:refuesd"})
    public Result<?> refuesd(@RequestBody SalePerformanceReconciliationVO vo) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)salePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.salePerformanceReconciliationService.confirmOrRefused(salePerformanceReconciliation, "refused");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4/\u62d2\u7edd", notes="\u9500\u552e\u786e\u8ba4/\u62d2\u7edd")
    @GetMapping(value={"/emailConfirmOrRefuesd"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:emailConfirmOrRefuesd"})
    public Result<?> emailConfirmOrRefuesd(@RequestParam(name="operation") String operation, @RequestParam(name="id") String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.salePerformanceReconciliationService.emailConfirmOrRefuesd(id, operation);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26-\u63d0\u53d6\u5bf9\u8d26\u5355", logType=2)
    @ApiOperation(value="\u63d0\u53d6\u5bf9\u8d26\u5355", notes="\u63d0\u53d6\u5bf9\u8d26\u5355")
    @PostMapping(value={"/extractReconciliation"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:extractReconciliation"})
    public Result<?> extractReconciliation(@RequestBody SalePerformanceReconciliationVO vo) {
        return Result.ok((Object)((Object)this.salePerformanceReconciliationService.extractReconciliation(vo)));
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:publish"})
    public Result<?> publish(@RequestBody SalePerformanceReconciliationVO vo) {
        Result result = new Result();
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)salePerformanceReconciliation));
        if (!this.redisUtil.tryGetDistributedLock("supplier_performanceReconciliation_", vo.getElsAccount(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AvjDiKUmRdXIeVRSsK_72c19add", (String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4e0e\u6b64\u4f9b\u5e94\u5546\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01"));
        }
        try {
            result = this.salePerformanceReconciliationService.publish(salePerformanceReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock("supplier_performanceReconciliation_", vo.getElsAccount());
        }
        return result;
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:list"})
    public Result<?> counts(SalePerformanceReconciliation salePerformanceReconciliation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)salePerformanceReconciliation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((SalePerformanceReconciliationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SalePerformanceReconciliation::getStatus, SalePerformanceReconciliation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("reconciliationBillStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u76f4\u8fde\u5f00\u7968", notes="\u76f4\u8fde\u5f00\u7968")
    @PostMapping(value={"/billing"})
    public Result<?> billing(@RequestBody SalePerformanceReconciliationVO vo) {
        Result result = new Result();
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.salePerformanceReconciliationService.billing(vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryReconciliationItemList"})
    public Result<?> queryReconciliationItemList(SalePerformanceReconciliation salePerformanceReconciliation) {
        SalePerformanceReconciliationVO vo = this.salePerformanceReconciliationService.queryReconciliationItemList(salePerformanceReconciliation, salePerformanceReconciliation.getId());
        return Result.ok((Object)((Object)vo));
    }
}

