/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.open.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.ReconciliationBillStatusEnum;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchaseRecAcceptReturnService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.SaleRecAcceptReturnService;
import com.els.modules.reconciliation.service.SaleReconciliationService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseReconciliationCreateFinanceCloudServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseReconciliationCreateFinanceCloudServiceImpl.class);
    @Resource
    private PurchaseReconciliationService purchaseReconciliationService;
    @Resource
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private SaleReconciliationService saleReconciliationService;
    @Resource
    private SaleInvoiceService saleInvoiceService;
    @Resource
    private PurchaseRecAcceptReturnService purchaseRecAcceptReturnService;
    @Resource
    private SaleRecAcceptReturnService saleRecAcceptReturnService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        log.info("receive data: {} ", (Object)JSON.toJSONString((Object)array));
        ArrayList<PurchaseReconciliation> headList = new ArrayList<PurchaseReconciliation>();
        String account = TenantContext.getTenant();
        ArrayList invoices = new ArrayList();
        ArrayList accepts = new ArrayList();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)ConvertUtils.convertDefault(PurchaseReconciliation.class, (JSONObject)object, defaultHeadMap));
            purchaseReconciliation.setElsAccount(account);
            purchaseReconciliation.setCreateTime(new Date());
            purchaseReconciliation.setUpdateTime(new Date());
            purchaseReconciliation.setCreateBy(purchaseReconciliation.getCreateBy());
            purchaseReconciliation.setUpdateBy(purchaseReconciliation.getCreateBy());
            purchaseReconciliation.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseReconciliation.setTemplateName(templateHead.getTemplateName());
            purchaseReconciliation.setTemplateNumber(templateHead.getTemplateNumber());
            purchaseReconciliation.setTemplateVersion(templateHead.getTemplateVersion() + "");
            purchaseReconciliation.setTemplateAccount(templateHead.getElsAccount());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)purchaseReconciliation), (String[])new String[0]);
            purchaseReconciliation.setId(SysUtil.getAssignId((Object)((Object)purchaseReconciliation)));
            purchaseReconciliation.setCreateAccount(account);
            purchaseReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_CONFIRMED.getValue());
            purchaseReconciliation.setSendStatus("1");
            headList.add(purchaseReconciliation);
            try {
                JSONArray recAcceptReturnJsonArray = this.getItemList(purchaseReconciliation, object, defaultItemMap, "recAcceptReturnList");
                List acceptList = JSON.parseArray((String)recAcceptReturnJsonArray.toJSONString(), PurchaseRecAcceptReturn.class);
                accepts.addAll(acceptList);
            }
            catch (Exception e) {
                log.error("{}==>acceptList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
            }
            try {
                JSONArray invoiceJsonArray = this.getItemList(purchaseReconciliation, object, defaultItemMap, "invoiceList");
                List invoiceList = JSON.parseArray((String)invoiceJsonArray.toJSONString(), PurchaseInvoice.class);
                invoices.addAll(invoiceList);
            }
            catch (Exception e) {
                log.error("{}==>invoiceList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
            }
        }
        ArrayList<SaleReconciliation> saleReconciliations = new ArrayList<SaleReconciliation>();
        if (!CollectionUtils.isEmpty(headList)) {
            PurchaseReconciliation entity = (PurchaseReconciliation)((Object)headList.get(0));
            long size = headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getReconciliationNumber())).count();
            if (size > 0L) {
                List nextCodes = this.invokeBaseRpcService.getNextCodes("reconciliation", (Object)entity, (int)size);
                int codeIndex = 0;
                for (PurchaseReconciliation reconciliation : headList) {
                    if (CharSequenceUtil.isEmpty((CharSequence)reconciliation.getReconciliationNumber())) {
                        reconciliation.setReconciliationNumber((String)nextCodes.get(codeIndex++));
                    }
                    SaleReconciliation saleReconciliation = new SaleReconciliation();
                    BeanUtil.copyProperties((Object)((Object)reconciliation), (Object)((Object)saleReconciliation), (String[])new String[0]);
                    saleReconciliation.setElsAccount(reconciliation.getToElsAccount());
                    saleReconciliation.setToElsAccount(reconciliation.getElsAccount());
                    saleReconciliation.setBusAccount(reconciliation.getElsAccount());
                    saleReconciliations.add(saleReconciliation);
                }
            }
            this.purchaseReconciliationService.saveBatch(headList, 2000);
            this.saleReconciliationService.saveBatch(saleReconciliations, 2000);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(headList)) {
            for (PurchaseReconciliation purchaseReconciliation : headList) {
                map.put(purchaseReconciliation.getId(), purchaseReconciliation.getReconciliationNumber());
            }
        }
        ArrayList<SaleRecAcceptReturn> saleAccepts = new ArrayList<SaleRecAcceptReturn>();
        if (!CollectionUtils.isEmpty(accepts)) {
            for (Object accept : accepts) {
                String reconciliationNumber = map.get(accept.getHeadId()) == null ? "" : (String)map.get(accept.getHeadId());
                accept.setReconciliationNumber(reconciliationNumber);
                SaleRecAcceptReturn saleRecAcceptReturn = new SaleRecAcceptReturn();
                BeanUtil.copyProperties((Object)accept, (Object)((Object)saleRecAcceptReturn), (String[])new String[0]);
                saleRecAcceptReturn.setId(null);
                saleRecAcceptReturn.setToElsAccount(accept.getElsAccount());
                saleRecAcceptReturn.setElsAccount(accept.getToElsAccount());
                saleRecAcceptReturn.setBusAccount(accept.getElsAccount());
                saleAccepts.add(saleRecAcceptReturn);
            }
            this.purchaseRecAcceptReturnService.saveBatch(accepts, 2000);
            this.saleRecAcceptReturnService.saveBatch(saleAccepts, 2000);
        }
        ArrayList<SaleInvoice> arrayList = new ArrayList<SaleInvoice>();
        if (!CollectionUtils.isEmpty(invoices)) {
            for (PurchaseInvoice invoice : invoices) {
                String reconciliationNumber = map.get(invoice.getHeadId()) == null ? "" : (String)map.get(invoice.getHeadId());
                invoice.setReconciliationNumber(reconciliationNumber);
                String invoiceNumber = this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)invoice);
                invoice.setInvoiceNumber(invoiceNumber);
                SaleInvoice saleInvoice = new SaleInvoice();
                BeanUtil.copyProperties((Object)((Object)invoice), (Object)((Object)saleInvoice), (String[])new String[0]);
                saleInvoice.setId(null);
                saleInvoice.setToElsAccount(invoice.getElsAccount());
                saleInvoice.setElsAccount(invoice.getToElsAccount());
                saleInvoice.setBusAccount(invoice.getElsAccount());
                arrayList.add(saleInvoice);
            }
            this.purchaseInvoiceService.saveBatch(invoices, 2000);
            this.saleInvoiceService.saveBatch(arrayList, 2000);
        }
        List collect = headList.stream().map(x -> (PurchaseReconciliationVO)((Object)((Object)Convert.convert(PurchaseReconciliationVO.class, (Object)x)))).collect(Collectors.toList());
        Map<String, List<PurchaseInvoice>> orderMap = invoices.stream().collect(Collectors.groupingBy(PurchaseInvoice::getHeadId));
        for (PurchaseReconciliationVO vo : collect) {
            vo.setInvoiceList(orderMap.get(vo.getId()));
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", collect);
        log.info("response data: {} ", (Object)JSON.toJSONString(collect));
        return resultObj;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "reconciliation";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return null;
    }

    public List<String> supportItemList() {
        return null;
    }

    private JSONArray getItemList(PurchaseReconciliation head, JSONObject object, Map<String, String> defaultItemMap, String name) {
        if (!object.containsKey((Object)name)) {
            return new JSONArray();
        }
        JSONArray jsonArray = object.getJSONArray(name);
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return new JSONArray();
        }
        JSONArray newJsonArray = new JSONArray();
        for (Object item : jsonArray) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString(item));
            jsonObject.put("headId", (Object)head.getId());
            jsonObject.put("elsAccount", (Object)head.getElsAccount());
            jsonObject.put("toElsAccount", (Object)head.getToElsAccount());
            jsonObject.put("createTime", (Object)head.getCreateTime());
            jsonObject.put("updateTime", (Object)head.getUpdateTime());
            jsonObject.put("createBy", (Object)head.getCreateBy());
            jsonObject.put("updateBy", (Object)head.getUpdateBy());
            jsonObject.put("deleted", (Object)CommonConstant.DEL_FLAG_0);
            jsonObject.put("id", null);
            BeanUtil.copyProperties(defaultItemMap, (Object)jsonObject, (String[])new String[0]);
            newJsonArray.add((Object)jsonObject);
        }
        return newJsonArray;
    }
}

